[**@cdklabs/generative-ai-cdk-constructs**](../../../README.md) • **Docs**

***

[@cdklabs/generative-ai-cdk-constructs](../../../README.md) / [bedrock](../README.md) / AgentActionGroupProps

# Interface: AgentActionGroupProps

## Properties

### actionGroupExecutor?

> `readonly` `optional` **actionGroupExecutor**: [`ActionGroupExecutor`](ActionGroupExecutor.md)

***

### actionGroupName

> `readonly` **actionGroupName**: `string`

The name of the action group.

#### Default

```ts
- a name is generated by CloudFormation.
```

***

### actionGroupState?

> `readonly` `optional` **actionGroupState**: `"ENABLED"` \| `"DISABLED"`

Specifies whether the action group is available for the agent to invoke or not when sending an InvokeAgent request.

***

### apiSchema?

> `readonly` `optional` **apiSchema**: [`ApiSchema`](../classes/ApiSchema.md)

Contains details about the S3 object containing the OpenAPI schema for the action group. For more information, see
[Action group OpenAPI schemas](https://docs.aws.amazon.com/bedrock/latest/userguide/agents-api-schema.html).

***

### description?

> `readonly` `optional` **description**: `string`

A description of the action group.

#### Remarks

This object is a Union. Only one member of this object can be specified or returned.

***

### functionSchema?

> `readonly` `optional` **functionSchema**: `FunctionSchemaProperty`

Defines functions that each define parameters that the agent needs to invoke from the user.

***

### parentActionGroupSignature?

> `readonly` `optional` **parentActionGroupSignature**: `"AMAZON.UserInput"`

If you specify this value as AMAZON.UserInput, the agent will prompt additional information from the user when it
doesn't have enough information to respond to an utterance. Leave this field blank if you don't want the agent to
prompt additional information.

***

### skipResourceInUseCheckOnDelete?

> `readonly` `optional` **skipResourceInUseCheckOnDelete**: `boolean`

Specifies whether the agent should skip the resource in use check on delete.
