[**@cdklabs/generative-ai-cdk-constructs**](../../../README.md) • **Docs**

***

[@cdklabs/generative-ai-cdk-constructs](../../../README.md) / [bedrock](../README.md) / WebCrawlerDataSource

# Class: WebCrawlerDataSource

Sets up a web crawler data source to be added to a knowledge base.

## Extends

- [`DataSourceNew`](DataSourceNew.md)

## Constructors

### new WebCrawlerDataSource()

> **new WebCrawlerDataSource**(`scope`, `id`, `props`): [`WebCrawlerDataSource`](WebCrawlerDataSource.md)

#### Parameters

• **scope**: `Construct`

• **id**: `string`

• **props**: [`WebCrawlerDataSourceProps`](../interfaces/WebCrawlerDataSourceProps.md)

#### Returns

[`WebCrawlerDataSource`](WebCrawlerDataSource.md)

#### Overrides

[`DataSourceNew`](DataSourceNew.md).[`constructor`](DataSourceNew.md#constructors)

## Properties

### crawlingRate

> `readonly` **crawlingRate**: `number`

The max rate at which pages are crawled.

***

### dataSourceId

> `readonly` **dataSourceId**: `string`

The unique identifier of the data source.

#### Example

```ts
'JHUEVXUZMU'
```

#### Overrides

[`DataSourceNew`](DataSourceNew.md).[`dataSourceId`](DataSourceNew.md#datasourceid)

***

### dataSourceName

> `readonly` **dataSourceName**: `string`

The name of the data source.

#### Overrides

[`DataSourceNew`](DataSourceNew.md).[`dataSourceName`](DataSourceNew.md#datasourcename)

***

### dataSourceType

> `readonly` **dataSourceType**: [`DataSourceType`](../enumerations/DataSourceType.md)

The type of data source.

#### Overrides

[`DataSourceNew`](DataSourceNew.md).[`dataSourceType`](DataSourceNew.md#datasourcetype)

***

### env

> `readonly` **env**: `ResourceEnvironment`

The environment this resource belongs to.
For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`env`](DataSourceNew.md#env)

***

### kmsKey?

> `readonly` `optional` **kmsKey**: `IKey`

The KMS key to use to encrypt the data source.

#### Overrides

[`DataSourceNew`](DataSourceNew.md).[`kmsKey`](DataSourceNew.md#kmskey)

***

### knowledgeBase

> `readonly` **knowledgeBase**: [`IKnowledgeBase`](../interfaces/IKnowledgeBase.md)

The knowledge base associated with the data source.

#### Overrides

[`DataSourceNew`](DataSourceNew.md).[`knowledgeBase`](DataSourceNew.md#knowledgebase)

***

### node

> `readonly` **node**: `Node`

The tree node.

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`node`](DataSourceNew.md#node)

***

### physicalName

> `protected` `readonly` **physicalName**: `string`

Returns a string-encoded token that resolves to the physical name that
should be passed to the CloudFormation resource.

This value will resolve to one of the following:
- a concrete value (e.g. `"my-awesome-bucket"`)
- `undefined`, when a name should be generated by CloudFormation
- a concrete name generated automatically during synthesis, in
  cross-environment scenarios.

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`physicalName`](DataSourceNew.md#physicalname)

***

### siteUrls

> `readonly` **siteUrls**: `string`[]

The max rate at which pages are crawled.

***

### stack

> `readonly` **stack**: `Stack`

The stack in which this resource is defined.

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`stack`](DataSourceNew.md#stack)

## Methods

### \_enableCrossEnvironment()

> **\_enableCrossEnvironment**(): `void`

**`Internal`**

Called when this resource is referenced across environments
(account/region) to order to request that a physical name will be generated
for this resource during synthesis, so the resource can be referenced
through its absolute name/arn.

#### Returns

`void`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`_enableCrossEnvironment`](DataSourceNew.md#_enablecrossenvironment)

***

### applyRemovalPolicy()

> **applyRemovalPolicy**(`policy`): `void`

Apply the given removal policy to this resource

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

#### Parameters

• **policy**: `RemovalPolicy`

#### Returns

`void`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`applyRemovalPolicy`](DataSourceNew.md#applyremovalpolicy)

***

### formatAsCfnProps()

> **formatAsCfnProps**(`props`, `dataSourceConfiguration`): `CfnDataSourceProps`

Formats the data source configuration properties for CloudFormation.

#### Parameters

• **props**: [`DataSourceAssociationProps`](../interfaces/DataSourceAssociationProps.md)

• **dataSourceConfiguration**: `DataSourceConfigurationProperty`

#### Returns

`CfnDataSourceProps`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`formatAsCfnProps`](DataSourceNew.md#formatascfnprops)

***

### generatePhysicalName()

> `protected` **generatePhysicalName**(): `string`

#### Returns

`string`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`generatePhysicalName`](DataSourceNew.md#generatephysicalname)

***

### getResourceArnAttribute()

> `protected` **getResourceArnAttribute**(`arnAttr`, `arnComponents`): `string`

Returns an environment-sensitive token that should be used for the
resource's "ARN" attribute (e.g. `bucket.bucketArn`).

Normally, this token will resolve to `arnAttr`, but if the resource is
referenced across environments, `arnComponents` will be used to synthesize
a concrete ARN with the resource's physical name. Make sure to reference
`this.physicalName` in `arnComponents`.

#### Parameters

• **arnAttr**: `string`

The CFN attribute which resolves to the ARN of the resource.
Commonly it will be called "Arn" (e.g. `resource.attrArn`), but sometimes
it's the CFN resource's `ref`.

• **arnComponents**: `ArnComponents`

The format of the ARN of this resource. You must
reference `this.physicalName` somewhere within the ARN in order for
cross-environment references to work.

#### Returns

`string`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`getResourceArnAttribute`](DataSourceNew.md#getresourcearnattribute)

***

### getResourceNameAttribute()

> `protected` **getResourceNameAttribute**(`nameAttr`): `string`

Returns an environment-sensitive token that should be used for the
resource's "name" attribute (e.g. `bucket.bucketName`).

Normally, this token will resolve to `nameAttr`, but if the resource is
referenced across environments, it will be resolved to `this.physicalName`,
which will be a concrete name.

#### Parameters

• **nameAttr**: `string`

The CFN attribute which resolves to the resource's name.
Commonly this is the resource's `ref`.

#### Returns

`string`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`getResourceNameAttribute`](DataSourceNew.md#getresourcenameattribute)

***

### handleCommonPermissions()

> **handleCommonPermissions**(`props`): `void`

Adds appropriate permissions to the KB execution role needed by the data source.

#### Parameters

• **props**: [`DataSourceAssociationProps`](../interfaces/DataSourceAssociationProps.md)

#### Returns

`void`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`handleCommonPermissions`](DataSourceNew.md#handlecommonpermissions)

***

### toString()

> **toString**(): `string`

Returns a string representation of this construct.

#### Returns

`string`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`toString`](DataSourceNew.md#tostring)

***

### isConstruct()

> `static` **isConstruct**(`x`): `x is Construct`

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

#### Parameters

• **x**: `any`

Any object

#### Returns

`x is Construct`

true if `x` is an object created from a class which extends `Construct`.

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`isConstruct`](DataSourceNew.md#isconstruct)

***

### isOwnedResource()

> `static` **isOwnedResource**(`construct`): `boolean`

Returns true if the construct was created by CDK, and false otherwise

#### Parameters

• **construct**: `IConstruct`

#### Returns

`boolean`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`isOwnedResource`](DataSourceNew.md#isownedresource)

***

### isResource()

> `static` **isResource**(`construct`): `construct is Resource`

Check whether the given construct is a Resource

#### Parameters

• **construct**: `IConstruct`

#### Returns

`construct is Resource`

#### Inherited from

[`DataSourceNew`](DataSourceNew.md).[`isResource`](DataSourceNew.md#isresource)
