[**@cdklabs/generative-ai-cdk-constructs**](../../../README.md) • **Docs**

***

[@cdklabs/generative-ai-cdk-constructs](../../../README.md) / [bedrock](../README.md) / Guardrail

# Class: Guardrail

Class to create a Guardrail with CDK.

## Extends

- [`GuardrailBase`](GuardrailBase.md)

## Constructors

### new Guardrail()

> **new Guardrail**(`scope`, `id`, `props`): [`Guardrail`](Guardrail.md)

#### Parameters

• **scope**: `Construct`

• **id**: `string`

• **props**: [`GuardrailProps`](../interfaces/GuardrailProps.md)

#### Returns

[`Guardrail`](Guardrail.md)

#### Overrides

[`GuardrailBase`](GuardrailBase.md).[`constructor`](GuardrailBase.md#constructors)

## Properties

### contentFilters

> `readonly` **contentFilters**: [`ContentFilter`](../interfaces/ContentFilter.md)[]

The content filters applied by the guardrail.

***

### contextualGroundingFilters

> `readonly` **contextualGroundingFilters**: [`ContextualGroundingFilter`](../interfaces/ContextualGroundingFilter.md)[]

The contextual grounding filters applied by the guardrail.

***

### deniedTopics

> `readonly` **deniedTopics**: [`Topic`](Topic.md)[]

The denied topic filters applied by the guardrail.

***

### env

> `readonly` **env**: `ResourceEnvironment`

The environment this resource belongs to.
For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`env`](GuardrailBase.md#env)

***

### guardrailArn

> `readonly` **guardrailArn**: `string`

The ARN of the guardrail.

#### Overrides

[`GuardrailBase`](GuardrailBase.md).[`guardrailArn`](GuardrailBase.md#guardrailarn)

***

### guardrailId

> `readonly` **guardrailId**: `string`

The ID of the guardrail.

#### Overrides

[`GuardrailBase`](GuardrailBase.md).[`guardrailId`](GuardrailBase.md#guardrailid)

***

### guardrailVersion

> **guardrailVersion**: `string`

The version of the guardrail.
By default, this value will always be `DRAFT` unless an explicit version is created.
For an explicit version created, this will usually be a number (e.g. for Version 1 just enter "1")

#### Example

```ts
"1"
```

#### Default

```ts
- "DRAFT"
```

#### Overrides

[`GuardrailBase`](GuardrailBase.md).[`guardrailVersion`](GuardrailBase.md#guardrailversion)

***

### hash

> `readonly` **hash**: `string`

The computed hash of the guardrail properties.

***

### kmsKey?

> `readonly` `optional` **kmsKey**: `IKey`

The KMS key used to encrypt data.

#### Default

```ts
undefined - "Data is encrypted by default with a key that AWS owns and manages for you"
```

#### Overrides

[`GuardrailBase`](GuardrailBase.md).[`kmsKey`](GuardrailBase.md#kmskey)

***

### managedWordListFilters

> `readonly` **managedWordListFilters**: [`PROFANITY`](../enumerations/ManagedWordFilterType.md#profanity)[]

The managed word list filters applied by the guardrail.

***

### name

> `readonly` **name**: `string`

The name of the guardrail.

***

### node

> `readonly` **node**: `Node`

The tree node.

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`node`](GuardrailBase.md#node)

***

### physicalName

> `protected` `readonly` **physicalName**: `string`

Returns a string-encoded token that resolves to the physical name that
should be passed to the CloudFormation resource.

This value will resolve to one of the following:
- a concrete value (e.g. `"my-awesome-bucket"`)
- `undefined`, when a name should be generated by CloudFormation
- a concrete name generated automatically during synthesis, in
  cross-environment scenarios.

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`physicalName`](GuardrailBase.md#physicalname)

***

### piiFilters

> `readonly` **piiFilters**: [`PIIFilter`](../interfaces/PIIFilter.md)[]

The PII filters applied by the guardrail.

***

### regexFilters

> `readonly` **regexFilters**: [`RegexFilter`](../interfaces/RegexFilter.md)[]

The regex filters applied by the guardrail.

***

### stack

> `readonly` **stack**: `Stack`

The stack in which this resource is defined.

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`stack`](GuardrailBase.md#stack)

***

### wordFilters

> `readonly` **wordFilters**: `string`[]

The word filters applied by the guardrail.

## Methods

### \_enableCrossEnvironment()

> **\_enableCrossEnvironment**(): `void`

**`Internal`**

Called when this resource is referenced across environments
(account/region) to order to request that a physical name will be generated
for this resource during synthesis, so the resource can be referenced
through its absolute name/arn.

#### Returns

`void`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`_enableCrossEnvironment`](GuardrailBase.md#_enablecrossenvironment)

***

### addContentFilter()

> **addContentFilter**(`filter`): `void`

Adds a content filter to the guardrail.

#### Parameters

• **filter**: [`ContentFilter`](../interfaces/ContentFilter.md)

The content filter to add.

#### Returns

`void`

***

### addContextualGroundingFilter()

> **addContextualGroundingFilter**(`filter`): `void`

Adds a contextual grounding filter to the guardrail.

#### Parameters

• **filter**: [`ContextualGroundingFilter`](../interfaces/ContextualGroundingFilter.md)

The contextual grounding filter to add.

#### Returns

`void`

***

### addDeniedTopicFilter()

> **addDeniedTopicFilter**(`filter`): `void`

Adds a denied topic filter to the guardrail.

#### Parameters

• **filter**: [`Topic`](Topic.md)

The denied topic filter to add.

#### Returns

`void`

***

### addManagedWordListFilter()

> **addManagedWordListFilter**(`filter`): `void`

Adds a managed word list filter to the guardrail.

#### Parameters

• **filter**: [`PROFANITY`](../enumerations/ManagedWordFilterType.md#profanity)

The managed word list filter to add.

#### Returns

`void`

***

### addPIIFilter()

> **addPIIFilter**(`filter`): `void`

Adds a PII filter to the guardrail.

#### Parameters

• **filter**: [`PIIFilter`](../interfaces/PIIFilter.md)

The PII filter to add.

#### Returns

`void`

***

### addRegexFilter()

> **addRegexFilter**(`filter`): `void`

Adds a regex filter to the guardrail.

#### Parameters

• **filter**: [`RegexFilter`](../interfaces/RegexFilter.md)

The regex filter to add.

#### Returns

`void`

***

### addWordFilter()

> **addWordFilter**(`filter`): `void`

Adds a word filter to the guardrail.

#### Parameters

• **filter**: `string`

The word filter to add.

#### Returns

`void`

***

### addWordFilterFromFile()

> **addWordFilterFromFile**(`filePath`): `void`

Adds a word filter to the guardrail.

#### Parameters

• **filePath**: `string`

The location of the word filter file.

#### Returns

`void`

***

### applyRemovalPolicy()

> **applyRemovalPolicy**(`policy`): `void`

Apply the given removal policy to this resource

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

#### Parameters

• **policy**: `RemovalPolicy`

#### Returns

`void`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`applyRemovalPolicy`](GuardrailBase.md#applyremovalpolicy)

***

### createVersion()

> **createVersion**(`description`?): `string`

Create a version for the guardrail.

#### Parameters

• **description?**: `string`

The description of the version.

#### Returns

`string`

The guardrail version.

***

### generatePhysicalName()

> `protected` **generatePhysicalName**(): `string`

#### Returns

`string`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`generatePhysicalName`](GuardrailBase.md#generatephysicalname)

***

### getResourceArnAttribute()

> `protected` **getResourceArnAttribute**(`arnAttr`, `arnComponents`): `string`

Returns an environment-sensitive token that should be used for the
resource's "ARN" attribute (e.g. `bucket.bucketArn`).

Normally, this token will resolve to `arnAttr`, but if the resource is
referenced across environments, `arnComponents` will be used to synthesize
a concrete ARN with the resource's physical name. Make sure to reference
`this.physicalName` in `arnComponents`.

#### Parameters

• **arnAttr**: `string`

The CFN attribute which resolves to the ARN of the resource.
Commonly it will be called "Arn" (e.g. `resource.attrArn`), but sometimes
it's the CFN resource's `ref`.

• **arnComponents**: `ArnComponents`

The format of the ARN of this resource. You must
reference `this.physicalName` somewhere within the ARN in order for
cross-environment references to work.

#### Returns

`string`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`getResourceArnAttribute`](GuardrailBase.md#getresourcearnattribute)

***

### getResourceNameAttribute()

> `protected` **getResourceNameAttribute**(`nameAttr`): `string`

Returns an environment-sensitive token that should be used for the
resource's "name" attribute (e.g. `bucket.bucketName`).

Normally, this token will resolve to `nameAttr`, but if the resource is
referenced across environments, it will be resolved to `this.physicalName`,
which will be a concrete name.

#### Parameters

• **nameAttr**: `string`

The CFN attribute which resolves to the resource's name.
Commonly this is the resource's `ref`.

#### Returns

`string`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`getResourceNameAttribute`](GuardrailBase.md#getresourcenameattribute)

***

### grantApply()

> **grantApply**(`grantee`): `Grant`

Grant the given identity permissions to apply the guardrail.

#### Parameters

• **grantee**: `IGrantable`

#### Returns

`Grant`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`grantApply`](GuardrailBase.md#grantapply)

***

### toString()

> **toString**(): `string`

Returns a string representation of this construct.

#### Returns

`string`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`toString`](GuardrailBase.md#tostring)

***

### fromCfnGuardrail()

> `static` **fromCfnGuardrail**(`cfnGuardrail`): [`IGuardrail`](../interfaces/IGuardrail.md)

Import a low-level L1 Cfn Guardrail

#### Parameters

• **cfnGuardrail**: `CfnGuardrail`

#### Returns

[`IGuardrail`](../interfaces/IGuardrail.md)

***

### fromGuardrailAttributes()

> `static` **fromGuardrailAttributes**(`scope`, `id`, `attrs`): [`IGuardrail`](../interfaces/IGuardrail.md)

Import a guardrail given its attributes

#### Parameters

• **scope**: `Construct`

• **id**: `string`

• **attrs**: [`GuardrailAttributes`](../interfaces/GuardrailAttributes.md)

#### Returns

[`IGuardrail`](../interfaces/IGuardrail.md)

***

### isConstruct()

> `static` **isConstruct**(`x`): `x is Construct`

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

#### Parameters

• **x**: `any`

Any object

#### Returns

`x is Construct`

true if `x` is an object created from a class which extends `Construct`.

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`isConstruct`](GuardrailBase.md#isconstruct)

***

### isOwnedResource()

> `static` **isOwnedResource**(`construct`): `boolean`

Returns true if the construct was created by CDK, and false otherwise

#### Parameters

• **construct**: `IConstruct`

#### Returns

`boolean`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`isOwnedResource`](GuardrailBase.md#isownedresource)

***

### isResource()

> `static` **isResource**(`construct`): `construct is Resource`

Check whether the given construct is a Resource

#### Parameters

• **construct**: `IConstruct`

#### Returns

`construct is Resource`

#### Inherited from

[`GuardrailBase`](GuardrailBase.md).[`isResource`](GuardrailBase.md#isresource)
