[**@cdklabs/generative-ai-cdk-constructs**](../../../README.md) • **Docs**

***

[@cdklabs/generative-ai-cdk-constructs](../../../README.md) / [bedrock](../README.md) / ApplicationInferenceProfile

# Class: ApplicationInferenceProfile

Class to create a ApplicationInferenceProfile with CDK.
These are inference profiles created by users (user defined).
This helps to track costs and model usage.

## Resource

AWS::Bedrock::ApplicationInferenceProfile

## See

https://docs.aws.amazon.com/bedrock/latest/userguide/inference-profiles-create.html

## Extends

- [`InferenceProfileBase`](InferenceProfileBase.md)

## Implements

- [`IInvokable`](../interfaces/IInvokable.md)

## Constructors

### new ApplicationInferenceProfile()

> **new ApplicationInferenceProfile**(`scope`, `id`, `props`): [`ApplicationInferenceProfile`](ApplicationInferenceProfile.md)

#### Parameters

• **scope**: `Construct`

• **id**: `string`

• **props**: [`ApplicationInferenceProfileProps`](../interfaces/ApplicationInferenceProfileProps.md)

#### Returns

[`ApplicationInferenceProfile`](ApplicationInferenceProfile.md)

#### Overrides

[`InferenceProfileBase`](InferenceProfileBase.md).[`constructor`](InferenceProfileBase.md#constructors)

## Properties

### createdAt

> `readonly` **createdAt**: `string`

Time Stamp for ApplicationInferenceProfile creation.

***

### env

> `readonly` **env**: `ResourceEnvironment`

The environment this resource belongs to.
For resources that are created and managed by the CDK
(generally, those created by creating new class instances like Role, Bucket, etc.),
this is always the same as the environment of the stack they belong to;
however, for imported resources
(those obtained from static methods like fromRoleArn, fromBucketName, etc.),
that might be different than the stack they were imported into.

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`env`](InferenceProfileBase.md#env)

***

### inferenceProfileArn

> `readonly` **inferenceProfileArn**: `string`

The ARN of the application application inference profile.

#### Overrides

[`InferenceProfileBase`](InferenceProfileBase.md).[`inferenceProfileArn`](InferenceProfileBase.md#inferenceprofilearn)

***

### inferenceProfileId

> `readonly` **inferenceProfileId**: `string`

The unique identifier of the application inference profile.

#### Overrides

[`InferenceProfileBase`](InferenceProfileBase.md).[`inferenceProfileId`](InferenceProfileBase.md#inferenceprofileid)

***

### inferenceProfileModel

> `readonly` **inferenceProfileModel**: [`IInvokable`](../interfaces/IInvokable.md)

The underlying model/cross-region model used by the application inference profile.

***

### inferenceProfileName

> `readonly` **inferenceProfileName**: `string`

The name of the application inference profile.

***

### invokableArn

> `readonly` **invokableArn**: `string`

This equals to the inferenceProfileArn property, useful just to implement IInvokable interface.

#### Implementation of

[`IInvokable`](../interfaces/IInvokable.md).[`invokableArn`](../interfaces/IInvokable.md#invokablearn)

***

### node

> `readonly` **node**: `Node`

The tree node.

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`node`](InferenceProfileBase.md#node)

***

### physicalName

> `protected` `readonly` **physicalName**: `string`

Returns a string-encoded token that resolves to the physical name that
should be passed to the CloudFormation resource.

This value will resolve to one of the following:
- a concrete value (e.g. `"my-awesome-bucket"`)
- `undefined`, when a name should be generated by CloudFormation
- a concrete name generated automatically during synthesis, in
  cross-environment scenarios.

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`physicalName`](InferenceProfileBase.md#physicalname)

***

### stack

> `readonly` **stack**: `Stack`

The stack in which this resource is defined.

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`stack`](InferenceProfileBase.md#stack)

***

### status

> `readonly` **status**: `string`

The status of the application inference profile. ACTIVE means that the inference profile is ready to be used.

***

### type

> `readonly` **type**: [`InferenceProfileType`](../enumerations/InferenceProfileType.md)

The type of the inference profile. The following types are possible:
SYSTEM_DEFINED – The inference profile is defined by Amazon Bedrock.
You can route inference requests across regions with these inference profiles.
APPLICATION – The inference profile was created by a user.
This type of inference profile can track metrics and costs when invoking the model in it.
The inference profile may route requests to one or multiple regions.

#### Overrides

[`InferenceProfileBase`](InferenceProfileBase.md).[`type`](InferenceProfileBase.md#type)

***

### updatedAt

> `readonly` **updatedAt**: `string`

Time Stamp for ApplicationInferenceProfile update.

## Methods

### \_enableCrossEnvironment()

> **\_enableCrossEnvironment**(): `void`

**`Internal`**

Called when this resource is referenced across environments
(account/region) to order to request that a physical name will be generated
for this resource during synthesis, so the resource can be referenced
through its absolute name/arn.

#### Returns

`void`

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`_enableCrossEnvironment`](InferenceProfileBase.md#_enablecrossenvironment)

***

### applyRemovalPolicy()

> **applyRemovalPolicy**(`policy`): `void`

Apply the given removal policy to this resource

The Removal Policy controls what happens to this resource when it stops
being managed by CloudFormation, either because you've removed it from the
CDK application or because you've made a change that requires the resource
to be replaced.

The resource can be deleted (`RemovalPolicy.DESTROY`), or left in your AWS
account for data recovery and cleanup later (`RemovalPolicy.RETAIN`).

#### Parameters

• **policy**: `RemovalPolicy`

#### Returns

`void`

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`applyRemovalPolicy`](InferenceProfileBase.md#applyremovalpolicy)

***

### generatePhysicalName()

> `protected` **generatePhysicalName**(): `string`

#### Returns

`string`

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`generatePhysicalName`](InferenceProfileBase.md#generatephysicalname)

***

### getResourceArnAttribute()

> `protected` **getResourceArnAttribute**(`arnAttr`, `arnComponents`): `string`

Returns an environment-sensitive token that should be used for the
resource's "ARN" attribute (e.g. `bucket.bucketArn`).

Normally, this token will resolve to `arnAttr`, but if the resource is
referenced across environments, `arnComponents` will be used to synthesize
a concrete ARN with the resource's physical name. Make sure to reference
`this.physicalName` in `arnComponents`.

#### Parameters

• **arnAttr**: `string`

The CFN attribute which resolves to the ARN of the resource.
Commonly it will be called "Arn" (e.g. `resource.attrArn`), but sometimes
it's the CFN resource's `ref`.

• **arnComponents**: `ArnComponents`

The format of the ARN of this resource. You must
reference `this.physicalName` somewhere within the ARN in order for
cross-environment references to work.

#### Returns

`string`

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`getResourceArnAttribute`](InferenceProfileBase.md#getresourcearnattribute)

***

### getResourceNameAttribute()

> `protected` **getResourceNameAttribute**(`nameAttr`): `string`

Returns an environment-sensitive token that should be used for the
resource's "name" attribute (e.g. `bucket.bucketName`).

Normally, this token will resolve to `nameAttr`, but if the resource is
referenced across environments, it will be resolved to `this.physicalName`,
which will be a concrete name.

#### Parameters

• **nameAttr**: `string`

The CFN attribute which resolves to the resource's name.
Commonly this is the resource's `ref`.

#### Returns

`string`

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`getResourceNameAttribute`](InferenceProfileBase.md#getresourcenameattribute)

***

### grantInvoke()

> **grantInvoke**(`grantee`): `Grant`

Gives the appropriate policies to invoke and use the application inference profile.

#### Parameters

• **grantee**: `IGrantable`

#### Returns

`Grant`

#### Implementation of

[`IInvokable`](../interfaces/IInvokable.md).[`grantInvoke`](../interfaces/IInvokable.md#grantinvoke)

***

### grantProfileUsage()

> **grantProfileUsage**(`grantee`): `Grant`

Grants appropriate permissions to use the application inference profile (AIP).
Does not grant permissions to use the model/cross-region profile in the AIP.

#### Parameters

• **grantee**: `IGrantable`

#### Returns

`Grant`

#### Overrides

[`InferenceProfileBase`](InferenceProfileBase.md).[`grantProfileUsage`](InferenceProfileBase.md#grantprofileusage)

***

### toString()

> **toString**(): `string`

Returns a string representation of this construct.

#### Returns

`string`

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`toString`](InferenceProfileBase.md#tostring)

***

### fromApplicationInferenceProfileAttributes()

> `static` **fromApplicationInferenceProfileAttributes**(`scope`, `id`, `attrs`): [`IInferenceProfile`](../interfaces/IInferenceProfile.md)

Import a ApplicationInferenceProfile given its attributes

#### Parameters

• **scope**: `Construct`

• **id**: `string`

• **attrs**: [`ApplicationInferenceProfileAttributes`](../interfaces/ApplicationInferenceProfileAttributes.md)

#### Returns

[`IInferenceProfile`](../interfaces/IInferenceProfile.md)

***

### fromCfnApplicationInferenceProfile()

> `static` **fromCfnApplicationInferenceProfile**(`CfnApplicationInferenceProfile`): [`IInferenceProfile`](../interfaces/IInferenceProfile.md)

Import a low-level L1 Cfn ApplicationInferenceProfile

#### Parameters

• **CfnApplicationInferenceProfile**: `CfnApplicationInferenceProfile`

#### Returns

[`IInferenceProfile`](../interfaces/IInferenceProfile.md)

***

### isConstruct()

> `static` **isConstruct**(`x`): `x is Construct`

Checks if `x` is a construct.

Use this method instead of `instanceof` to properly detect `Construct`
instances, even when the construct library is symlinked.

Explanation: in JavaScript, multiple copies of the `constructs` library on
disk are seen as independent, completely different libraries. As a
consequence, the class `Construct` in each copy of the `constructs` library
is seen as a different class, and an instance of one class will not test as
`instanceof` the other class. `npm install` will not create installations
like this, but users may manually symlink construct libraries together or
use a monorepo tool: in those cases, multiple copies of the `constructs`
library can be accidentally installed, and `instanceof` will behave
unpredictably. It is safest to avoid using `instanceof`, and using
this type-testing method instead.

#### Parameters

• **x**: `any`

Any object

#### Returns

`x is Construct`

true if `x` is an object created from a class which extends `Construct`.

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`isConstruct`](InferenceProfileBase.md#isconstruct)

***

### isOwnedResource()

> `static` **isOwnedResource**(`construct`): `boolean`

Returns true if the construct was created by CDK, and false otherwise

#### Parameters

• **construct**: `IConstruct`

#### Returns

`boolean`

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`isOwnedResource`](InferenceProfileBase.md#isownedresource)

***

### isResource()

> `static` **isResource**(`construct`): `construct is Resource`

Check whether the given construct is a Resource

#### Parameters

• **construct**: `IConstruct`

#### Returns

`construct is Resource`

#### Inherited from

[`InferenceProfileBase`](InferenceProfileBase.md).[`isResource`](InferenceProfileBase.md#isresource)
