# Configuring Credential Providers

[AwsCredentialProviders][aws-credentials-provider] are not a one-size-fits-all.
The AWS SDK provides a rich API to support various configurations for many different providers.
KCL multilang does not, and is not intended to, proxy the full breadth of the AWS SDK.
However, KCL now provides better extensibility to handle, and be enhanced to handle, additional configurations.
This document should help multilang customers configure a suitable `CredentialProvider` (or contribute changes to support a new use case!).

## Sample Provider Configuration

In a Properties file, an `AwsCredentialsProperty` configuration might look like:
```
AwsCredentialsProvider = StsAssumeRoleCredentialsProvider|<arn>|<sessionName>|endpointRegion=us-east-1
```
This basic configuration creates an [StsAssumeRoleCredentialsProvider][sts-assume-provider] with an ARN and session name.
If `endpointRegion` is not specified, the provider will use the region defined in the AWS config file.
If no region is found in the config file, the credentials provider will fail.

The providers generated by this config property will be [AWS SDK v2 AwsCredentialsProviders][aws-credentials-provider].
These differ from the SDK v1 AWSCredentialsProviders in a number of ways. See [Credentials Provider Changes][credentials-provider-changes].

While functional, this configuration is limited.
For example, this configuration cannot set a regional endpoint (e.g., VPC use case).

Leveraging nested properties, an `AwsCredentialsProperty` value might change to:
```
AwsCredentialsProvider = KclStsAssumeRoleCredentialsProvider|<arn>|<sessionName>\
    |endpointRegion=us-east-1|externalId=spartacus
```
N.B. Backslash (`\`) is for multi-line legibility and is not required.

You can create a default [DefaultCredentialsProvider][default-credentials-provider] by passing it in the config like:
```
AwsCredentialsProvider = DefaultCredentialsProvider
```

## Nested Properties

KCL multilang supports "nested properties" on the `AwsCredentialsProvider` key in the properties file.
The [Backus-Naur form][bnf] of the value:
```
<property-value> ::= <provider-class> ["|" <required-param>]* ["|" <nested-property>]*
<provider-class> ::= <fully-qualified-provider-class> | <provider-class-name>
<required-param> ::= <string> # this depends on the provider
<nested-property> ::= <nested-key> "=" <nested-value>
<nested-key> ::= <lower-camel-case-key>
<nested-value ::= <string> # this depends on the nested key
```

In general, required parameters are passed directly to the class' constructor or .create() method
(e.g., [ProfileCredentialsProvider(String)][profile-credentials-provider-create]). However, most of these providers
require builders and will require a custom implementation similar to `KclStsAssumeRoleCredentialsProvider` for customization

Nested properties are a custom mapping provided by KCL multilang, and do not exist in the AWS SDK.
See [NestedPropertyKey][nested-property-key] for the supported keys, and details on their expected values.

## Nested Property Processor

Nested keys are processed via [NestedPropertyProcessor][nested-property-processor].
Implementation is, obviously, dependent on the implementing class.
Adding a new nested key should be trivial.
A backwards-compatible addition might look like:
```
    default void acceptFoo(...) {
        // do nothing
    }
```

Leveraging nested properties, an `AwsCredentialsProperty` value might look like:
```
AwsCredentialsProvider = KclStsAssumeRoleCredentialsProvider|<arn>|<sessionName>\
    |endpointRegion=us-east-1|externalId=spartacus
```

N.B. Backslash (`\`) is for multi-line legibility and is not required.
### KclStsAssumeRoleCredentialsProvider

KCL multilang includes a [custom nested property processor for `StsAssumeRole`][kcl-sts-provider].
Multilang configurations that use `StsAssumeRoleSessionCredentialsProvider` need only prefix `Kcl` to exercise this new provider:
```
AwsCredentialsProvider = KclStsAssumeRoleCredentialsProvider|<arn>|<sessionName>|endpointRegion=us-east-1
```

[aws-credentials-provider]: https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/auth/credentials/AwsCredentialsProvider.html
[bnf]: https://en.wikipedia.org/wiki/Backus%E2%80%93Naur_form
[kcl-sts-provider]: /amazon-kinesis-client-multilang/src/main/java/software/amazon/kinesis/multilang/auth/KclStsAssumeRoleCredentialsProvider.java
[nested-property-key]: /amazon-kinesis-client-multilang/src/main/java/software/amazon/kinesis/multilang/NestedPropertyKey.java
[nested-property-processor]: /amazon-kinesis-client-multilang/src/main/java/software/amazon/kinesis/multilang/NestedPropertyProcessor.java
[sts-assume-provider]: https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/services/sts/auth/StsAssumeRoleCredentialsProvider.html
[profile-credentials-provider-create]: https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/auth/credentials/ProfileCredentialsProvider.html#create(java.lang.String)
[default-credentials-provider]: https://sdk.amazonaws.com/java/api/latest/software/amazon/awssdk/auth/credentials/DefaultCredentialsProvider.html
[credentials-provider-changes]: https://docs.aws.amazon.com/sdk-for-java/latest/developer-guide/migration-client-credentials.html
