//go:build e2e
// +build e2e

package e2e

import (
	"github.com/aws/eks-anywhere/test/framework"
)

func runSimpleFlow(test *framework.ClusterE2ETest) {
	test.GenerateClusterConfig()
	test.CreateCluster()
	test.DeleteCluster()
}

// runSimpleFlowWithoutClusterConfigGeneration runs the Create and Delete cluster flows
// that use the cluster config generated by the WithClusterConfig method when the test object
// is created, and avoids regenerating a cluster config with defaults.
func runSimpleFlowWithoutClusterConfigGeneration(test *framework.ClusterE2ETest) {
	test.CreateCluster()
	test.DeleteCluster()
}

func runTinkerbellSimpleFlow(test *framework.ClusterE2ETest) {
	test.GenerateClusterConfig()
	test.GenerateHardwareConfig()
	test.CreateCluster(framework.WithControlPlaneWaitTimeout("20m"))
	test.DeleteCluster()
	test.ValidateHardwareDecommissioned()
}

// runTinkerbellSimpleFlowWithoutClusterConfigGeneration runs the Create and Delete cluster flows
// for Baremetal that use the cluster config generated by the WithClusterConfig method when the
// test object is created, and avoids regenerating a cluster config with defaults.
func runTinkerbellSimpleFlowWithoutClusterConfigGeneration(test *framework.ClusterE2ETest) {
	test.GenerateHardwareConfig()
	test.CreateCluster(framework.WithControlPlaneWaitTimeout("20m"))
	test.DeleteCluster()
	test.ValidateHardwareDecommissioned()
}
