//go:build !ignore_autogenerated
// +build !ignore_autogenerated

// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by controller-gen. DO NOT EDIT.

package v1alpha1

import (
	snowapiv1beta1 "github.com/aws/eks-anywhere/pkg/providers/snow/api/v1beta1"
	"k8s.io/api/core/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/runtime"
	"k8s.io/apimachinery/pkg/util/intstr"
	"sigs.k8s.io/cluster-api/api/v1beta1"
	apiv1beta1 "sigs.k8s.io/cluster-api/bootstrap/kubeadm/api/v1beta1"
)

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSDatacenterConfig) DeepCopyInto(out *AWSDatacenterConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSDatacenterConfig.
func (in *AWSDatacenterConfig) DeepCopy() *AWSDatacenterConfig {
	if in == nil {
		return nil
	}
	out := new(AWSDatacenterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *AWSDatacenterConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSDatacenterConfigList) DeepCopyInto(out *AWSDatacenterConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]AWSDatacenterConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSDatacenterConfigList.
func (in *AWSDatacenterConfigList) DeepCopy() *AWSDatacenterConfigList {
	if in == nil {
		return nil
	}
	out := new(AWSDatacenterConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *AWSDatacenterConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSDatacenterConfigSpec) DeepCopyInto(out *AWSDatacenterConfigSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSDatacenterConfigSpec.
func (in *AWSDatacenterConfigSpec) DeepCopy() *AWSDatacenterConfigSpec {
	if in == nil {
		return nil
	}
	out := new(AWSDatacenterConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSDatacenterConfigStatus) DeepCopyInto(out *AWSDatacenterConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSDatacenterConfigStatus.
func (in *AWSDatacenterConfigStatus) DeepCopy() *AWSDatacenterConfigStatus {
	if in == nil {
		return nil
	}
	out := new(AWSDatacenterConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSIamConfig) DeepCopyInto(out *AWSIamConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSIamConfig.
func (in *AWSIamConfig) DeepCopy() *AWSIamConfig {
	if in == nil {
		return nil
	}
	out := new(AWSIamConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *AWSIamConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSIamConfigList) DeepCopyInto(out *AWSIamConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]AWSIamConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSIamConfigList.
func (in *AWSIamConfigList) DeepCopy() *AWSIamConfigList {
	if in == nil {
		return nil
	}
	out := new(AWSIamConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *AWSIamConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSIamConfigSpec) DeepCopyInto(out *AWSIamConfigSpec) {
	*out = *in
	if in.BackendMode != nil {
		in, out := &in.BackendMode, &out.BackendMode
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MapRoles != nil {
		in, out := &in.MapRoles, &out.MapRoles
		*out = make([]MapRoles, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.MapUsers != nil {
		in, out := &in.MapUsers, &out.MapUsers
		*out = make([]MapUsers, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSIamConfigSpec.
func (in *AWSIamConfigSpec) DeepCopy() *AWSIamConfigSpec {
	if in == nil {
		return nil
	}
	out := new(AWSIamConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AWSIamConfigStatus) DeepCopyInto(out *AWSIamConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AWSIamConfigStatus.
func (in *AWSIamConfigStatus) DeepCopy() *AWSIamConfigStatus {
	if in == nil {
		return nil
	}
	out := new(AWSIamConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *AutoScalingConfiguration) DeepCopyInto(out *AutoScalingConfiguration) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new AutoScalingConfiguration.
func (in *AutoScalingConfiguration) DeepCopy() *AutoScalingConfiguration {
	if in == nil {
		return nil
	}
	out := new(AutoScalingConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BottlerocketConfiguration) DeepCopyInto(out *BottlerocketConfiguration) {
	*out = *in
	if in.Kubernetes != nil {
		in, out := &in.Kubernetes, &out.Kubernetes
		*out = new(apiv1beta1.BottlerocketKubernetesSettings)
		(*in).DeepCopyInto(*out)
	}
	if in.Kernel != nil {
		in, out := &in.Kernel, &out.Kernel
		*out = new(apiv1beta1.BottlerocketKernelSettings)
		(*in).DeepCopyInto(*out)
	}
	if in.Boot != nil {
		in, out := &in.Boot, &out.Boot
		*out = new(apiv1beta1.BottlerocketBootSettings)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BottlerocketConfiguration.
func (in *BottlerocketConfiguration) DeepCopy() *BottlerocketConfiguration {
	if in == nil {
		return nil
	}
	out := new(BottlerocketConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *BundlesRef) DeepCopyInto(out *BundlesRef) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new BundlesRef.
func (in *BundlesRef) DeepCopy() *BundlesRef {
	if in == nil {
		return nil
	}
	out := new(BundlesRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CNIConfig) DeepCopyInto(out *CNIConfig) {
	*out = *in
	if in.Cilium != nil {
		in, out := &in.Cilium, &out.Cilium
		*out = new(CiliumConfig)
		(*in).DeepCopyInto(*out)
	}
	if in.Kindnetd != nil {
		in, out := &in.Kindnetd, &out.Kindnetd
		*out = new(KindnetdConfig)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CNIConfig.
func (in *CNIConfig) DeepCopy() *CNIConfig {
	if in == nil {
		return nil
	}
	out := new(CNIConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CiliumConfig) DeepCopyInto(out *CiliumConfig) {
	*out = *in
	if in.SkipUpgrade != nil {
		in, out := &in.SkipUpgrade, &out.SkipUpgrade
		*out = new(bool)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CiliumConfig.
func (in *CiliumConfig) DeepCopy() *CiliumConfig {
	if in == nil {
		return nil
	}
	out := new(CiliumConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackAvailabilityZone) DeepCopyInto(out *CloudStackAvailabilityZone) {
	*out = *in
	out.Zone = in.Zone
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackAvailabilityZone.
func (in *CloudStackAvailabilityZone) DeepCopy() *CloudStackAvailabilityZone {
	if in == nil {
		return nil
	}
	out := new(CloudStackAvailabilityZone)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackDatacenterConfig) DeepCopyInto(out *CloudStackDatacenterConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackDatacenterConfig.
func (in *CloudStackDatacenterConfig) DeepCopy() *CloudStackDatacenterConfig {
	if in == nil {
		return nil
	}
	out := new(CloudStackDatacenterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CloudStackDatacenterConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackDatacenterConfigList) DeepCopyInto(out *CloudStackDatacenterConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CloudStackDatacenterConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackDatacenterConfigList.
func (in *CloudStackDatacenterConfigList) DeepCopy() *CloudStackDatacenterConfigList {
	if in == nil {
		return nil
	}
	out := new(CloudStackDatacenterConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CloudStackDatacenterConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackDatacenterConfigSpec) DeepCopyInto(out *CloudStackDatacenterConfigSpec) {
	*out = *in
	if in.Zones != nil {
		in, out := &in.Zones, &out.Zones
		*out = make([]CloudStackZone, len(*in))
		copy(*out, *in)
	}
	if in.AvailabilityZones != nil {
		in, out := &in.AvailabilityZones, &out.AvailabilityZones
		*out = make([]CloudStackAvailabilityZone, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackDatacenterConfigSpec.
func (in *CloudStackDatacenterConfigSpec) DeepCopy() *CloudStackDatacenterConfigSpec {
	if in == nil {
		return nil
	}
	out := new(CloudStackDatacenterConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackDatacenterConfigStatus) DeepCopyInto(out *CloudStackDatacenterConfigStatus) {
	*out = *in
	if in.FailureMessage != nil {
		in, out := &in.FailureMessage, &out.FailureMessage
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackDatacenterConfigStatus.
func (in *CloudStackDatacenterConfigStatus) DeepCopy() *CloudStackDatacenterConfigStatus {
	if in == nil {
		return nil
	}
	out := new(CloudStackDatacenterConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackMachineConfig) DeepCopyInto(out *CloudStackMachineConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackMachineConfig.
func (in *CloudStackMachineConfig) DeepCopy() *CloudStackMachineConfig {
	if in == nil {
		return nil
	}
	out := new(CloudStackMachineConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CloudStackMachineConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackMachineConfigList) DeepCopyInto(out *CloudStackMachineConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]CloudStackMachineConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackMachineConfigList.
func (in *CloudStackMachineConfigList) DeepCopy() *CloudStackMachineConfigList {
	if in == nil {
		return nil
	}
	out := new(CloudStackMachineConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *CloudStackMachineConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackMachineConfigSpec) DeepCopyInto(out *CloudStackMachineConfigSpec) {
	*out = *in
	out.Template = in.Template
	out.ComputeOffering = in.ComputeOffering
	if in.DiskOffering != nil {
		in, out := &in.DiskOffering, &out.DiskOffering
		*out = new(CloudStackResourceDiskOffering)
		**out = **in
	}
	if in.Users != nil {
		in, out := &in.Users, &out.Users
		*out = make([]UserConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.AffinityGroupIds != nil {
		in, out := &in.AffinityGroupIds, &out.AffinityGroupIds
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.UserCustomDetails != nil {
		in, out := &in.UserCustomDetails, &out.UserCustomDetails
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.Symlinks != nil {
		in, out := &in.Symlinks, &out.Symlinks
		*out = make(SymlinkMaps, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackMachineConfigSpec.
func (in *CloudStackMachineConfigSpec) DeepCopy() *CloudStackMachineConfigSpec {
	if in == nil {
		return nil
	}
	out := new(CloudStackMachineConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackMachineConfigStatus) DeepCopyInto(out *CloudStackMachineConfigStatus) {
	*out = *in
	if in.FailureMessage != nil {
		in, out := &in.FailureMessage, &out.FailureMessage
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackMachineConfigStatus.
func (in *CloudStackMachineConfigStatus) DeepCopy() *CloudStackMachineConfigStatus {
	if in == nil {
		return nil
	}
	out := new(CloudStackMachineConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackResourceDiskOffering) DeepCopyInto(out *CloudStackResourceDiskOffering) {
	*out = *in
	out.CloudStackResourceIdentifier = in.CloudStackResourceIdentifier
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackResourceDiskOffering.
func (in *CloudStackResourceDiskOffering) DeepCopy() *CloudStackResourceDiskOffering {
	if in == nil {
		return nil
	}
	out := new(CloudStackResourceDiskOffering)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackResourceIdentifier) DeepCopyInto(out *CloudStackResourceIdentifier) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackResourceIdentifier.
func (in *CloudStackResourceIdentifier) DeepCopy() *CloudStackResourceIdentifier {
	if in == nil {
		return nil
	}
	out := new(CloudStackResourceIdentifier)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *CloudStackZone) DeepCopyInto(out *CloudStackZone) {
	*out = *in
	out.Network = in.Network
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new CloudStackZone.
func (in *CloudStackZone) DeepCopy() *CloudStackZone {
	if in == nil {
		return nil
	}
	out := new(CloudStackZone)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Cluster) DeepCopyInto(out *Cluster) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Cluster.
func (in *Cluster) DeepCopy() *Cluster {
	if in == nil {
		return nil
	}
	out := new(Cluster)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *Cluster) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterList) DeepCopyInto(out *ClusterList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]Cluster, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterList.
func (in *ClusterList) DeepCopy() *ClusterList {
	if in == nil {
		return nil
	}
	out := new(ClusterList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ClusterList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterNetwork) DeepCopyInto(out *ClusterNetwork) {
	*out = *in
	in.Pods.DeepCopyInto(&out.Pods)
	in.Services.DeepCopyInto(&out.Services)
	if in.CNIConfig != nil {
		in, out := &in.CNIConfig, &out.CNIConfig
		*out = new(CNIConfig)
		(*in).DeepCopyInto(*out)
	}
	in.DNS.DeepCopyInto(&out.DNS)
	if in.Nodes != nil {
		in, out := &in.Nodes, &out.Nodes
		*out = new(Nodes)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterNetwork.
func (in *ClusterNetwork) DeepCopy() *ClusterNetwork {
	if in == nil {
		return nil
	}
	out := new(ClusterNetwork)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterSpec) DeepCopyInto(out *ClusterSpec) {
	*out = *in
	in.ControlPlaneConfiguration.DeepCopyInto(&out.ControlPlaneConfiguration)
	if in.WorkerNodeGroupConfigurations != nil {
		in, out := &in.WorkerNodeGroupConfigurations, &out.WorkerNodeGroupConfigurations
		*out = make([]WorkerNodeGroupConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	out.DatacenterRef = in.DatacenterRef
	if in.IdentityProviderRefs != nil {
		in, out := &in.IdentityProviderRefs, &out.IdentityProviderRefs
		*out = make([]Ref, len(*in))
		copy(*out, *in)
	}
	if in.GitOpsRef != nil {
		in, out := &in.GitOpsRef, &out.GitOpsRef
		*out = new(Ref)
		**out = **in
	}
	in.ClusterNetwork.DeepCopyInto(&out.ClusterNetwork)
	if in.ExternalEtcdConfiguration != nil {
		in, out := &in.ExternalEtcdConfiguration, &out.ExternalEtcdConfiguration
		*out = new(ExternalEtcdConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.ProxyConfiguration != nil {
		in, out := &in.ProxyConfiguration, &out.ProxyConfiguration
		*out = new(ProxyConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.RegistryMirrorConfiguration != nil {
		in, out := &in.RegistryMirrorConfiguration, &out.RegistryMirrorConfiguration
		*out = new(RegistryMirrorConfiguration)
		(*in).DeepCopyInto(*out)
	}
	out.ManagementCluster = in.ManagementCluster
	if in.PodIAMConfig != nil {
		in, out := &in.PodIAMConfig, &out.PodIAMConfig
		*out = new(PodIAMConfig)
		**out = **in
	}
	if in.Packages != nil {
		in, out := &in.Packages, &out.Packages
		*out = new(PackageConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.BundlesRef != nil {
		in, out := &in.BundlesRef, &out.BundlesRef
		*out = new(BundlesRef)
		**out = **in
	}
	if in.EksaVersion != nil {
		in, out := &in.EksaVersion, &out.EksaVersion
		*out = new(EksaVersion)
		**out = **in
	}
	if in.MachineHealthCheck != nil {
		in, out := &in.MachineHealthCheck, &out.MachineHealthCheck
		*out = new(MachineHealthCheck)
		(*in).DeepCopyInto(*out)
	}
	if in.EtcdEncryption != nil {
		in, out := &in.EtcdEncryption, &out.EtcdEncryption
		*out = new([]EtcdEncryption)
		if **in != nil {
			in, out := *in, *out
			*out = make([]EtcdEncryption, len(*in))
			for i := range *in {
				(*in)[i].DeepCopyInto(&(*out)[i])
			}
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterSpec.
func (in *ClusterSpec) DeepCopy() *ClusterSpec {
	if in == nil {
		return nil
	}
	out := new(ClusterSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ClusterStatus) DeepCopyInto(out *ClusterStatus) {
	*out = *in
	if in.FailureMessage != nil {
		in, out := &in.FailureMessage, &out.FailureMessage
		*out = new(string)
		**out = **in
	}
	if in.FailureReason != nil {
		in, out := &in.FailureReason, &out.FailureReason
		*out = new(FailureReasonType)
		**out = **in
	}
	if in.EksdReleaseRef != nil {
		in, out := &in.EksdReleaseRef, &out.EksdReleaseRef
		*out = new(EksdReleaseRef)
		**out = **in
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]v1beta1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ClusterStatus.
func (in *ClusterStatus) DeepCopy() *ClusterStatus {
	if in == nil {
		return nil
	}
	out := new(ClusterStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControlPlaneConfiguration) DeepCopyInto(out *ControlPlaneConfiguration) {
	*out = *in
	if in.Endpoint != nil {
		in, out := &in.Endpoint, &out.Endpoint
		*out = new(Endpoint)
		**out = **in
	}
	if in.MachineGroupRef != nil {
		in, out := &in.MachineGroupRef, &out.MachineGroupRef
		*out = new(Ref)
		**out = **in
	}
	if in.Taints != nil {
		in, out := &in.Taints, &out.Taints
		*out = make([]v1.Taint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.UpgradeRolloutStrategy != nil {
		in, out := &in.UpgradeRolloutStrategy, &out.UpgradeRolloutStrategy
		*out = new(ControlPlaneUpgradeRolloutStrategy)
		(*in).DeepCopyInto(*out)
	}
	if in.CertSANs != nil {
		in, out := &in.CertSANs, &out.CertSANs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.MachineHealthCheck != nil {
		in, out := &in.MachineHealthCheck, &out.MachineHealthCheck
		*out = new(MachineHealthCheck)
		(*in).DeepCopyInto(*out)
	}
	if in.APIServerExtraArgs != nil {
		in, out := &in.APIServerExtraArgs, &out.APIServerExtraArgs
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.KubeletConfiguration != nil {
		in, out := &in.KubeletConfiguration, &out.KubeletConfiguration
		*out = (*in).DeepCopy()
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControlPlaneConfiguration.
func (in *ControlPlaneConfiguration) DeepCopy() *ControlPlaneConfiguration {
	if in == nil {
		return nil
	}
	out := new(ControlPlaneConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControlPlaneRollingUpdateParams) DeepCopyInto(out *ControlPlaneRollingUpdateParams) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControlPlaneRollingUpdateParams.
func (in *ControlPlaneRollingUpdateParams) DeepCopy() *ControlPlaneRollingUpdateParams {
	if in == nil {
		return nil
	}
	out := new(ControlPlaneRollingUpdateParams)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControlPlaneUpgrade) DeepCopyInto(out *ControlPlaneUpgrade) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControlPlaneUpgrade.
func (in *ControlPlaneUpgrade) DeepCopy() *ControlPlaneUpgrade {
	if in == nil {
		return nil
	}
	out := new(ControlPlaneUpgrade)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ControlPlaneUpgrade) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControlPlaneUpgradeList) DeepCopyInto(out *ControlPlaneUpgradeList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]ControlPlaneUpgrade, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControlPlaneUpgradeList.
func (in *ControlPlaneUpgradeList) DeepCopy() *ControlPlaneUpgradeList {
	if in == nil {
		return nil
	}
	out := new(ControlPlaneUpgradeList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *ControlPlaneUpgradeList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControlPlaneUpgradeRolloutStrategy) DeepCopyInto(out *ControlPlaneUpgradeRolloutStrategy) {
	*out = *in
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(ControlPlaneRollingUpdateParams)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControlPlaneUpgradeRolloutStrategy.
func (in *ControlPlaneUpgradeRolloutStrategy) DeepCopy() *ControlPlaneUpgradeRolloutStrategy {
	if in == nil {
		return nil
	}
	out := new(ControlPlaneUpgradeRolloutStrategy)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControlPlaneUpgradeSpec) DeepCopyInto(out *ControlPlaneUpgradeSpec) {
	*out = *in
	out.ControlPlane = in.ControlPlane
	if in.MachinesRequireUpgrade != nil {
		in, out := &in.MachinesRequireUpgrade, &out.MachinesRequireUpgrade
		*out = make([]v1.ObjectReference, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControlPlaneUpgradeSpec.
func (in *ControlPlaneUpgradeSpec) DeepCopy() *ControlPlaneUpgradeSpec {
	if in == nil {
		return nil
	}
	out := new(ControlPlaneUpgradeSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ControlPlaneUpgradeStatus) DeepCopyInto(out *ControlPlaneUpgradeStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ControlPlaneUpgradeStatus.
func (in *ControlPlaneUpgradeStatus) DeepCopy() *ControlPlaneUpgradeStatus {
	if in == nil {
		return nil
	}
	out := new(ControlPlaneUpgradeStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DNS) DeepCopyInto(out *DNS) {
	*out = *in
	if in.ResolvConf != nil {
		in, out := &in.ResolvConf, &out.ResolvConf
		*out = new(ResolvConf)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DNS.
func (in *DNS) DeepCopy() *DNS {
	if in == nil {
		return nil
	}
	out := new(DNS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerDatacenterConfig) DeepCopyInto(out *DockerDatacenterConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerDatacenterConfig.
func (in *DockerDatacenterConfig) DeepCopy() *DockerDatacenterConfig {
	if in == nil {
		return nil
	}
	out := new(DockerDatacenterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DockerDatacenterConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerDatacenterConfigList) DeepCopyInto(out *DockerDatacenterConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]DockerDatacenterConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerDatacenterConfigList.
func (in *DockerDatacenterConfigList) DeepCopy() *DockerDatacenterConfigList {
	if in == nil {
		return nil
	}
	out := new(DockerDatacenterConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *DockerDatacenterConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerDatacenterConfigSpec) DeepCopyInto(out *DockerDatacenterConfigSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerDatacenterConfigSpec.
func (in *DockerDatacenterConfigSpec) DeepCopy() *DockerDatacenterConfigSpec {
	if in == nil {
		return nil
	}
	out := new(DockerDatacenterConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *DockerDatacenterConfigStatus) DeepCopyInto(out *DockerDatacenterConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new DockerDatacenterConfigStatus.
func (in *DockerDatacenterConfigStatus) DeepCopy() *DockerDatacenterConfigStatus {
	if in == nil {
		return nil
	}
	out := new(DockerDatacenterConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EksdReleaseRef) DeepCopyInto(out *EksdReleaseRef) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EksdReleaseRef.
func (in *EksdReleaseRef) DeepCopy() *EksdReleaseRef {
	if in == nil {
		return nil
	}
	out := new(EksdReleaseRef)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Endpoint) DeepCopyInto(out *Endpoint) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Endpoint.
func (in *Endpoint) DeepCopy() *Endpoint {
	if in == nil {
		return nil
	}
	out := new(Endpoint)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdEncryption) DeepCopyInto(out *EtcdEncryption) {
	*out = *in
	if in.Providers != nil {
		in, out := &in.Providers, &out.Providers
		*out = make([]EtcdEncryptionProvider, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Resources != nil {
		in, out := &in.Resources, &out.Resources
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdEncryption.
func (in *EtcdEncryption) DeepCopy() *EtcdEncryption {
	if in == nil {
		return nil
	}
	out := new(EtcdEncryption)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *EtcdEncryptionProvider) DeepCopyInto(out *EtcdEncryptionProvider) {
	*out = *in
	if in.KMS != nil {
		in, out := &in.KMS, &out.KMS
		*out = new(KMS)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new EtcdEncryptionProvider.
func (in *EtcdEncryptionProvider) DeepCopy() *EtcdEncryptionProvider {
	if in == nil {
		return nil
	}
	out := new(EtcdEncryptionProvider)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ExternalEtcdConfiguration) DeepCopyInto(out *ExternalEtcdConfiguration) {
	*out = *in
	if in.MachineGroupRef != nil {
		in, out := &in.MachineGroupRef, &out.MachineGroupRef
		*out = new(Ref)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ExternalEtcdConfiguration.
func (in *ExternalEtcdConfiguration) DeepCopy() *ExternalEtcdConfiguration {
	if in == nil {
		return nil
	}
	out := new(ExternalEtcdConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Flux) DeepCopyInto(out *Flux) {
	*out = *in
	out.Github = in.Github
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Flux.
func (in *Flux) DeepCopy() *Flux {
	if in == nil {
		return nil
	}
	out := new(Flux)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluxConfig) DeepCopyInto(out *FluxConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluxConfig.
func (in *FluxConfig) DeepCopy() *FluxConfig {
	if in == nil {
		return nil
	}
	out := new(FluxConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *FluxConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluxConfigList) DeepCopyInto(out *FluxConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]FluxConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluxConfigList.
func (in *FluxConfigList) DeepCopy() *FluxConfigList {
	if in == nil {
		return nil
	}
	out := new(FluxConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *FluxConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluxConfigSpec) DeepCopyInto(out *FluxConfigSpec) {
	*out = *in
	if in.Github != nil {
		in, out := &in.Github, &out.Github
		*out = new(GithubProviderConfig)
		**out = **in
	}
	if in.Git != nil {
		in, out := &in.Git, &out.Git
		*out = new(GitProviderConfig)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluxConfigSpec.
func (in *FluxConfigSpec) DeepCopy() *FluxConfigSpec {
	if in == nil {
		return nil
	}
	out := new(FluxConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *FluxConfigStatus) DeepCopyInto(out *FluxConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new FluxConfigStatus.
func (in *FluxConfigStatus) DeepCopy() *FluxConfigStatus {
	if in == nil {
		return nil
	}
	out := new(FluxConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GitOpsConfig) DeepCopyInto(out *GitOpsConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GitOpsConfig.
func (in *GitOpsConfig) DeepCopy() *GitOpsConfig {
	if in == nil {
		return nil
	}
	out := new(GitOpsConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GitOpsConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GitOpsConfigList) DeepCopyInto(out *GitOpsConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]GitOpsConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GitOpsConfigList.
func (in *GitOpsConfigList) DeepCopy() *GitOpsConfigList {
	if in == nil {
		return nil
	}
	out := new(GitOpsConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *GitOpsConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GitOpsConfigSpec) DeepCopyInto(out *GitOpsConfigSpec) {
	*out = *in
	out.Flux = in.Flux
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GitOpsConfigSpec.
func (in *GitOpsConfigSpec) DeepCopy() *GitOpsConfigSpec {
	if in == nil {
		return nil
	}
	out := new(GitOpsConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GitOpsConfigStatus) DeepCopyInto(out *GitOpsConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GitOpsConfigStatus.
func (in *GitOpsConfigStatus) DeepCopy() *GitOpsConfigStatus {
	if in == nil {
		return nil
	}
	out := new(GitOpsConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GitProviderConfig) DeepCopyInto(out *GitProviderConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GitProviderConfig.
func (in *GitProviderConfig) DeepCopy() *GitProviderConfig {
	if in == nil {
		return nil
	}
	out := new(GitProviderConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Github) DeepCopyInto(out *Github) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Github.
func (in *Github) DeepCopy() *Github {
	if in == nil {
		return nil
	}
	out := new(Github)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *GithubProviderConfig) DeepCopyInto(out *GithubProviderConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new GithubProviderConfig.
func (in *GithubProviderConfig) DeepCopy() *GithubProviderConfig {
	if in == nil {
		return nil
	}
	out := new(GithubProviderConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in HardwareSelector) DeepCopyInto(out *HardwareSelector) {
	{
		in := &in
		*out = make(HardwareSelector, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HardwareSelector.
func (in HardwareSelector) DeepCopy() HardwareSelector {
	if in == nil {
		return nil
	}
	out := new(HardwareSelector)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *HostOSConfiguration) DeepCopyInto(out *HostOSConfiguration) {
	*out = *in
	if in.NTPConfiguration != nil {
		in, out := &in.NTPConfiguration, &out.NTPConfiguration
		*out = new(NTPConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.BottlerocketConfiguration != nil {
		in, out := &in.BottlerocketConfiguration, &out.BottlerocketConfiguration
		*out = new(BottlerocketConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.CertBundles != nil {
		in, out := &in.CertBundles, &out.CertBundles
		*out = make([]certBundle, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new HostOSConfiguration.
func (in *HostOSConfiguration) DeepCopy() *HostOSConfiguration {
	if in == nil {
		return nil
	}
	out := new(HostOSConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *IPPool) DeepCopyInto(out *IPPool) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new IPPool.
func (in *IPPool) DeepCopy() *IPPool {
	if in == nil {
		return nil
	}
	out := new(IPPool)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ImageResource) DeepCopyInto(out *ImageResource) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ImageResource.
func (in *ImageResource) DeepCopy() *ImageResource {
	if in == nil {
		return nil
	}
	out := new(ImageResource)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KMS) DeepCopyInto(out *KMS) {
	*out = *in
	if in.CacheSize != nil {
		in, out := &in.CacheSize, &out.CacheSize
		*out = new(int32)
		**out = **in
	}
	if in.Timeout != nil {
		in, out := &in.Timeout, &out.Timeout
		*out = new(metav1.Duration)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KMS.
func (in *KMS) DeepCopy() *KMS {
	if in == nil {
		return nil
	}
	out := new(KMS)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *KindnetdConfig) DeepCopyInto(out *KindnetdConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new KindnetdConfig.
func (in *KindnetdConfig) DeepCopy() *KindnetdConfig {
	if in == nil {
		return nil
	}
	out := new(KindnetdConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineDeploymentUpgrade) DeepCopyInto(out *MachineDeploymentUpgrade) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineDeploymentUpgrade.
func (in *MachineDeploymentUpgrade) DeepCopy() *MachineDeploymentUpgrade {
	if in == nil {
		return nil
	}
	out := new(MachineDeploymentUpgrade)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MachineDeploymentUpgrade) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineDeploymentUpgradeList) DeepCopyInto(out *MachineDeploymentUpgradeList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]MachineDeploymentUpgrade, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineDeploymentUpgradeList.
func (in *MachineDeploymentUpgradeList) DeepCopy() *MachineDeploymentUpgradeList {
	if in == nil {
		return nil
	}
	out := new(MachineDeploymentUpgradeList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *MachineDeploymentUpgradeList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineDeploymentUpgradeSpec) DeepCopyInto(out *MachineDeploymentUpgradeSpec) {
	*out = *in
	out.MachineDeployment = in.MachineDeployment
	if in.MachinesRequireUpgrade != nil {
		in, out := &in.MachinesRequireUpgrade, &out.MachinesRequireUpgrade
		*out = make([]v1.ObjectReference, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineDeploymentUpgradeSpec.
func (in *MachineDeploymentUpgradeSpec) DeepCopy() *MachineDeploymentUpgradeSpec {
	if in == nil {
		return nil
	}
	out := new(MachineDeploymentUpgradeSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineDeploymentUpgradeStatus) DeepCopyInto(out *MachineDeploymentUpgradeStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineDeploymentUpgradeStatus.
func (in *MachineDeploymentUpgradeStatus) DeepCopy() *MachineDeploymentUpgradeStatus {
	if in == nil {
		return nil
	}
	out := new(MachineDeploymentUpgradeStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MachineHealthCheck) DeepCopyInto(out *MachineHealthCheck) {
	*out = *in
	if in.NodeStartupTimeout != nil {
		in, out := &in.NodeStartupTimeout, &out.NodeStartupTimeout
		*out = new(metav1.Duration)
		**out = **in
	}
	if in.UnhealthyMachineTimeout != nil {
		in, out := &in.UnhealthyMachineTimeout, &out.UnhealthyMachineTimeout
		*out = new(metav1.Duration)
		**out = **in
	}
	if in.MaxUnhealthy != nil {
		in, out := &in.MaxUnhealthy, &out.MaxUnhealthy
		*out = new(intstr.IntOrString)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MachineHealthCheck.
func (in *MachineHealthCheck) DeepCopy() *MachineHealthCheck {
	if in == nil {
		return nil
	}
	out := new(MachineHealthCheck)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ManagementCluster) DeepCopyInto(out *ManagementCluster) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ManagementCluster.
func (in *ManagementCluster) DeepCopy() *ManagementCluster {
	if in == nil {
		return nil
	}
	out := new(ManagementCluster)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MapRoles) DeepCopyInto(out *MapRoles) {
	*out = *in
	if in.Groups != nil {
		in, out := &in.Groups, &out.Groups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MapRoles.
func (in *MapRoles) DeepCopy() *MapRoles {
	if in == nil {
		return nil
	}
	out := new(MapRoles)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *MapUsers) DeepCopyInto(out *MapUsers) {
	*out = *in
	if in.Groups != nil {
		in, out := &in.Groups, &out.Groups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new MapUsers.
func (in *MapUsers) DeepCopy() *MapUsers {
	if in == nil {
		return nil
	}
	out := new(MapUsers)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NTPConfiguration) DeepCopyInto(out *NTPConfiguration) {
	*out = *in
	if in.Servers != nil {
		in, out := &in.Servers, &out.Servers
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NTPConfiguration.
func (in *NTPConfiguration) DeepCopy() *NTPConfiguration {
	if in == nil {
		return nil
	}
	out := new(NTPConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeUpgrade) DeepCopyInto(out *NodeUpgrade) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeUpgrade.
func (in *NodeUpgrade) DeepCopy() *NodeUpgrade {
	if in == nil {
		return nil
	}
	out := new(NodeUpgrade)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NodeUpgrade) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeUpgradeList) DeepCopyInto(out *NodeUpgradeList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]NodeUpgrade, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeUpgradeList.
func (in *NodeUpgradeList) DeepCopy() *NodeUpgradeList {
	if in == nil {
		return nil
	}
	out := new(NodeUpgradeList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NodeUpgradeList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeUpgradeSpec) DeepCopyInto(out *NodeUpgradeSpec) {
	*out = *in
	out.Machine = in.Machine
	if in.EtcdVersion != nil {
		in, out := &in.EtcdVersion, &out.EtcdVersion
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeUpgradeSpec.
func (in *NodeUpgradeSpec) DeepCopy() *NodeUpgradeSpec {
	if in == nil {
		return nil
	}
	out := new(NodeUpgradeSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NodeUpgradeStatus) DeepCopyInto(out *NodeUpgradeStatus) {
	*out = *in
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make([]v1beta1.Condition, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NodeUpgradeStatus.
func (in *NodeUpgradeStatus) DeepCopy() *NodeUpgradeStatus {
	if in == nil {
		return nil
	}
	out := new(NodeUpgradeStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Nodes) DeepCopyInto(out *Nodes) {
	*out = *in
	if in.CIDRMaskSize != nil {
		in, out := &in.CIDRMaskSize, &out.CIDRMaskSize
		*out = new(int)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Nodes.
func (in *Nodes) DeepCopy() *Nodes {
	if in == nil {
		return nil
	}
	out := new(Nodes)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixCategoryIdentifier) DeepCopyInto(out *NutanixCategoryIdentifier) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixCategoryIdentifier.
func (in *NutanixCategoryIdentifier) DeepCopy() *NutanixCategoryIdentifier {
	if in == nil {
		return nil
	}
	out := new(NutanixCategoryIdentifier)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixDatacenterConfig) DeepCopyInto(out *NutanixDatacenterConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixDatacenterConfig.
func (in *NutanixDatacenterConfig) DeepCopy() *NutanixDatacenterConfig {
	if in == nil {
		return nil
	}
	out := new(NutanixDatacenterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NutanixDatacenterConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixDatacenterConfigList) DeepCopyInto(out *NutanixDatacenterConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]NutanixDatacenterConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixDatacenterConfigList.
func (in *NutanixDatacenterConfigList) DeepCopy() *NutanixDatacenterConfigList {
	if in == nil {
		return nil
	}
	out := new(NutanixDatacenterConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NutanixDatacenterConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixDatacenterConfigSpec) DeepCopyInto(out *NutanixDatacenterConfigSpec) {
	*out = *in
	if in.CredentialRef != nil {
		in, out := &in.CredentialRef, &out.CredentialRef
		*out = new(Ref)
		**out = **in
	}
	if in.FailureDomains != nil {
		in, out := &in.FailureDomains, &out.FailureDomains
		*out = make([]NutanixDatacenterFailureDomain, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixDatacenterConfigSpec.
func (in *NutanixDatacenterConfigSpec) DeepCopy() *NutanixDatacenterConfigSpec {
	if in == nil {
		return nil
	}
	out := new(NutanixDatacenterConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixDatacenterConfigStatus) DeepCopyInto(out *NutanixDatacenterConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixDatacenterConfigStatus.
func (in *NutanixDatacenterConfigStatus) DeepCopy() *NutanixDatacenterConfigStatus {
	if in == nil {
		return nil
	}
	out := new(NutanixDatacenterConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixDatacenterFailureDomain) DeepCopyInto(out *NutanixDatacenterFailureDomain) {
	*out = *in
	in.Cluster.DeepCopyInto(&out.Cluster)
	if in.Subnets != nil {
		in, out := &in.Subnets, &out.Subnets
		*out = make([]NutanixResourceIdentifier, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.WorkerMachineGroups != nil {
		in, out := &in.WorkerMachineGroups, &out.WorkerMachineGroups
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixDatacenterFailureDomain.
func (in *NutanixDatacenterFailureDomain) DeepCopy() *NutanixDatacenterFailureDomain {
	if in == nil {
		return nil
	}
	out := new(NutanixDatacenterFailureDomain)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixGPUIdentifier) DeepCopyInto(out *NutanixGPUIdentifier) {
	*out = *in
	if in.DeviceID != nil {
		in, out := &in.DeviceID, &out.DeviceID
		*out = new(int64)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixGPUIdentifier.
func (in *NutanixGPUIdentifier) DeepCopy() *NutanixGPUIdentifier {
	if in == nil {
		return nil
	}
	out := new(NutanixGPUIdentifier)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixMachineConfig) DeepCopyInto(out *NutanixMachineConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixMachineConfig.
func (in *NutanixMachineConfig) DeepCopy() *NutanixMachineConfig {
	if in == nil {
		return nil
	}
	out := new(NutanixMachineConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NutanixMachineConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixMachineConfigList) DeepCopyInto(out *NutanixMachineConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]NutanixMachineConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixMachineConfigList.
func (in *NutanixMachineConfigList) DeepCopy() *NutanixMachineConfigList {
	if in == nil {
		return nil
	}
	out := new(NutanixMachineConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *NutanixMachineConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixMachineConfigSpec) DeepCopyInto(out *NutanixMachineConfigSpec) {
	*out = *in
	if in.Users != nil {
		in, out := &in.Users, &out.Users
		*out = make([]UserConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	out.MemorySize = in.MemorySize.DeepCopy()
	in.Image.DeepCopyInto(&out.Image)
	in.Cluster.DeepCopyInto(&out.Cluster)
	in.Subnet.DeepCopyInto(&out.Subnet)
	if in.Project != nil {
		in, out := &in.Project, &out.Project
		*out = new(NutanixResourceIdentifier)
		(*in).DeepCopyInto(*out)
	}
	out.SystemDiskSize = in.SystemDiskSize.DeepCopy()
	if in.AdditionalCategories != nil {
		in, out := &in.AdditionalCategories, &out.AdditionalCategories
		*out = make([]NutanixCategoryIdentifier, len(*in))
		copy(*out, *in)
	}
	if in.GPUs != nil {
		in, out := &in.GPUs, &out.GPUs
		*out = make([]NutanixGPUIdentifier, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixMachineConfigSpec.
func (in *NutanixMachineConfigSpec) DeepCopy() *NutanixMachineConfigSpec {
	if in == nil {
		return nil
	}
	out := new(NutanixMachineConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixMachineConfigStatus) DeepCopyInto(out *NutanixMachineConfigStatus) {
	*out = *in
	if in.Addresses != nil {
		in, out := &in.Addresses, &out.Addresses
		*out = make([]v1beta1.MachineAddress, len(*in))
		copy(*out, *in)
	}
	if in.VmUUID != nil {
		in, out := &in.VmUUID, &out.VmUUID
		*out = new(string)
		**out = **in
	}
	if in.NodeRef != nil {
		in, out := &in.NodeRef, &out.NodeRef
		*out = new(v1.ObjectReference)
		**out = **in
	}
	if in.Conditions != nil {
		in, out := &in.Conditions, &out.Conditions
		*out = make(v1beta1.Conditions, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixMachineConfigStatus.
func (in *NutanixMachineConfigStatus) DeepCopy() *NutanixMachineConfigStatus {
	if in == nil {
		return nil
	}
	out := new(NutanixMachineConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *NutanixResourceIdentifier) DeepCopyInto(out *NutanixResourceIdentifier) {
	*out = *in
	if in.UUID != nil {
		in, out := &in.UUID, &out.UUID
		*out = new(string)
		**out = **in
	}
	if in.Name != nil {
		in, out := &in.Name, &out.Name
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new NutanixResourceIdentifier.
func (in *NutanixResourceIdentifier) DeepCopy() *NutanixResourceIdentifier {
	if in == nil {
		return nil
	}
	out := new(NutanixResourceIdentifier)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OCINamespace) DeepCopyInto(out *OCINamespace) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OCINamespace.
func (in *OCINamespace) DeepCopy() *OCINamespace {
	if in == nil {
		return nil
	}
	out := new(OCINamespace)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OIDCConfig) DeepCopyInto(out *OIDCConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OIDCConfig.
func (in *OIDCConfig) DeepCopy() *OIDCConfig {
	if in == nil {
		return nil
	}
	out := new(OIDCConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *OIDCConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OIDCConfigList) DeepCopyInto(out *OIDCConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]OIDCConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OIDCConfigList.
func (in *OIDCConfigList) DeepCopy() *OIDCConfigList {
	if in == nil {
		return nil
	}
	out := new(OIDCConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *OIDCConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OIDCConfigRequiredClaim) DeepCopyInto(out *OIDCConfigRequiredClaim) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OIDCConfigRequiredClaim.
func (in *OIDCConfigRequiredClaim) DeepCopy() *OIDCConfigRequiredClaim {
	if in == nil {
		return nil
	}
	out := new(OIDCConfigRequiredClaim)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OIDCConfigSpec) DeepCopyInto(out *OIDCConfigSpec) {
	*out = *in
	if in.RequiredClaims != nil {
		in, out := &in.RequiredClaims, &out.RequiredClaims
		*out = make([]OIDCConfigRequiredClaim, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OIDCConfigSpec.
func (in *OIDCConfigSpec) DeepCopy() *OIDCConfigSpec {
	if in == nil {
		return nil
	}
	out := new(OIDCConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *OIDCConfigStatus) DeepCopyInto(out *OIDCConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new OIDCConfigStatus.
func (in *OIDCConfigStatus) DeepCopy() *OIDCConfigStatus {
	if in == nil {
		return nil
	}
	out := new(OIDCConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ObjectMeta) DeepCopyInto(out *ObjectMeta) {
	*out = *in
	if in.Annotations != nil {
		in, out := &in.Annotations, &out.Annotations
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ObjectMeta.
func (in *ObjectMeta) DeepCopy() *ObjectMeta {
	if in == nil {
		return nil
	}
	out := new(ObjectMeta)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PackageConfiguration) DeepCopyInto(out *PackageConfiguration) {
	*out = *in
	if in.Controller != nil {
		in, out := &in.Controller, &out.Controller
		*out = new(PackageControllerConfiguration)
		(*in).DeepCopyInto(*out)
	}
	if in.CronJob != nil {
		in, out := &in.CronJob, &out.CronJob
		*out = new(PackageControllerCronJob)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PackageConfiguration.
func (in *PackageConfiguration) DeepCopy() *PackageConfiguration {
	if in == nil {
		return nil
	}
	out := new(PackageConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PackageControllerConfiguration) DeepCopyInto(out *PackageControllerConfiguration) {
	*out = *in
	if in.Env != nil {
		in, out := &in.Env, &out.Env
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	out.Resources = in.Resources
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PackageControllerConfiguration.
func (in *PackageControllerConfiguration) DeepCopy() *PackageControllerConfiguration {
	if in == nil {
		return nil
	}
	out := new(PackageControllerConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PackageControllerCronJob) DeepCopyInto(out *PackageControllerCronJob) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PackageControllerCronJob.
func (in *PackageControllerCronJob) DeepCopy() *PackageControllerCronJob {
	if in == nil {
		return nil
	}
	out := new(PackageControllerCronJob)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PackageControllerResources) DeepCopyInto(out *PackageControllerResources) {
	*out = *in
	out.Requests = in.Requests
	out.Limits = in.Limits
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PackageControllerResources.
func (in *PackageControllerResources) DeepCopy() *PackageControllerResources {
	if in == nil {
		return nil
	}
	out := new(PackageControllerResources)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *PodIAMConfig) DeepCopyInto(out *PodIAMConfig) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new PodIAMConfig.
func (in *PodIAMConfig) DeepCopy() *PodIAMConfig {
	if in == nil {
		return nil
	}
	out := new(PodIAMConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Pods) DeepCopyInto(out *Pods) {
	*out = *in
	if in.CidrBlocks != nil {
		in, out := &in.CidrBlocks, &out.CidrBlocks
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Pods.
func (in *Pods) DeepCopy() *Pods {
	if in == nil {
		return nil
	}
	out := new(Pods)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ProxyConfiguration) DeepCopyInto(out *ProxyConfiguration) {
	*out = *in
	if in.NoProxy != nil {
		in, out := &in.NoProxy, &out.NoProxy
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ProxyConfiguration.
func (in *ProxyConfiguration) DeepCopy() *ProxyConfiguration {
	if in == nil {
		return nil
	}
	out := new(ProxyConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Ref) DeepCopyInto(out *Ref) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Ref.
func (in *Ref) DeepCopy() *Ref {
	if in == nil {
		return nil
	}
	out := new(Ref)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *RegistryMirrorConfiguration) DeepCopyInto(out *RegistryMirrorConfiguration) {
	*out = *in
	if in.OCINamespaces != nil {
		in, out := &in.OCINamespaces, &out.OCINamespaces
		*out = make([]OCINamespace, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new RegistryMirrorConfiguration.
func (in *RegistryMirrorConfiguration) DeepCopy() *RegistryMirrorConfiguration {
	if in == nil {
		return nil
	}
	out := new(RegistryMirrorConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *ResolvConf) DeepCopyInto(out *ResolvConf) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new ResolvConf.
func (in *ResolvConf) DeepCopy() *ResolvConf {
	if in == nil {
		return nil
	}
	out := new(ResolvConf)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *Services) DeepCopyInto(out *Services) {
	*out = *in
	if in.CidrBlocks != nil {
		in, out := &in.CidrBlocks, &out.CidrBlocks
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new Services.
func (in *Services) DeepCopy() *Services {
	if in == nil {
		return nil
	}
	out := new(Services)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowDatacenterConfig) DeepCopyInto(out *SnowDatacenterConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowDatacenterConfig.
func (in *SnowDatacenterConfig) DeepCopy() *SnowDatacenterConfig {
	if in == nil {
		return nil
	}
	out := new(SnowDatacenterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SnowDatacenterConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowDatacenterConfigList) DeepCopyInto(out *SnowDatacenterConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]SnowDatacenterConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowDatacenterConfigList.
func (in *SnowDatacenterConfigList) DeepCopy() *SnowDatacenterConfigList {
	if in == nil {
		return nil
	}
	out := new(SnowDatacenterConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SnowDatacenterConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowDatacenterConfigSpec) DeepCopyInto(out *SnowDatacenterConfigSpec) {
	*out = *in
	out.IdentityRef = in.IdentityRef
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowDatacenterConfigSpec.
func (in *SnowDatacenterConfigSpec) DeepCopy() *SnowDatacenterConfigSpec {
	if in == nil {
		return nil
	}
	out := new(SnowDatacenterConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowDatacenterConfigStatus) DeepCopyInto(out *SnowDatacenterConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowDatacenterConfigStatus.
func (in *SnowDatacenterConfigStatus) DeepCopy() *SnowDatacenterConfigStatus {
	if in == nil {
		return nil
	}
	out := new(SnowDatacenterConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowDirectNetworkInterface) DeepCopyInto(out *SnowDirectNetworkInterface) {
	*out = *in
	if in.VlanID != nil {
		in, out := &in.VlanID, &out.VlanID
		*out = new(int32)
		**out = **in
	}
	if in.IPPoolRef != nil {
		in, out := &in.IPPoolRef, &out.IPPoolRef
		*out = new(Ref)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowDirectNetworkInterface.
func (in *SnowDirectNetworkInterface) DeepCopy() *SnowDirectNetworkInterface {
	if in == nil {
		return nil
	}
	out := new(SnowDirectNetworkInterface)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowIPPool) DeepCopyInto(out *SnowIPPool) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowIPPool.
func (in *SnowIPPool) DeepCopy() *SnowIPPool {
	if in == nil {
		return nil
	}
	out := new(SnowIPPool)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SnowIPPool) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowIPPoolList) DeepCopyInto(out *SnowIPPoolList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]SnowIPPool, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowIPPoolList.
func (in *SnowIPPoolList) DeepCopy() *SnowIPPoolList {
	if in == nil {
		return nil
	}
	out := new(SnowIPPoolList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SnowIPPoolList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowIPPoolSpec) DeepCopyInto(out *SnowIPPoolSpec) {
	*out = *in
	if in.Pools != nil {
		in, out := &in.Pools, &out.Pools
		*out = make([]IPPool, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowIPPoolSpec.
func (in *SnowIPPoolSpec) DeepCopy() *SnowIPPoolSpec {
	if in == nil {
		return nil
	}
	out := new(SnowIPPoolSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowIPPoolStatus) DeepCopyInto(out *SnowIPPoolStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowIPPoolStatus.
func (in *SnowIPPoolStatus) DeepCopy() *SnowIPPoolStatus {
	if in == nil {
		return nil
	}
	out := new(SnowIPPoolStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowMachineConfig) DeepCopyInto(out *SnowMachineConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowMachineConfig.
func (in *SnowMachineConfig) DeepCopy() *SnowMachineConfig {
	if in == nil {
		return nil
	}
	out := new(SnowMachineConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SnowMachineConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowMachineConfigList) DeepCopyInto(out *SnowMachineConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]SnowMachineConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowMachineConfigList.
func (in *SnowMachineConfigList) DeepCopy() *SnowMachineConfigList {
	if in == nil {
		return nil
	}
	out := new(SnowMachineConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *SnowMachineConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowMachineConfigSpec) DeepCopyInto(out *SnowMachineConfigSpec) {
	*out = *in
	if in.Devices != nil {
		in, out := &in.Devices, &out.Devices
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.ContainersVolume != nil {
		in, out := &in.ContainersVolume, &out.ContainersVolume
		*out = new(snowapiv1beta1.Volume)
		**out = **in
	}
	if in.NonRootVolumes != nil {
		in, out := &in.NonRootVolumes, &out.NonRootVolumes
		*out = make([]*snowapiv1beta1.Volume, len(*in))
		for i := range *in {
			if (*in)[i] != nil {
				in, out := &(*in)[i], &(*out)[i]
				*out = new(snowapiv1beta1.Volume)
				**out = **in
			}
		}
	}
	in.Network.DeepCopyInto(&out.Network)
	if in.HostOSConfiguration != nil {
		in, out := &in.HostOSConfiguration, &out.HostOSConfiguration
		*out = new(HostOSConfiguration)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowMachineConfigSpec.
func (in *SnowMachineConfigSpec) DeepCopy() *SnowMachineConfigSpec {
	if in == nil {
		return nil
	}
	out := new(SnowMachineConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowMachineConfigStatus) DeepCopyInto(out *SnowMachineConfigStatus) {
	*out = *in
	if in.FailureMessage != nil {
		in, out := &in.FailureMessage, &out.FailureMessage
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowMachineConfigStatus.
func (in *SnowMachineConfigStatus) DeepCopy() *SnowMachineConfigStatus {
	if in == nil {
		return nil
	}
	out := new(SnowMachineConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *SnowNetwork) DeepCopyInto(out *SnowNetwork) {
	*out = *in
	if in.DirectNetworkInterfaces != nil {
		in, out := &in.DirectNetworkInterfaces, &out.DirectNetworkInterfaces
		*out = make([]SnowDirectNetworkInterface, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SnowNetwork.
func (in *SnowNetwork) DeepCopy() *SnowNetwork {
	if in == nil {
		return nil
	}
	out := new(SnowNetwork)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in SymlinkMaps) DeepCopyInto(out *SymlinkMaps) {
	{
		in := &in
		*out = make(SymlinkMaps, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new SymlinkMaps.
func (in SymlinkMaps) DeepCopy() SymlinkMaps {
	if in == nil {
		return nil
	}
	out := new(SymlinkMaps)
	in.DeepCopyInto(out)
	return *out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellDatacenterConfig) DeepCopyInto(out *TinkerbellDatacenterConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellDatacenterConfig.
func (in *TinkerbellDatacenterConfig) DeepCopy() *TinkerbellDatacenterConfig {
	if in == nil {
		return nil
	}
	out := new(TinkerbellDatacenterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TinkerbellDatacenterConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellDatacenterConfigList) DeepCopyInto(out *TinkerbellDatacenterConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]TinkerbellDatacenterConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellDatacenterConfigList.
func (in *TinkerbellDatacenterConfigList) DeepCopy() *TinkerbellDatacenterConfigList {
	if in == nil {
		return nil
	}
	out := new(TinkerbellDatacenterConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TinkerbellDatacenterConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellDatacenterConfigSpec) DeepCopyInto(out *TinkerbellDatacenterConfigSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellDatacenterConfigSpec.
func (in *TinkerbellDatacenterConfigSpec) DeepCopy() *TinkerbellDatacenterConfigSpec {
	if in == nil {
		return nil
	}
	out := new(TinkerbellDatacenterConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellDatacenterConfigStatus) DeepCopyInto(out *TinkerbellDatacenterConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellDatacenterConfigStatus.
func (in *TinkerbellDatacenterConfigStatus) DeepCopy() *TinkerbellDatacenterConfigStatus {
	if in == nil {
		return nil
	}
	out := new(TinkerbellDatacenterConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellMachineConfig) DeepCopyInto(out *TinkerbellMachineConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellMachineConfig.
func (in *TinkerbellMachineConfig) DeepCopy() *TinkerbellMachineConfig {
	if in == nil {
		return nil
	}
	out := new(TinkerbellMachineConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TinkerbellMachineConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellMachineConfigList) DeepCopyInto(out *TinkerbellMachineConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]TinkerbellMachineConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellMachineConfigList.
func (in *TinkerbellMachineConfigList) DeepCopy() *TinkerbellMachineConfigList {
	if in == nil {
		return nil
	}
	out := new(TinkerbellMachineConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TinkerbellMachineConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellMachineConfigSpec) DeepCopyInto(out *TinkerbellMachineConfigSpec) {
	*out = *in
	if in.HardwareSelector != nil {
		in, out := &in.HardwareSelector, &out.HardwareSelector
		*out = make(HardwareSelector, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	out.TemplateRef = in.TemplateRef
	if in.Users != nil {
		in, out := &in.Users, &out.Users
		*out = make([]UserConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.HostOSConfiguration != nil {
		in, out := &in.HostOSConfiguration, &out.HostOSConfiguration
		*out = new(HostOSConfiguration)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellMachineConfigSpec.
func (in *TinkerbellMachineConfigSpec) DeepCopy() *TinkerbellMachineConfigSpec {
	if in == nil {
		return nil
	}
	out := new(TinkerbellMachineConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellMachineConfigStatus) DeepCopyInto(out *TinkerbellMachineConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellMachineConfigStatus.
func (in *TinkerbellMachineConfigStatus) DeepCopy() *TinkerbellMachineConfigStatus {
	if in == nil {
		return nil
	}
	out := new(TinkerbellMachineConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellTemplateConfig) DeepCopyInto(out *TinkerbellTemplateConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellTemplateConfig.
func (in *TinkerbellTemplateConfig) DeepCopy() *TinkerbellTemplateConfig {
	if in == nil {
		return nil
	}
	out := new(TinkerbellTemplateConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TinkerbellTemplateConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellTemplateConfigList) DeepCopyInto(out *TinkerbellTemplateConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]TinkerbellTemplateConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellTemplateConfigList.
func (in *TinkerbellTemplateConfigList) DeepCopy() *TinkerbellTemplateConfigList {
	if in == nil {
		return nil
	}
	out := new(TinkerbellTemplateConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *TinkerbellTemplateConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellTemplateConfigSpec) DeepCopyInto(out *TinkerbellTemplateConfigSpec) {
	*out = *in
	in.Template.DeepCopyInto(&out.Template)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellTemplateConfigSpec.
func (in *TinkerbellTemplateConfigSpec) DeepCopy() *TinkerbellTemplateConfigSpec {
	if in == nil {
		return nil
	}
	out := new(TinkerbellTemplateConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *TinkerbellTemplateConfigStatus) DeepCopyInto(out *TinkerbellTemplateConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new TinkerbellTemplateConfigStatus.
func (in *TinkerbellTemplateConfigStatus) DeepCopy() *TinkerbellTemplateConfigStatus {
	if in == nil {
		return nil
	}
	out := new(TinkerbellTemplateConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *UserConfiguration) DeepCopyInto(out *UserConfiguration) {
	*out = *in
	if in.SshAuthorizedKeys != nil {
		in, out := &in.SshAuthorizedKeys, &out.SshAuthorizedKeys
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new UserConfiguration.
func (in *UserConfiguration) DeepCopy() *UserConfiguration {
	if in == nil {
		return nil
	}
	out := new(UserConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSphereDatacenterConfig) DeepCopyInto(out *VSphereDatacenterConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	out.Spec = in.Spec
	in.Status.DeepCopyInto(&out.Status)
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSphereDatacenterConfig.
func (in *VSphereDatacenterConfig) DeepCopy() *VSphereDatacenterConfig {
	if in == nil {
		return nil
	}
	out := new(VSphereDatacenterConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VSphereDatacenterConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSphereDatacenterConfigList) DeepCopyInto(out *VSphereDatacenterConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VSphereDatacenterConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSphereDatacenterConfigList.
func (in *VSphereDatacenterConfigList) DeepCopy() *VSphereDatacenterConfigList {
	if in == nil {
		return nil
	}
	out := new(VSphereDatacenterConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VSphereDatacenterConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSphereDatacenterConfigSpec) DeepCopyInto(out *VSphereDatacenterConfigSpec) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSphereDatacenterConfigSpec.
func (in *VSphereDatacenterConfigSpec) DeepCopy() *VSphereDatacenterConfigSpec {
	if in == nil {
		return nil
	}
	out := new(VSphereDatacenterConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSphereDatacenterConfigStatus) DeepCopyInto(out *VSphereDatacenterConfigStatus) {
	*out = *in
	if in.FailureMessage != nil {
		in, out := &in.FailureMessage, &out.FailureMessage
		*out = new(string)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSphereDatacenterConfigStatus.
func (in *VSphereDatacenterConfigStatus) DeepCopy() *VSphereDatacenterConfigStatus {
	if in == nil {
		return nil
	}
	out := new(VSphereDatacenterConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSphereMachineConfig) DeepCopyInto(out *VSphereMachineConfig) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ObjectMeta.DeepCopyInto(&out.ObjectMeta)
	in.Spec.DeepCopyInto(&out.Spec)
	out.Status = in.Status
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSphereMachineConfig.
func (in *VSphereMachineConfig) DeepCopy() *VSphereMachineConfig {
	if in == nil {
		return nil
	}
	out := new(VSphereMachineConfig)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VSphereMachineConfig) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSphereMachineConfigList) DeepCopyInto(out *VSphereMachineConfigList) {
	*out = *in
	out.TypeMeta = in.TypeMeta
	in.ListMeta.DeepCopyInto(&out.ListMeta)
	if in.Items != nil {
		in, out := &in.Items, &out.Items
		*out = make([]VSphereMachineConfig, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSphereMachineConfigList.
func (in *VSphereMachineConfigList) DeepCopy() *VSphereMachineConfigList {
	if in == nil {
		return nil
	}
	out := new(VSphereMachineConfigList)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyObject is an autogenerated deepcopy function, copying the receiver, creating a new runtime.Object.
func (in *VSphereMachineConfigList) DeepCopyObject() runtime.Object {
	if c := in.DeepCopy(); c != nil {
		return c
	}
	return nil
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSphereMachineConfigSpec) DeepCopyInto(out *VSphereMachineConfigSpec) {
	*out = *in
	if in.Users != nil {
		in, out := &in.Users, &out.Users
		*out = make([]UserConfiguration, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.TagIDs != nil {
		in, out := &in.TagIDs, &out.TagIDs
		*out = make([]string, len(*in))
		copy(*out, *in)
	}
	if in.HostOSConfiguration != nil {
		in, out := &in.HostOSConfiguration, &out.HostOSConfiguration
		*out = new(HostOSConfiguration)
		(*in).DeepCopyInto(*out)
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSphereMachineConfigSpec.
func (in *VSphereMachineConfigSpec) DeepCopy() *VSphereMachineConfigSpec {
	if in == nil {
		return nil
	}
	out := new(VSphereMachineConfigSpec)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *VSphereMachineConfigStatus) DeepCopyInto(out *VSphereMachineConfigStatus) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new VSphereMachineConfigStatus.
func (in *VSphereMachineConfigStatus) DeepCopy() *VSphereMachineConfigStatus {
	if in == nil {
		return nil
	}
	out := new(VSphereMachineConfigStatus)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WorkerNodeGroupConfiguration) DeepCopyInto(out *WorkerNodeGroupConfiguration) {
	*out = *in
	if in.Count != nil {
		in, out := &in.Count, &out.Count
		*out = new(int)
		**out = **in
	}
	if in.AutoScalingConfiguration != nil {
		in, out := &in.AutoScalingConfiguration, &out.AutoScalingConfiguration
		*out = new(AutoScalingConfiguration)
		**out = **in
	}
	if in.MachineGroupRef != nil {
		in, out := &in.MachineGroupRef, &out.MachineGroupRef
		*out = new(Ref)
		**out = **in
	}
	if in.Taints != nil {
		in, out := &in.Taints, &out.Taints
		*out = make([]v1.Taint, len(*in))
		for i := range *in {
			(*in)[i].DeepCopyInto(&(*out)[i])
		}
	}
	if in.Labels != nil {
		in, out := &in.Labels, &out.Labels
		*out = make(map[string]string, len(*in))
		for key, val := range *in {
			(*out)[key] = val
		}
	}
	if in.UpgradeRolloutStrategy != nil {
		in, out := &in.UpgradeRolloutStrategy, &out.UpgradeRolloutStrategy
		*out = new(WorkerNodesUpgradeRolloutStrategy)
		(*in).DeepCopyInto(*out)
	}
	if in.KubernetesVersion != nil {
		in, out := &in.KubernetesVersion, &out.KubernetesVersion
		*out = new(KubernetesVersion)
		**out = **in
	}
	if in.MachineHealthCheck != nil {
		in, out := &in.MachineHealthCheck, &out.MachineHealthCheck
		*out = new(MachineHealthCheck)
		(*in).DeepCopyInto(*out)
	}
	if in.KubeletConfiguration != nil {
		in, out := &in.KubeletConfiguration, &out.KubeletConfiguration
		*out = (*in).DeepCopy()
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WorkerNodeGroupConfiguration.
func (in *WorkerNodeGroupConfiguration) DeepCopy() *WorkerNodeGroupConfiguration {
	if in == nil {
		return nil
	}
	out := new(WorkerNodeGroupConfiguration)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WorkerNodesRollingUpdateParams) DeepCopyInto(out *WorkerNodesRollingUpdateParams) {
	*out = *in
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WorkerNodesRollingUpdateParams.
func (in *WorkerNodesRollingUpdateParams) DeepCopy() *WorkerNodesRollingUpdateParams {
	if in == nil {
		return nil
	}
	out := new(WorkerNodesRollingUpdateParams)
	in.DeepCopyInto(out)
	return out
}

// DeepCopyInto is an autogenerated deepcopy function, copying the receiver, writing into out. in must be non-nil.
func (in *WorkerNodesUpgradeRolloutStrategy) DeepCopyInto(out *WorkerNodesUpgradeRolloutStrategy) {
	*out = *in
	if in.RollingUpdate != nil {
		in, out := &in.RollingUpdate, &out.RollingUpdate
		*out = new(WorkerNodesRollingUpdateParams)
		**out = **in
	}
}

// DeepCopy is an autogenerated deepcopy function, copying the receiver, creating a new WorkerNodesUpgradeRolloutStrategy.
func (in *WorkerNodesUpgradeRolloutStrategy) DeepCopy() *WorkerNodesUpgradeRolloutStrategy {
	if in == nil {
		return nil
	}
	out := new(WorkerNodesUpgradeRolloutStrategy)
	in.DeepCopyInto(out)
	return out
}
