// Code generated by smithy-go-codegen DO NOT EDIT.

package snowballdevice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/eks-anywhere/internal/aws-sdk-go-v2/service/snowballdevice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

func (c *Client) DescribeAutoStartConfigurations(ctx context.Context, params *DescribeAutoStartConfigurationsInput, optFns ...func(*Options)) (*DescribeAutoStartConfigurationsOutput, error) {
	if params == nil {
		params = &DescribeAutoStartConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeAutoStartConfigurations", params, optFns, c.addOperationDescribeAutoStartConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeAutoStartConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeAutoStartConfigurationsInput struct {
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeAutoStartConfigurationsOutput struct {
	AutoStartConfigurations []types.AutoStartConfigurationDetails

	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeAutoStartConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDescribeAutoStartConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDescribeAutoStartConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeAutoStartConfigurations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeAutoStartConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeAutoStartConfigurationsAPIClient is a client that implements the
// DescribeAutoStartConfigurations operation.
type DescribeAutoStartConfigurationsAPIClient interface {
	DescribeAutoStartConfigurations(context.Context, *DescribeAutoStartConfigurationsInput, ...func(*Options)) (*DescribeAutoStartConfigurationsOutput, error)
}

var _ DescribeAutoStartConfigurationsAPIClient = (*Client)(nil)

// DescribeAutoStartConfigurationsPaginatorOptions is the paginator options for
// DescribeAutoStartConfigurations
type DescribeAutoStartConfigurationsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeAutoStartConfigurationsPaginator is a paginator for
// DescribeAutoStartConfigurations
type DescribeAutoStartConfigurationsPaginator struct {
	options   DescribeAutoStartConfigurationsPaginatorOptions
	client    DescribeAutoStartConfigurationsAPIClient
	params    *DescribeAutoStartConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewDescribeAutoStartConfigurationsPaginator returns a new
// DescribeAutoStartConfigurationsPaginator
func NewDescribeAutoStartConfigurationsPaginator(client DescribeAutoStartConfigurationsAPIClient, params *DescribeAutoStartConfigurationsInput, optFns ...func(*DescribeAutoStartConfigurationsPaginatorOptions)) *DescribeAutoStartConfigurationsPaginator {
	if params == nil {
		params = &DescribeAutoStartConfigurationsInput{}
	}

	options := DescribeAutoStartConfigurationsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeAutoStartConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeAutoStartConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeAutoStartConfigurations page.
func (p *DescribeAutoStartConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeAutoStartConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.DescribeAutoStartConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeAutoStartConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeAutoStartConfigurations",
	}
}
