---
title: "v0.14.5"
linkTitle: "v0.14.5"
weight: 20
aliases:
    /docs/reference/packagespec/metallb/v0.14.5/
description: >
---

{{% pageinfo %}}
[FRRouting](https://frrouting.org/) is currently not supported for MetalLB.
{{% /pageinfo %}}

### Configuring MetalLB in EKS Anywhere package spec

#### Example
```
apiVersion: packages.eks.amazonaws.com/v1alpha1
kind: Package
metadata:
  name: mylb
  namespace: eksa-packages-<cluster-name>
spec:
  packageName: metallb
  targetNamespace: metallb-system
  config: |
    IPAddressPools:
      - name: default
        addresses:
          - 10.220.0.93/32
          - 10.220.0.94/32
          - 10.220.0.95/32
      - name: bgp
        addresses:
          - 10.220.0.97-10.220.0.99
    L2Advertisements:
      - ipAddressPools:
          - default
    BGPAdvertisements:
      - ipAddressPools:
          - bgp 
        autoAssign: false
    BGPPeers:
      - myASN: 123
        peerASN: 55001
        peerAddress: 1.2.3.4
        keepaliveTime: 30s
```

| Parameter | Description | Default | Required |
|---|---|---|---|
| IPAddressPools[] | A list of ip address pools. See **IPAddressPool**. | None | False |
| L2Advertisements[] | A list of Layer 2 advertisements. See **L2Advertisement**. | None | False |
| BGPAdvertisements[] | A list of BGP advertisements. See **BGPAdvertisement**. | None | False |
| BGPPeers[] | A list of BGP peers. See **BGPPeer**. | None | False |
|---|---|---|---|
|**IPAddressPool** | A list of IP address ranges over which MetalLB has authority. You can list multiple ranges in a single pool and they will all share the same settings. Each range can be either a CIDR prefix, or an explicit start-end range of IPs.|||
| name | Name for the address pool. | None | True |
| addresses[] | A list of **string** representing CIRD or IP ranges. | None | True |
| autoAssign | AutoAssign flag used to prevent MetalLB from automatic allocation for a pool. | true | False |
|---|---|---|---|
|**L2Advertisement**|L2Advertisement allows MetalLB to advertise the LoadBalancer IPs provided by the selected pools via L2.|||
| ipAddressPools[] | The list of **IPAddressPool** names to advertise. | None | True |
| name | Name for the L2Advertisement. | None | False |
|---|---|---|---|
|**BGPAdvertisement**|BGPAdvertisement allows MetalLB to advertise the IPs coming from the selected ipAddressPools via BGP, setting the parameters of the BGP Advertisement.|||
| aggregationLength | The aggregation-length advertisement option lets you “roll up” the /32s into a larger prefix. Defaults to 32. Works for IPv4 addresses. | 32 | False |
| aggregationLengthV6 | The aggregation-length advertisement option lets you “roll up” the /128s into a larger prefix. Defaults to 128. Works for IPv6 addresses. | 128 | False |
| communities[] | The BGP communities to be associated with the announcement. Each item can be a community of the form 1234:1234 or the name of an alias defined in the Community CRD. | None | False |
| ipAddressPools[] | The list of **IPAddressPool** names to be advertised via BGP. | None | True |
| localPref | The BGP LOCAL_PREF attribute which is used by BGP best path algorithm, Path with higher localpref is preferred over one with lower localpref. | None | False |
| peers[] | List of peer names. Limits the bgppeer to advertise the ips of the selected pools to. When empty, the loadbalancer IP is announced to all the BGPPeers configured. | None | False |
|---|---|---|---|
|**BGPPeer**|Peers for the BGP protocol.|||
| holdTime | Requested BGP hold time, per RFC4271. | None | False |
| keepaliveTime | Requested BGP keepalive time, per RFC4271. | None | False |
| myASN | AS number to use for the local end of the session. | None | True |
| password | Authentication password for routers enforcing TCP MD5 authenticated sessions. | None | False |
| peerASN | AS number to expect from the remote end of the session. | None | True |
| peerAddress | Address to dial when establishing the session. | None | True |
| peerPort | Port to dial when establishing the session. | 179 | False |
| routerID | BGP router ID to advertise to the peer. | None | False |
| sourceAddress | Source address to use when establishing the session. | None | False |
| password | Authentication password for routers enforcing TCP MD5 authenticated sessions. | None | False |
| passwordSecret | passwordSecret is a reference to the authentication secret for BGP Peer. The secret must be of type 'kubernetes.io/basic-auth' and the password stored under the "password" key. Example: <br/><pre>passwordSecret:<br/>  name: mySecret<br/>  namespace: metallb-system</pre> | None | False|
