---
title: "v0.12.1"
linkTitle: "v0.12.1"
weight: 20
aliases:
    /docs/reference/packagespec/metallb/v0.12.1/
description: >
---

{{% pageinfo %}}
[FRRouting](https://frrouting.org/) is currently not supported for MetalLB.
{{% /pageinfo %}}

### Configuring MetalLB in EKS Anywhere package spec

#### Example
```
apiVersion: packages.eks.amazonaws.com/v1alpha1
kind: Package
metadata:
  name: mylb
  namespace: eksa-packages-<cluster-name>
spec:
  packageName: metallb
  targetNamespace: metallb-system
  config: |
    IPAddressPools:
      - name: default
        addresses:
          - 10.220.0.93/32
          - 10.220.0.94/32
          - 10.220.0.95/32
      - name: bgp
        addresses:
          - 10.220.0.97-10.220.0.99
    L2Advertisements:
      - IPAddressPools:
          - default
    BGPAdvertisements:
      - IPAddressPools:
          - bgp 
    BGPPeers:
      - myASN: 123
        peerASN: 55001
        peerAddress: 1.2.3.4
        keepaliveTime: 30s
```

| Parameter | Description | Default |
|---|---|---|
| IPAddressPools[] | A list of **IPAddressPool**. | None |
| L2Advertisements[] | A list of **L2Advertisement**. | None |
| BGPAdvertisements[] | A list of **BGPAdvertisement**. | None |
| BGPPeers[] | A list of **BGPPeer**. | None |
|---|---|---|
|**IPAddressPool**|A list of IP address ranges over which MetalLB has authority. You can list multiple ranges in a single pool and they will all share the same settings. Each range can be either a CIDR prefix, or an explicit start-end range of IPs.||
| name | Name for the address pool. | None |
| addresses[] | A list of **string** representing CIRD or IP ranges. | None |
| autoAssign | AutoAssign flag used to prevent MetalLB from automatic allocation for a pool. | true |
|---|---|---|
|**L2Advertisement**|L2Advertisement allows MetalLB to advertise the LoadBalancer IPs provided by the selected pools via L2.||
| IPAddressPools[] | The list of IPAddressPools to advertise via this advertisement, selected by name. | None |
|---|---|---|
|**BGPAdvertisement**|BGPAdvertisement allows MetalLB to advertise the IPs coming from the selected IPAddressPools via BGP, setting the parameters of the BGP Advertisement.||
| aggregationLength | The aggregation-length advertisement option lets you “roll up” the /32s into a larger prefix. Defaults to 32. Works for IPv4 addresses. | 32 |
| aggregationLengthV6 | The aggregation-length advertisement option lets you “roll up” the /128s into a larger prefix. Defaults to 128. Works for IPv6 addresses. | 128 |
| communities[] | The BGP communities to be associated with the announcement. Each item can be a community of the form 1234:1234 or the name of an alias defined in the Community CRD. | None |
| IPAddressPools[] | The list of IPAddressPools to advertise via this advertisement, selected by name. | None |
| localPref | The BGP LOCAL_PREF attribute which is used by BGP best path algorithm, Path with higher localpref is preferred over one with lower localpref. | None |
|---|---|---|
|**BGPPeer**|Peers for the BGP protocol.||
| bfdProfile | The name of the BFD Profile to be used for the BFD session associated to the BGP session. If not set, the BFD session won't be set up. | None |
| holdTime | Requested BGP hold time, per RFC4271. | None |
| keepaliveTime | Requested BGP keepalive time, per RFC4271. | None |
| myASN | AS number to use for the local end of the session. | None |
| password | Authentication password for routers enforcing TCP MD5 authenticated sessions. | None |
| peerASN | AS number to expect from the remote end of the session. | None |
| peerAddress | Address to dial when establishing the session. | None |
| peerPort | Port to dial when establishing the session. | 179 |
| routerID | BGP router ID to advertise to the peer. | None |
| sourceAddress | Source address to use when establishing the session. | None |
