---
title: "v2.10.2"
linkTitle: "v2.10.2"
weight: 60
aliases:
    /docs/reference/packagespec/harbor/v2.10.2/
description: >
---

### Configuring Harbor in EKS Anywhere package spec
The following table lists the configurable parameters of the Harbor package spec and the default values.

| Parameter                                                            | Description                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Default                               |
| -------------------------------------------------------------------- | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------- |
| **General**                                                          |                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                                       |
| `externalURL`                                                        | The external URL for Harbor core service                                                                                                                                                                                                                                                                                                                                                                                                                          | `https://127.0.0.1:30003`          |
| `imagePullPolicy`                                                    | The image pull policy  | `IfNotPresent`                                                                                                                                                                                                                                                                                                                                                                                                                                            |                                       |
| `logLevel`                                                           | The log level: `debug`, `info`, `warning`, `error` or `fatal`                                                                                                                                                                                                                                                                                                                                                                                                     | `info`                                |
| `harborAdminPassword`                                                | The initial password of the Harbor `admin` account. Change it from the portal after launching Harbor                                                                                                                                                                                                                                                                                                                                                                                | `Harbor12345`                         |
| `secretKey`                                                          | The key used for encryption. Must be a string of 16 chars                                                                                                                                                                                                                                                                                                                                                                                                         | ""                    |
| **Expose**                                                           |                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                                       |
| `expose.type`                                                        | How to expose the service: `nodePort` or `loadBalancer`, other values will be ignored and the creation of the service will be skipped.                                                                                                                                                                                                                                                                                                        | `nodePort`                             |
| `expose.tls.enabled`                                                 | Enable TLS or not.                                                                                                            | `true`                                |
| `expose.tls.certSource`                                              | The source of the TLS certificate. Set as `auto`, `secret` or `none` and fill the information in the corresponding section: 1) auto: generate the TLS certificate automatically 2) secret: read the TLS certificate from the specified secret. The TLS certificate can be generated manually or by cert manager 3) none: configure no TLS certificate. | `secret`                                |
| `expose.tls.auto.commonName`                                         | The common name used to generate the certificate. It's necessary when `expose.tls.certSource` is set to `auto`                                                                                                                                                                                                                                                                                                                                                                    |                                       |
| `expose.tls.secret.secretName`                                       | The name of the secret which contains keys named: `tls.crt` - the certificate; `tls.key` - the private key                                                                                                                                                                                                                                                                                                                                                            |  `harbor-tls-secret`                            |
| `expose.nodePort.name`                                               | The name of the NodePort service                                                                                                                                                                                                                                                                                                                                                                                                                                      | `harbor`                              |
| `expose.nodePort.ports.http.port`                                    | The service port Harbor listens on when serving HTTP                                                                                                                                                                                                                                                                                                                                                                                                              | `80`                                  |
| `expose.nodePort.ports.http.nodePort`                                | The node port Harbor listens on when serving HTTP                                                                                                                                                                                                                                                                                                                                                                                                                 | `30002`                               |
| `expose.nodePort.ports.https.port`                                   | The service port Harbor listens on when serving HTTPS                                                                                                                                                                                                                                                                                                                                                                                                             | `443`                                 |
| `expose.nodePort.ports.https.nodePort`                               | The node port Harbor listens on when serving HTTPS                                                                                                                                                                                                                                                                                                                                                                                                                | `30003`                               |
| `expose.loadBalancer.name`                                           | The name of the service                                                                                                                                                                                                                                                                                                                                                                                                                                               | `harbor`                              |
| `expose.loadBalancer.IP`                                             | The IP address of the loadBalancer. It only works when loadBalancer supports assigning an IP address                                                                                                                                                                                                                                                                                                                                                                                 | `""`                                  |
| `expose.loadBalancer.ports.httpPort`                                 | The service port Harbor listens on when serving HTTP                                                                                                                                                                                                                                                                                                                                                                                                              | `80`                                  |
| `expose.loadBalancer.ports.httpsPort`                                | The service port Harbor listens on when serving HTTPS                                                                                                                                                                                                                                                                                                                                                                                                             | `30002`                               |
| `expose.loadBalancer.annotations`                                    | The annotations attached to the loadBalancer service                                                                                                                                                                                                                                                                                                                                                                                                              | {}                                    |
| `expose.loadBalancer.sourceRanges`                                   | List of IP address ranges to assign to loadBalancerSourceRanges                                                                                                                                                                                                                                                                                                                                                                                                   | []                                    |
| **Internal TLS**                                                     |                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                                       |
| `internalTLS.enabled`                                                | Enable TLS for the components (core, jobservice, portal, and registry)                                                                                                                                                                                                                                                                                                                                                                            | `true`                               |
| **Persistence**                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                                       |
| `persistence.resourcePolicy`                                         | Setting it to `keep` to avoid removing PVCs during a helm delete operation. Leaving it empty will delete PVCs after the chart is deleted. Does not affect PVCs created for internal database and redis components.                                                                                                                                                                                                                                                   | `keep`                                |
| `persistence.persistentVolumeClaim.registry.size`                    | The size of the volume                                                                                                                                                                                                                                                                                                                                                                                                                                            | `5Gi`                                 |
| `persistence.persistentVolumeClaim.registry.storageClass`            | Specify the `storageClass` used to provision the volume, or the default StorageClass will be used (the default). Set it to `-` to disable dynamic provisioning                                                                                                                                                                                                                                                                                                    |                  ""                     |
| `persistence.persistentVolumeClaim.jobservice.jobLog.size`                  | The size of the volume                                                                                                                                                                                                                                                                                                                                                                                                                                            | `1Gi`                                 |
| `persistence.persistentVolumeClaim.jobservice.jobLog.storageClass`          | Specify the `storageClass` used to provision the volume, or the default StorageClass will be used (the default). Set it to `-` to disable dynamic provisioning                                                                                                                                                                                                                                                                                                    |                  ""                     |
| `persistence.persistentVolumeClaim.database.size`                    | The size of the volume. If an external database is used, the setting will be ignored                                                                                                                                                                                                                                                                                                                                                                                 | `1Gi`                                 |
| `persistence.persistentVolumeClaim.database.storageClass`            | Specify the `storageClass` used to provision the volume, or the default StorageClass will be used (the default). Set it to `-` to disable dynamic provisioning. If an external database is used, the setting will be ignored                                                                                                                                                                                                                                         |                   ""                  |
| `persistence.persistentVolumeClaim.redis.size`                       | The size of the volume. If an external Redis is used, the setting will be ignored                                                                                                                                                                                                                                                                                                                                                                                    | `1Gi`                                 |
| `persistence.persistentVolumeClaim.redis.storageClass`               | Specify the `storageClass` used to provision the volume, or the default StorageClass will be used (the default). Set it to `-` to disable dynamic provisioning. If an external Redis is used, the setting will be ignored                                                                                                                                                                                                                                            |                   ""                  |
| `persistence.persistentVolumeClaim.trivy.size`                       | The size of the volume                                                                                                                                                                                                                                                                                                                                                                                                                                            | `5Gi`                                 |
| `persistence.persistentVolumeClaim.trivy.storageClass`               | Specify the `storageClass` used to provision the volume, or the default StorageClass will be used (the default). Set it to `-` to disable dynamic provisioning                                                                                                                                                                                                                                                                                                    |                   ""                    |
| **Trivy**                                                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                                       |
| `trivy.enabled`                                                      | The flag to enable Trivy scanner                                                                                                                                                                                                                                                                                                                                                                                                                                  | `true`                                |
| `trivy.vulnType`                                                     | Comma-separated list of vulnerability types. Possible values `os` and `library`.                                                                                                                                                                                                                                                                                                                                                                                  | `os,library`                          |
| `trivy.severity`                                                     | Comma-separated list of severities to be checked                                                                                                                                                                                                                                                                                                                                                                                                                  | `UNKNOWN,LOW,MEDIUM,HIGH,CRITICAL`    |
| `trivy.skipUpdate`                                                   | The flag to disable [Trivy DB](https://github.com/aquasecurity/trivy-db) downloads from GitHub                                                                                                                                                                                                                                                                                                                                                                                                    | `false`                               |
| `trivy.offlineScan`                                                  | The flag prevents Trivy from sending API requests to identify dependencies.                                                                                                                                                                                                                                                                                                                                                                                       | `false`                               |
| **Registry**                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                   |                                       |
| `registry.relativeurls`                                                | If true, the registry returns relative URLs in Location headers. The client is responsible for resolving the correct URL. Needed if harbor is behind a reverse proxy                                                                                                                                                                                                                                                                                                                                                                            | `false`                               |
