---
title: "v0.1.0"
linkTitle: "v0.1.0"
weight: 20
aliases:
    /docs/reference/packagespec/credential-provider-package/v0.1.0/
description: >
---

### Configuring Credential Provider Package in EKS Anywhere package spec

#### Example

The following is the sample configuration for the credential provider package that is installed by default with the package controller.
Please refer to [Credential Provider Package with IAM Roles Anywhere.]({{< relref "iam_roles_anywhere" >}})

```
apiVersion: packages.eks.amazonaws.com/v1alpha1
kind: Package
metadata:
  name: ecr-credential-provider-package
  namespace: eksa-packages-<clusterName>
  annotations:
    "helm.sh/resource-policy": keep
    "anywhere.eks.aws.com/internal": "true"
spec:
  packageName: credential-provider-package
  targetNamespace: eksa-packages
  config: |-
    tolerations:
      - key: "node-role.kubernetes.io/master"
        operator: "Exists"
        effect: "NoSchedule"
      - key: "node-role.kubernetes.io/control-plane"
        operator: "Exists"
        effect: "NoSchedule"
    sourceRegistry: public.ecr.aws/eks-anywhere
    credential:
      - matchImages:
        - 783794618700.dkr.ecr.us-west-2.amazonaws.com
        profile: "default"
        secretName: aws-secret
        defaultCacheDuration: "5h"
```

In this example, the credential provider will use the secret provided in aws-secret (created automatically on cluster creation) to authenticate to the repository from which curated package images are pulled. Tolerations were also added so that the control plane nodes would also be configured with authentication.

The secret can exist in two forms: either a base64 encoding of a credential config or individual keys for fields.

Example credential
```
[default]
aws_access_key_id=EXAMPLE_ACCESS_KEY
aws_secret_access_key=EXAMPLE_SECRET_KEY
region=us-west-2
```

##### Example secret with separate keys
```
apiVersion: v1
kind: Secret
metadata:
  name: aws-secret
  namespace: eksa-packages
data:
  AWS_ACCESS_KEY_ID: "QUtJQUlPU0ZPRE5ON0VYQU1QTEUK"
  AWS_SECRET_ACCESS_KEY: "d0phbHJYVXRuRkVNSS9LN01ERU5HL2JQeFJmaUNZRVhBTVBMRUtFWQo="
  REGION: dXMtd2VzdC0yCg==
```

##### Example secret in config form
```
apiVersion: v1
kind: Secret
metadata:
  name: aws-secret
  namespace: eksa-packages
data:
  config: W2RlZmF1bHRdCmF3c19hY2Nlc3Nfa2V5X2lkPUFLSUFJT1NGT0ROTjdFWEFNUExFCmF3c19zZWNyZXRfYWNjZXNzX2tleT13SmFsclhVdG5GRU1JL0s3TURFTkcvYlB4UmZpQ1lFWEFNUExFS0VZCnJlZ2lvbj11cy13ZXN0LTI=
type: Opaque
```

#### Configurable parameters and default values under `spec.config`

| Parameter            | Description                                                                                                                                                                                                                                                                                                | Default                                                                                                  |
|----------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------|
| **General**          |                                                                                                                                                                                                                                                                                                            |                                                                                                          |
| image.pullPolicy     | Specifies image pull policy: `IfNotPresent`, `Always`, `Never`.                                                                                                                                                                                                                                            | `"IfNotPresent"`                                                                                         |
| tolerations          | [Kubernetes tolerations](https://kubernetes.io/docs/concepts/scheduling-eviction/taint-and-toleration/) for pod scheduling                                                                                                                                                                                 | `{}` |
| **Credential**       |                                                                                                                                                                                                                                                                                                            |                                                                                                          |
| credential           | List of credential providers for authenticating with ECR. Currently only one is supported                                                                                                                                                                                                                  | <pre>credential: <br/>  - secretName: "aws-secret"<br/>    matchImages: []<br/>    defaultCacheDuration: "1h"<br/>    profile: "default</pre> |
| secretName           | Name of secret that contains the aws credentials                                                                                                                                                                                                                                                           | `"aws-secret"` |
| profile              | AWS Profile for secretName                                                                                                                                                                                                                                                                                 | `"default"` |
| matchImages          | List of strings used to match against images. See [here](https://kubernetes.io/docs/tasks/administer-cluster/kubelet-credential-provider/#configure-image-matching) for more info <br/>Example to match against any account across multiple regions for ECR:<br/></pre>`"*.dkr.ecr.*.amazonaws.com"`</pre> | `"[]"` |
| defaultCacheDuration | Duration the kubelet will cache credentials in-memory. For ECR it is recommended to keep this value less then 12 hours.                                                                                                                                                                           | `"5h"` |

   
