---
title: "v9.43.0"
linkTitle: "v9.43.0"
weight: 20
aliases:
    /docs/reference/packagespec/cluster-autoscaler/v9.43.0/
description: >
---

### Configuring Cluster Autoscaler in EKS Anywhere package spec

| Parameter | Description | Default |
|---|---|---|
|**General**|||
| cloudProvider | Cluster Autoscaler cloud provider. This should always be clusterapi. <br/>Example:<br/> <pre>cloudProvider: "clusterapi"</pre>| "clusterapi"
| autoDiscovery.clusterName | Name of the kubernetes cluster this autoscaler package should autoscale. <br/>Example:<br/> <pre>autoDiscovery.clusterName: "mgmt-cluster"</pre>| false
| clusterAPIMode | Where Cluster Autoscaler should look for a kubeconfig to communicate with the cluster it will manage. See https://github.com/kubernetes/autoscaler/blob/master/cluster-autoscaler/cloudprovider/clusterapi/README.md#connecting-cluster-autoscaler-to-cluster-api-management-and-workload-clusters <br/>Example:<br/> <pre>clusterAPIMode: "incluster-kubeconfig"</pre>| "incluster-incluster"
| clusterAPICloudConfigPath | Path to kubeconfig for connecting to Cluster API Management Cluster, only used if `clusterAPIMode=kubeconfig-kubeconfig or incluster-kubeconfig` <br/>Example:<br/> <pre>clusterAPICloudConfigPath: "/etc/kubernetes/value"</pre>| "/etc/kubernetes/mgmt-kubeconfig"
| extraVolumeSecrets | Additional volumes to mount from Secrets. <br/>Example:<br/> <pre>extraVolumeSecrets: {}</pre>| {}
