---
title: "v1.9.1"
linkTitle: "v1.9.1"
weight: 20
aliases:
    /docs/reference/packagespec/cert-manager/v1.9.1/
description: >
---

### Configuring Cert-Manager in EKS Anywhere package spec

#### Example
```
apiVersion: packages.eks.amazonaws.com/v1alpha1
kind: Package
metadata:
  name: my-cert-manager
  namespace: eksa-packages-<cluster-name>
spec:
  packageName: cert-manager
  config: | 
    global:
        logLevel: 4
```

The following table lists the configurable parameters of the cert-manager package spec and the default values.

| Parameter                | Description                                                                                          | Default        |
|--------------------------|------------------------------------------------------------------------------------------------------|----------------|
| **General**              |                                                                                                      |                |
| `namespace`              | The namespace to use for installing cert-manager package                                             | `cert-manager` |
| `imagePullPolicy`        | The image pull policy                                                                                | `IfNotPresent` |                                     
| **global**               |                                                                                                      |                |
| `global.logLevel`        | The log level: integer from 0-6                                                                      | `2`            |
| **Webhook**              |                                                                                                      |                |
| `webhook.timeoutSeconds` | The time in seconds to wait for the webhook to connect with the kube-api server                      | `0`            |
