---
title: "v0.21.1"
linkTitle: "v0.21.1"
weight: 20
aliases:
    /docs/reference/packagespec/adot/v0.21.1/
description: >
---

### Configuring ADOT in EKS Anywhere package spec

#### Example

We included a sample configuration below for reference. For in-depth examples and use cases, please refer to [ADOT with AMP and AMG.]({{< relref "adot_amp_amg.md" >}})

```
apiVersion: packages.eks.amazonaws.com/v1alpha1
kind: Package
metadata:
  name: my-adot
  namespace: eksa-packages-<cluster-name>
spec:
  packageName: adot
  targetNamespace: observability
  config: | 
    mode: daemonset
```

#### Configurable parameters and default values under `spec.config`

| Parameter | Description | Default |
|-----|---------|-------------|
|**General**|
| hostNetwork | Indicates if the pod should run in the host networking namespace. | `false` |
| image.pullPolicy | Specifies image pull policy: `IfNotPresent`, `Always`, `Never`. | `"IfNotPresent"` |
| mode | Specifies Collector deployment options: `daemonset`, `deployment`, or `statefulset`. | `"daemonset"` |
| ports.[\*].containerPort | Specifies containerPort used. | See footnote [^1] |
| ports.[\*].enabled | Indicates if a port is enabled. | See footnote [^1] |
| ports.[\*].hostPort | Specifies hostPort used. | See footnote [^1] |
| ports.[\*].protocol | Specifies protocol used. | See footnote [^1] |
| ports.[\*].servicePort | Specifies servicePort used. | See footnote [^1] |
| resources.limits.cpu | Specifies CPU resource limits for containers. | `1` |
| resources.limits.memory | Specifies memory resource limits for containers. | `"2Gi"` |
|**Config**|
| config.config | Specifies Collector receiver, processor, exporter, and extensions configurations. Refer to [aws-otel-collector](https://github.com/aws-observability/aws-otel-collector) for full details. **Note EKS Anywhere ADOT package version matches the exact aws-otel-collector version.** | See footnote [^2] |
| config.config.receiver | Specifies how data gets in the Collector. Receivers can be either push or pull based, and support one or more data source. | See footnote [^2] |
| config.config.processor | Specifies how processors are run on data between the stage of being received and being exported. Processors are optional though some are [recommended.](https://github.com/open-telemetry/opentelemetry-collector/tree/main/processor#recommended-processors)  | See footnote [^2] |
| config.config.exporters | Specifies how data gets sent to backends/destinations. Exporters can be either push or pull based, and support one or more data source.  | See footnote [^2] |
| config.config.extensions | Specifies tasks that do not involve processing telemetry data. Examples of extensions include health monitoring, service discovery, and data forwarding. Extensions are optional. | See footnote [^2] |
| config.config.service | Specifies what components are enabled in the Collector based on the configuration found in the receivers, processors, exporters, and extensions sections. **If a component is configured, but not defined within the service section, then it is not enabled.** | See footnote [^2] |
|**Deployment mode only**|
| replicaCount | Specifies replicaCount for pods. | `1` |
| service.type | Specifies service types: `ClusterIP`, `NodePort`, `LoadBalancer`, `ExternalName`.  |`"ClusterIP"` |

[^1]:
    The default `ports` enables `otlp` and `otlp-http`. See below specification for details.
    ```yaml
    apiVersion: packages.eks.amazonaws.com/v1alpha1
    kind: Package
    ...
    spec:
      config: |
        ports:
          otlp:
            enabled: true
            containerPort: 4317
            servicePort: 4317
            hostPort: 4317
            protocol: TCP
          otlp-http:
            enabled: true
            containerPort: 4318
            servicePort: 4318
            hostPort: 4318
            protocol: TCP
    ```

[^2]:
    The default `config.config` deploys an ADOT Collector with the metrics pipeline, which includes otlp and prometheus receiver, and logging exporter. See below specification for details.
    ```yaml
    apiVersion: packages.eks.amazonaws.com/v1alpha1
    kind: Package
    ...
    spec:
      config: |
        config:
          receivers:
            otlp:
              protocols:
                grpc:
                  endpoint: 0.0.0.0:4317
                http:
                  endpoint: 0.0.0.0:4318
            prometheus:
              config:
                scrape_configs:
                  - job_name: opentelemetry-collector
                    scrape_interval: 10s
                    static_configs:
                      - targets:
                          - ${MY_POD_IP}:8888
          processors:
            batch: {}
            memory_limiter: null
          exporters:
            logging:
              loglevel: info
          extensions:
            health_check: {}
            memory_ballast: {}
          service:
            telemetry:
              metrics:
                address: 0.0.0.0:8888
            extensions:
              - health_check
              - memory_ballast
            pipelines:
              metrics:
                exporters:
                  - logging
                processors:
                  - memory_limiter
                  - batch
                receivers:
                  - otlp
                  - prometheus
    ```
