---
title: "Partners"
linkTitle: "Partners"
weight: 30
description: >
  EKS Anywhere validated partners
---

Amazon EKS Anywhere maintains relationships with third-party vendors to provide add-on solutions for EKS Anywhere clusters.
A complete list of these partners is maintained on the [Amazon EKS Anywhere Partners](https://aws.amazon.com/eks/eks-anywhere/partners/) page.
See [Conformitron: Validate third-party software with Amazon EKS and Amazon EKS Anywhere](https://aws.amazon.com/blogs/containers/conformitron-validate-third-party-software-with-amazon-eks-and-amazon-eks-anywhere/) for information on how conformance testing and quality assurance is done on this software.

The following shows validated EKS Anywhere partners whose products have passed conformance test for specific EKS Anywhere providers and versions:

## Bare Metal provider validated partners

```
Kubernetes Version :  1.27 
Date of Conformance Test : 2024-05-02
 
Following ISV Partners have Validated their Conformance : 
 
VENDOR_PRODUCT   VENDOR_PRODUCT_TYPE          VENDOR_PRODUCT_VERSION
aqua             aqua-enforcer                2022.4.20
dynatrace        dynatrace                    0.10.1
komodor          k8s-watcher                  1.15.5
kong             kong-enterprise              2.27.0
accuknox         kubearmor                    v1.3.2
kubecost         cost-analyzer                2.1.0
nirmata          enterprise-kyverno           1.6.10
lacework         polygraph                    6.11.0
newrelic         nri-bundle                   5.0.64
perfectscale     perfectscale                 v0.0.38
pulumi           pulumi-kubernetes-operator   0.3.0
solo.io          solo-istiod                  1.18.3-eks-a
sysdig           sysdig-agent                 1.6.3
tetrate.io       tetrate-istio-distribution   1.18.1
hashicorp        vault                        0.25.0
```

## vSphere provider validated partners

```
Kubernetes Version :  1.28 
Date of Conformance Test : 2024-05-02
 
Following ISV Partners have Validated their Conformance : 
 
VENDOR_PRODUCT   VENDOR_PRODUCT_TYPE          VENDOR_PRODUCT_VERSION
aqua             aqua-enforcer                2022.4.20
dynatrace        dynatrace                    0.10.1
komodor          k8s-watcher                  1.15.5
kong             kong-enterprise              2.27.0
accuknox         kubearmor                    v1.3.2
kubecost         cost-analyzer                2.1.0
nirmata          enterprise-kyverno           1.6.10
lacework         polygraph                    6.11.0
newrelic         nri-bundle                   5.0.64
perfectscale     perfectscale                 v0.0.38
pulumi           pulumi-kubernetes-operator   0.3.0
solo.io          solo-istiod                  1.18.3-eks-a
sysdig           sysdig-agent                 1.6.3
tetrate.io       tetrate-istio-distribution   1.18.1
hashicorp        vault                        0.25.0
```

## AWS Snow provider validated partners

```
Kubernetes Version :  1.28 
Date of Conformance Test : 2023-11-10
 
Following ISV Partners have Validated their Conformance : 
 
VENDOR_PRODUCT   VENDOR_PRODUCT_TYPE
dynatrace        dynatrace
solo.io          solo-istiod
komodor          k8s-watcher
kong             kong-enterprise
accuknox         kubearmor
kubecost         cost-analyzer
nirmata          enterprise-kyverno
lacework         polygraph
suse             neuvector
newrelic         newrelic-bundle
perfectscale     perfectscale
pulumi           pulumi-kubernetes-operator
sysdig           sysdig-agent
hashicorp        vault
```
## AWS Outpost provider validated partners
```
Kubernetes Version :  1.27 
Date of Conformance Test : 2024-05-02
 
Following ISV Partners have Validated their Conformance : 
 
VENDOR_PRODUCT   VENDOR_PRODUCT_TYPE          VENDOR_PRODUCT_VERSION
aqua             aqua-enforcer                2022.4.20
dynatrace        dynatrace                    0.10.1
komodor          k8s-watcher                  1.15.5
kong             kong-enterprise              2.27.0
accuknox         kubearmor                    v1.3.2
kubecost         cost-analyzer                2.1.0
nirmata          enterprise-kyverno           1.6.10
lacework         polygraph                    6.11.0
perfectscale     perfectscale                 v0.0.38
pulumi           pulumi-kubernetes-operator   0.3.0
solo.io          solo-istiod                  1.18.3-eks-a
sysdig           sysdig-agent                 1.6.3
tetrate.io       tetrate-istio-distribution   1.18.1
hashicorp        vault                        0.25.0
```
