---
title: "Project governance"
weight: 40
description: >
  Roles and responsibilities of the project
---


This document lays out the guidelines under which the EKS Anywhere project will be governed.
The goal is to make sure that the roles and responsibilities are well-defined and clarify how decisions are made.

## Roles

In the context of EKS Anywhere, we consider the following roles:

* __Users__ ... everyone using EKS Anywhere, typically willing to provide feedback on EKS Anywhere by proposing features and/or filing issues.
* __Contributors__ ... everyone contributing code, documentation, examples, testing infra, and participating in feature proposals as well as design discussions.
* __Maintainers__ ... are responsible for engaging with and assisting contributors to iterate on the contributions until it reaches acceptable quality.
Maintainers can decide whether the contributions can be accepted into the project or rejected.

## Communication

The primary mechanism for communication will be via the [`#eks` channel](https://kubernetes.slack.com/archives/C8SH2GSL9) on the Kubernetes Slack community.
All features and bug fixes will be tracked as issues in GitHub.
All decisions will be documented in GitHub issues.

In the future, we may consider using a public mailing list, which can be better archived. 

## Release Management

The release process will be governed by AWS and will coincide with the release of EKS.

## Roadmap Planning

Maintainers will share roadmap and release versions as milestones in GitHub. 
