
//! Autogenerated weights for pallet_subspace
//!
//! THIS FILE WAS AUTO-GENERATED USING THE SUBSTRATE BENCHMARK CLI VERSION 42.0.0
//! DATE: 2024-09-06, STEPS: `50`, REPEAT: `20`, LOW RANGE: `[]`, HIGH RANGE: `[]`
//! WORST CASE MAP SIZE: `1000000`
//! HOSTNAME: `Ubuntu-2404-noble-amd64-base`, CPU: `Intel(R) Core(TM) i7-6700 CPU @ 3.40GHz`
//! EXECUTION: , WASM-EXECUTION: Compiled, CHAIN: None, DB CACHE: 1024

// Executed Command:
// ./target/release/subspace-node
// benchmark
// pallet
// --runtime=./target/release/wbuild/subspace-runtime/subspace_runtime.compact.compressed.wasm
// --genesis-builder=runtime
// --steps=50
// --repeat=20
// --pallet=pallet_subspace
// --extrinsic=*
// --wasm-execution=compiled
// --heap-pages=4096
// --output=./weights/pallet-subspace.rs
// --template=./frame-weight-template.hbs

#![cfg_attr(rustfmt, rustfmt_skip)]
#![allow(unused_parens)]
#![allow(unused_imports)]

use frame_support::{traits::Get, weights::{Weight, constants::ParityDbWeight}};
use core::marker::PhantomData;

/// Weight functions needed for pallet_subspace.
pub trait WeightInfo {
	fn store_segment_headers(x: u32, ) -> Weight;
	fn enable_solution_range_adjustment() -> Weight;
	fn vote() -> Weight;
	fn enable_rewards_at() -> Weight;
	fn enable_authoring_by_anyone() -> Weight;
	fn set_pot_slot_iterations() -> Weight;
}

/// Weights for pallet_subspace using the Substrate node and recommended hardware.
pub struct SubstrateWeight<T>(PhantomData<T>);
impl<T: frame_system::Config> WeightInfo for SubstrateWeight<T> {
	/// Storage: `Subspace::DidProcessSegmentHeaders` (r:1 w:1)
	/// Proof: `Subspace::DidProcessSegmentHeaders` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::SegmentCommitment` (r:20 w:20)
	/// Proof: `Subspace::SegmentCommitment` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::CounterForSegmentCommitment` (r:1 w:1)
	/// Proof: `Subspace::CounterForSegmentCommitment` (`max_values`: Some(1), `max_size`: Some(4), added: 499, mode: `MaxEncodedLen`)
	/// Storage: `System::Digest` (r:1 w:1)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// The range of component `x` is `[1, 20]`.
	fn store_segment_headers(x: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1489 + x * (2475 ±0)`
		// Minimum execution time: 14_713_000 picoseconds.
		Weight::from_parts(8_393_097, 1489)
			// Standard Error: 5_367
			.saturating_add(Weight::from_parts(6_664_776, 0).saturating_mul(x.into()))
			.saturating_add(T::DbWeight::get().reads(3_u64))
			.saturating_add(T::DbWeight::get().reads((1_u64).saturating_mul(x.into())))
			.saturating_add(T::DbWeight::get().writes(3_u64))
			.saturating_add(T::DbWeight::get().writes((1_u64).saturating_mul(x.into())))
			.saturating_add(Weight::from_parts(0, 2475).saturating_mul(x.into()))
	}
	/// Storage: `Subspace::ShouldAdjustSolutionRange` (r:1 w:1)
	/// Proof: `Subspace::ShouldAdjustSolutionRange` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::SolutionRanges` (r:1 w:1)
	/// Proof: `Subspace::SolutionRanges` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Digest` (r:1 w:1)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::NextSolutionRangeOverride` (r:0 w:1)
	/// Proof: `Subspace::NextSolutionRangeOverride` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn enable_solution_range_adjustment() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 8_505_000 picoseconds.
		Weight::from_parts(8_696_000, 1485)
			.saturating_add(T::DbWeight::get().reads(3_u64))
			.saturating_add(T::DbWeight::get().writes(4_u64))
	}
	/// Storage: `Subspace::BlockList` (r:1 w:0)
	/// Proof: `Subspace::BlockList` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn vote() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `3465`
		// Minimum execution time: 10_116_000 picoseconds.
		Weight::from_parts(10_442_000, 3465)
			.saturating_add(T::DbWeight::get().reads(1_u64))
	}
	/// Storage: `Subspace::EnableRewards` (r:1 w:1)
	/// Proof: `Subspace::EnableRewards` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn enable_rewards_at() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 4_200_000 picoseconds.
		Weight::from_parts(4_344_000, 1485)
			.saturating_add(T::DbWeight::get().reads(1_u64))
			.saturating_add(T::DbWeight::get().writes(1_u64))
	}
	/// Storage: `Subspace::RootPlotPublicKey` (r:1 w:0)
	/// Proof: `Subspace::RootPlotPublicKey` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Digest` (r:1 w:1)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::AllowAuthoringByAnyone` (r:0 w:1)
	/// Proof: `Subspace::AllowAuthoringByAnyone` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn enable_authoring_by_anyone() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 5_316_000 picoseconds.
		Weight::from_parts(5_589_000, 1485)
			.saturating_add(T::DbWeight::get().reads(2_u64))
			.saturating_add(T::DbWeight::get().writes(2_u64))
	}
	/// Storage: `Subspace::PotSlotIterations` (r:1 w:0)
	/// Proof: `Subspace::PotSlotIterations` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::PotSlotIterationsUpdate` (r:1 w:1)
	/// Proof: `Subspace::PotSlotIterationsUpdate` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn set_pot_slot_iterations() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 5_132_000 picoseconds.
		Weight::from_parts(5_251_000, 1485)
			.saturating_add(T::DbWeight::get().reads(2_u64))
			.saturating_add(T::DbWeight::get().writes(1_u64))
	}
}

// For backwards compatibility and tests
impl WeightInfo for () {
	/// Storage: `Subspace::DidProcessSegmentHeaders` (r:1 w:1)
	/// Proof: `Subspace::DidProcessSegmentHeaders` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::SegmentCommitment` (r:20 w:20)
	/// Proof: `Subspace::SegmentCommitment` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::CounterForSegmentCommitment` (r:1 w:1)
	/// Proof: `Subspace::CounterForSegmentCommitment` (`max_values`: Some(1), `max_size`: Some(4), added: 499, mode: `MaxEncodedLen`)
	/// Storage: `System::Digest` (r:1 w:1)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// The range of component `x` is `[1, 20]`.
	fn store_segment_headers(x: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1489 + x * (2475 ±0)`
		// Minimum execution time: 14_713_000 picoseconds.
		Weight::from_parts(8_393_097, 1489)
			// Standard Error: 5_367
			.saturating_add(Weight::from_parts(6_664_776, 0).saturating_mul(x.into()))
			.saturating_add(ParityDbWeight::get().reads(3_u64))
			.saturating_add(ParityDbWeight::get().reads((1_u64).saturating_mul(x.into())))
			.saturating_add(ParityDbWeight::get().writes(3_u64))
			.saturating_add(ParityDbWeight::get().writes((1_u64).saturating_mul(x.into())))
			.saturating_add(Weight::from_parts(0, 2475).saturating_mul(x.into()))
	}
	/// Storage: `Subspace::ShouldAdjustSolutionRange` (r:1 w:1)
	/// Proof: `Subspace::ShouldAdjustSolutionRange` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::SolutionRanges` (r:1 w:1)
	/// Proof: `Subspace::SolutionRanges` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Digest` (r:1 w:1)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::NextSolutionRangeOverride` (r:0 w:1)
	/// Proof: `Subspace::NextSolutionRangeOverride` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn enable_solution_range_adjustment() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 8_505_000 picoseconds.
		Weight::from_parts(8_696_000, 1485)
			.saturating_add(ParityDbWeight::get().reads(3_u64))
			.saturating_add(ParityDbWeight::get().writes(4_u64))
	}
	/// Storage: `Subspace::BlockList` (r:1 w:0)
	/// Proof: `Subspace::BlockList` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn vote() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `3465`
		// Minimum execution time: 10_116_000 picoseconds.
		Weight::from_parts(10_442_000, 3465)
			.saturating_add(ParityDbWeight::get().reads(1_u64))
	}
	/// Storage: `Subspace::EnableRewards` (r:1 w:1)
	/// Proof: `Subspace::EnableRewards` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn enable_rewards_at() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 4_200_000 picoseconds.
		Weight::from_parts(4_344_000, 1485)
			.saturating_add(ParityDbWeight::get().reads(1_u64))
			.saturating_add(ParityDbWeight::get().writes(1_u64))
	}
	/// Storage: `Subspace::RootPlotPublicKey` (r:1 w:0)
	/// Proof: `Subspace::RootPlotPublicKey` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Digest` (r:1 w:1)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::AllowAuthoringByAnyone` (r:0 w:1)
	/// Proof: `Subspace::AllowAuthoringByAnyone` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn enable_authoring_by_anyone() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 5_316_000 picoseconds.
		Weight::from_parts(5_589_000, 1485)
			.saturating_add(ParityDbWeight::get().reads(2_u64))
			.saturating_add(ParityDbWeight::get().writes(2_u64))
	}
	/// Storage: `Subspace::PotSlotIterations` (r:1 w:0)
	/// Proof: `Subspace::PotSlotIterations` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Subspace::PotSlotIterationsUpdate` (r:1 w:1)
	/// Proof: `Subspace::PotSlotIterationsUpdate` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	fn set_pot_slot_iterations() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 5_132_000 picoseconds.
		Weight::from_parts(5_251_000, 1485)
			.saturating_add(ParityDbWeight::get().reads(2_u64))
			.saturating_add(ParityDbWeight::get().writes(1_u64))
	}
}
