
//! Autogenerated weights for pallet_runtime_configs
//!
//! THIS FILE WAS AUTO-GENERATED USING THE SUBSTRATE BENCHMARK CLI VERSION 42.0.0
//! DATE: 2024-09-06, STEPS: `50`, REPEAT: `20`, LOW RANGE: `[]`, HIGH RANGE: `[]`
//! WORST CASE MAP SIZE: `1000000`
//! HOSTNAME: `Ubuntu-2404-noble-amd64-base`, CPU: `Intel(R) Core(TM) i7-6700 CPU @ 3.40GHz`
//! EXECUTION: , WASM-EXECUTION: Compiled, CHAIN: None, DB CACHE: 1024

// Executed Command:
// ./target/release/subspace-node
// benchmark
// pallet
// --runtime=./target/release/wbuild/subspace-runtime/subspace_runtime.compact.compressed.wasm
// --genesis-builder=runtime
// --steps=50
// --repeat=20
// --pallet=pallet_runtime_configs
// --extrinsic=*
// --wasm-execution=compiled
// --heap-pages=4096
// --output=./weights/pallet-runtime-configs.rs
// --template=./frame-weight-template.hbs

#![cfg_attr(rustfmt, rustfmt_skip)]
#![allow(unused_parens)]
#![allow(unused_imports)]

use frame_support::{traits::Get, weights::{Weight, constants::ParityDbWeight}};
use core::marker::PhantomData;

/// Weight functions needed for pallet_runtime_configs.
pub trait WeightInfo {
	fn set_enable_domains() -> Weight;
	fn set_enable_dynamic_cost_of_storage() -> Weight;
	fn set_enable_balance_transfers() -> Weight;
}

/// Weights for pallet_runtime_configs using the Substrate node and recommended hardware.
pub struct SubstrateWeight<T>(PhantomData<T>);
impl<T: frame_system::Config> WeightInfo for SubstrateWeight<T> {
	/// Storage: `RuntimeConfigs::EnableDomains` (r:0 w:1)
	/// Proof: `RuntimeConfigs::EnableDomains` (`max_values`: Some(1), `max_size`: Some(1), added: 496, mode: `MaxEncodedLen`)
	fn set_enable_domains() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 3_227_000 picoseconds.
		Weight::from_parts(3_380_000, 0)
			.saturating_add(T::DbWeight::get().writes(1_u64))
	}
	/// Storage: `RuntimeConfigs::EnableDynamicCostOfStorage` (r:0 w:1)
	/// Proof: `RuntimeConfigs::EnableDynamicCostOfStorage` (`max_values`: Some(1), `max_size`: Some(1), added: 496, mode: `MaxEncodedLen`)
	fn set_enable_dynamic_cost_of_storage() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 3_003_000 picoseconds.
		Weight::from_parts(3_122_000, 0)
			.saturating_add(T::DbWeight::get().writes(1_u64))
	}
	/// Storage: `RuntimeConfigs::EnableBalanceTransfers` (r:0 w:1)
	/// Proof: `RuntimeConfigs::EnableBalanceTransfers` (`max_values`: Some(1), `max_size`: Some(1), added: 496, mode: `MaxEncodedLen`)
	fn set_enable_balance_transfers() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 3_078_000 picoseconds.
		Weight::from_parts(3_216_000, 0)
			.saturating_add(T::DbWeight::get().writes(1_u64))
	}
}

// For backwards compatibility and tests
impl WeightInfo for () {
	/// Storage: `RuntimeConfigs::EnableDomains` (r:0 w:1)
	/// Proof: `RuntimeConfigs::EnableDomains` (`max_values`: Some(1), `max_size`: Some(1), added: 496, mode: `MaxEncodedLen`)
	fn set_enable_domains() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 3_227_000 picoseconds.
		Weight::from_parts(3_380_000, 0)
			.saturating_add(ParityDbWeight::get().writes(1_u64))
	}
	/// Storage: `RuntimeConfigs::EnableDynamicCostOfStorage` (r:0 w:1)
	/// Proof: `RuntimeConfigs::EnableDynamicCostOfStorage` (`max_values`: Some(1), `max_size`: Some(1), added: 496, mode: `MaxEncodedLen`)
	fn set_enable_dynamic_cost_of_storage() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 3_003_000 picoseconds.
		Weight::from_parts(3_122_000, 0)
			.saturating_add(ParityDbWeight::get().writes(1_u64))
	}
	/// Storage: `RuntimeConfigs::EnableBalanceTransfers` (r:0 w:1)
	/// Proof: `RuntimeConfigs::EnableBalanceTransfers` (`max_values`: Some(1), `max_size`: Some(1), added: 496, mode: `MaxEncodedLen`)
	fn set_enable_balance_transfers() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `0`
		// Minimum execution time: 3_078_000 picoseconds.
		Weight::from_parts(3_216_000, 0)
			.saturating_add(ParityDbWeight::get().writes(1_u64))
	}
}
