
//! Autogenerated weights for pallet_domains
//!
//! THIS FILE WAS AUTO-GENERATED USING THE SUBSTRATE BENCHMARK CLI VERSION 42.0.0
//! DATE: 2024-09-06, STEPS: `50`, REPEAT: `20`, LOW RANGE: `[]`, HIGH RANGE: `[]`
//! WORST CASE MAP SIZE: `1000000`
//! HOSTNAME: `Ubuntu-2404-noble-amd64-base`, CPU: `Intel(R) Core(TM) i7-6700 CPU @ 3.40GHz`
//! EXECUTION: , WASM-EXECUTION: Compiled, CHAIN: None, DB CACHE: 1024

// Executed Command:
// ./target/release/subspace-node
// benchmark
// pallet
// --runtime=./target/release/wbuild/subspace-runtime/subspace_runtime.compact.compressed.wasm
// --genesis-builder=runtime
// --steps=50
// --repeat=20
// --pallet=pallet_domains
// --extrinsic=*
// --wasm-execution=compiled
// --heap-pages=4096
// --output=./weights/pallet-domains.rs
// --template=./frame-weight-template.hbs

#![cfg_attr(rustfmt, rustfmt_skip)]
#![allow(unused_parens)]
#![allow(unused_imports)]

use frame_support::{traits::Get, weights::{Weight, constants::ParityDbWeight}};
use core::marker::PhantomData;

/// Weight functions needed for pallet_domains.
pub trait WeightInfo {
	fn submit_bundle() -> Weight;
	fn submit_fraud_proof() -> Weight;
	fn handle_bad_receipt(n: u32, ) -> Weight;
	fn confirm_domain_block(n: u32, s: u32, ) -> Weight;
	fn operator_reward_tax_and_restake(n: u32, ) -> Weight;
	fn slash_operator(n: u32, ) -> Weight;
	fn finalize_domain_epoch_staking(p: u32, ) -> Weight;
	fn register_domain_runtime() -> Weight;
	fn upgrade_domain_runtime() -> Weight;
	fn instantiate_domain() -> Weight;
	fn register_operator() -> Weight;
	fn nominate_operator() -> Weight;
	fn deregister_operator() -> Weight;
	fn withdraw_stake() -> Weight;
	fn unlock_funds() -> Weight;
	fn unlock_nominator() -> Weight;
	fn update_domain_operator_allow_list() -> Weight;
	fn transfer_treasury_funds() -> Weight;
	fn submit_receipt() -> Weight;
}

/// Weights for pallet_domains using the Substrate node and recommended hardware.
pub struct SubstrateWeight<T>(PhantomData<T>);
impl<T: frame_system::Config> WeightInfo for SubstrateWeight<T> {
	/// Storage: `Domains::HeadReceiptNumber` (r:1 w:1)
	/// Proof: `Domains::HeadReceiptNumber` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NewAddedHeadReceipt` (r:1 w:1)
	/// Proof: `Domains::NewAddedHeadReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:1)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTree` (r:2 w:2)
	/// Proof: `Domains::BlockTree` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:1 w:2)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::ExecutionInbox` (r:3 w:1)
	/// Proof: `Domains::ExecutionInbox` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Transporter::DomainBalances` (r:1 w:1)
	/// Proof: `Transporter::DomainBalances` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainRegistry` (r:1 w:0)
	/// Proof: `Domains::DomainRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainRuntimeUpgradeRecords` (r:1 w:0)
	/// Proof: `Domains::DomainRuntimeUpgradeRecords` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::SuccessfulBundles` (r:1 w:1)
	/// Proof: `Domains::SuccessfulBundles` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::HeadDomainNumber` (r:1 w:1)
	/// Proof: `Domains::HeadDomainNumber` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorBundleSlot` (r:1 w:1)
	/// Proof: `Domains::OperatorBundleSlot` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::InboxedBundleAuthor` (r:0 w:1)
	/// Proof: `Domains::InboxedBundleAuthor` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::ConsensusBlockHash` (r:0 w:1)
	/// Proof: `Domains::ConsensusBlockHash` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn submit_bundle() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1751`
		//  Estimated: `10166`
		// Minimum execution time: 172_846_000 picoseconds.
		Weight::from_parts(174_992_000, 10166)
			.saturating_add(T::DbWeight::get().reads(16_u64))
			.saturating_add(T::DbWeight::get().writes(14_u64))
	}
	/// Storage: `Domains::HeadReceiptNumber` (r:1 w:1)
	/// Proof: `Domains::HeadReceiptNumber` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:1 w:0)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn submit_fraud_proof() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1008`
		//  Estimated: `4473`
		// Minimum execution time: 38_692_000 picoseconds.
		Weight::from_parts(41_247_000, 4473)
			.saturating_add(T::DbWeight::get().reads(2_u64))
			.saturating_add(T::DbWeight::get().writes(1_u64))
	}
	/// Storage: `Domains::BlockTree` (r:1 w:1)
	/// Proof: `Domains::BlockTree` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:1 w:1)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:100 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:100 w:100)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::PendingSlashes` (r:1 w:1)
	/// Proof: `Domains::PendingSlashes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `n` is `[1, 100]`.
	fn handle_bad_receipt(n: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `932 + n * (208 ±0)`
		//  Estimated: `4397 + n * (2683 ±0)`
		// Minimum execution time: 56_216_000 picoseconds.
		Weight::from_parts(56_940_000, 4397)
			// Standard Error: 67_772
			.saturating_add(Weight::from_parts(22_316_875, 0).saturating_mul(n.into()))
			.saturating_add(T::DbWeight::get().reads(4_u64))
			.saturating_add(T::DbWeight::get().reads((2_u64).saturating_mul(n.into())))
			.saturating_add(T::DbWeight::get().writes(4_u64))
			.saturating_add(T::DbWeight::get().writes((1_u64).saturating_mul(n.into())))
			.saturating_add(Weight::from_parts(0, 2683).saturating_mul(n.into()))
	}
	/// Storage: `Domains::Operators` (r:200 w:100)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:100 w:100)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::AccumulatedTreasuryFunds` (r:1 w:0)
	/// Proof: `Domains::AccumulatedTreasuryFunds` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::PendingSlashes` (r:1 w:1)
	/// Proof: `Domains::PendingSlashes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `n` is `[1, 100]`.
	/// The range of component `s` is `[0, 100]`.
	fn confirm_domain_block(n: u32, s: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0 + n * (378 ±0) + s * (239 ±0)`
		//  Estimated: `271975 + n * (2588 ±0) + s * (979 ±0)`
		// Minimum execution time: 2_284_894_000 picoseconds.
		Weight::from_parts(2_292_775_000, 271975)
			// Standard Error: 419_121
			.saturating_add(Weight::from_parts(13_897_823, 0).saturating_mul(n.into()))
			// Standard Error: 419_507
			.saturating_add(Weight::from_parts(14_690_876, 0).saturating_mul(s.into()))
			.saturating_add(T::DbWeight::get().reads(3_u64))
			.saturating_add(T::DbWeight::get().reads((2_u64).saturating_mul(n.into())))
			.saturating_add(T::DbWeight::get().reads((1_u64).saturating_mul(s.into())))
			.saturating_add(T::DbWeight::get().writes(3_u64))
			.saturating_add(T::DbWeight::get().writes((1_u64).saturating_mul(n.into())))
			.saturating_add(T::DbWeight::get().writes((1_u64).saturating_mul(s.into())))
			.saturating_add(Weight::from_parts(0, 2588).saturating_mul(n.into()))
			.saturating_add(Weight::from_parts(0, 979).saturating_mul(s.into()))
	}
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:100 w:100)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `n` is `[1, 100]`.
	fn operator_reward_tax_and_restake(n: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `366 + n * (224 ±0)`
		//  Estimated: `3831 + n * (2699 ±0)`
		// Minimum execution time: 22_997_000 picoseconds.
		Weight::from_parts(33_679_642, 3831)
			// Standard Error: 11_599
			.saturating_add(Weight::from_parts(4_386_338, 0).saturating_mul(n.into()))
			.saturating_add(T::DbWeight::get().reads(1_u64))
			.saturating_add(T::DbWeight::get().reads((1_u64).saturating_mul(n.into())))
			.saturating_add(T::DbWeight::get().writes(1_u64))
			.saturating_add(T::DbWeight::get().writes((1_u64).saturating_mul(n.into())))
			.saturating_add(Weight::from_parts(0, 2699).saturating_mul(n.into()))
	}
	/// Storage: `Domains::PendingSlashes` (r:1 w:1)
	/// Proof: `Domains::PendingSlashes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorIdOwner` (r:1 w:1)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Deposits` (r:11 w:10)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:10 w:10)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:2 w:2)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Withdrawals` (r:10 w:0)
	/// Proof: `Domains::Withdrawals` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:12 w:12)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::AccumulatedTreasuryFunds` (r:1 w:0)
	/// Proof: `Domains::AccumulatedTreasuryFunds` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NominatorCount` (r:1 w:1)
	/// Proof: `Domains::NominatorCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorSigningKey` (r:0 w:1)
	/// Proof: `Domains::OperatorSigningKey` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `n` is `[0, 9]`.
	fn slash_operator(n: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1365 + n * (298 ±0)`
		//  Estimated: `9015 + n * (8025 ±0)`
		// Minimum execution time: 236_187_000 picoseconds.
		Weight::from_parts(271_847_200, 9015)
			// Standard Error: 293_537
			.saturating_add(Weight::from_parts(92_669_227, 0).saturating_mul(n.into()))
			.saturating_add(T::DbWeight::get().reads(14_u64))
			.saturating_add(T::DbWeight::get().reads((4_u64).saturating_mul(n.into())))
			.saturating_add(T::DbWeight::get().writes(12_u64))
			.saturating_add(T::DbWeight::get().writes((3_u64).saturating_mul(n.into())))
			.saturating_add(Weight::from_parts(0, 8025).saturating_mul(n.into()))
	}
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:512 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:512 w:512)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LastEpochStakingDistribution` (r:0 w:1)
	/// Proof: `Domains::LastEpochStakingDistribution` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:0 w:512)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `p` is `[0, 512]`.
	fn finalize_domain_epoch_staking(p: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `116165`
		//  Estimated: `1384355`
		// Minimum execution time: 3_726_400_000 picoseconds.
		Weight::from_parts(3_900_459_490, 1384355)
			// Standard Error: 10_021
			.saturating_add(Weight::from_parts(3_667_131, 0).saturating_mul(p.into()))
			.saturating_add(T::DbWeight::get().reads(1025_u64))
			.saturating_add(T::DbWeight::get().writes(2_u64))
			.saturating_add(T::DbWeight::get().writes((2_u64).saturating_mul(p.into())))
	}
	/// Storage: `Domains::NextRuntimeId` (r:1 w:1)
	/// Proof: `Domains::NextRuntimeId` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::RuntimeRegistry` (r:0 w:1)
	/// Proof: `Domains::RuntimeRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn register_domain_runtime() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 34_365_019_000 picoseconds.
		Weight::from_parts(34_417_998_000, 1485)
			.saturating_add(T::DbWeight::get().reads(1_u64))
			.saturating_add(T::DbWeight::get().writes(2_u64))
	}
	/// Storage: `Domains::RuntimeRegistry` (r:1 w:0)
	/// Proof: `Domains::RuntimeRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::ScheduledRuntimeUpgrades` (r:0 w:1)
	/// Proof: `Domains::ScheduledRuntimeUpgrades` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn upgrade_domain_runtime() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `2481067`
		//  Estimated: `2484532`
		// Minimum execution time: 37_943_257_000 picoseconds.
		Weight::from_parts(38_175_433_000, 2484532)
			.saturating_add(T::DbWeight::get().reads(1_u64))
			.saturating_add(T::DbWeight::get().writes(1_u64))
	}
	/// Storage: `Domains::PermissionedActionAllowedBy` (r:1 w:0)
	/// Proof: `Domains::PermissionedActionAllowedBy` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::RuntimeRegistry` (r:1 w:1)
	/// Proof: `Domains::RuntimeRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::NextDomainId` (r:1 w:1)
	/// Proof: `Domains::NextDomainId` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NextEVMChainId` (r:1 w:1)
	/// Proof: `Domains::NextEVMChainId` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Transporter::DomainBalances` (r:1 w:1)
	/// Proof: `Transporter::DomainBalances` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `System::Digest` (r:1 w:1)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainSudoCalls` (r:0 w:1)
	/// Proof: `Domains::DomainSudoCalls` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainRegistry` (r:0 w:1)
	/// Proof: `Domains::DomainRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:0 w:1)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:0 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:0 w:1)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTree` (r:0 w:1)
	/// Proof: `Domains::BlockTree` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Messenger::DomainChainAllowlistUpdate` (r:0 w:1)
	/// Proof: `Messenger::DomainChainAllowlistUpdate` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn instantiate_domain() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `2481139`
		//  Estimated: `2484604`
		// Minimum execution time: 9_071_076_000 picoseconds.
		Weight::from_parts(9_096_678_000, 2484604)
			.saturating_add(T::DbWeight::get().reads(8_u64))
			.saturating_add(T::DbWeight::get().writes(14_u64))
	}
	/// Storage: `Domains::PendingStakingOperationCount` (r:1 w:1)
	/// Proof: `Domains::PendingStakingOperationCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorSigningKey` (r:1 w:1)
	/// Proof: `Domains::OperatorSigningKey` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainRegistry` (r:1 w:0)
	/// Proof: `Domains::DomainRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NextOperatorId` (r:1 w:1)
	/// Proof: `Domains::NextOperatorId` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:0 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LastEpochStakingDistribution` (r:0 w:1)
	/// Proof: `Domains::LastEpochStakingDistribution` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorIdOwner` (r:0 w:1)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:0 w:1)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn register_operator() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `651`
		//  Estimated: `9015`
		// Minimum execution time: 252_801_000 picoseconds.
		Weight::from_parts(256_406_000, 9015)
			.saturating_add(T::DbWeight::get().reads(10_u64))
			.saturating_add(T::DbWeight::get().writes(12_u64))
	}
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::PendingStakingOperationCount` (r:1 w:1)
	/// Proof: `Domains::PendingStakingOperationCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:0)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:1 w:0)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn nominate_operator() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1131`
		//  Estimated: `9015`
		// Minimum execution time: 168_898_000 picoseconds.
		Weight::from_parts(174_307_000, 9015)
			.saturating_add(T::DbWeight::get().reads(9_u64))
			.saturating_add(T::DbWeight::get().writes(6_u64))
	}
	/// Storage: `Domains::OperatorIdOwner` (r:1 w:0)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn deregister_operator() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `977`
		//  Estimated: `4442`
		// Minimum execution time: 54_905_000 picoseconds.
		Weight::from_parts(56_948_000, 4442)
			.saturating_add(T::DbWeight::get().reads(5_u64))
			.saturating_add(T::DbWeight::get().writes(2_u64))
	}
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::PendingStakingOperationCount` (r:1 w:1)
	/// Proof: `Domains::PendingStakingOperationCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:0)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:1 w:0)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Withdrawals` (r:1 w:1)
	/// Proof: `Domains::Withdrawals` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorIdOwner` (r:1 w:0)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn withdraw_stake() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1674`
		//  Estimated: `9015`
		// Minimum execution time: 152_234_000 picoseconds.
		Weight::from_parts(156_823_000, 9015)
			.saturating_add(T::DbWeight::get().reads(12_u64))
			.saturating_add(T::DbWeight::get().writes(7_u64))
	}
	/// Storage: `Domains::Operators` (r:1 w:0)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Withdrawals` (r:1 w:1)
	/// Proof: `Domains::Withdrawals` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:1 w:0)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn unlock_funds() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1290`
		//  Estimated: `9015`
		// Minimum execution time: 144_271_000 picoseconds.
		Weight::from_parts(147_196_000, 9015)
			.saturating_add(T::DbWeight::get().reads(8_u64))
			.saturating_add(T::DbWeight::get().writes(4_u64))
	}
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:3 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:1 w:1)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Withdrawals` (r:1 w:0)
	/// Proof: `Domains::Withdrawals` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NominatorCount` (r:1 w:1)
	/// Proof: `Domains::NominatorCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorIdOwner` (r:1 w:1)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::AccumulatedTreasuryFunds` (r:1 w:0)
	/// Proof: `Domains::AccumulatedTreasuryFunds` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorSigningKey` (r:0 w:1)
	/// Proof: `Domains::OperatorSigningKey` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn unlock_nominator() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1491`
		//  Estimated: `9015`
		// Minimum execution time: 262_655_000 picoseconds.
		Weight::from_parts(269_561_000, 9015)
			.saturating_add(T::DbWeight::get().reads(13_u64))
			.saturating_add(T::DbWeight::get().writes(9_u64))
	}
	/// Storage: `Domains::DomainRegistry` (r:1 w:1)
	/// Proof: `Domains::DomainRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn update_domain_operator_allow_list() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `438`
		//  Estimated: `3903`
		// Minimum execution time: 32_711_000 picoseconds.
		Weight::from_parts(34_742_000, 3903)
			.saturating_add(T::DbWeight::get().reads(1_u64))
			.saturating_add(T::DbWeight::get().writes(1_u64))
	}
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	fn transfer_treasury_funds() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `52`
		//  Estimated: `6196`
		// Minimum execution time: 50_180_000 picoseconds.
		Weight::from_parts(50_700_000, 6196)
			.saturating_add(T::DbWeight::get().reads(2_u64))
			.saturating_add(T::DbWeight::get().writes(2_u64))
	}
	/// Storage: `Domains::HeadReceiptNumber` (r:1 w:1)
	/// Proof: `Domains::HeadReceiptNumber` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NewAddedHeadReceipt` (r:1 w:1)
	/// Proof: `Domains::NewAddedHeadReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTree` (r:1 w:1)
	/// Proof: `Domains::BlockTree` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:1)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:0 w:1)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn submit_receipt() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `655`
		//  Estimated: `4120`
		// Minimum execution time: 59_509_000 picoseconds.
		Weight::from_parts(61_214_000, 4120)
			.saturating_add(T::DbWeight::get().reads(5_u64))
			.saturating_add(T::DbWeight::get().writes(5_u64))
	}
}

// For backwards compatibility and tests
impl WeightInfo for () {
	/// Storage: `Domains::HeadReceiptNumber` (r:1 w:1)
	/// Proof: `Domains::HeadReceiptNumber` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NewAddedHeadReceipt` (r:1 w:1)
	/// Proof: `Domains::NewAddedHeadReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:1)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTree` (r:2 w:2)
	/// Proof: `Domains::BlockTree` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:1 w:2)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::ExecutionInbox` (r:3 w:1)
	/// Proof: `Domains::ExecutionInbox` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Transporter::DomainBalances` (r:1 w:1)
	/// Proof: `Transporter::DomainBalances` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainRegistry` (r:1 w:0)
	/// Proof: `Domains::DomainRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainRuntimeUpgradeRecords` (r:1 w:0)
	/// Proof: `Domains::DomainRuntimeUpgradeRecords` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::SuccessfulBundles` (r:1 w:1)
	/// Proof: `Domains::SuccessfulBundles` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::HeadDomainNumber` (r:1 w:1)
	/// Proof: `Domains::HeadDomainNumber` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorBundleSlot` (r:1 w:1)
	/// Proof: `Domains::OperatorBundleSlot` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::InboxedBundleAuthor` (r:0 w:1)
	/// Proof: `Domains::InboxedBundleAuthor` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::ConsensusBlockHash` (r:0 w:1)
	/// Proof: `Domains::ConsensusBlockHash` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn submit_bundle() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1751`
		//  Estimated: `10166`
		// Minimum execution time: 172_846_000 picoseconds.
		Weight::from_parts(174_992_000, 10166)
			.saturating_add(ParityDbWeight::get().reads(16_u64))
			.saturating_add(ParityDbWeight::get().writes(14_u64))
	}
	/// Storage: `Domains::HeadReceiptNumber` (r:1 w:1)
	/// Proof: `Domains::HeadReceiptNumber` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:1 w:0)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn submit_fraud_proof() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1008`
		//  Estimated: `4473`
		// Minimum execution time: 38_692_000 picoseconds.
		Weight::from_parts(41_247_000, 4473)
			.saturating_add(ParityDbWeight::get().reads(2_u64))
			.saturating_add(ParityDbWeight::get().writes(1_u64))
	}
	/// Storage: `Domains::BlockTree` (r:1 w:1)
	/// Proof: `Domains::BlockTree` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:1 w:1)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:100 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:100 w:100)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::PendingSlashes` (r:1 w:1)
	/// Proof: `Domains::PendingSlashes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `n` is `[1, 100]`.
	fn handle_bad_receipt(n: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `932 + n * (208 ±0)`
		//  Estimated: `4397 + n * (2683 ±0)`
		// Minimum execution time: 56_216_000 picoseconds.
		Weight::from_parts(56_940_000, 4397)
			// Standard Error: 67_772
			.saturating_add(Weight::from_parts(22_316_875, 0).saturating_mul(n.into()))
			.saturating_add(ParityDbWeight::get().reads(4_u64))
			.saturating_add(ParityDbWeight::get().reads((2_u64).saturating_mul(n.into())))
			.saturating_add(ParityDbWeight::get().writes(4_u64))
			.saturating_add(ParityDbWeight::get().writes((1_u64).saturating_mul(n.into())))
			.saturating_add(Weight::from_parts(0, 2683).saturating_mul(n.into()))
	}
	/// Storage: `Domains::Operators` (r:200 w:100)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:100 w:100)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::AccumulatedTreasuryFunds` (r:1 w:0)
	/// Proof: `Domains::AccumulatedTreasuryFunds` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::PendingSlashes` (r:1 w:1)
	/// Proof: `Domains::PendingSlashes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `n` is `[1, 100]`.
	/// The range of component `s` is `[0, 100]`.
	fn confirm_domain_block(n: u32, s: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0 + n * (378 ±0) + s * (239 ±0)`
		//  Estimated: `271975 + n * (2588 ±0) + s * (979 ±0)`
		// Minimum execution time: 2_284_894_000 picoseconds.
		Weight::from_parts(2_292_775_000, 271975)
			// Standard Error: 419_121
			.saturating_add(Weight::from_parts(13_897_823, 0).saturating_mul(n.into()))
			// Standard Error: 419_507
			.saturating_add(Weight::from_parts(14_690_876, 0).saturating_mul(s.into()))
			.saturating_add(ParityDbWeight::get().reads(3_u64))
			.saturating_add(ParityDbWeight::get().reads((2_u64).saturating_mul(n.into())))
			.saturating_add(ParityDbWeight::get().reads((1_u64).saturating_mul(s.into())))
			.saturating_add(ParityDbWeight::get().writes(3_u64))
			.saturating_add(ParityDbWeight::get().writes((1_u64).saturating_mul(n.into())))
			.saturating_add(ParityDbWeight::get().writes((1_u64).saturating_mul(s.into())))
			.saturating_add(Weight::from_parts(0, 2588).saturating_mul(n.into()))
			.saturating_add(Weight::from_parts(0, 979).saturating_mul(s.into()))
	}
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:100 w:100)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `n` is `[1, 100]`.
	fn operator_reward_tax_and_restake(n: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `366 + n * (224 ±0)`
		//  Estimated: `3831 + n * (2699 ±0)`
		// Minimum execution time: 22_997_000 picoseconds.
		Weight::from_parts(33_679_642, 3831)
			// Standard Error: 11_599
			.saturating_add(Weight::from_parts(4_386_338, 0).saturating_mul(n.into()))
			.saturating_add(ParityDbWeight::get().reads(1_u64))
			.saturating_add(ParityDbWeight::get().reads((1_u64).saturating_mul(n.into())))
			.saturating_add(ParityDbWeight::get().writes(1_u64))
			.saturating_add(ParityDbWeight::get().writes((1_u64).saturating_mul(n.into())))
			.saturating_add(Weight::from_parts(0, 2699).saturating_mul(n.into()))
	}
	/// Storage: `Domains::PendingSlashes` (r:1 w:1)
	/// Proof: `Domains::PendingSlashes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorIdOwner` (r:1 w:1)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Deposits` (r:11 w:10)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:10 w:10)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:2 w:2)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Withdrawals` (r:10 w:0)
	/// Proof: `Domains::Withdrawals` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:12 w:12)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::AccumulatedTreasuryFunds` (r:1 w:0)
	/// Proof: `Domains::AccumulatedTreasuryFunds` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NominatorCount` (r:1 w:1)
	/// Proof: `Domains::NominatorCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorSigningKey` (r:0 w:1)
	/// Proof: `Domains::OperatorSigningKey` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `n` is `[0, 9]`.
	fn slash_operator(n: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1365 + n * (298 ±0)`
		//  Estimated: `9015 + n * (8025 ±0)`
		// Minimum execution time: 236_187_000 picoseconds.
		Weight::from_parts(271_847_200, 9015)
			// Standard Error: 293_537
			.saturating_add(Weight::from_parts(92_669_227, 0).saturating_mul(n.into()))
			.saturating_add(ParityDbWeight::get().reads(14_u64))
			.saturating_add(ParityDbWeight::get().reads((4_u64).saturating_mul(n.into())))
			.saturating_add(ParityDbWeight::get().writes(12_u64))
			.saturating_add(ParityDbWeight::get().writes((3_u64).saturating_mul(n.into())))
			.saturating_add(Weight::from_parts(0, 8025).saturating_mul(n.into()))
	}
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:512 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:512 w:512)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LastEpochStakingDistribution` (r:0 w:1)
	/// Proof: `Domains::LastEpochStakingDistribution` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:0 w:512)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// The range of component `p` is `[0, 512]`.
	fn finalize_domain_epoch_staking(p: u32, ) -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `116165`
		//  Estimated: `1384355`
		// Minimum execution time: 3_726_400_000 picoseconds.
		Weight::from_parts(3_900_459_490, 1384355)
			// Standard Error: 10_021
			.saturating_add(Weight::from_parts(3_667_131, 0).saturating_mul(p.into()))
			.saturating_add(ParityDbWeight::get().reads(1025_u64))
			.saturating_add(ParityDbWeight::get().writes(2_u64))
			.saturating_add(ParityDbWeight::get().writes((2_u64).saturating_mul(p.into())))
	}
	/// Storage: `Domains::NextRuntimeId` (r:1 w:1)
	/// Proof: `Domains::NextRuntimeId` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::RuntimeRegistry` (r:0 w:1)
	/// Proof: `Domains::RuntimeRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn register_domain_runtime() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `0`
		//  Estimated: `1485`
		// Minimum execution time: 34_365_019_000 picoseconds.
		Weight::from_parts(34_417_998_000, 1485)
			.saturating_add(ParityDbWeight::get().reads(1_u64))
			.saturating_add(ParityDbWeight::get().writes(2_u64))
	}
	/// Storage: `Domains::RuntimeRegistry` (r:1 w:0)
	/// Proof: `Domains::RuntimeRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::ScheduledRuntimeUpgrades` (r:0 w:1)
	/// Proof: `Domains::ScheduledRuntimeUpgrades` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn upgrade_domain_runtime() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `2481067`
		//  Estimated: `2484532`
		// Minimum execution time: 37_943_257_000 picoseconds.
		Weight::from_parts(38_175_433_000, 2484532)
			.saturating_add(ParityDbWeight::get().reads(1_u64))
			.saturating_add(ParityDbWeight::get().writes(1_u64))
	}
	/// Storage: `Domains::PermissionedActionAllowedBy` (r:1 w:0)
	/// Proof: `Domains::PermissionedActionAllowedBy` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::RuntimeRegistry` (r:1 w:1)
	/// Proof: `Domains::RuntimeRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::NextDomainId` (r:1 w:1)
	/// Proof: `Domains::NextDomainId` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NextEVMChainId` (r:1 w:1)
	/// Proof: `Domains::NextEVMChainId` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Transporter::DomainBalances` (r:1 w:1)
	/// Proof: `Transporter::DomainBalances` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `System::Digest` (r:1 w:1)
	/// Proof: `System::Digest` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainSudoCalls` (r:0 w:1)
	/// Proof: `Domains::DomainSudoCalls` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainRegistry` (r:0 w:1)
	/// Proof: `Domains::DomainRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:0 w:1)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:0 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:0 w:1)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTree` (r:0 w:1)
	/// Proof: `Domains::BlockTree` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Messenger::DomainChainAllowlistUpdate` (r:0 w:1)
	/// Proof: `Messenger::DomainChainAllowlistUpdate` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn instantiate_domain() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `2481139`
		//  Estimated: `2484604`
		// Minimum execution time: 9_071_076_000 picoseconds.
		Weight::from_parts(9_096_678_000, 2484604)
			.saturating_add(ParityDbWeight::get().reads(8_u64))
			.saturating_add(ParityDbWeight::get().writes(14_u64))
	}
	/// Storage: `Domains::PendingStakingOperationCount` (r:1 w:1)
	/// Proof: `Domains::PendingStakingOperationCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorSigningKey` (r:1 w:1)
	/// Proof: `Domains::OperatorSigningKey` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainRegistry` (r:1 w:0)
	/// Proof: `Domains::DomainRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NextOperatorId` (r:1 w:1)
	/// Proof: `Domains::NextOperatorId` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:0 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LastEpochStakingDistribution` (r:0 w:1)
	/// Proof: `Domains::LastEpochStakingDistribution` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorIdOwner` (r:0 w:1)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:0 w:1)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn register_operator() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `651`
		//  Estimated: `9015`
		// Minimum execution time: 252_801_000 picoseconds.
		Weight::from_parts(256_406_000, 9015)
			.saturating_add(ParityDbWeight::get().reads(10_u64))
			.saturating_add(ParityDbWeight::get().writes(12_u64))
	}
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::PendingStakingOperationCount` (r:1 w:1)
	/// Proof: `Domains::PendingStakingOperationCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:0)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:1 w:0)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn nominate_operator() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1131`
		//  Estimated: `9015`
		// Minimum execution time: 168_898_000 picoseconds.
		Weight::from_parts(174_307_000, 9015)
			.saturating_add(ParityDbWeight::get().reads(9_u64))
			.saturating_add(ParityDbWeight::get().writes(6_u64))
	}
	/// Storage: `Domains::OperatorIdOwner` (r:1 w:0)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:1)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn deregister_operator() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `977`
		//  Estimated: `4442`
		// Minimum execution time: 54_905_000 picoseconds.
		Weight::from_parts(56_948_000, 4442)
			.saturating_add(ParityDbWeight::get().reads(5_u64))
			.saturating_add(ParityDbWeight::get().writes(2_u64))
	}
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::PendingStakingOperationCount` (r:1 w:1)
	/// Proof: `Domains::PendingStakingOperationCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::DomainStakingSummary` (r:1 w:0)
	/// Proof: `Domains::DomainStakingSummary` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:1 w:0)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Withdrawals` (r:1 w:1)
	/// Proof: `Domains::Withdrawals` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorIdOwner` (r:1 w:0)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn withdraw_stake() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1674`
		//  Estimated: `9015`
		// Minimum execution time: 152_234_000 picoseconds.
		Weight::from_parts(156_823_000, 9015)
			.saturating_add(ParityDbWeight::get().reads(12_u64))
			.saturating_add(ParityDbWeight::get().writes(7_u64))
	}
	/// Storage: `Domains::Operators` (r:1 w:0)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::Withdrawals` (r:1 w:1)
	/// Proof: `Domains::Withdrawals` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:1 w:0)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `System::Account` (r:1 w:1)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn unlock_funds() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1290`
		//  Estimated: `9015`
		// Minimum execution time: 144_271_000 picoseconds.
		Weight::from_parts(147_196_000, 9015)
			.saturating_add(ParityDbWeight::get().reads(8_u64))
			.saturating_add(ParityDbWeight::get().writes(4_u64))
	}
	/// Storage: `Domains::Operators` (r:1 w:1)
	/// Proof: `Domains::Operators` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:0)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `System::Account` (r:3 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Deposits` (r:1 w:1)
	/// Proof: `Domains::Deposits` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorEpochSharePrice` (r:1 w:1)
	/// Proof: `Domains::OperatorEpochSharePrice` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Balances::Holds` (r:1 w:1)
	/// Proof: `Balances::Holds` (`max_values`: None, `max_size`: Some(5550), added: 8025, mode: `MaxEncodedLen`)
	/// Storage: `Domains::Withdrawals` (r:1 w:0)
	/// Proof: `Domains::Withdrawals` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NominatorCount` (r:1 w:1)
	/// Proof: `Domains::NominatorCount` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorIdOwner` (r:1 w:1)
	/// Proof: `Domains::OperatorIdOwner` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::AccumulatedTreasuryFunds` (r:1 w:0)
	/// Proof: `Domains::AccumulatedTreasuryFunds` (`max_values`: Some(1), `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::OperatorSigningKey` (r:0 w:1)
	/// Proof: `Domains::OperatorSigningKey` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn unlock_nominator() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `1491`
		//  Estimated: `9015`
		// Minimum execution time: 262_655_000 picoseconds.
		Weight::from_parts(269_561_000, 9015)
			.saturating_add(ParityDbWeight::get().reads(13_u64))
			.saturating_add(ParityDbWeight::get().writes(9_u64))
	}
	/// Storage: `Domains::DomainRegistry` (r:1 w:1)
	/// Proof: `Domains::DomainRegistry` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn update_domain_operator_allow_list() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `438`
		//  Estimated: `3903`
		// Minimum execution time: 32_711_000 picoseconds.
		Weight::from_parts(34_742_000, 3903)
			.saturating_add(ParityDbWeight::get().reads(1_u64))
			.saturating_add(ParityDbWeight::get().writes(1_u64))
	}
	/// Storage: `System::Account` (r:2 w:2)
	/// Proof: `System::Account` (`max_values`: None, `max_size`: Some(128), added: 2603, mode: `MaxEncodedLen`)
	fn transfer_treasury_funds() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `52`
		//  Estimated: `6196`
		// Minimum execution time: 50_180_000 picoseconds.
		Weight::from_parts(50_700_000, 6196)
			.saturating_add(ParityDbWeight::get().reads(2_u64))
			.saturating_add(ParityDbWeight::get().writes(2_u64))
	}
	/// Storage: `Domains::HeadReceiptNumber` (r:1 w:1)
	/// Proof: `Domains::HeadReceiptNumber` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::NewAddedHeadReceipt` (r:1 w:1)
	/// Proof: `Domains::NewAddedHeadReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestConfirmedDomainExecutionReceipt` (r:1 w:0)
	/// Proof: `Domains::LatestConfirmedDomainExecutionReceipt` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTree` (r:1 w:1)
	/// Proof: `Domains::BlockTree` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::LatestSubmittedER` (r:1 w:1)
	/// Proof: `Domains::LatestSubmittedER` (`max_values`: None, `max_size`: None, mode: `Measured`)
	/// Storage: `Domains::BlockTreeNodes` (r:0 w:1)
	/// Proof: `Domains::BlockTreeNodes` (`max_values`: None, `max_size`: None, mode: `Measured`)
	fn submit_receipt() -> Weight {
		// Proof Size summary in bytes:
		//  Measured:  `655`
		//  Estimated: `4120`
		// Minimum execution time: 59_509_000 picoseconds.
		Weight::from_parts(61_214_000, 4120)
			.saturating_add(ParityDbWeight::get().reads(5_u64))
			.saturating_add(ParityDbWeight::get().writes(5_u64))
	}
}
