<?php
function mergeFolders($source, $destination) {
  $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($source, RecursiveDirectoryIterator::SKIP_DOTS),RecursiveIteratorIterator::SELF_FIRST);
  foreach ($iterator as $item) {
  	if ($item->isDir()) {
  		$target = $destination . DIRECTORY_SEPARATOR . $iterator->getSubPathName();
  		if (!is_dir($target)) {
  			mkdir($target);
  		}
  	} else {
  		$target = $destination . DIRECTORY_SEPARATOR . $iterator->getSubPathName();
  		copy($item, $target);
  	}
  }
}
function listFiles($dir) {
	$files = scandir($dir);
	foreach($files as $file) {
		if ($file == '.' || $file == '..') {
			continue;
		}
		$path = $dir . '/' . $file;
		if (is_dir($path)) {
			echo str_replace($dir,'',$path) . " ";
			listFiles($path);
		} else {
			if (pathinfo($path, PATHINFO_EXTENSION) != 'zip') {
				echo str_replace($dir,'',$path) . " ";
			}
		}
	}
}
function site_dir($dir) {
	global $show;
	$folders = glob($dir .'*');
	$totalFolders = count($folders);
	$perPage = $show;
	$totalPages = ceil($totalFolders / $perPage);
	if (!isset($_GET['page'])) {
		$currentPage = 1;
	} else {
		$currentPage = $_GET['page'];
	}
	$start = ($currentPage - 1) * $perPage;
	$end = $start + $perPage;
	$foldersToDisplay = array_slice($folders, $start, $perPage);

	foreach ($foldersToDisplay as $files) {
		$file = str_ireplace($dir,"",$files);
		if($file=="default"){$file_name="默认站点";}else{$file_name=str_ireplace("@","/",$file);}
		include $dir.$file."/config.php";
		echo '<tr>
		<td style="text-align: center;"><a href="'.$site_url.'" target="_blank">'.$file_name.'</a></td>
		<td style="text-align: center;">
		<a href="site_add.php?copy='.$file.'" class="btn btn-success btn-mini" onClick="copysite()">复制配置</a>
		<a href="index.php?sidebar=1&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">网站配置</a>
		<a href="index.php?sidebar=2&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">采集设置</a>
		<a href="index.php?sidebar=3&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">站点适配</a>
		<a href="index.php?sidebar=7&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">蜘蛛屏蔽</a>
		<a href="index.php?sidebar=8&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">内容替换</a>
		<a href="index.php?sidebar=4&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">缓存设置</a>
		<a href="index.php?sidebar=5&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">外链处理</a>
		<a href="index.php?sidebar=9&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">随机TDK</a>
		<a href="index.php?sidebar=6&edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">访问跳转</a>
		<a href="robot.php?edit='.$file.'" class="btn btn-info btn-mini" onClick="editsite()">蜘蛛统计</a>
		<a href="site_del.php?id='.$file.'" class="btn btn-danger btn-mini" onClick="delsite()">删除网站</a>
		</td>
		</tr>';
  }
  if($totalPages > 1){
  	echo page($currentPage,$totalPages);
  }
}
?>