/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util;

import java.util.AbstractQueue;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HoldQueue<T, C>
extends AbstractQueue<T>
implements Queue<T> {
    private final PriorityQueue<HoldHandle<C>> handles = new PriorityQueue();
    private final Queue<T> exposed;
    private HoldHandle<C> hold;

    protected HoldQueue(Queue<T> queue, Queue<T> queue2, Comparator<T> comparator) {
        this.exposed = queue2;
    }

    @Override
    public Iterator<T> iterator() {
        return this.exposed.iterator();
    }

    private void release(HoldHandle<C> holdHandle) {
        this.handles.remove(holdHandle);
        this.hold = this.handles.isEmpty() ? null : this.handles.peek();
    }

    @Override
    public int size() {
        return this.exposed.size();
    }

    @Override
    public boolean offer(T t) {
        if (this.hold == null) {
            this.exposed.offer(t);
        }
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public T peek() {
        return this.exposed.peek();
    }

    @Override
    public T poll() {
        return this.exposed.poll();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HoldHandle<C>
    implements Comparable<C> {
        private final AtomicInteger ref = new AtomicInteger();
        private final Comparable<C> hold;
        private final HoldQueue<?, C> parent;

        public HoldHandle(HoldQueue<?, C> holdQueue, Comparable<C> comparable) {
            this.hold = comparable;
            this.parent = holdQueue;
        }

        public int release() {
            int n = this.ref.decrementAndGet();
            if (n < 0) {
                throw new IllegalStateException("invalid hold-handle");
            }
            if (n == 0) {
                ((HoldQueue)this.parent).release(this);
            }
            return n;
        }

        @Override
        public int compareTo(C c) {
            return this.hold.compareTo(c);
        }
    }
}

