/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BlockingQueuePump<T>
implements BlockingQueue<T> {
    private final String name;
    private final BlockingQueue<T> queue;
    private final AtomicReference<Thread> thread = new AtomicReference();
    public Runnable dispatchQueue = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                while (BlockingQueuePump.this.thread.get() != null) {
                    BlockingQueuePump.this.dispatch(BlockingQueuePump.this.take());
                }
                if (BlockingQueuePump.this.thread.get() != null) {
                    throw new IllegalStateException(BlockingQueuePump.this.name + " thread unexpected termination");
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            finally {
                BlockingQueuePump.this.thread.set(null);
            }
        }
    };

    public BlockingQueuePump(String string) {
        this.queue = new LinkedBlockingQueue<T>();
        this.name = string;
        this.start();
    }

    public BlockingQueuePump(String string, int n) {
        this.queue = new ArrayBlockingQueue<T>(n);
        this.name = string;
        this.start();
    }

    @Override
    public boolean add(T t) {
        return this.queue.add(t);
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return this.queue.addAll(collection);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean contains(Object object) {
        return this.queue.contains(object);
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        return this.queue.containsAll(collection);
    }

    protected abstract void dispatch(T var1);

    @Override
    public int drainTo(Collection<? super T> collection) {
        return this.queue.drainTo(collection);
    }

    @Override
    public int drainTo(Collection<? super T> collection, int n) {
        return this.queue.drainTo(collection, n);
    }

    @Override
    public T element() {
        return (T)this.queue.element();
    }

    @Override
    public boolean equals(Object object) {
        return this.queue.equals(object);
    }

    @Override
    public int hashCode() {
        return this.queue.hashCode();
    }

    public boolean isAlive() {
        return this.thread.get() != null && this.thread.get().isAlive();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public boolean offer(T t) {
        return this.queue.offer(t);
    }

    @Override
    public boolean offer(T t, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.offer(t, l, timeUnit);
    }

    @Override
    public T peek() {
        return (T)this.queue.peek();
    }

    @Override
    public T poll() {
        return (T)this.queue.poll();
    }

    @Override
    public T poll(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.poll(l, timeUnit);
    }

    @Override
    public void put(T t) throws InterruptedException {
        this.queue.put(t);
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public T remove() {
        return (T)this.queue.remove();
    }

    @Override
    public boolean remove(Object object) {
        return this.queue.remove(object);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.queue.removeAll(collection);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.queue.retainAll(collection);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    public void start() {
        if (this.thread.get() != null) {
            throw new IllegalStateException(this.name + " thread unexpected termination");
        }
        this.thread.set(new Thread(this.dispatchQueue, this.name));
        this.thread.get().setDaemon(true);
        this.thread.get().start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.thread.get() == null || !this.thread.get().isAlive()) {
            this.thread.set(null);
            return;
        }
        Thread thread = this.thread.get();
        synchronized (thread) {
            try {
                this.thread.wait();
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this.thread.set(null);
            }
        }
    }

    @Override
    public T take() throws InterruptedException {
        return this.queue.take();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <Q> Q[] toArray(Q[] QArray) {
        return this.queue.toArray(QArray);
    }
}

