/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.packet;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import org.jnetpcap.nio.JFunction;
import org.jnetpcap.packet.JBinding;
import org.jnetpcap.packet.JHeader;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScan;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.annotate.HeaderLength;
import org.jnetpcap.packet.structure.AnnotatedHeaderLengthMethod;
import org.jnetpcap.packet.structure.AnnotatedScannerMethod;
import org.jnetpcap.protocol.JProtocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JHeaderScanner
extends JFunction {
    private static final String FUNCT_NAME = "scan_";
    private JBinding[] bindings = null;
    private final List<JBinding> bindingsList = new ArrayList<JBinding>();
    private final int id;
    private AnnotatedHeaderLengthMethod[] lengthMethods;
    private AnnotatedScannerMethod scannerMethod;
    private final JProtocol protocol;
    private boolean needJProtocolInitialization;

    public JHeaderScanner(Class<? extends JHeader> clazz) {
        super("java header scanner");
        this.protocol = null;
        this.needJProtocolInitialization = false;
        this.id = JRegistry.lookupId(clazz);
        this.lengthMethods = AnnotatedHeaderLengthMethod.inspectClass(clazz);
        this.scannerMethod = AnnotatedScannerMethod.inspectClass(clazz).length != 0 ? AnnotatedScannerMethod.inspectClass(clazz)[0] : null;
    }

    public JHeaderScanner(JProtocol jProtocol) {
        super(FUNCT_NAME + jProtocol.toString().toLowerCase());
        this.protocol = jProtocol;
        this.id = jProtocol.getId();
        this.needJProtocolInitialization = true;
        this.bindNativeScanner(this.id);
    }

    private void initFromJProtocol(JProtocol jProtocol) {
        Class<? extends JHeader> clazz = jProtocol.getHeaderClass();
        this.lengthMethods = AnnotatedHeaderLengthMethod.inspectClass(clazz);
        this.scannerMethod = AnnotatedScannerMethod.inspectClass(clazz).length != 0 ? AnnotatedScannerMethod.inspectClass(clazz)[0] : null;
        this.needJProtocolInitialization = false;
    }

    private AnnotatedHeaderLengthMethod getLengthMethod(HeaderLength.Type type) {
        if (this.needJProtocolInitialization) {
            this.initFromJProtocol(this.protocol);
        }
        return this.lengthMethods[type.ordinal()];
    }

    private AnnotatedScannerMethod getScannerMethod() {
        if (this.needJProtocolInitialization) {
            this.initFromJProtocol(this.protocol);
        }
        return this.scannerMethod;
    }

    public boolean addBindings(JBinding ... jBindingArray) {
        this.bindings = null;
        return this.bindingsList.addAll(Arrays.asList(jBindingArray));
    }

    private native void bindNativeScanner(int var1);

    public void clearBindings() {
        this.bindings = null;
        this.bindingsList.clear();
    }

    public boolean hasBindings() {
        return !this.bindingsList.isEmpty();
    }

    public JBinding[] getBindings() {
        if (this.bindings == null) {
            this.bindings = this.bindingsList.toArray(new JBinding[this.bindingsList.size()]);
        }
        return this.bindings;
    }

    public int getHeaderLength(JPacket jPacket, int n) {
        return this.getLengthMethod(HeaderLength.Type.HEADER).getHeaderLength(jPacket, n);
    }

    public int getPrefixLength(JPacket jPacket, int n) {
        return this.getLengthMethod(HeaderLength.Type.PREFIX) == null ? 0 : this.getLengthMethod(HeaderLength.Type.PREFIX).getHeaderLength(jPacket, n);
    }

    public int getGapLength(JPacket jPacket, int n) {
        return this.getLengthMethod(HeaderLength.Type.GAP) == null ? 0 : this.getLengthMethod(HeaderLength.Type.GAP).getHeaderLength(jPacket, n);
    }

    public int getPayloadLength(JPacket jPacket, int n) {
        return this.getLengthMethod(HeaderLength.Type.PAYLOAD) == null ? 0 : this.getLengthMethod(HeaderLength.Type.PAYLOAD).getHeaderLength(jPacket, n);
    }

    public int getPostfixLength(JPacket jPacket, int n) {
        return this.getLengthMethod(HeaderLength.Type.POSTFIX) == null ? 0 : this.getLengthMethod(HeaderLength.Type.POSTFIX).getHeaderLength(jPacket, n);
    }

    public final int getId() {
        return this.id;
    }

    public boolean isDirect() {
        return super.isInitialized() && this.getScannerMethod() == null;
    }

    private native void nativeScan(JScan var1);

    public boolean removeBindings(JBinding ... jBindingArray) {
        this.bindings = null;
        return this.bindingsList.removeAll(Arrays.asList(jBindingArray));
    }

    public int scanAllBindings(JPacket jPacket, int n) {
        for (JBinding jBinding : this.getBindings()) {
            if (jBinding == null || !jBinding.isBound(jPacket, n)) continue;
            return jBinding.getSourceId();
        }
        return 0;
    }

    protected void scanHeader(JScan jScan) {
        int n;
        JPacket jPacket;
        if (this.getScannerMethod() != null) {
            this.getScannerMethod().scan(jScan);
        } else if (this.isDirect()) {
            this.nativeScan(jScan);
        } else {
            jPacket = jScan.scan_packet();
            n = jScan.scan_offset();
            this.setAllLengths(jScan, jPacket, n);
        }
        if (jScan.scan_length() == 0) {
            return;
        }
        if (jScan.scan_next_id() == 0) {
            jScan.record_header();
            jPacket = jScan.scan_packet();
            n = jScan.scan_offset();
            jScan.scan_offset(n);
            int n2 = this.scanAllBindings(jPacket, n + jScan.scan_length() + jScan.scan_gap());
            jScan.scan_next_id(n2);
        }
    }

    private void setAllLengths(JScan jScan, JPacket jPacket, int n) {
        if (this.needJProtocolInitialization) {
            this.initFromJProtocol(this.protocol);
        }
        int n2 = this.lengthMethods[HeaderLength.Type.PREFIX.ordinal()] == null ? 0 : this.lengthMethods[HeaderLength.Type.PREFIX.ordinal()].getHeaderLength(jPacket, n);
        int n3 = this.lengthMethods[HeaderLength.Type.HEADER.ordinal()].getHeaderLength(jPacket, n += n2);
        int n4 = this.lengthMethods[HeaderLength.Type.GAP.ordinal()] == null ? 0 : this.lengthMethods[HeaderLength.Type.GAP.ordinal()].getHeaderLength(jPacket, n);
        int n5 = this.lengthMethods[HeaderLength.Type.PAYLOAD.ordinal()] == null ? 0 : this.lengthMethods[HeaderLength.Type.PAYLOAD.ordinal()].getHeaderLength(jPacket, n);
        int n6 = this.lengthMethods[HeaderLength.Type.POSTFIX.ordinal()] == null ? 0 : this.lengthMethods[HeaderLength.Type.POSTFIX.ordinal()].getHeaderLength(jPacket, n);
        jScan.scan_set_lengths(n2, n3, n4, n5, n6);
    }

    public void setScannerMethod(AnnotatedScannerMethod annotatedScannerMethod) {
        this.scannerMethod = annotatedScannerMethod;
    }

    public String toString() {
        Formatter formatter = new Formatter();
        StringBuilder stringBuilder = new StringBuilder();
        for (JBinding jBinding : this.bindingsList) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append(JRegistry.lookupClass(jBinding.getSourceId()).getSimpleName());
        }
        formatter.format("id=%2d, loaded=%-5s direct=%-5s, scan=%-5s bindings=%-2d [%s]", this.id, this.lengthMethods != null, this.isDirect(), this.hasScanMethod(), this.bindingsList.size(), stringBuilder);
        return formatter.toString();
    }

    public boolean hasScanMethod() {
        return this.getScannerMethod() != null;
    }

    static {
        JScanner.sizeof();
    }
}

