/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap.nio;

import java.util.Iterator;
import org.jnetpcap.nio.Link;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkSequence<T>
implements Iterable<T> {
    private final String name;
    private Link<T> first;
    private Link<T> last;
    private int size;

    public LinkSequence() {
        this.name = super.toString();
    }

    public LinkSequence(String string) {
        this.name = string;
    }

    public synchronized void add(Link<T> link) {
        if (link.linkNext() != null || link.linkPrev() != null) {
            throw new IllegalStateException("link element already part of list");
        }
        if (this.last == null) {
            this.first = link;
            this.last = link;
        } else {
            this.last.linkNext(link);
            link.linkPrev(this.last);
            this.last = link;
        }
        ++this.size;
        link.linkCollection(this);
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized void remove(Link<T> link) {
        Link<T> link2 = link.linkPrev();
        Link<T> link3 = link.linkNext();
        if (link2 == null && link3 == null) {
            this.first = null;
            this.last = null;
        } else if (link2 == null) {
            this.first = link3;
            this.first.linkPrev(null);
        } else if (link3 == null) {
            this.last = link2;
            this.last.linkNext(null);
        } else {
            link2.linkNext(link3);
            link3.linkPrev(link2);
        }
        link.linkNext(null);
        link.linkPrev(null);
        link.linkCollection(null);
        --this.size;
        if (this.size < 0) {
            T t = link.linkElement();
            String string = t == null ? null : t.getClass().getSimpleName();
            String string2 = String.format("%s:: size < 0 :: culprit=%s[%s]", this.name, string, String.valueOf(t));
            throw new IllegalStateException(string2);
        }
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized T get(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(String.format("index=%d, size=%d", n, this.size));
        }
        Link<T> link = this.first;
        for (int i = 0; i < n; ++i) {
            link = link.linkNext();
        }
        return link == null ? null : (T)link.linkElement();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        for (Link<T> link = this.first; link != null; link = link.linkNext()) {
            if (link != this.first) {
                stringBuilder.append(',');
            }
            stringBuilder.append(link.toString());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Link<T> node;
            {
                this.node = LinkSequence.this.first;
            }

            @Override
            public boolean hasNext() {
                return this.node != null;
            }

            @Override
            public T next() {
                Link link = this.node;
                this.node = this.node.linkNext();
                return link.linkElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

