/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import com.slytechs.library.JNILibrary;
import com.slytechs.library.Library;
import com.slytechs.library.LibraryInitializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jnetpcap.Pcap;
import org.jnetpcap.PcapAddr;
import org.jnetpcap.PcapUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Library(preload={PcapIf.class, PcapAddr.class}, jni={"jnetpcap"})
public class PcapIf {
    private volatile PcapIf next;
    private volatile String name;
    private volatile String description;
    private final List<PcapAddr> addresses = new ArrayList<PcapAddr>(2);
    private volatile int flags;

    @LibraryInitializer
    private static native void initIDs();

    private final PcapIf getNext() {
        return this.next;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final List<PcapAddr> getAddresses() {
        return this.addresses;
    }

    public final int getFlags() {
        return this.flags;
    }

    public byte[] getHardwareAddress() throws IOException {
        return PcapUtils.getHardwareAddress(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        if (this.addresses != null && !this.addresses.isEmpty()) {
            stringBuilder.append("flags=").append(this.flags);
            stringBuilder.append(", addresses=").append(this.addresses);
            stringBuilder.append(", ");
        }
        stringBuilder.append("name=").append(this.name);
        stringBuilder.append(", desc=").append(this.description);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public static PcapIf findDefaultIf(StringBuilder stringBuilder) {
        LinkedList<PcapIf> linkedList = new LinkedList<PcapIf>();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        if (Pcap.findAllDevs(linkedList, stringBuilder) != 0) {
            return null;
        }
        for (PcapIf pcapIf : linkedList) {
            List<PcapAddr> list = pcapIf.getAddresses();
            if (list.isEmpty()) continue;
            return pcapIf;
        }
        return null;
    }

    public static List<PcapIf> findAllDevs(StringBuilder stringBuilder) {
        LinkedList<PcapIf> linkedList = new LinkedList<PcapIf>();
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder();
        }
        Pcap.findAllDevs(linkedList, stringBuilder);
        return linkedList;
    }

    static {
        JNILibrary.register(PcapIf.class);
    }
}

