/*
 * Decompiled with CFR 0.152.
 */
package org.jnetpcap;

import com.slytechs.library.JNILibrary;
import com.slytechs.library.Library;
import com.slytechs.library.LibraryInitializer;
import com.slytechs.library.LibraryMember;
import java.nio.ByteBuffer;
import java.util.List;
import org.jnetpcap.ByteBufferHandler;
import org.jnetpcap.JBufferHandler;
import org.jnetpcap.PcapBpfProgram;
import org.jnetpcap.PcapClosedException;
import org.jnetpcap.PcapDumper;
import org.jnetpcap.PcapHandler;
import org.jnetpcap.PcapHeader;
import org.jnetpcap.PcapIf;
import org.jnetpcap.PcapInteger;
import org.jnetpcap.PcapPktBuffer;
import org.jnetpcap.PcapPktHdr;
import org.jnetpcap.PcapStat;
import org.jnetpcap.nio.JBuffer;
import org.jnetpcap.nio.JMemory;
import org.jnetpcap.nio.JNumber;
import org.jnetpcap.packet.JPacket;
import org.jnetpcap.packet.JPacketHandler;
import org.jnetpcap.packet.JRegistry;
import org.jnetpcap.packet.JScanner;
import org.jnetpcap.packet.PcapPacket;
import org.jnetpcap.packet.PcapPacketHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Library(preload={PcapDumper.class, PcapIf.class, PcapBpfProgram.class, PcapDumper.class}, natives={"wpcap", "pcap", "packet"}, jni={"jnetpcap", "jnetpcap-pcap100"})
public class Pcap {
    public static final int DEFAULT_JPACKET_BUFFER_SIZE = 0x100000;
    public static final int DEFAULT_PROMISC = 1;
    public static final int DEFAULT_SNAPLEN = 65536;
    public static final int DEFAULT_TIMEOUT = 0;
    public static final int DISPATCH_BUFFER_FULL = -1;
    public static final int ERROR = -1;
    public static final int ERROR_ACTIVATED = -4;
    public static final int ERROR_BREAK = -2;
    public static final int ERROR_IFACE_NOT_UP = -9;
    public static final int ERROR_NO_SUCH_DEVICE = -5;
    public static final int ERROR_NOT_ACTIVATED = -3;
    public static final int ERROR_NOT_RFMON = -7;
    public static final int ERROR_PERM_DENIED = -8;
    public static final int ERROR_RFMON_NOTSUP = -6;
    public static final int IN = 1;
    public static final int INOUT = 0;
    public static final String JNETPCAP_LIBRARY_NAME = "jnetpcap";
    public static final String LIBRARY = "jnetpcap";
    private static boolean LIBRARY_LOAD_STATUS;
    @Deprecated
    public static final int LOOP_INFINATE = -1;
    public static final int LOOP_INFINITE = -1;
    @Deprecated
    public static final int LOOP_INTERRUPTED = -2;
    public static final int MODE_BLOCKING = 0;
    public static final int MODE_NON_BLOCKING = 1;
    public static final int MODE_NON_PROMISCUOUS = 0;
    public static final int MODE_PROMISCUOUS = 1;
    public static final int NEXT_EX_EOF = -2;
    public static final int NEXT_EX_NOT_OK = -1;
    public static final int NEXT_EX_OK = 1;
    public static final int NEXT_EX_TIMEDOUT = 0;
    @Deprecated
    public static final int NOT_OK = -1;
    public static final int OK = 0;
    public static final int OUT = 2;
    public static final String PCAP_LIBRARY = "pcap";
    public static final boolean PCAP100_LOAD_STATUS;
    public static final String PCAP100_WRAPPER = "jnetpcap-pcap100";
    public static final int WARNING = 1;
    public static final int WARNING_PROMISC_NOT_SUP = 2;
    public static final String WINPCAP_LIBRARY = "wpcap";
    private volatile long physical;
    private int id = -1;

    @Deprecated
    public static int compile(int n, int n2, PcapBpfProgram pcapBpfProgram, String string, int n3, int n4) {
        return Pcap.compileNoPcap(n, n2, pcapBpfProgram, string, n3, n4);
    }

    @LibraryMember(value={"pcap_compile_nopcap"})
    public static native int compileNoPcap(int var0, int var1, PcapBpfProgram var2, String var3, int var4, int var5);

    @LibraryMember(value={"pcap_create"})
    public static native Pcap create(String var0, StringBuilder var1);

    @LibraryMember(value={"pcap_datalink_name_to_val"})
    public static native int datalinkNameToVal(String var0);

    @LibraryMember(value={"pcap_datalink_val_to_description"})
    public static native String datalinkValToDescription(int var0);

    @LibraryMember(value={"pcap_datalink_val_to_name"})
    public static native String datalinkValToName(int var0);

    @LibraryMember(value={"pcap_findalldevs"})
    public static native int findAllDevs(List<PcapIf> var0, StringBuilder var1);

    @Deprecated
    public static void freeAllDevs(List<PcapIf> list, byte[] byArray) {
        if (list == null || byArray == null) {
            throw new NullPointerException();
        }
        list.clear();
    }

    public static void freeAllDevs(List<PcapIf> list, StringBuilder stringBuilder) {
        if (list == null || stringBuilder == null) {
            throw new NullPointerException();
        }
        stringBuilder.setLength(0);
        list.clear();
    }

    @LibraryMember(value={"pcap_freecode"})
    public static native void freecode(PcapBpfProgram var0);

    public static Error getPcap080LoadError() {
        JNILibrary jNILibrary = JNILibrary.loadLibrary("jnetpcap");
        return jNILibrary.errors.isEmpty() ? null : jNILibrary.errors.get(0);
    }

    @LibraryInitializer
    private static native void initIDs();

    @Deprecated
    public static native boolean isCreateSupported();

    @LibraryMember(value={"pcap_inject"})
    public static native boolean isInjectSupported();

    public static boolean isLoaded(String string, Class<?> ... classArray) {
        return JNILibrary.findSymbol(Pcap.class, string, classArray).isLoaded();
    }

    public static boolean isPcap080Loaded() {
        return LIBRARY_LOAD_STATUS;
    }

    public static boolean isPcap100Loaded() {
        return PCAP100_LOAD_STATUS;
    }

    @LibraryMember(value={"pcap_sendpacket"})
    public static native boolean isSendPacketSupported();

    @LibraryMember(value={"pcap_lib_version"})
    public static native String libVersion();

    @LibraryMember(value={"pcap_lookupdev"})
    public static native String lookupDev(StringBuilder var0);

    @LibraryMember(value={"pcap_lookupnet"})
    public static native int lookupNet(String var0, JNumber var1, JNumber var2, StringBuilder var3);

    @Deprecated
    @LibraryMember(value={"pcap_lookupnet"})
    public static native int lookupNet(String var0, PcapInteger var1, PcapInteger var2, StringBuilder var3);

    @LibraryMember(value={"pcap_open_dead"})
    public static native Pcap openDead(int var0, int var1);

    @LibraryMember(value={"pcap_open_live"})
    public static native Pcap openLive(String var0, int var1, int var2, int var3, StringBuilder var4);

    @LibraryMember(value={"pcap_open_offline"})
    public static native Pcap openOffline(String var0, StringBuilder var1);

    @LibraryMember(value={"pcap_activate"})
    public native int activate();

    @LibraryMember(value={"pcap_breakloop"})
    public native void breakloop();

    @LibraryMember(value={"pcap_can_set_rfmon"})
    public native int canSetRfmon();

    protected native void checkIsActive() throws PcapClosedException;

    @LibraryMember(value={"pcap_close"})
    public native void close();

    @LibraryMember(value={"pcap_compile"})
    public native int compile(PcapBpfProgram var1, String var2, int var3, int var4);

    @LibraryMember(value={"pcap_datalink"})
    public native int datalink();

    private int datalinkToId() {
        if (this.id == -1) {
            this.id = JRegistry.mapDLTToId(this.datalink());
            this.id = this.id == -1 ? 1 : this.id;
        }
        return this.id;
    }

    public <T> int dispatch(int n, ByteBufferHandler<T> byteBufferHandler, T t) {
        return this.dispatch(n, byteBufferHandler, t, new PcapHeader(JMemory.Type.POINTER));
    }

    private native <T> int dispatch(int var1, ByteBufferHandler<T> var2, T var3, PcapHeader var4);

    public <T> int dispatch(int n, int n2, JPacketHandler<T> jPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, n2, jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    private native <T> int dispatch(int var1, int var2, JPacketHandler<T> var3, T var4, JPacket var5, JPacket.State var6, PcapHeader var7, JScanner var8);

    public <T> int dispatch(int n, int n2, PcapPacketHandler<T> pcapPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, n2, pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    private native <T> int dispatch(int var1, int var2, PcapPacketHandler<T> var3, T var4, JPacket var5, JPacket.State var6, PcapHeader var7, JScanner var8);

    public <T> int dispatch(int n, JBufferHandler<T> jBufferHandler, T t) {
        return this.dispatch(n, jBufferHandler, t, new PcapHeader(JMemory.Type.POINTER), new JBuffer(JMemory.Type.POINTER));
    }

    private native <T> int dispatch(int var1, JBufferHandler<T> var2, T var3, PcapHeader var4, JBuffer var5);

    public <T> int dispatch(int n, JPacketHandler<T> jPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, this.datalinkToId(), jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    public <T> int dispatch(int n, JPacketHandler<T> jPacketHandler, T t, JScanner jScanner) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, this.datalinkToId(), jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), jScanner);
    }

    public native int dispatch(int var1, PcapDumper var2);

    @Deprecated
    public native <T> int dispatch(int var1, PcapHandler<T> var2, T var3);

    @Deprecated
    public <T> int dispatch(int n, PcapPacketHandler<T> pcapPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, this.datalinkToId(), pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    @Deprecated
    public <T> int dispatch(int n, PcapPacketHandler<T> pcapPacketHandler, T t, JScanner jScanner) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.dispatch(n, this.datalinkToId(), pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), jScanner);
    }

    @LibraryMember(value={"pcap_dump_open"})
    public native PcapDumper dumpOpen(String var1);

    protected void finalize() {
        if (this.physical != 0L) {
            this.close();
        }
    }

    @LibraryMember(value={"pcap_geterr"})
    public native String getErr();

    @LibraryMember(value={"pcap_getnonblock"})
    public native int getNonBlock(StringBuilder var1);

    public int inject(byte[] byArray) {
        this.checkIsActive();
        int n = byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.put(byArray);
        return this.injectPrivate(byteBuffer, 0, n);
    }

    public int inject(byte[] byArray, int n, int n2) {
        this.checkIsActive();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.put(byArray, n, n2);
        return this.injectPrivate(byteBuffer, 0, n2);
    }

    public int inject(ByteBuffer byteBuffer) {
        this.checkIsActive();
        if (!byteBuffer.isDirect()) {
            int n = byteBuffer.limit() - byteBuffer.position();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
            byteBuffer2.put(byteBuffer);
            return this.injectPrivate(byteBuffer2, 0, n);
        }
        return this.injectPrivate(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    @LibraryMember(value={"pcap_inject"})
    public native int inject(JBuffer var1, int var2, int var3);

    @LibraryMember(value={"pcap_inject"})
    private native int injectPrivate(ByteBuffer var1, int var2, int var3);

    @LibraryMember(value={"pcap_is_swapped"})
    public native int isSwapped();

    public <T> int loop(int n, ByteBufferHandler<T> byteBufferHandler, T t) {
        return this.loop(n, byteBufferHandler, t, new PcapHeader(JMemory.Type.POINTER));
    }

    @LibraryMember(value={"pcap_loop"})
    private native <T> int loop(int var1, ByteBufferHandler<T> var2, T var3, PcapHeader var4);

    public <T> int loop(int n, final int n2, final JPacketHandler<T> jPacketHandler, T t) {
        return this.loop(n, new JBufferHandler<T>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, T t) {
                PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
                pcapPacket.scan(n2);
                jPacketHandler.nextPacket(pcapPacket, t);
            }
        }, t);
    }

    @LibraryMember(value={"pcap_loop"})
    private native <T> int loop(int var1, int var2, JPacketHandler<T> var3, T var4, JPacket var5, JPacket.State var6, PcapHeader var7, JScanner var8);

    public <T> int loop(int n, final int n2, final PcapPacketHandler<T> pcapPacketHandler, T t) {
        return this.loop(n, new JBufferHandler<T>(){

            @Override
            public void nextPacket(PcapHeader pcapHeader, JBuffer jBuffer, T t) {
                PcapPacket pcapPacket = new PcapPacket(pcapHeader, jBuffer);
                pcapPacket.scan(n2);
                pcapPacketHandler.nextPacket(pcapPacket, t);
            }
        }, t);
    }

    @LibraryMember(value={"pcap_loop"})
    private native <T> int loop(int var1, int var2, PcapPacketHandler<T> var3, T var4, JPacket var5, JPacket.State var6, PcapHeader var7, JScanner var8);

    public <T> int loop(int n, JBufferHandler<T> jBufferHandler, T t) {
        return this.loop(n, jBufferHandler, t, new PcapHeader(JMemory.Type.POINTER), new JBuffer(JMemory.Type.POINTER));
    }

    @LibraryMember(value={"pcap_loop"})
    private native <T> int loop(int var1, JBufferHandler<T> var2, T var3, PcapHeader var4, JBuffer var5);

    public <T> int loop(int n, JPacketHandler<T> jPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, this.datalinkToId(), jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    public <T> int loop(int n, JPacketHandler<T> jPacketHandler, T t, JScanner jScanner) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, this.datalinkToId(), jPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), jScanner);
    }

    @LibraryMember(value={"pcap_loop"})
    public native int loop(int var1, PcapDumper var2);

    @Deprecated
    @LibraryMember(value={"pcap_loop"})
    public native <T> int loop(int var1, PcapHandler<T> var2, T var3);

    public <T> int loop(int n, PcapPacketHandler<T> pcapPacketHandler, T t) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, this.datalinkToId(), pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), JScanner.getThreadLocal());
    }

    public <T> int loop(int n, PcapPacketHandler<T> pcapPacketHandler, T t, JScanner jScanner) {
        PcapPacket pcapPacket = new PcapPacket(JMemory.Type.POINTER);
        return this.loop(n, this.datalinkToId(), pcapPacketHandler, t, (JPacket)pcapPacket, pcapPacket.getState(), pcapPacket.getCaptureHeader(), jScanner);
    }

    @LibraryMember(value={"pcap_major_version"})
    public native int majorVersion();

    @LibraryMember(value={"pcap_minor_version"})
    public native int minorVersion();

    @LibraryMember(value={"pcap_next"})
    public native JBuffer next(PcapHeader var1, JBuffer var2);

    @Deprecated
    @LibraryMember(value={"pcap_next"})
    public native ByteBuffer next(PcapPktHdr var1);

    @LibraryMember(value={"pcap_next_ex"})
    public native int nextEx(PcapHeader var1, JBuffer var2);

    public synchronized int nextEx(PcapPacket pcapPacket) {
        int n = this.nextEx(pcapPacket.getCaptureHeader(), pcapPacket);
        pcapPacket.scan(this.datalinkToId());
        return n;
    }

    @Deprecated
    public native int nextEx(PcapPktHdr var1, PcapPktBuffer var2);

    public int sendPacket(byte[] byArray) {
        this.checkIsActive();
        int n = byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n);
        byteBuffer.put(byArray);
        return this.sendPacketPrivate(byteBuffer, 0, n);
    }

    public int sendPacket(byte[] byArray, int n, int n2) {
        this.checkIsActive();
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n2);
        byteBuffer.put(byArray, n, n2);
        return this.sendPacketPrivate(byteBuffer, 0, n2);
    }

    public int sendPacket(ByteBuffer byteBuffer) {
        this.checkIsActive();
        if (!byteBuffer.isDirect()) {
            int n = byteBuffer.limit() - byteBuffer.position();
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
            byteBuffer2.put(byteBuffer);
            return this.sendPacketPrivate(byteBuffer2, 0, n);
        }
        return this.sendPacketPrivate(byteBuffer, byteBuffer.position(), byteBuffer.limit() - byteBuffer.position());
    }

    @LibraryMember(value={"pcap_sendpacket"})
    public native int sendPacket(JBuffer var1);

    private native int sendPacketPrivate(ByteBuffer var1, int var2, int var3);

    @LibraryMember(value={"pcap_set_buffer_size"})
    public native int setBufferSize(long var1);

    @LibraryMember(value={"pcap_set_datalink"})
    public native int setDatalink(int var1);

    public int setDirection(Direction direction) {
        return this.setDirection(direction.ordinal());
    }

    @LibraryMember(value={"pcap_setdirection"})
    public native int setDirection(int var1);

    @LibraryMember(value={"pcap_setfilter"})
    public native int setFilter(PcapBpfProgram var1);

    @LibraryMember(value={"pcap_setnonblock"})
    public native int setNonBlock(int var1, StringBuilder var2);

    @LibraryMember(value={"pcap_set_promisc"})
    public native int setPromisc(int var1);

    @LibraryMember(value={"pcap_set_rfmon"})
    public native int setRfmon(int var1);

    @LibraryMember(value={"pcap_set_snaplen"})
    public native int setSnaplen(int var1);

    @LibraryMember(value={"pcap_set_timeout"})
    public native int setTimeout(int var1);

    @LibraryMember(value={"pcap_snapshot"})
    public native int snapshot();

    @LibraryMember(value={"pcap_stats"})
    public native int stats(PcapStat var1);

    public String toString() {
        this.checkIsActive();
        return Pcap.libVersion();
    }

    static {
        JNILibrary.register(Pcap.class);
        LIBRARY_LOAD_STATUS = JNILibrary.loadLibrary("jnetpcap").isLoaded();
        PCAP100_LOAD_STATUS = JNILibrary.loadLibrary(PCAP100_WRAPPER).isLoaded();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        IN,
        INOUT,
        OUT;

    }
}

