/*
 * Decompiled with CFR 0.152.
 */
package com.slytechs.library;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JNIFormat {
    public static String mangleClassPath(Class<?> clazz) {
        return clazz.getCanonicalName().replace('.', '_');
    }

    public static String mangleClassSig(Class<?> clazz) {
        return clazz.getCanonicalName().replace('.', '/');
    }

    public static String mangleTypes(Class<?>[] classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> clazz : classArray) {
            stringBuilder.append(JNIFormat.jniType(clazz));
        }
        return stringBuilder.toString();
    }

    public static String jniParenSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(JNIFormat.jniType(clazz));
        }
        stringBuilder.append(")");
        stringBuilder.append(JNIFormat.jniType(method.getReturnType()));
        return stringBuilder.toString();
    }

    public static String jniSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> clazz : method.getParameterTypes()) {
            stringBuilder.append(JNIFormat.jniType(clazz));
        }
        return stringBuilder.toString();
    }

    public static String jniMethodName(Class<?> clazz, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Java_");
        stringBuilder.append(JNIFormat.mangleClassPath(clazz));
        stringBuilder.append("_");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static String jniMethodName(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        Class<?> clazz = method.getDeclaringClass();
        stringBuilder.append("Java_");
        stringBuilder.append(JNIFormat.mangleClassPath(clazz));
        stringBuilder.append("_");
        stringBuilder.append(method.getName());
        return stringBuilder.toString();
    }

    public static String jniMethodNameAndSignature(Method method) {
        StringBuilder stringBuilder = new StringBuilder();
        Class<?> clazz = method.getDeclaringClass();
        stringBuilder.append("Java_");
        stringBuilder.append(JNIFormat.mangle(clazz.getCanonicalName()));
        stringBuilder.append("_");
        stringBuilder.append(JNIFormat.mangle(method.getName()));
        stringBuilder.append("__");
        stringBuilder.append(JNIFormat.mangle(JNIFormat.jniSignature(method)));
        return stringBuilder.toString();
    }

    public static String mangle(String string) {
        String string2 = string;
        string2 = string2.replaceAll("_", "_1");
        string2 = string2.replaceAll(";", "_2");
        string2 = string2.replaceAll("\\[", "_3");
        string2 = string2.replaceAll("\\.", "_");
        string2 = string2.replaceAll("/", "_");
        return string2;
    }

    public static String jniType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            return "[" + JNIFormat.jniType(clazz2);
        }
        return "L" + clazz.getCanonicalName().replace('.', '/') + ";";
    }

    public static String javaParameters(Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(JNIFormat.javaTypes(classArray));
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public static String javaTypes(Class<?> ... classArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Class<?> clazz : classArray) {
            if (stringBuilder.length() > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(clazz.getSimpleName());
        }
        return stringBuilder.toString();
    }

    public static String javaModifiers(int n) {
        return Modifier.toString(n);
    }

    public static String javaModifiers(Method method) {
        return Modifier.toString(method.getModifiers());
    }

    public static String javaModifiers(Field field) {
        return Modifier.toString(field.getModifiers());
    }

    public static String javaModifiers(Class<?> clazz) {
        return Modifier.toString(clazz.getModifiers());
    }

    public static String jType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return "void";
            }
            if (clazz == Boolean.TYPE) {
                return "jboolean";
            }
            if (clazz == Byte.TYPE) {
                return "jbyte";
            }
            if (clazz == Character.TYPE) {
                return "jchar";
            }
            if (clazz == Short.TYPE) {
                return "jshort";
            }
            if (clazz == Integer.TYPE) {
                return "jint";
            }
            if (clazz == Long.TYPE) {
                return "jlong";
            }
            if (clazz == Float.TYPE) {
                return "jfloat";
            }
            if (clazz == Double.TYPE) {
                return "jdouble";
            }
        }
        if (clazz == String.class) {
            return "jstring";
        }
        if (clazz == Class.class) {
            return "jclass";
        }
        if (clazz.isArray()) {
            return "jarray";
        }
        return "jobject";
    }
}

