<p align="center">
  <a href="https://github.com/assemble/assemble">
    <img height="250" width="250" src="https://raw.githubusercontent.com/assemble/assemble-core/master/docs/logo.png">
  </a>
</p>

# {%= name %} 

{%= badge("npm") %} {%= badge('downloads') %} {%= ifExists(["test", "test.js"], badge('travis')) %} {%= badge('gitter') %} 

Built on top of [base][] and [templates][], assemble-core is used in [assemble][] to provide the baseline features and API necessary for rendering templates, working with the file system, and running tasks. 

Implementors and hackers can use assemble-core to create rich and powerful build tooling, project scaffolding systems, documentation generators, or even your completely custom static site generators. 

<details>
<summary><strong>Table of contents</strong></summary>
<!-- toc -->
</details>

## What can I do with assemble-core?

Create your own:

- blog engine
- project generator / scaffolder
- e-book development framework
- build system
- landing page generator
- documentation generator
- front-end UI framework
- rapid prototyping framework
- static site generator
- web application

## Install

**NPM**

## Install

{%= include("install-npm", {save: true}) %}

**yarn**

Install with [yarn](yarnpkg.com):

```sh
$ yarn add assemble-core && yarn upgrade
```

## Usage

```js
var assemble = require('{%= name %}');
var app = assemble();
```

## Examples

**view collections**

Create a custom view collection:

```js
var app = assemble();
app.create('pages');
```

Now you can add pages with `app.page()` or `app.pages()`:

```js
app.page('home.hbs', {content: 'this is the home page!'});
```

**render**

Render a view:

```js
var app = assemble();

var view = app.view('foo', {content: 'Hi, my name is <%= name %>'});

app.render(view, { name: 'Brian' }, function(err, res) {
  console.log(res.content);
  //=> 'Hi, my name is Brian'
});
```

Render a view from a collection:

```js
var app = assemble();
app.create('pages');

app.page('foo', {content: 'Hi, my name is <%= name %>'})
  .set('data.name', 'Brian')
  .render(function (err, res) {
    console.log(res.content);
    //=> 'Hi, my name is Brian'
  });
```

## API
{%= apidocs("index.js") %}


***

### File System API

Assemble has the following methods for working with the file system:

- [src](#src)
- [dest](#dest)
- [copy](#copy)
- [symlink](#symlink)

Assemble v0.6.0 has full [vinyl-fs][] support, so any [gulp][] plugin should work with assemble.

#### .src

Use one or more glob patterns or filepaths to specify source files.

**Params**

* `glob` **{String|Array}**: Glob patterns or file paths to source files.
* `options` **{Object}**: Options or locals to merge into the context and/or pass to `src` plugins

**Example**

```js
app.src('src/*.hbs', {layout: 'default'});
```

#### .dest

Specify the destination to use for processed files.

**Params**

* `dest` **{String|Function}**: File path or custom renaming function.
* `options` **{Object}**: Options and locals to pass to `dest` plugins

**Example**

```js
app.dest('dist/');
```

#### .copy

Copy files from A to B, where `A` is any pattern that would be valid in [app.src](#src) and `B` is the destination directory.

**Params**

* `patterns` **{String|Array}**: One or more file paths or glob patterns for the source files to copy.
* `dest` **{String|Function}**: Desination directory.
* `returns` **{Stream}**: The stream is returned, so you can continue processing files if necessary.

**Example**

```js
app.copy('assets/**', 'dist/');
```

#### .symlink

Glob patterns or paths for symlinks.

**Params**

* `glob` **{String|Array}**

**Example**

```js
app.symlink('src/**');
```

***

### Task API

Assemble has the following methods for running tasks and controlling workflows:

- [task](#task)  
- [build](#build)  
- [watch](#watch)  

#### .task

Define a task. Tasks are functions that are stored on a `tasks` object, allowing them to be called later by the [build](#build) method. (the [CLI][assemble-cli] calls [build](#build) to run tasks)

**Params**

* `name` **{String}**: Task name
* `fn` **{Function}**: function that is called when the task is run.

**Example**

```js
app.task('default', function() {
  return app.src('templates/*.hbs')
    .pipe(app.dest('dist/'));
});
```

#### .build

Run one or more tasks.

**Params**

* `tasks` **{Array|String}**: Task name or array of task names.
* `cb` **{Function}**: callback function that exposes `err`

**Example**

```js
app.build(['foo', 'bar'], function(err) {
  if (err) console.error('ERROR:', err);
});
```

#### .watch

Watch files, run one or more tasks when a watched file changes.

**Params**

* `glob` **{String|Array}**: Filepaths or glob patterns.
* `tasks` **{Array}**: Task(s) to watch.

**Example**

```js
app.task('watch', function() {
  app.watch('docs/*.md', ['docs']);
});
```

## FAQ

**How does assemble-core differ from [assemble][]?**

**feature** | **assemble-core** | **assemble** | **notes** 
--- | :---: | :---: | ---
front-matter parsing | No | Yes | use [assemble][] or use [parser-front-matter][] as an `.onLoad` middleware. 
CLI | No | Yes | Create your own CLI experience, or use [assemble][] 
Built-in template collections | No | Yes | Use `.create()` to add collections 
Built-in template engine | No | Yes | [assemble][] ships with [engine-handlebars][]. Use `.engine()` to register any [consolidate][]-compatible template engine. 

## Toolkit suite

assemble-core is a standalone application that was created using applications and plugins from the [toolkit suite](https://github.com/node-toolkit/getting-started):

**Building blocks**

- [base][]: framework for rapidly creating high quality node.js applications, using plugins like building blocks.
- [templates][]: used to create the foundation of assemble-core's API, along with support for managing template collections, template engines and template rendering support

**Plugins**

- [assemble-fs][]: adds support for using [gulp][] plugins and working with the file system
- [assemble-streams][]: adds support for pushing views and view collections into a [vinyl][] stream
- [base-task][]: adds flow control methods

## About
### Related projects
Assemble is built on top of these great projects:
{%= related(verb.related.list) %}  

### Tests
{%= include("tests") %}

### Contributing
{%= include("contributing") %}

If Assemble doesn't do what you need, [please let us know](../../issues).

### Release History
{%= increaseHeadings(increaseHeadings(changelog('changelog.md', {
  changelogFooter: true,
  stripHeading: true, 
  repo: repo
}))) %}

### Authors

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

**Brian Woodward**

* [github/doowb](https://github.com/doowb)
* [twitter/doowb](http://twitter.com/doowb)

### License
{%= copyright() %}
{%= license %}

***

{%= include("footer") %}

{%= reflinks(verb.reflinks) %}
