---
myst:
  html_meta:
    "description lang=en": |
      Top-level documentation for pydata-sphinx theme, with links to the rest
      of the site..
html_theme.sidebar_secondary.remove: true
---

# The ASReview LAB documentation

Join the movement towards fast, open, and transparent systematic reviews.

```{gallery-grid}
:grid-columns: 1 2 2 3

- header: "{fas}`bolt;pst-color-primary` Fast screening"
  content: "Powerful and customizable AI to screen large volumes of text, achieving up to 95% time savings."
  link: "https://doi.org/10.1038/s42256-020-00287-7"
- header: "{fas}`eye;pst-color-primary` Transparant and reproducible"
  content: "Engage in a fully open and transparent interaction with the AI where you are the oracle."
  link: "https://osf.io/preprints/psyarxiv/g93zf"
- header: "{fas}`circle-half-stroke;pst-color-primary` Customizable interface"
  content: "Customize your review environment, offering light and dark modes, adding tags and AI-aided highlighting."
- header: "{fas}`lightbulb;pst-color-primary` Simulate and validate"
  content: "Utilize the robust simulation tool to predict AI performance and validate your, another reviewer’s or LLM findings"
  link: "lab/simulation_overview.html"
- header: "{fas}`microchip;pst-color-primary` CLI and API"
  content: "Access extensive command-line options and API integration for advanced customization."
  link: "technical/index.html"
- header: "{fas}`users;pst-color-primary` Community"
  content: "Join a community where open discussions and shared insights contribute to the continuous improvement."
  link: "https://github.com/asreview/asreview/discussions"
```

## ASReview LAB explained in 2 minutes

```{youtube} k-a2SCq-LtA
:align: center
```

## ASReview LAB user guide


```{toctree}
:maxdepth: 2

lab/index
```

## ASReview LAB Server

All documentation for the ASReview LAB Server

```{toctree}
:maxdepth: 2

server/index
```

## Technical guide

All resources for them who develop ASReview and the API

```{toctree}
:maxdepth: 2

technical/index
```
