# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

import datetime

try:
    from asreview import __version__ as asreview_version

    print(asreview_version)
except Exception:
    asreview_version = ""

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys

sys.path.insert(0, os.path.abspath(os.path.join("..", "..")))
sys.path.insert(0, os.path.abspath(".."))


# -- Mock
autodoc_mock_imports = []

suppress_warnings = [
    "ref.ref",  # workaround for https://github.com/sphinx-doc/sphinx/issues/11212
]


# -- Project information -----------------------------------------------------

# add current year
year = datetime.datetime.now().year

project = "ASReview LAB"
copyright = "{}, ASReview LAB developers".format(year)
author = "ASReview LAB developers, Utrecht University"

# The short X.Y version
version = asreview_version
# The full version, including alpha/beta/rc tags
release = asreview_version


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
    "sphinx.ext.autodoc",
    "sphinx.ext.intersphinx",
    "sphinx.ext.autosummary",
    "sphinx.ext.viewcode",
    "sphinx.ext.napoleon",
    "sphinx.ext.autosectionlabel",
    "sphinx_reredirects",
    "sphinxcontrib.youtube",
    "nbsphinx",
    "IPython.sphinxext.ipython_console_highlighting",
    "myst_parser",
    "sphinx_design",
    # custom extentions
    "_extension.gallery_directive",
]
autosectionlabel_prefix_document = True

# generate autosummary even if no references
autosummary_generate = True

# Add any paths that contain templates here, relative to this directory.
templates_path = ["_templates"]

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
source_suffix = [".rst", ".md"]

# The master toctree document.
master_doc = "index"

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
# language = None

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = ["build", "**.ipynb_checkpoints"]

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = None

# -- MyST options ------------------------------------------------------------

# This allows us to use ::: to denote directives, useful for admonitions
myst_enable_extensions = ["colon_fence", "substitution"]
myst_heading_anchors = 2
myst_substitutions = {"rtd": "[Read the Docs](https://readthedocs.org/)"}


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = "pydata_sphinx_theme"

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#

html_favicon = "favicon.ico"

html_theme_options = {
    "external_links": [
        {
            "url": "https://github.com/asreview/asreview/releases",
            "name": "Changelog",
        },
        {
            "url": "https://asreview.ai",
            "name": "asreview.ai",
        },
        {
            "url": "https://asreview.nl/donate",
            "name": "Donate to ASReview",
        },
        {
            "url": "https://www.uu.nl/en/research/ai-labs/disc-ai-lab",
            "name": "AI-Lab at Utrecht University",
        },
    ],
    "logo": {
        "image_light": "https://raw.githubusercontent.com/asreview/asreview-artwork/master/LogoASReview/SVG/GitHub_Repo_Card_Transparent.svg",
        "image_dark": "https://raw.githubusercontent.com/asreview/asreview-artwork/master/LogoASReview/SVG/GitHub_Repo_Card_Transparent.svg",
    },
    "announcement": "ASReview LAB 2.0 is now available! <a href='https://asreview.nl/download'>Try it out</a>.",
    "use_edit_page_button": True,
    "navbar_align": "left",
    "navbar_center": ["navbar-nav"],
    "footer_start": ["copyright"],
    "footer_center": ["sphinx-version"],
    "icon_links": [
        {
            "name": "GitHub",
            "url": "https://github.com/asreview/asreview",
            "icon": "fa-brands fa-github",
        },
        {
            "name": "PyPI",
            "url": "https://pypi.org/project/asreview/",
            "icon": "fa-custom fa-pypi",
        },
    ],
}

html_context = {
    "github_user": "asreview",
    "github_repo": "asreview",
    "github_version": "main",
    "doc_path": "docs/source",
}

# html_static_path = ["_static"]


# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
# html_css_files = ["css/asreviewtheme.css"]

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = "ASReviewdoc"

# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    # 'papersize': 'letterpaper',
    # The font size ('10pt', '11pt' or '12pt').
    #
    # 'pointsize': '10pt',
    # Additional stuff for the LaTeX preamble.
    #
    # 'preamble': '',
    # Latex figure (float) alignment
    #
    # 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
    (master_doc, "ASReview.tex", "ASReview Software Documentation", author, "manual"),
]


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [(master_doc, "asreview", "ASReview Software Documentation", [author], 1)]


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
    (
        master_doc,
        "ASReview",
        "ASReview Software Documentation",
        author,
        "ASReview",
        "ASReview Software Documentation.",
        "Miscellaneous",
    ),
]


# -- Options for Epub output -------------------------------------------------

# Bibliographic Dublin Core info.
epub_title = project

# The unique identifier of the text. This can be a ISBN number
# or the project homepage.
#
# epub_identifier = ''

# A unique identification for the text.
#
# epub_uid = ''

# A list of files that should not be packed into the epub file.
epub_exclude_files = ["search.html"]


# -- Extension configuration -------------------------------------------------

# -- Options for intersphinx extension ---------------------------------------

# Example configuration for intersphinx: refer to the Python standard library.
intersphinx_mapping = {
    "python": ("https://docs.python.org/3", None),
    "numpy": ("https://numpy.org/doc/stable/", None),
    "pandas": ("https://pandas.pydata.org/docs/", None),
}

# -- Napoleon options --------------------------------------------------------

napoleon_google_docstring = False
napoleon_numpy_docstring = True
napoleon_include_private_with_doc = False
napoleon_include_special_with_doc = False
napoleon_use_admonition_for_examples = False
napoleon_use_admonition_for_notes = True
napoleon_use_admonition_for_references = True
napoleon_use_ivar = True
napoleon_use_param = True
napoleon_use_rtype = False

# -- Redirects ---------------------------------------------------------------

redirects = {
    "intro/zen": "https://asreview.ai/blog/the-zen-of-elas/",
    "intro/datasets": "../data.html",
    "intro/faq": "https://github.com/asreview/asreview/discussions",
    "intro/vocabulary": "../about.html",
    "lab/overview_lab": "../about.html",
    "lab/launch": "../start.html",
    "lab/oracle": "../about.html",
    "lab/exploration": "../screening.html#screening-in-validation-mode",
    "lab/simulation": "../simulation_overview.html",
    "features/settings": "../screening.html",
    "features/pre_screening": "../project_create.html",
    "features/screening": "../screening.html",
    "features/post_screening": "../progress.html",
    "extensions/overview_extensions": "../products.html",
    "extensions/extension_covid19": "../products.html",
    "extensions/extension_visualization": "../products.html",
    "extensions/extension_wordcloud": "../products.html",
    "API/extension_dev": "../extensions_dev.html",
    "API/reference": "../reference.html",
    "guides/activelearning": "https://asreview.nl/blog/active-learning-explained/",
    "guides/simulation_study_results": "https://asreview.nl/research/",
    "guides/sim_overview": "../simulation_overview.html",
}

# -- Options for linkcheck ----------------------------------------------------

linkcheck_ignore = [r"http://localhost:\d+[/]*.*"]

linkcheck_allowed_redirects = {
    r"https://doi.org/.*": r"https://.*",
    r"https://asreview.ai/.*": r"https://asreview.nl/.*",
}
