import * as React from "react";

import { useTheme } from "@mui/material";

export const WordMark = (props) => {
  const theme = useTheme();

  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 653.77 162.94"
      {...props}
    >
      <rect
        width={226}
        height={157}
        x={427.77}
        rx={28.24}
        ry={28.24}
        style={{
          fill: "#ffcc07",
        }}
      />
      <path
        d="M43.47 103.96H16.79l-5.4 21.65H.1l25.57-96.82h8.92l25.56 96.82H48.91l-5.45-21.65Zm-3.04-13L30.25 48.6h-.19L19.88 90.96h20.55ZM70.5 102.16c5.6 6.35 12.26 9.56 19.99 9.65 9.14-.18 13.78-4.67 13.91-13.49.07-7.22-2.99-11.56-9.17-13.03-2.83-.53-5.94-1.13-9.31-1.79-6.05-1.37-10.65-4.45-13.8-9.24-3.25-4.92-4.87-10.9-4.87-17.95 0-8.46 2.04-15.29 6.12-20.47 3.95-5.14 9.56-7.75 16.82-7.84 8.74.27 16.34 3.6 22.8 10l-5.94 12.05c-5.28-4.79-11.09-7.27-17.43-7.45-3.28 0-6.02 1.13-8.21 3.39-2.28 2.35-3.46 5.85-3.52 10.5 0 2.79.79 5.32 2.36 7.58 1.58 2.3 4.1 3.9 7.58 4.79 1.93.44 4.57.95 7.91 1.53 6.59 1.24 11.47 4.5 14.62 9.77 3.12 5.19 4.68 11.21 4.68 18.08-.35 18.52-8.58 27.92-24.68 28.18-10.41 0-19.36-4.4-26.85-13.22l6.99-11.04ZM128.15 28.79h27.48c5.86 0 10.64 2.12 14.34 6.38 4.46 4.83 6.78 11.71 6.97 20.65-.13 13.15-4.66 22.09-13.58 26.83l16.28 42.96h-12.65l-14.56-41.38h-13.64v41.38h-10.65V28.79Zm10.65 42.44h16.15c4-.09 7-1.69 9-4.79 1.97-2.89 2.95-6.44 2.95-10.65-.06-5.06-1.24-8.72-3.53-10.99-1.81-2-4.42-3-7.83-3h-16.73v29.43ZM197.02 96.39c0 5.54 1.16 9.75 3.48 12.63 2.16 2.92 4.99 4.39 8.5 4.39 4.09 0 7.74-2.24 10.96-6.71l7.29 8.57c-5.11 7.52-11.12 11.24-18.04 11.15-2.64 0-5.21-.53-7.72-1.59-1.25-.57-2.48-1.35-3.66-2.32-1.25-.84-2.43-1.88-3.52-3.12-2.12-2.57-3.84-6.15-5.16-10.76-1.45-4.43-2.17-10.18-2.17-17.27s.63-12.48 1.88-17c1.25-4.6 2.86-8.23 4.82-10.89 1.99-2.7 4.23-4.65 6.7-5.84 2.44-1.2 4.85-1.79 7.23-1.79 5.72.09 10.56 2.68 14.52 7.77 4.02 5.18 6.06 12.31 6.12 21.39v11.41h-31.23Zm21.18-11.41c-.13-5.38-1.18-9.45-3.14-12.21-1.93-2.63-4.42-3.94-7.45-3.94s-5.51 1.31-7.45 3.94c-1.9 2.76-2.95 6.83-3.14 12.21h21.18ZM232.74 56.69h10.65L255.15 105h.19l11.71-48.31h10.7l-18.36 68.93h-8.29l-18.36-68.93ZM285.44 28.79h10.05V42.6h-10.05V28.79Zm0 27.89h10.05v68.94h-10.05V56.69ZM317.15 96.39c0 5.54 1.16 9.75 3.48 12.63 2.16 2.92 4.99 4.39 8.5 4.39 4.09 0 7.74-2.24 10.96-6.71l7.29 8.57c-5.11 7.52-11.12 11.24-18.04 11.15-2.64 0-5.21-.53-7.72-1.59-1.25-.57-2.48-1.35-3.66-2.32-1.25-.84-2.43-1.88-3.52-3.12-2.12-2.57-3.84-6.15-5.16-10.76-1.45-4.43-2.17-10.18-2.17-17.27s.63-12.48 1.88-17c1.25-4.6 2.86-8.23 4.82-10.89 1.99-2.7 4.23-4.65 6.7-5.84 2.44-1.2 4.85-1.79 7.23-1.79 5.72.09 10.56 2.68 14.52 7.77 4.02 5.18 6.06 12.31 6.12 21.39v11.41h-31.23Zm21.18-11.41c-.13-5.38-1.18-9.45-3.14-12.21-1.93-2.63-4.42-3.94-7.45-3.94s-5.51 1.31-7.45 3.94c-1.9 2.76-2.95 6.83-3.14 12.21h21.18ZM389.82 77.32h-.19l-10.47 48.29h-8.88l-16.02-68.93h10.66l9.6 48.35h.19l11.39-48.35h7.28l11.38 48.35h.19l9.55-48.35h10.66l-15.97 68.93h-8.92L389.8 77.32Z"
        style={{
          fill: theme.palette.mode === "dark" ? "#FFF" : "#000",
        }}
      />
      <path d="M459.6 28.79h10.65v83.02h34.28v13.81H459.6V28.79ZM552.37 103.96h-26.68l-5.4 21.65H509l25.57-96.82h8.92l25.57 96.82h-11.24l-5.45-21.65Zm-3.04-13L539.15 48.6h-.19l-10.18 42.36h20.55ZM578.54 28.79h27.26c6.92.09 12.11 2.48 15.58 7.17 3.51 4.74 5.26 11 5.26 18.79.07 3.98-.62 7.79-2.07 11.42-.74 1.73-1.8 3.36-3.18 4.91-1.38 1.64-3.09 3.12-5.11 4.45v.27c3.84 1.37 6.74 4.14 8.71 8.3 1.84 4.29 2.76 8.96 2.76 14.01-.06 8.37-1.96 14.99-5.7 19.86-3.7 5.09-8.32 7.64-13.86 7.64h-29.64V28.79Zm10.65 13.01v27.84h15.4c3.89 0 6.76-1.4 8.59-4.21 1.87-2.58 2.8-5.83 2.8-9.75s-.93-7.23-2.8-9.95c-1.83-2.54-4.7-3.85-8.59-3.94h-15.4Zm0 40.84v29.17h16.44c3.96-.09 6.87-1.58 8.7-4.46 1.84-2.84 2.76-6.21 2.76-10.12s-.92-7.41-2.76-10.25c-1.84-2.8-4.74-4.24-8.7-4.33h-16.44Z" />
    </svg>
  );
};
