# Copyright 2019-2022 The ASReview Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""Max sampling while saving prediction probabilities."""

__all__ = ["MaxQuery"]

import numpy as np

from asreview.models.query.base import BaseQueryStrategy


class MaxQuery(BaseQueryStrategy):
    """Maximum query strategy (``max``).

    Choose the most likely samples to be included according to the model.
    """

    name = "max"
    label = "Maximum"

    def query(self, feature_matrix, relevance_scores):
        del feature_matrix
        query_indices = np.argsort(relevance_scores[:, 0])
        return query_indices
