/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.Reader;
import java.sql.SQLException;
import javax.sql.RowSetInternal;
import javax.sql.rowset.WebRowSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.jdbc.rowset.OracleWebRowSet;
import oracle.jdbc.rowset.OracleWebRowSetXmlReader;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderContHandler;
import oracle.jdbc.rowset.OracleWebRowSetXmlReaderDomHandler;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class OracleWebRowSetXmlReaderImpl
implements OracleWebRowSetXmlReader {
    private static final String JAVA_SAXPARSER_PROPERTY = "javax.xml.parsers.SAXParserFactory";
    private static final String JAVA_DOMPARSER_PROPERTY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String ORACLE_JAXP_SAXPARSER_FACTORY = "oracle.xml.jaxp.JXSAXParserFactory";
    private static final String ORACLE_JAXP_DOMPARSER_FACTORY = "oracle.xml.jaxp.JXDocumentBuilderFactory";
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String WEBROWSET_SCHEMA = "http://java.sun.com/xml/ns/jdbc/webrowset.xsd";
    private Document document = null;
    private String parserStr = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Aug_26_18:07:59_PDT_2010";
    public static final boolean TRACE = false;

    OracleWebRowSetXmlReaderImpl() {
    }

    public void readXML(WebRowSet webRowSet, Reader reader) throws SQLException {
        this.parserStr = this.getSystemProperty(JAVA_SAXPARSER_PROPERTY);
        if (this.parserStr != null) {
            this.readXMLSax((OracleWebRowSet)webRowSet, reader);
        } else {
            this.parserStr = this.getSystemProperty(JAVA_DOMPARSER_PROPERTY);
            if (this.parserStr != null) {
                this.readXMLDom((OracleWebRowSet)webRowSet, reader);
            } else {
                throw new SQLException("No valid JAXP parser property specified");
            }
        }
    }

    public void readData(RowSetInternal rowSetInternal) throws SQLException {
    }

    private void readXMLSax(OracleWebRowSet oracleWebRowSet, Reader reader) throws SQLException {
        try {
            InputSource inputSource = new InputSource(reader);
            OracleWebRowSetXmlReaderContHandler oracleWebRowSetXmlReaderContHandler = new OracleWebRowSetXmlReaderContHandler(oracleWebRowSet);
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setValidating(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            sAXParser.setProperty(JAXP_SCHEMA_SOURCE, WEBROWSET_SCHEMA);
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setContentHandler(oracleWebRowSetXmlReaderContHandler);
            xMLReader.parse(inputSource);
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            sAXParseException.printStackTrace();
            throw new SQLException(sAXParseException.getMessage());
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
            throw new SQLException("readXMLSax: SAXNotRecognizedException: " + sAXNotRecognizedException.getMessage());
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new SQLException("readXMLSax: SAXException: " + sAXException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            throw new SQLException("readXMLSax: Parser factory config: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SQLException("readXMLSax: Parser config: " + parserConfigurationException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("readXMLSax: " + exception.getMessage());
        }
    }

    private void readXMLDom(OracleWebRowSet oracleWebRowSet, Reader reader) throws SQLException {
        try {
            InputSource inputSource = new InputSource(reader);
            OracleWebRowSetXmlReaderDomHandler oracleWebRowSetXmlReaderDomHandler = new OracleWebRowSetXmlReaderDomHandler(oracleWebRowSet);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, WEBROWSET_SCHEMA);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            this.document = documentBuilder.parse(inputSource);
            oracleWebRowSetXmlReaderDomHandler.readXMLDocument(this.document);
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            throw new SQLException("readXMLDom: SAXException: " + sAXException.getMessage());
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            factoryConfigurationError.printStackTrace();
            throw new SQLException("readXMLDom: Parser factory config: " + factoryConfigurationError.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            throw new SQLException("readXMLDom: Parser config: " + parserConfigurationException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("readXMLDom: " + exception.getMessage());
        }
    }

    private String getSystemProperty(String string) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            string2 = null;
        }
        return string2;
    }
}

