/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

class SQLStateMapping {
    public static final int SQLEXCEPTION = 0;
    public static final int SQLNONTRANSIENTEXCEPTION = 1;
    public static final int SQLTRANSIENTEXCEPTION = 2;
    public static final int SQLDATAEXCEPTION = 3;
    public static final int SQLFEATURENOTSUPPORTEDEXCEPTION = 4;
    public static final int SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION = 5;
    public static final int SQLINVALIDAUTHORIZATIONSPECEXCEPTION = 6;
    public static final int SQLNONTRANSIENTCONNECTIONEXCEPTION = 7;
    public static final int SQLSYNTAXERROREXCEPTION = 8;
    public static final int SQLTIMEOUTEXCEPTION = 9;
    public static final int SQLTRANSACTIONROLLBACKEXCEPTION = 10;
    public static final int SQLTRANSIENTCONNECTIONEXCEPTION = 11;
    public static final int SQLCLIENTINFOEXCEPTION = 12;
    public static final int SQLRECOVERABLEEXCEPTION = 13;
    int low;
    int high;
    public String sqlState;
    public int exception;
    static final String mappingResource = "errorMap.xml";
    static SQLStateMapping[] all;
    private static final int NUMEBER_OF_MAPPINGS_IN_ERRORMAP_XML = 128;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Aug_26_18:07:59_PDT_2010";
    public static final boolean TRACE = false;

    public SQLStateMapping(int n2, int n3, String string, int n4) {
        this.low = n2;
        this.sqlState = string;
        this.exception = n4;
        this.high = n3;
    }

    public boolean isIncluded(int n2) {
        return this.low <= n2 && n2 <= this.high;
    }

    public SQLException newSQLException(String string, int n2) {
        switch (this.exception) {
            case 0: {
                return new SQLException(string, this.sqlState, n2);
            }
        }
        return new SQLException(string, this.sqlState, n2);
    }

    boolean lessThan(SQLStateMapping sQLStateMapping) {
        if (this.low < sQLStateMapping.low) {
            return this.high < sQLStateMapping.high;
        }
        return this.high <= sQLStateMapping.high;
    }

    public String toString() {
        return super.toString() + "(" + this.low + ", " + this.high + ", " + this.sqlState + ", " + this.exception + ")";
    }

    public static void main(String[] stringArray) throws IOException {
        SQLStateMapping[] sQLStateMappingArray = SQLStateMapping.doGetMappings();
        System.out.println("a\t" + sQLStateMappingArray);
        for (int i2 = 0; i2 < sQLStateMappingArray.length; ++i2) {
            System.out.println("low:\t" + sQLStateMappingArray[i2].low + "\thigh:\t" + sQLStateMappingArray[i2].high + "\tsqlState:\t" + sQLStateMappingArray[i2].sqlState + "\tsqlException:\t" + sQLStateMappingArray[i2].exception);
        }
    }

    static SQLStateMapping[] getMappings() {
        if (all == null) {
            try {
                all = SQLStateMapping.doGetMappings();
            }
            catch (Throwable throwable) {
                all = new SQLStateMapping[0];
            }
        }
        return all;
    }

    static SQLStateMapping[] doGetMappings() throws IOException {
        InputStream inputStream = SQLStateMapping.class.getResourceAsStream(mappingResource);
        ArrayList arrayList = new ArrayList(128);
        SQLStateMapping.load(inputStream, arrayList);
        return arrayList.toArray(new SQLStateMapping[0]);
    }

    static void load(InputStream inputStream, List list) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        Tokenizer tokenizer = new Tokenizer(bufferedReader);
        int n2 = -1;
        int n3 = -1;
        String string2 = null;
        int n4 = -1;
        String string3 = null;
        int n5 = 0;
        block39: while ((string = tokenizer.next()) != null) {
            switch (n5) {
                case 0: {
                    if (!string.equals("<")) continue block39;
                    n5 = 1;
                    continue block39;
                }
                case 1: {
                    if (string.equals("!")) {
                        n5 = 2;
                        continue block39;
                    }
                    if (string.equals("oraErrorSqlStateSqlExceptionMapping")) {
                        n5 = 6;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
                }
                case 2: {
                    if (string.equals("-")) {
                        n5 = 3;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 3: {
                    if (!string.equals("-")) continue block39;
                    n5 = 4;
                    continue block39;
                }
                case 4: {
                    if (string.equals("-")) {
                        n5 = 5;
                        continue block39;
                    }
                    n5 = 3;
                    continue block39;
                }
                case 5: {
                    if (string.equals(">")) {
                        n5 = 1;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 6: {
                    if (string.equals(">")) {
                        n5 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 7: {
                    if (string.equals("<")) {
                        n5 = 8;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"<\".");
                }
                case 8: {
                    if (string.equals("!")) {
                        n5 = 9;
                        continue block39;
                    }
                    if (string.equals("error")) {
                        n5 = 14;
                        continue block39;
                    }
                    if (string.equals("/")) {
                        n5 = 16;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected one of \"!--\", \"error\", \"/\".");
                }
                case 9: {
                    if (string.equals("-")) {
                        n5 = 10;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 10: {
                    if (string.equals("-")) {
                        n5 = 11;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"-\".");
                }
                case 11: {
                    if (!string.equals("-")) continue block39;
                    n5 = 12;
                    continue block39;
                }
                case 12: {
                    if (string.equals("-")) {
                        n5 = 13;
                        continue block39;
                    }
                    n5 = 11;
                    continue block39;
                }
                case 13: {
                    if (string.equals(">")) {
                        n5 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 14: {
                    if (string.equals("/")) {
                        n5 = 15;
                        continue block39;
                    }
                    if (string.equals("oraErrorFrom")) {
                        n5 = 19;
                        continue block39;
                    }
                    if (string.equals("oraErrorTo")) {
                        n5 = 21;
                        continue block39;
                    }
                    if (string.equals("sqlState")) {
                        n5 = 23;
                        continue block39;
                    }
                    if (string.equals("sqlException")) {
                        n5 = 25;
                        continue block39;
                    }
                    if (string.equals("comment")) {
                        n5 = 27;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected one of " + "\"oraErrorFrom\", \"oraErrorTo\", \"sqlState\", " + "\"sqlException\", \"comment\", \"/\".");
                }
                case 15: {
                    if (string.equals(">")) {
                        try {
                            SQLStateMapping.createOne(list, n2, n3, string2, n4, string3);
                        }
                        catch (IOException iOException) {
                            throw new IOException("Invalid error element at line " + tokenizer.lineno + " of errorMap.xml. " + iOException.getMessage());
                        }
                        n2 = -1;
                        n3 = -1;
                        string2 = null;
                        n4 = -1;
                        string3 = null;
                        n5 = 7;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 16: {
                    if (string.equals("oraErrorSqlStateSqlExceptionMapping")) {
                        n5 = 17;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"oraErrorSqlStateSqlExceptionMapping\".");
                }
                case 17: {
                    if (string.equals(">")) {
                        n5 = 18;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \">\".");
                }
                case 18: {
                    continue block39;
                }
                case 19: {
                    if (string.equals("=")) {
                        n5 = 20;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 20: {
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Unexpected value \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected an integer.");
                    }
                    n5 = 14;
                    continue block39;
                }
                case 21: {
                    if (string.equals("=")) {
                        n5 = 22;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 22: {
                    try {
                        n3 = Integer.parseInt(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Unexpected value \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected an integer.");
                    }
                    n5 = 14;
                    continue block39;
                }
                case 23: {
                    if (string.equals("=")) {
                        n5 = 24;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 24: {
                    string2 = string;
                    n5 = 14;
                    continue block39;
                }
                case 25: {
                    if (string.equals("=")) {
                        n5 = 26;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 26: {
                    try {
                        n4 = SQLStateMapping.valueOf(string);
                    }
                    catch (Exception exception) {
                        throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected SQLException" + " subclass name.");
                    }
                    n5 = 14;
                    continue block39;
                }
                case 27: {
                    if (string.equals("=")) {
                        n5 = 28;
                        continue block39;
                    }
                    throw new IOException("Unexpected token \"" + string + "\" at line " + tokenizer.lineno + " of errorMap.xml. Expected \"=\".");
                }
                case 28: {
                    string3 = string;
                    n5 = 14;
                    continue block39;
                }
            }
            throw new IOException("Unknown parser state " + n5 + " at line " + tokenizer.lineno + " of errorMap.xml.");
        }
    }

    private static void createOne(List list, int n2, int n3, String string, int n4, String string2) throws IOException {
        if (n2 == -1) {
            throw new IOException("oraErrorFrom is a required attribute");
        }
        if (n3 == -1) {
            n3 = n2;
        }
        if (string == null || string.length() == 0) {
            throw new IOException("sqlState is a required attribute");
        }
        if (n4 == -1) {
            throw new IOException("sqlException is a required attribute");
        }
        if (string2 == null || string2.length() < 8) {
            throw new IOException("a lengthy comment in required");
        }
        SQLStateMapping sQLStateMapping = new SQLStateMapping(n2, n3, string, n4);
        SQLStateMapping.add(list, sQLStateMapping);
    }

    static void add(List list, SQLStateMapping sQLStateMapping) {
        int n2;
        for (n2 = list.size(); n2 > 0 && !((SQLStateMapping)list.get(n2 - 1)).lessThan(sQLStateMapping); --n2) {
        }
        list.add(n2, sQLStateMapping);
    }

    static int valueOf(String string) throws Exception {
        if (string.equalsIgnoreCase("SQLEXCEPTION")) {
            return 0;
        }
        if (string.equalsIgnoreCase("SQLNONTRANSIENTEXCEPTION")) {
            return 1;
        }
        if (string.equalsIgnoreCase("SQLTRANSIENTEXCEPTION")) {
            return 2;
        }
        if (string.equalsIgnoreCase("SQLDATAEXCEPTION")) {
            return 3;
        }
        if (string.equalsIgnoreCase("SQLFEATURENOTSUPPORTEDEXCEPTION")) {
            return 4;
        }
        if (string.equalsIgnoreCase("SQLINTEGRITYCONSTRAINTVIOLATIONEXCEPTION")) {
            return 5;
        }
        if (string.equalsIgnoreCase("SQLINVALIDAUTHORIZATIONSPECEXCEPTION")) {
            return 6;
        }
        if (string.equalsIgnoreCase("SQLNONTRANSIENTCONNECTIONEXCEPTION")) {
            return 7;
        }
        if (string.equalsIgnoreCase("SQLSYNTAXERROREXCEPTION")) {
            return 8;
        }
        if (string.equalsIgnoreCase("SQLTIMEOUTEXCEPTION")) {
            return 9;
        }
        if (string.equalsIgnoreCase("SQLTRANSACTIONROLLBACKEXCEPTION")) {
            return 10;
        }
        if (string.equalsIgnoreCase("SQLTRANSIENTCONNECTIONEXCEPTION")) {
            return 11;
        }
        if (string.equalsIgnoreCase("SQLCLIENTINFOEXCEPTION")) {
            return 12;
        }
        if (string.equalsIgnoreCase("SQLRECOVERABLEEXCEPTION")) {
            return 13;
        }
        throw new Exception("unexpected exception name: " + string);
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    }

    private static final class Tokenizer {
        int lineno = 1;
        Reader r;
        int c;

        Tokenizer(Reader reader) throws IOException {
            this.r = reader;
            this.c = reader.read();
        }

        String next() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(16);
            boolean bl = true;
            while (this.c != -1) {
                if (this.c == 10) {
                    ++this.lineno;
                }
                if (this.c <= 32 && bl) {
                    this.c = this.r.read();
                    continue;
                }
                if (this.c <= 32 && !bl) {
                    this.c = this.r.read();
                    break;
                }
                if (this.c == 34) {
                    while ((this.c = this.r.read()) != 34) {
                        stringBuffer.append((char)this.c);
                    }
                    this.c = this.r.read();
                    break;
                }
                if (48 <= this.c && this.c <= 57 || 65 <= this.c && this.c <= 90 || 97 <= this.c && this.c <= 122 || this.c == 95) {
                    do {
                        stringBuffer.append((char)this.c);
                    } while (48 <= (this.c = this.r.read()) && this.c <= 57 || 65 <= this.c && this.c <= 90 || 97 <= this.c && this.c <= 122 || this.c == 95);
                    break;
                }
                stringBuffer.append((char)this.c);
                this.c = this.r.read();
                break;
            }
            if (stringBuffer.length() > 0) {
                return stringBuffer.toString();
            }
            return null;
        }
    }
}

