<p align="center">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://github.com/asaxena0824/ScripterAI/blob/main/RSA_6.png?raw=true" height="140">
    <img alt="logo" src="https://github.com/asaxena0824/ScripterAI/blob/main/RSA_6.png?raw=true" height="140">
  </picture>
  <h1 align="center">ScripterAI</h1>
  <p align="center">AI tool for Generating Code for Gaming Engines. <br> Search AI-Generated Code for free from GPT-4, Copilot, etc.</p>
</p>


<div align="center">

[![Join Discord Server](https://img.shields.io/badge/discord%20community-join-blue)](https://discord.gg/Km4rKqWav6)
  <a href="https://www.haddock.ai/signup" alt="haddock.ai">
        <img src="https://img.shields.io/badge/website-sign_up-blue" /></a>
  [![Twitter](https://img.shields.io/twitter/url/https/twitter.com/FM.svg?style=social&label=@haddockai)](https://twitter.com/haddockai)
</div><p>


# ScripterAI

<i> This doc is not complete. Please bear with us as we work toward making it completed.</i> <br>
For tracking the number of scripts available in the library, please refer to the `Script Count` [section](https://github.com/asaxena0824/ScripterAI#script-count). <br>

## Introduction

ScripterAI is an AI powered build tool for gaming engines such as Roblox, Unreal, Minecraft (Forge), and Unity. Its primary purpose is to generate simple scripts using natural language prompts. We offer free access to GPT-4, Copilot, and a code-engineered version of ChatGPT (plus). We welcome any other suggestions or ideas you may have too. We also record high-quality generations and provide them in a free searchable and easy to use library.

## Best Practices

* Refer to our [YouTube](https://www.youtube.com/@haddockai) for getting a better idea of the tool usage. 
* Remember to be specific and clear in your prompt, you do not need to specify that you're requesting something for ```Roblox``` as ScripterAI is trained to work with Roblox by default.
  * ```Script for a Zombie spawner in Roblox``` ❌
  * ```Make a zombie spwnwer``` or ```create a zombie spawner``` or ```script for a zombie spawner``` :white_check_mark:
* ScripterAI is not capable of creating entire games by commands. For example, commands like ```create this RP game for me``` will probably not work. Instead, you must be specific about what you want, if it is a ```quest``` then you can ask the ScripterAI to create functions for that ```quest```.
* To make multiple functions work through a single prompt, remember to separate the instructions by a `delimiter`.
* Do not overengineer the prompt, keep it simple but specific. 

## Main Pro Tips

* Use tick mark to indicate that the scripts are correct. We use your feedback as training data for fine-tuning the ScripterAI model.
* You can ask ScripterAI to add comments to the code by appending 'add comments to code' to your request.
* If you are not satisfied with the results, you can keep clicking on 'Generate' again to regenerate the response until you get what you're looking for. Albeit, each click will be a considered a call.

## Haddock Library 
* Library Mode is a free search engine for scripts generated by ScripterAI. Although there is a limited number of scripts accessible at this point, the library is expected to grow by 30-50 scripts every week. If a script has not been generated by ScripterAI, it will clearly say so at the top.

### Script Count 
(Last Updated: 10/11/2023)

**Roblox**

* Total Scripts Generated: **24213**
* Scripts Available in the Library: **6231**

**Unity**

* Total Scripts Generated: **7294**
* Scripts Available in the Library: **3023**

**Unreal**

* Total Scripts Generated: **1450**
* Scripts Available in the Library: **1203**

**Minecraft (forge)**

* Total Scripts Generated: **1102**
* Scripts Available in the Library: **950**

#### Why are not all scripts available? 

* Any script generated using ScripterAI or any other mode is not automatically added in the library. We moderate and sign off on each script to make it visible in the library. We're adding an average of 100 scripts per week. This can be tracked using our above Script Count.

## Tech Stack 

* `Node.js` for backend.
* `MongoDB` for data storage.
* `Bootstrap` and `Angular` for frontend.
* `CodeMirror` for the code editor. 


