Document Summary:
## Named Entities and Roles:

**People:**

* **Jose Castro:** Undocumented alien employee of Hoffman Plastic Compounds, Inc. who was laid off after supporting a union-organizing campaign. He was found eligible for backpay by the NLRB but the Supreme Court reversed this decision.
* **Ryan D. McCortney:** Attorney representing petitioner Hoffman Plastic Compounds, Inc.
* **Maurice Baskin:** Attorney representing petitioner Hoffman Plastic Compounds, Inc.
* **Paul R. Q. Wolfson:** Attorney representing respondent National Labor Relations Board (NLRB).
* **Solicitor General Olson:** Attorney representing respondent NLRB.
* **Deputy Solicitor General Wallace:** Attorney representing respondent NLRB.
* **Arthur F. Rosenfeld:** Attorney representing respondent NLRB.
* **John H. Ferguson:** Attorney representing respondent NLRB.
* **Norton J. Come:** Attorney representing respondent NLRB.
* **John Emad Arbab:** Attorney representing respondent NLRB.
* **Ann Elizabeth Reesman:** Attorney for amicus curiae Equal Employment Advisory Council.
* **Daniel V. Yager:** Attorney for amicus curiae Equal Employment Advisory Council.
* **Eliot Spitzer:** Attorney General of New York, representing amicus curiae State of New York.
* **Caitlin J. Halligan:** Solicitor General of New York, representing amicus curiae State of New York.
* **Daniel Smirlock:** Deputy Solicitor General of New York, representing amicus curiae State of New York.
* **M. Patricia Smith:** Assistant Attorney General of New York, representing amicus curiae State of New York.
* **Seth Kupperberg:** Assistant Attorney General of New York, representing amicus curiae State of New York.
* **Janet Napolitano:** Attorney General of Arizona, representing amicus curiae State of Arizona.
* **Bill Lockyer:** Attorney General of California, representing amicus curiae State of California.
* **Earl I. Anzai:** Attorney General of Hawaii, representing amicus curiae State of Hawaii.
* **Thomas F. Reilly:** Attorney General of Massachusetts, representing amicus curiae State of Massachusetts.
* **Darrell V. McGraw, Jr.:** Attorney General of West Virginia, representing amicus curiae State of West Virginia.
* **Anabelle Rodriguez:** Attorney General of Puerto Rico, representing amicus curiae State of Puerto Rico.
* **Craig Goldblatt:** Attorney for amicus curiae American Civil Liberties Union Foundation.
* **Lucas Guttentag:** Attorney for amicus curiae American Civil Liberties Union Foundation.
* **Jonathan P. Hiatt:** Attorney for amicus curiae American Federation of Labor and Congress of Industrial Organizations.
* **James B. Coppess:** Attorney for amicus curiae American Federation of Labor and Congress of Industrial Organizations.
* **Michael Rubin:** Attorney for amicus curiae American Federation of Labor and Congress of Industrial Organizations.
* **David A. Schulz:** Attorney for amicus curiae Employers and Employer Organizations.
* **Jeffrey H. Drichta:** Attorney for amicus curiae Employers and Employer Organizations.
* **Michael J. Wishnie:** Attorney for amicus curiae Employers and Employer Organizations.
* **Rebecca Smith:** Attorney for amicus curiae National Employment Law Project.
* **James Reif:** Attorney for amicus curiae National Employment Law Project.
* **James Williams:** Attorney for amicus curiae National Employment Law Project.

**Organizations:**

* **Hoffman Plastic Compounds, Inc.:** Petitioner in the case, a company that custom-formulates chemical compounds. 
* **National Labor Relations Board (NLRB):** Respondent in the case, a federal agency responsible for enforcing the National Labor Relations Act (NLRA).
* **United Rubber, Cork, Linoleum, and Plastic Workers of America, AFL–CIO:** A labor union that began an organizing campaign at Hoffman's plant.
* **Equal Employment Advisory Council:** Amicus curiae in the case, an organization advocating for employers.
* **State of New York:** Amicus curiae in the case, represented by the Attorney General of New York.
* **State of Arizona:** Amicus curiae in the case, represented by the Attorney General of Arizona.
* **State of California:** Amicus curiae in the case, represented by the Attorney General of California.
* **State of Hawaii:** Amicus curiae in the case, represented by the Attorney General of Hawaii.
* **State of Massachusetts:** Amicus curiae in the case, represented by the Attorney General of Massachusetts.
* **State of West Virginia:** Amicus curiae in the case, represented by the Attorney General of West Virginia.
* **State of Puerto Rico:** Amicus curiae in the case, represented by the Attorney General of Puerto Rico.
* **American Civil Liberties Union Foundation:** Amicus curiae in the case, an organization advocating for civil liberties.
* **American Federation of Labor and Congress of Industrial Organizations (AFL-CIO):** Amicus curiae in the case, a large federation of labor unions.
* **Employers and Employer Organizations:** Amicus curiae in the case, a group representing employers.
* **National Employment Law Project:** Amicus curiae in the case, an organization advocating for workers' rights.
* **Immigration and Naturalization Service (INS):** A former agency within the Department of Justice responsible for enforcing immigration laws.

**Locations:**

* **United States:** The country where the events of the case took place.
* **Mexico:** Country of origin for Jose Castro.
* **Texas:** State where Castro's friend, whose birth certificate he used, was born.
* **California:** State where Castro obtained a fraudulent driver's license and Social Security card.

**Significance:**

* **Hoffman Plastic Compounds, Inc.:** Accused of violating the NLRA by laying off employees who supported a union organizing campaign.
* **National Labor Relations Board (NLRB):**  Found Hoffman guilty of violating the NLRA and initially ordered backpay for Castro.
* **Jose Castro:**  An undocumented alien who was found ineligible for backpay by the Supreme Court due to his illegal status.
* **United Rubber, Cork, Linoleum, and Plastic Workers of America, AFL–CIO:**  The union that Castro supported, which triggered the dispute over NLRA violations. 
* **Immigration and Naturalization Service (INS):**  The agency whose policies the Supreme Court found to be in conflict with the NLRB's backpay order. 

This is a case that highlights the complex interaction between different areas of federal law and the potential for conflicting legal principles.
## Direct Quotations with Speakers and Context:

**1. From Justice Rehnquist's Majority Opinion:**

* **"We are unable to conclude that Congress intended to compel employers to retain persons in their employ regardless of their unlawful conduct,—to invest those who go on strike with an immunity from discharge for acts of trespass or violence against the employer’s property, which they would not have enjoyed had they remained at work.”** (Quoting **Fansteel**,  306 U. S. at 255) - This quote is used in the context of explaining why the Court has consistently set aside awards of reinstatement or backpay to employees found guilty of serious illegal conduct.

* **"It is sufficient for this case to observe that the Board has not been commissioned to effectuate the policies of the Labor Relations Act so single-mindedly that it may wholly ignore other and equally important [c]ongressional objectives.”** (Quoting **Southern S. S. Co.**, 316 U. S. at 47) - This quote is used in the context of explaining the limits of the Board’s discretion in selecting remedies for NLRA violations, particularly when those remedies might conflict with other congressional objectives.

* **“For whatever reason,” Congress had not “made it a separate criminal offense” for employers to hire an illegal alien, or for an illegal alien “to accept employment after entering this country illegally.”** (Quoting **Sure-Tan**, 467 U. S. at 892–893) - This quote is used in the context of the Court's reasoning that the application of the NLRA to undocumented workers would not necessarily conflict with the terms of the INA at the time.

* **“In devising remedies for unfair labor practices, the Board is obliged to take into account another ‘equally important Congressional objective’ ”** (Quoting **Southern S. S. Co.**, supra at 47) - This quote is used in the context of explaining why the Board’s authority to select remedies is limited by federal immigration policy, as expressed in the INA.

* **“[T]he employees must be deemed ‘unavailable’ for work (and the accrual of backpay therefore tolled) during any period when they were not lawfully entitled to be present and employed in the United States.”** (Quoting **Sure-Tan**, 467 U. S. at 903) - This quote is used in the context of explaining why the Court believes the Board is limited in its ability to award backpay to undocumented aliens.

* **“This threat of contempt sanctions... provides a significant deterrent against future violations of the [NLRA].”** (Quoting **Sure-Tan**, 467 U. S. at 904, n. 13) - This quote is used in the context of explaining why the Court believes the Board’s traditional remedies, like cease and desist orders, are sufficient to deter future violations of the NLRA, even without backpay.

* **“As we concluded in Sure-Tan, “in light of the practical workings of the immigration laws,” any “perceived deficienc[y] in the NLRA’s existing remedial arsenal” must be “addressed by congressional action,” not the courts.”** (Quoting **Sure-Tan**, 467 U. S. at 904) - This quote is used in the context of concluding that any perceived shortcomings in the NLRA's remedies must be addressed by Congress, not the courts.

**2. From Justice Breyer's Dissenting Opinion:**

* **“We would leave helpless the very persons who most need protection from exploitative employer practices.”** (Quoting **NLRB v. Apollo Tire Co.**, 604 F. 2d 1180, 1184 (CA9 1979) (Kennedy, J., concurring opinion)) - This quote is used by Justice Breyer to argue that the Board’s backpay award serves to protect undocumented workers from exploitative employer practices and therefore should be upheld.

* **“IRCA does not “undermine or diminish in any way labor protections in existing law, or . . . limit the powers of federal or state labor relations boards . . . to remedy unfair practices committed against undocumented employees.”** (Quoting H. R. Rep. No. 99–682, at 58) - This quote is used by Justice Breyer to argue that the immigration statute does not explicitly strip the Board of its remedial authority.

* **“[L]anguage of an opinion” must be “read in context” and not “parsed” like a statute.** (Quoting **Reiter v. Sonotone Corp.**, 442 U. S. 330, 341 (1979)) - This quote is used by Justice Breyer to explain why he believes the Court should not take Sure-Tan’s language regarding backpay out of context and apply it to the current case.

* **“[T]he board has not examined this issue in detail.”** (Quoting the Government at Oral Argument) - This quote is used by Justice Breyer to point out the Government's acknowledgement that the Board has not thoroughly examined the tension between backpay awards and IRCA. 

* **“The board has acted “with a discriminating awareness of the consequences of its action” on the immigration laws.** (Quoting **Burlington Truck Lines, Inc. v. United States**, 371 U. S. 156, 174 (1962)) - This quote is used by Justice Breyer to argue that the Board has carefully considered the consequences of its actions on the immigration laws.

* **“[T]he Solicitor General’s statements represent agency’s position.”** (Quoting **United States v. Mead Corp.**, 533 U. S. 218, 258–259, n. 6 (2001) (Scalia, J., dissenting)) - This quote is used by Justice Breyer to argue that the Attorney General's support for the Board's order carries significant weight.

* **“Agency’s position with respect to its regulation during litigation “arrives with some authority.”** (Quoting **Jean v. Nelson**, 472 U. S. 846, 856, and n. 3 (1985)) - This quote is used by Justice Breyer to support his claim that the Attorney General's position on the Board's order carries weight.
## Numerical Data from the Hoffman Plastic Compounds, Inc. v. National Labor Relations Board Case:

**Dates:**

* **09-26-03 12:56:30:** Date and time the document was generated.
* **May 1988:** Date Jose Castro was hired by Hoffman.
* **December 1988:** Date the United Rubber, Cork, Linoleum, and Plastic Workers of America began a union-organizing campaign at Hoffman's plant.
* **January 1989:** Date Castro and other employees were laid off by Hoffman.
* **January 1992:** Date the National Labor Relations Board (NLRB) found that Hoffman unlawfully laid off four employees, including Castro.
* **June 1993:** Date the parties proceeded to a compliance hearing before an Administrative Law Judge (ALJ) to determine the amount of backpay owed.
* **September 1998:** Date the NLRB reversed the ALJ's decision and determined that Castro was entitled to backpay.
* **October 2001:** Term of the Supreme Court when the case was argued. 
* **January 15, 2002:** Date the case was argued before the Supreme Court.
* **March 27, 2002:** Date the Supreme Court decided the case. 

**Statistics and Measurements:**

* **$U33:** Unit associated with the document (possibly a document ID).
* **41⁄2 years:** Duration of the backpay award period.
* **$66,951:** Amount of backpay awarded to Castro by the NLRB.
* **306 N. L. R. B. 100:**  NLRB decision number.
* **314 N. L. R. B. 683:** ALJ decision number.
* **326 N. L. R. B. 1060:** NLRB decision number reversing the ALJ.
* **208 F. 3d 229:**  Court of Appeals case number. 
* **237 F. 3d 639:**  Court of Appeals case number (en banc). 
* **533 U. S. 976:** Supreme Court case number. 

**Other:**

* **1986:** Year IRCA was enacted.
* **1984:** Year Sure-Tan, Inc. v. NLRB was decided.
* **467 U. S. 883:**  Supreme Court case number for Sure-Tan, Inc. v. NLRB.
* **510 U. S. 317:** Supreme Court case number for ABF Freight System, Inc. v. NLRB. 

**Note:** It's important to recognize that the document does not explicitly identify all numerical data as "statistics" or "measurements." This list includes all numerical information present in the document, allowing for further analysis and interpretation.
## Key Terms and Concepts from the Hoffman Plastic Compounds, Inc. v. National Labor Relations Board Case:

**1. National Labor Relations Act (NLRA)**: A federal law enacted in 1935 that protects employees' rights to organize, bargain collectively, and engage in other concerted activities for the purpose of collective bargaining.

**2. National Labor Relations Board (NLRB)**: An independent federal agency created by the NLRA to administer and enforce the law. It investigates and adjudicates labor disputes, and issues decisions and orders to remedy unfair labor practices.

**3. Backpay**: A remedy ordered by the NLRB for employees who have been illegally discharged or discriminated against, requiring the employer to pay wages for the time the employee was wrongfully denied employment.

**4. Immigration Reform and Control Act of 1986 (IRCA)**: A comprehensive federal law that reformed the U.S. immigration system and made it unlawful for employers to knowingly hire undocumented workers.

**5. Undocumented Alien**: A person living in a country without legal permission to do so. In this case, this refers to someone who is not legally authorized to work in the United States.

**6. Sure-Tan, Inc. v. NLRB**: A 1984 Supreme Court case that determined that the NLRB could not order the reinstatement of undocumented workers who were not authorized to reenter the United States. This case also limited backpay to periods when the undocumented worker was lawfully entitled to be present and employed in the United States.

**7. ABF Freight System, Inc. v. NLRB**: A 1994 Supreme Court case that ruled that the NLRB could award backpay to an employee who lied under oath during a compliance proceeding. This case distinguished the Board’s authority to punish for misconduct that was not directly related to the underlying employment relationship.

**8. Remedy**: A legal course of action designed to correct an injustice or violation of the law. In this case, the remedies discussed are those available to employees who have been unlawfully discriminated against in violation of the NLRA.

**9. Employer Verification System**: A requirement under IRCA that employers verify the identity and employment authorization of all new hires using specific documentation.

**10. Mitigation of Damages**: A legal principle that requires a person who has suffered harm to take reasonable steps to minimize the extent of their loss.

**11. Contempt of Court**: A violation of a court order. The NLRB can seek contempt proceedings against employers who fail to comply with its orders.

**12. Punitive Remedy**: A remedy designed to punish a wrongdoer, rather than simply compensate for the harm caused.

**13. Statutory Prohibition**: A specific restriction imposed by a law.

**14. Deference**: Respect and weight given to an agency's interpretation of a statute it is charged with administering.

**15. Dicta**: Statements made in a judicial opinion that are not essential to the decision but may be persuasive in future cases.

**16. Perverse Incentive**: An economic or legal factor that encourages behavior that is contrary to a stated goal or objective.

**17. Magnetic Force**: A metaphor used to describe the attractive force that draws people to a particular place or situation.

**18. Borderline Case**: A case that falls close to the dividing line between two possible interpretations of the law.

**19. Agency Interpretation**: An interpretation of a law made by the agency responsible for administering the law.

**20. Chevron U. S. A. Inc. v. Natural Resources Defense Council, Inc.**: A 1984 Supreme Court case that established a two-part test for courts to use in reviewing agency interpretations of statutes. The test requires courts to defer to the agency's interpretation if it is reasonable and if Congress has not spoken directly to the issue.

**21. Reasonableness**: A test for determining whether an action is justified and appropriate in the circumstances.

**22. Independent View**: An interpretation of the law made by a court, rather than an agency.
Here are the references to external sources with available citation information from the document:

**Cases:**

* **Southern S. S. Co. v. NLRB, 316 U. S. 31 (1942)**
* **NLRB v. Seven-Up Bottling Co. of Miami, Inc., 344 U. S. 344 (1953)**
* **NLRB v. Fansteel Metallurgical Corp., 306 U. S. 240 (1939)**
* **NLRB v. Bildisco & Bildisco, 465 U. S. 513 (1984)**
* **Sure-Tan, Inc. v. NLRB, 467 U. S. 883 (1984)**
* **Connell Constr. Co. v. Plumbers, 421 U. S. 616 (1975)**
* **Carpenters v. NLRB, 357 U. S. 93 (1958)**
* **De Canas v. Bica, 424 U. S. 351 (1976)**
* **ABF Freight System, Inc. v. NLRB, 510 U. S. 317 (1994)**
* **Precision Window Mfg. v. NLRB, 963 F. 2d 1105 (CA8 1992)**
* **NLRB v. Commonwealth Foods, Inc., 506 F. 2d 1065 (CA4 1974)**
* **Burlington Truck Lines, Inc. v. United States, 371 U. S. 156 (1962)**
* **Del Rey Tortilleria, Inc. v. NLRB, 976 F. 2d 1115 (CA7 1992)**
* **NLRB v. A. P. R. A. Fuel Oil Buyers Group, Inc., 134 F. 3d 50 (CA2 1997)**
* **Local 512, Warehouse and Office Workers’ Union v. NLRB, 795 F. 2d 705 (CA9 1986)**
* **NLRB v. Transportation Management Corp., 462 U. S. 393 (1983)**
* **NLRB v. Gissel Packing Co., 395 U. S. 575 (1969)**
* **NLRB v. J. H. Rutter-Rex Mfg. Co., 396 U. S. 258 (1969)**
* **Golden State Bottling Co. v. NLRB, 414 U. S. 168 (1973)**
* **EEOC v. Waffle House, Inc., 534 U. S. 279 (2002)**
* **Albemarle Paper Co. v. Moody, 422 U. S. 405 (1975)**
* **INS v. National Center for Immigrants’ Rights, Inc., 502 U. S. 183 (1991)**
* **NLRB v. Apollo Tire Co., 604 F. 2d 1180 (CA9 1979)**
* **Patel v. Quality Inn South, 846 F. 2d 700 (CA11 1988)**
* **Peterson v. Neme, 222 Va. 477, 281 S. E. 2d 869 (1981)**
* **Arteaga v. Literski, 83 Wis. 2d 128, 265 N. W. 2d 148 (1978)**
* **NLRB v. Warren Co., 350 U. S. 107 (1955)**
* **Republic Steel Corp. v. NLRB, 311 U. S. 7 (1940)**
* **United States v. Mead Corp., 533 U. S. 218 (2001)**
* **Jean v. Nelson, 472 U. S. 846 (1985)**
* **Chevron U. S. A. Inc. v. Natural Resources Defense Council, Inc., 467 U. S. 837 (1984)**

**Statutes:**

* **National Labor Relations Act (NLRA), 49 Stat. 452, as added, 61 Stat. 140, 29 U. S. C. § 158(a)(3)**
* **Immigration Reform and Control Act of 1986 (IRCA), § 101(a)(1), 100 Stat. 3360, 8 U. S. C. § 1324a**
* **Immigration and Nationality Act (INA), 66 Stat. 163, as amended, 8 U. S. C. § 1101 et seq.**
* **8 U. S. C. § 1324a(a)(1)**
* **8 U. S. C. § 1324a(a)(2)**
* **8 U. S. C. § 1324a(b)**
* **8 U. S. C. § 1324a(e)(4)(A)**
* **8 U. S. C. § 1324a(f)(1)**
* **8 U. S. C. § 1324a(h)(3)**
* **8 U. S. C. § 1324c(a)**
* **18 U. S. C. § 1546(b)**
* **18 U. S. C. § 1621**
* **8 CFR § 274a (2001)**

**Other Sources:**

* **H. R. Rep. No. 99–682, pt. 1 (1986)** 
* **General Accounting Office, Garment Industry: Efforts to Address the Prevalence and Conditions of Sweatshops (GAO/HEHS–95–29, Nov. 1994)**
* **Memorandum GC 87–8 from Office of General Counsel, NLRB, The Impact of the Immigration Reform and Control Act of 1986 on Board Remedies for Undocumented Discriminatees, 1987 WL 109409 (Oct. 27, 1988)**
* **Memorandum GC 98–15 from Office of General Counsel, NLRB, Reinstatement and Backpay Remedies for Discriminatees Who May Be Undocumented Aliens In Light of Recent Board and Court Precedent, 1998 WL 1806350 (Dec. 4, 1998)**
* **Memorandum GC 88–9 from Office of General Counsel, NLRB, Reinstatement and Backpay Remedies for Discriminatees Who Are “Undocumented Aliens,” 1988 WL 236182 (Sept. 1, 1988)**

This list includes the full citations for cases and statutes, as well as the relevant information for the other sources, such as the year, title, and identifying number (e.g., "H. R. Rep. No. 99–682").
