/*
 *  cparams.c
 *  artoolkitX
 *
 *  This file is part of artoolkitX.
 *
 *  artoolkitX is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  artoolkitX is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with artoolkitX.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  As a special exception, the copyright holders of this library give you
 *  permission to link this library with independent modules to produce an
 *  executable, regardless of the license terms of these independent modules, and to
 *  copy and distribute the resulting executable under terms of your choice,
 *  provided that you also meet, for each linked independent module, the terms and
 *  conditions of the license of that module. An independent module is a module
 *  which is neither derived from nor based on this library. If you modify this
 *  library, you may extend this exception to your version of the library, but you
 *  are not obligated to do so. If you do not wish to do so, delete this exception
 *  statement from your version.
 *
 *  Copyright 2018 Realmax, Inc.
 *  Copyright 2015 Daqri, LLC.
 *  Copyright 2012-2015 ARToolworks, Inc.
 *
 *  Author(s): Philip Lamb
 *
 */


#include "cparams.h"

#if TARGET_OS_IOS

// 35 x 176 bytes = 6160 bytes.
// Produced quickly with: hexdump -e '"    " 16/1 "0x%02x, " "\n" '

const unsigned char camera_para_iPhone[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x86, 0x70, 0x7b, 0xaf, 0x20, 0x02, 0x2f, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x88, 0x91, 0x40, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x86, 0x6f, 0x02, 0x23, 0x68, 0x61, 0x3f, 0x40, 0x6d, 0x87, 0x11, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb8, 0x44, 0xb5, 0x60, 0x00, 0x00, 0x00, 
    0xbf, 0xdc, 0x9f, 0x70, 0xc0, 0x00, 0x00, 0x00, 0xbf, 0x71, 0x19, 0x71, 0x40, 0x00, 0x00, 0x00, 
    0x3f, 0x87, 0x8b, 0x98, 0x00, 0x00, 0x00, 0x00, 0x40, 0x86, 0x10, 0xb0, 0xe0, 0x00, 0x00, 0x00, 
    0x40, 0x86, 0x0f, 0x3d, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x74, 0x88, 0x91, 0x40, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x87, 0x11, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x77, 0x64, 0xe8, 0x49, 0xc5, 0x31 } ;


const unsigned char camera_para_iPod_touch_4G_front[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x96, 0xc8, 0xc0, 0x84, 0x8d, 0x0b, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0x90, 0xb9, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x7d, 0x1c, 0x00, 0x46, 0x40, 0x80, 0x40, 0x6f, 0x17, 0xed, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xd1, 0x1e, 0x45, 0xc0, 0x00, 0x00, 0x00, 
    0xbf, 0xeb, 0x04, 0x09, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x3e, 0x20, 0xe5, 0x40, 0x00, 0x00, 0x00, 
    0xbf, 0x51, 0xd5, 0xb8, 0x40, 0x00, 0x00, 0x00, 0x40, 0x83, 0x2e, 0x11, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x14, 0xed, 0x80, 0x00, 0x00, 0x00, 0x40, 0x73, 0x90, 0xb9, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x6f, 0x17, 0xed, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x54, 0xef, 0xaa, 0x78, 0x98, 0xee } ;
const unsigned char camera_para_iPod_touch_4G_rear_640x480[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x88, 0x6c, 0x85, 0xb7, 0xba, 0x70, 0x06, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x2c, 0xb3, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x88, 0x48, 0x53, 0x16, 0x86, 0x69, 0xfa, 0x40, 0x6c, 0xc6, 0x30, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xa6, 0xb4, 0x16, 0x60, 0x00, 0x00, 0x00, 
    0xbf, 0xb4, 0xeb, 0x32, 0x40, 0x00, 0x00, 0x00, 0xbf, 0x70, 0x88, 0x12, 0xa0, 0x00, 0x00, 0x00, 
    0x3f, 0x19, 0xf9, 0x96, 0x40, 0x00, 0x00, 0x00, 0x40, 0x88, 0x22, 0xe3, 0x80, 0x00, 0x00, 0x00, 
    0x40, 0x87, 0xff, 0x1e, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x2c, 0xb3, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x6c, 0xc6, 0x30, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x9f, 0x86, 0x9c, 0x21, 0x68, 0xc5 } ;
const unsigned char camera_para_iPod_touch_4G_rear_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0xb0, 0x9e, 0x86, 0x38, 0x7a, 0x31, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x02, 0xab, 0x80, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x92, 0x9e, 0x91, 0x58, 0x7e, 0x3a, 0x5f, 0x40, 0x74, 0xd8, 0x75, 0x40, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xaa, 0x95, 0x65, 0x00, 0x00, 0x00, 0x00, 
    0xbf, 0xb1, 0x6a, 0x8b, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x81, 0x0c, 0xf1, 0xe0, 0x00, 0x00, 0x00, 
    0xbf, 0x5c, 0xaf, 0xa8, 0x20, 0x00, 0x00, 0x00, 0x40, 0x92, 0x30, 0xb2, 0x20, 0x00, 0x00, 0x00, 
    0x40, 0x92, 0x1f, 0x20, 0x80, 0x00, 0x00, 0x00, 0x40, 0x84, 0x02, 0xab, 0x80, 0x00, 0x00, 0x00, 
    0x40, 0x74, 0xd8, 0x75, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x24, 0xf9, 0xbb, 0x2a, 0x35, 0xed } ;
const unsigned char camera_para_iPad_2_front[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x66, 0xac, 0xd7, 0x25, 0x8f, 0x99, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x68, 0xe5, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x4f, 0xa2, 0x19, 0x7d, 0xef, 0xd5, 0x40, 0x6d, 0x35, 0x39, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x98, 0xf9, 0xb7, 0xc0, 0x00, 0x00, 0x00, 
    0xbf, 0xba, 0x30, 0x80, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0x42, 0xfe, 0x87, 0xc0, 0x00, 0x00, 0x00, 
    0xbf, 0x75, 0x03, 0x5f, 0x20, 0x00, 0x00, 0x00, 0x40, 0x83, 0x83, 0x85, 0x60, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x6c, 0x58, 0x60, 0x00, 0x00, 0x00, 0x40, 0x74, 0x68, 0xe5, 0xe0, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x35, 0x39, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x17, 0xca, 0x00, 0x19, 0x9c, 0x7d } ;
const unsigned char camera_para_iPad_2_rear_640x480[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x88, 0xe3, 0xbc, 0x20, 0x43, 0x78, 0x02, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x75, 0x44, 0xca, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x88, 0xb6, 0xee, 0x81, 0xf4, 0x89, 0xc0, 0x40, 0x6e, 0x1a, 0xc5, 0x80, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x8f, 0x10, 0xfa, 0xc0, 0x00, 0x00, 0x00, 
    0x3f, 0xb0, 0x1f, 0xdd, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x4f, 0xca, 0x82, 0x00, 0x00, 0x00, 0x00, 
    0x3f, 0x60, 0x5b, 0x8d, 0x60, 0x00, 0x00, 0x00, 0x40, 0x88, 0xcf, 0x52, 0xa0, 0x00, 0x00, 0x00, 
    0x40, 0x88, 0xa2, 0xa9, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x75, 0x44, 0xca, 0xc0, 0x00, 0x00, 0x00, 
    0x40, 0x6e, 0x1a, 0xc5, 0x80, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xe5, 0xc1, 0xb0, 0x10, 0x2b, 0x6a } ;
const unsigned char camera_para_iPad_2_rear_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x93, 0x7f, 0x3d, 0xbb, 0x77, 0xf8, 0x1d, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x74, 0xf0, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x93, 0x5c, 0xcd, 0x68, 0xb9, 0x11, 0x03, 0x40, 0x76, 0xdf, 0x56, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0xaa, 0x6a, 0x59, 0x60, 0x00, 0x00, 0x00, 
    0x3f, 0xda, 0x1e, 0xc9, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x71, 0x70, 0xbc, 0xa0, 0x00, 0x00, 0x00, 
    0xbf, 0x6d, 0xa8, 0x84, 0x00, 0x00, 0x00, 0x00, 0x40, 0x92, 0xa6, 0x04, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x92, 0x85, 0x13, 0x60, 0x00, 0x00, 0x00, 0x40, 0x84, 0x74, 0xf0, 0xe0, 0x00, 0x00, 0x00, 
    0x40, 0x76, 0xdf, 0x56, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xee, 0x9b, 0x79, 0x20, 0xfe, 0x16, 0x84 } ;
const unsigned char camera_para_iPhone_4_front[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0xc5, 0x92, 0xa5, 0x6c, 0x89, 0x79, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0x84, 0xc0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0xaa, 0xf6, 0x9a, 0x3a, 0xbd, 0x26, 0x40, 0x6d, 0x20, 0xda, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xa6, 0x2e, 0x9b, 0xe0, 0x00, 0x00, 0x00, 
    0xbf, 0xb7, 0x91, 0xac, 0xc0, 0x00, 0x00, 0x00, 0xbf, 0x6f, 0x6d, 0x71, 0x40, 0x00, 0x00, 0x00, 
    0x3f, 0x26, 0x3f, 0x45, 0x20, 0x00, 0x00, 0x00, 0x40, 0x83, 0x94, 0xc7, 0x60, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x7a, 0x6d, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0x84, 0xc0, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x20, 0xda, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xb1, 0x07, 0x42, 0xfc, 0xef, 0x73 } ;
const unsigned char camera_para_iPhone_4_rear_640x480_0_3m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0xfc, 0x3e, 0xaf, 0x54, 0x57, 0xb6, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xd8, 0x0f, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0xeb, 0x92, 0x65, 0xe5, 0xbe, 0x54, 0x40, 0x6d, 0x35, 0xc2, 0xa0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbd, 0x26, 0x6d, 0x40, 0x00, 0x00, 0x00, 
    0xbf, 0xdb, 0xfc, 0x6a, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0x5a, 0x4d, 0x48, 0xc0, 0x00, 0x00, 0x00, 
    0xbf, 0x35, 0x43, 0xcd, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x83, 0xcd, 0xc0, 0xa0, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0xbd, 0x3b, 0x20, 0x00, 0x00, 0x00, 0x40, 0x73, 0xd8, 0x0f, 0x60, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x35, 0xc2, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xb5, 0x8e, 0xba, 0x23, 0x9f, 0xa0 } ;
const unsigned char camera_para_iPhone_4_rear_640x480_1_0m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x9b, 0xae, 0x04, 0x2f, 0xd9, 0x42, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xd7, 0x10, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x82, 0x3a, 0x5d, 0x47, 0xde, 0xf2, 0x40, 0x6d, 0x7f, 0x68, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbe, 0x7b, 0x6e, 0x00, 0x00, 0x00, 0x00, 
    0xbf, 0xdb, 0x81, 0x14, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x36, 0xd1, 0x90, 0x60, 0x00, 0x00, 0x00, 
    0x3f, 0x14, 0xb9, 0x11, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x83, 0x70, 0xb5, 0x80, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x57, 0x79, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xd7, 0x10, 0xc0, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x7f, 0x68, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xb9, 0xdf, 0x6a, 0x1b, 0xdd, 0xdc } ;
const unsigned char camera_para_iPhone_4_rear_640x480_inf[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0xaa, 0xbd, 0xaf, 0x03, 0xc2, 0x22, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xfe, 0x63, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x93, 0x9f, 0xd5, 0xb1, 0x8a, 0xdd, 0x40, 0x6d, 0x5d, 0x68, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbd, 0x67, 0x85, 0x80, 0x00, 0x00, 0x00, 
    0xbf, 0xd8, 0xc1, 0xe4, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x53, 0x01, 0x05, 0xc0, 0x00, 0x00, 0x00, 
    0x3f, 0x4b, 0x28, 0xc2, 0x60, 0x00, 0x00, 0x00, 0x40, 0x83, 0x79, 0xd8, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x62, 0xf3, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xfe, 0x63, 0xc0, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x5d, 0x68, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xb0, 0x70, 0x8b, 0x47, 0xf7, 0x39 } ;
const unsigned char camera_para_iPhone_4_rear_640x480_macro[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x84, 0x79, 0x46, 0xb1, 0xc5, 0x2b, 0x19, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xd4, 0x56, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x84, 0x64, 0x1b, 0xf6, 0x19, 0xe5, 0x17, 0x40, 0x6d, 0x95, 0xad, 0x20, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc2, 0xcd, 0x9c, 0xa0, 0x00, 0x00, 0x00, 
    0xbf, 0xe8, 0x9c, 0x32, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x56, 0x6b, 0x22, 0x60, 0x00, 0x00, 0x00, 
    0xbf, 0x42, 0x30, 0x27, 0x40, 0x00, 0x00, 0x00, 0x40, 0x84, 0x52, 0x3d, 0x60, 0x00, 0x00, 0x00, 
    0x40, 0x84, 0x3d, 0x3b, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xd4, 0x56, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x95, 0xad, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xc2, 0xfc, 0xa9, 0x09, 0x76, 0x06 } ;
const unsigned char camera_para_iPhone_4_rear_1280x720_0_3m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x98, 0x57, 0xaf, 0xe8, 0x14, 0xbb, 0x26, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0xa6, 0xcd, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x98, 0x34, 0x41, 0x87, 0xe1, 0xe5, 0xf3, 0x40, 0x78, 0x86, 0xc5, 0x20, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb8, 0xde, 0x1f, 0xa0, 0x00, 0x00, 0x00, 
    0xbf, 0xd1, 0xca, 0xaa, 0x80, 0x00, 0x00, 0x00, 0x3f, 0x5b, 0xe6, 0x86, 0xe0, 0x00, 0x00, 0x00, 
    0x3f, 0x57, 0x61, 0xd8, 0x40, 0x00, 0x00, 0x00, 0x40, 0x98, 0x0f, 0x4a, 0x40, 0x00, 0x00, 0x00, 
    0x40, 0x97, 0xec, 0x45, 0x40, 0x00, 0x00, 0x00, 0x40, 0x84, 0xa6, 0xcd, 0xc0, 0x00, 0x00, 0x00, 
    0x40, 0x78, 0x86, 0xc5, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xa0, 0xd4, 0x2d, 0xa1, 0x74, 0xf3 } ;
const unsigned char camera_para_iPhone_4_rear_1280x720_1_0m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x98, 0x4a, 0x71, 0x66, 0xc1, 0x78, 0xaa, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x60, 0xf8, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x98, 0x2d, 0xb5, 0x3f, 0xa2, 0xaa, 0xf8, 0x40, 0x77, 0xe3, 0x57, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb7, 0xf1, 0xe2, 0x80, 0x00, 0x00, 0x00, 
    0xbf, 0xc5, 0x1e, 0x36, 0x60, 0x00, 0x00, 0x00, 0xbf, 0x36, 0x15, 0x47, 0x60, 0x00, 0x00, 0x00, 
    0x3f, 0x62, 0x7c, 0x46, 0x60, 0x00, 0x00, 0x00, 0x40, 0x97, 0xe8, 0xfe, 0x80, 0x00, 0x00, 0x00, 
    0x40, 0x97, 0xcc, 0xb5, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x60, 0xf8, 0xe0, 0x00, 0x00, 0x00, 
    0x40, 0x77, 0xe3, 0x57, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x7f, 0x9f, 0xa9, 0x49, 0xf7, 0xa2 } ;
const unsigned char camera_para_iPhone_4_rear_1280x720_inf[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x98, 0x56, 0x2c, 0x6d, 0x1e, 0xa8, 0xb5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x6f, 0x0b, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x98, 0x35, 0xc6, 0x14, 0x68, 0x8e, 0xd7, 0x40, 0x78, 0x58, 0xd8, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb9, 0x2b, 0x1d, 0xe0, 0x00, 0x00, 0x00, 
    0xbf, 0xc7, 0x08, 0xab, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x4d, 0x10, 0xeb, 0xa0, 0x00, 0x00, 0x00, 
    0x3f, 0x3a, 0x5c, 0xa0, 0x20, 0x00, 0x00, 0x00, 0x40, 0x97, 0xfe, 0xe0, 0x20, 0x00, 0x00, 0x00, 
    0x40, 0x97, 0xde, 0xee, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x6f, 0x0b, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x78, 0x58, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x8d, 0x36, 0x6a, 0xa9, 0xb6, 0xdc } ;
const unsigned char camera_para_iPhone_4_rear_1280x720_macro[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x99, 0x52, 0xe4, 0x64, 0x06, 0xf5, 0x25, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0xa0, 0x9b, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x99, 0x28, 0xfc, 0x3b, 0x85, 0xfe, 0x2c, 0x40, 0x76, 0x75, 0x52, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xd5, 0x5c, 0x83, 0x40, 0x00, 0x00, 0x00, 
    0xc0, 0x02, 0xae, 0xf0, 0x20, 0x00, 0x00, 0x00, 0xbf, 0x6d, 0x96, 0x66, 0x40, 0x00, 0x00, 0x00, 
    0xbf, 0x84, 0xce, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x40, 0x98, 0xfe, 0x32, 0x40, 0x00, 0x00, 0x00, 
    0x40, 0x98, 0xd4, 0xd6, 0x40, 0x00, 0x00, 0x00, 0x40, 0x83, 0xa0, 0x9b, 0xe0, 0x00, 0x00, 0x00, 
    0x40, 0x76, 0x75, 0x52, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x94, 0xf9, 0xb8, 0x38, 0xa8, 0xf0 } ;
const unsigned char camera_para_iPhone_4S_front[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x84, 0xd0, 0x08, 0xce, 0x47, 0x71, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x7b, 0x70, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x6f, 0x6d, 0x6c, 0x34, 0x41, 0x44, 0x40, 0x6d, 0x9b, 0x8e, 0xa0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xcf, 0x95, 0xd0, 0x00, 0x00, 0x00, 0x00, 
    0xbf, 0xe4, 0xf5, 0xb1, 0xc0, 0x00, 0x00, 0x00, 0xbf, 0x50, 0x04, 0xa4, 0x40, 0x00, 0x00, 0x00, 
    0x3f, 0x68, 0xb7, 0xca, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x83, 0x09, 0x9b, 0x60, 0x00, 0x00, 0x00, 
    0x40, 0x82, 0xf4, 0xbf, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x74, 0x7b, 0x70, 0xc0, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x9b, 0x8e, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x36, 0x02, 0xd2, 0x07, 0xbd, 0xf5 } ;
const unsigned char camera_para_iPhone_4S_rear_640x480_0_3m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x82, 0xe5, 0x99, 0x72, 0x77, 0x64, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xb4, 0x37, 0x40, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x6c, 0xff, 0x47, 0x9c, 0x41, 0x68, 0x40, 0x6d, 0x61, 0xb5, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc6, 0xa2, 0x26, 0x60, 0x00, 0x00, 0x00, 
    0xbf, 0xde, 0x29, 0x12, 0xc0, 0x00, 0x00, 0x00, 0xbf, 0x74, 0x98, 0x2c, 0x00, 0x00, 0x00, 0x00, 
    0xbf, 0x62, 0xbb, 0x03, 0x40, 0x00, 0x00, 0x00, 0x40, 0x83, 0x1a, 0x7b, 0xc0, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x05, 0x0a, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xb4, 0x37, 0x40, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0x61, 0xb5, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x54, 0xc1, 0x12, 0x55, 0x23, 0x55 } ;
const unsigned char camera_para_iPhone_4S_rear_640x480_1_0m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x55, 0x3d, 0x0c, 0x7b, 0x8c, 0xd5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x08, 0x4a, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x3c, 0x7a, 0x40, 0xd0, 0x37, 0x4e, 0x40, 0x6e, 0x09, 0x49, 0xc0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc4, 0xe7, 0x61, 0xe0, 0x00, 0x00, 0x00, 
    0xbf, 0xda, 0x39, 0x1c, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x4e, 0xc0, 0xb0, 0x80, 0x00, 0x00, 0x00, 
    0x3f, 0x57, 0x36, 0x7e, 0x20, 0x00, 0x00, 0x00, 0x40, 0x83, 0x04, 0x64, 0x40, 0x00, 0x00, 0x00, 
    0x40, 0x82, 0xec, 0x09, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x08, 0x4a, 0xc0, 0x00, 0x00, 0x00, 
    0x40, 0x6e, 0x09, 0x49, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x7a, 0x2e, 0x92, 0xb2, 0xdd, 0xa8 } ;
const unsigned char camera_para_iPhone_4S_rear_640x480_inf[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x75, 0xe8, 0x86, 0x66, 0x87, 0x5f, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x11, 0x66, 0x20, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x5d, 0xd8, 0xa8, 0x56, 0x9f, 0x67, 0x40, 0x6d, 0xa2, 0x04, 0xa0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc3, 0xb9, 0x65, 0xa0, 0x00, 0x00, 0x00, 
    0xbf, 0xd8, 0x01, 0xee, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x6b, 0x37, 0xb6, 0x80, 0x00, 0x00, 0x00, 
    0x3f, 0x5e, 0x09, 0x47, 0x40, 0x00, 0x00, 0x00, 0x40, 0x83, 0x1c, 0x3e, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0x04, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x11, 0x66, 0x20, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0xa2, 0x04, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x6c, 0x8e, 0xbb, 0x24, 0x88, 0x69 } ;
const unsigned char camera_para_iPhone_4S_rear_640x480_macro[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x84, 0x01, 0xd7, 0x7d, 0xaf, 0x07, 0xdc, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xd5, 0x92, 0x60, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0xee, 0x84, 0x1c, 0x21, 0x76, 0x9e, 0x40, 0x6d, 0xb3, 0xf7, 0xa0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0, 0x03, 0x1d, 0xe0, 0x00, 0x00, 0x00, 
    0xbf, 0xdd, 0xe7, 0xec, 0x80, 0x00, 0x00, 0x00, 0xbf, 0x5c, 0xa2, 0x0c, 0xa0, 0x00, 0x00, 0x00, 
    0x3f, 0x4a, 0x0f, 0x9d, 0x80, 0x00, 0x00, 0x00, 0x40, 0x83, 0xcd, 0x8e, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x83, 0xba, 0x6d, 0x20, 0x00, 0x00, 0x00, 0x40, 0x73, 0xd5, 0x92, 0x60, 0x00, 0x00, 0x00, 
    0x40, 0x6d, 0xb3, 0xf7, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xac, 0x5e, 0xea, 0x6d, 0x6d, 0x52 } ;
const unsigned char camera_para_iPhone_4S_rear_1280x720_0_3m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x96, 0xaf, 0x94, 0x68, 0x02, 0x70, 0xe5, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x77, 0x07, 0xa0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x96, 0x97, 0xe0, 0x30, 0xaa, 0x9d, 0xb6, 0x40, 0x76, 0xe0, 0xf9, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc1, 0xe1, 0xc4, 0x60, 0x00, 0x00, 0x00, 
    0xbf, 0xd3, 0x0a, 0x1d, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x37, 0x78, 0x61, 0x00, 0x00, 0x00, 0x00, 
    0x3f, 0x69, 0xe8, 0xfa, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x96, 0x37, 0xbd, 0xe0, 0x00, 0x00, 0x00, 
    0x40, 0x96, 0x20, 0x86, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x77, 0x07, 0xa0, 0x00, 0x00, 0x00, 
    0x40, 0x76, 0xe0, 0xf9, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x56, 0xf5, 0xc5, 0xa4, 0xfb, 0x79 } ;
const unsigned char camera_para_iPhone_4S_rear_1280x720_1_0m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x96, 0x4b, 0x05, 0xfd, 0x14, 0x2f, 0x71, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x91, 0xa1, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x96, 0x34, 0x1d, 0x5b, 0xeb, 0x0d, 0x58, 0x40, 0x76, 0xf2, 0x28, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xcb, 0x2f, 0xcf, 0x60, 0x00, 0x00, 0x00, 
    0xbf, 0xec, 0xe7, 0xdf, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0x63, 0x28, 0xd2, 0xe0, 0x00, 0x00, 0x00, 
    0x3f, 0x70, 0xb5, 0x5f, 0x60, 0x00, 0x00, 0x00, 0x40, 0x96, 0x01, 0x4e, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x95, 0xea, 0xb1, 0x20, 0x00, 0x00, 0x00, 0x40, 0x84, 0x91, 0xa1, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x76, 0xf2, 0x28, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x96, 0x2e, 0xb0, 0x6e, 0x62, 0xbe } ;
const unsigned char camera_para_iPhone_4S_rear_1280x720_inf[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x96, 0x88, 0x28, 0xb3, 0xf4, 0x5a, 0x65, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0xfe, 0xa0, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x96, 0x6d, 0xb1, 0x07, 0x67, 0x7e, 0x73, 0x40, 0x76, 0x57, 0xd4, 0x20, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc3, 0x71, 0xb0, 0x20, 0x00, 0x00, 0x00, 
    0xbf, 0xdd, 0x90, 0x83, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0x67, 0x85, 0x1c, 0x20, 0x00, 0x00, 0x00, 
    0xbf, 0x64, 0x07, 0x8f, 0x40, 0x00, 0x00, 0x00, 0x40, 0x96, 0x31, 0x7f, 0x40, 0x00, 0x00, 0x00, 
    0x40, 0x96, 0x17, 0x6d, 0x60, 0x00, 0x00, 0x00, 0x40, 0x83, 0xfe, 0xa0, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x76, 0x57, 0xd4, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x84, 0xeb, 0xfc, 0x96, 0x44, 0x63 } ;
const unsigned char camera_para_iPhone_4S_rear_1280x720_macro[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x97, 0x8d, 0x3b, 0x60, 0xb5, 0xcf, 0xce, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x82, 0xa0, 0x89, 0xa0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x40, 0x97, 0x75, 0x4f, 0xf7, 0xb8, 0x37, 0x57, 0x40, 0x76, 0x8f, 0x02, 0xe0, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xce, 0xe0, 0x03, 0x00, 0x00, 0x00, 0x00, 
    0xbf, 0xfd, 0xde, 0x6f, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x51, 0x3d, 0x05, 0x80, 0x00, 0x00, 0x00, 
    0xbf, 0x8a, 0x11, 0x7e, 0x40, 0x00, 0x00, 0x00, 0x40, 0x97, 0x3c, 0x55, 0xe0, 0x00, 0x00, 0x00, 
    0x40, 0x97, 0x24, 0xbc, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x82, 0xa0, 0x89, 0xa0, 0x00, 0x00, 0x00, 
    0x40, 0x76, 0x8f, 0x02, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x92, 0x15, 0xb7, 0x0a, 0xdc, 0x1e } ;
const unsigned char camera_para_iPhone_5_front_640x480[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0xdc, 0x31, 0xde, 0x36, 0xdd, 0x3d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x31, 0x71, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x83, 0xc0, 0xfb, 0x9f, 0xfa, 0x1b, 0x7c, 0x40, 0x6d, 0x9b, 0x9f, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xa3, 0x41, 0x1f, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0xa6, 0x53, 0xeb, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x66, 0x0d, 0x66, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0x52, 0xd3, 0x58, 0x60, 0x00, 0x00, 0x00, 0x40, 0x83, 0x95, 0x21, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x83, 0x7a, 0x4d, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x31, 0x71, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0x9b, 0x9f, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x8d, 0x7f, 0xd3, 0x3d, 0x0f, 0x3c } ;
const unsigned char camera_para_iPhone_5_rear_640x480_0_3m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0xe7, 0xf9, 0xe8, 0x15, 0x34, 0xbe,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xae, 0x83, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0xcc, 0x75, 0x00, 0xf9, 0xe4, 0x07, 0x40, 0x6d, 0xd5, 0x96, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc2, 0xbc, 0xf0, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0xd4, 0x38, 0xf3, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x58, 0x8b, 0x13, 0x00, 0x00, 0x00, 0x00,
    0xbf, 0x62, 0x29, 0x4d, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x82, 0x89, 0x68, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x6e, 0x6c, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xae, 0x83, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xd5, 0x96, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x5f, 0xef, 0x07, 0xef, 0x09, 0x0b } ;
const unsigned char camera_para_iPhone_5_rear_640x480_1_0m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x0a, 0xec, 0x5b, 0xa6, 0xd4, 0x4b,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x37, 0x2a, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0xf4, 0x2b, 0x77, 0x47, 0xc9, 0xff, 0x40, 0x6d, 0xb3, 0x68, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb9, 0x63, 0x5a, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0xb7, 0x95, 0x32, 0xc0, 0x00, 0x00, 0x00, 0xbf, 0x5e, 0xd8, 0x15, 0x60, 0x00, 0x00, 0x00,
    0x3f, 0x55, 0x82, 0xd7, 0x20, 0x00, 0x00, 0x00, 0x40, 0x82, 0x7b, 0x46, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x65, 0x30, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x74, 0x37, 0x2a, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xb3, 0x68, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x0e, 0x9b, 0x3a, 0xa4, 0x0f, 0x2e } ;
const unsigned char camera_para_iPhone_5_rear_640x480_inf[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x07, 0x8e, 0xc4, 0xb5, 0xef, 0xe3,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x7e, 0x81, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0xee, 0xa8, 0x0b, 0x46, 0x86, 0x89, 0x40, 0x6e, 0x7f, 0x68, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc3, 0x54, 0x7a, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0xd9, 0x32, 0x22, 0x80, 0x00, 0x00, 0x00, 0x3f, 0x70, 0xaf, 0xa2, 0xa0, 0x00, 0x00, 0x00,
    0x3f, 0x74, 0x86, 0x75, 0x60, 0x00, 0x00, 0x00, 0x40, 0x82, 0xa7, 0x18, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x8e, 0xb0, 0x60, 0x00, 0x00, 0x00, 0x40, 0x74, 0x7e, 0x81, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x6e, 0x7f, 0x68, 0x80, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x5d, 0xca, 0xce, 0x83, 0x77, 0x94 } ;
const unsigned char camera_para_iPhone_5_rear_640x480_macro[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x61, 0x7f, 0x2c, 0xd6, 0xcb, 0x98,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x7d, 0x4a, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x83, 0x4d, 0x5f, 0xb5, 0x93, 0xf8, 0x4d, 0x40, 0x6d, 0x88, 0x73, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc7, 0x73, 0xa2, 0x00, 0x00, 0x00, 0x00,
    0xbf, 0xe5, 0x3f, 0x5e, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x2b, 0x6c, 0x02, 0x60, 0x00, 0x00, 0x00,
    0x3f, 0x70, 0x36, 0x26, 0x80, 0x00, 0x00, 0x00, 0x40, 0x83, 0x23, 0x68, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x83, 0x0f, 0x89, 0x80, 0x00, 0x00, 0x00, 0x40, 0x74, 0x7d, 0x4a, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0x88, 0x73, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x99, 0x7c, 0x11, 0xad, 0x41, 0x03 } ;
const unsigned char camera_para_iPhone_5_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0x4e, 0x8a, 0x36, 0xfb, 0x72, 0xda,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0xf0, 0x60, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x3e, 0xd0, 0x45, 0x4b, 0x63, 0x28, 0x40, 0x75, 0xf9, 0x2f, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xaa, 0xb2, 0x18, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0xc0, 0x61, 0x18, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0x60, 0x73, 0x01, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0x7c, 0xb9, 0x48, 0x80, 0x00, 0x00, 0x00, 0x40, 0x91, 0x0a, 0x5e, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x90, 0xfa, 0xe2, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x84, 0xf0, 0x60, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x75, 0xf9, 0x2f, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x81, 0xf4, 0xbd, 0xdf, 0xb9, 0x40 } ;
const unsigned char camera_para_iPhone_5_rear_1280x720_0_3m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x96, 0x9e, 0x76, 0x7f, 0x77, 0x57, 0x0a,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0xa7, 0xdc, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x96, 0x86, 0xcb, 0xc4, 0x19, 0x3d, 0x95, 0x40, 0x76, 0x85, 0x3c, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xa0, 0x47, 0xa4, 0x20, 0x00, 0x00, 0x00,
    0x3f, 0xd1, 0x7e, 0xb9, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x54, 0x4b, 0xc4, 0x80, 0x00, 0x00, 0x00,
    0x3f, 0x79, 0x42, 0xc0, 0x40, 0x00, 0x00, 0x00, 0x40, 0x95, 0xe1, 0xb9, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x95, 0xca, 0xd4, 0x60, 0x00, 0x00, 0x00, 0x40, 0x84, 0xa7, 0xdc, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x85, 0x3c, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xee, 0xf4, 0xfc, 0x2e, 0xc4, 0xf8, 0x96 } ;
const unsigned char camera_para_iPhone_5_rear_1280x720_1_0m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x96, 0x47, 0x53, 0x5e, 0x6c, 0x04, 0x6b,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x4d, 0xe8, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x96, 0x2a, 0x8e, 0x68, 0x32, 0xaa, 0x88, 0x40, 0x75, 0x87, 0xaf, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb0, 0xce, 0xce, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0x4c, 0xe0, 0x55, 0xc0, 0x00, 0x00, 0x00, 0xbf, 0x6d, 0x56, 0xb3, 0xa0, 0x00, 0x00, 0x00,
    0x3f, 0x64, 0xad, 0xbf, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x95, 0xbf, 0x41, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x95, 0xa3, 0x2c, 0x80, 0x00, 0x00, 0x00, 0x40, 0x84, 0x4d, 0xe8, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x75, 0x87, 0xaf, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x3c, 0x8e, 0x8f, 0x36, 0x0d, 0x52 } ;
const unsigned char camera_para_iPhone_5_rear_1280x720_inf[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x96, 0x8a, 0xd5, 0x1e, 0x4e, 0x04, 0x92,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0xd5, 0x46, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x96, 0x72, 0x60, 0x11, 0x68, 0x1f, 0x8e, 0x40, 0x76, 0x92, 0x09, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x94, 0x4c, 0x9b, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0xd4, 0xed, 0xee, 0x20, 0x00, 0x00, 0x00, 0x3f, 0x31, 0x98, 0xa4, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0x47, 0x39, 0x3e, 0x80, 0x00, 0x00, 0x00, 0x40, 0x95, 0xef, 0x7a, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x95, 0xd7, 0xae, 0x20, 0x00, 0x00, 0x00, 0x40, 0x83, 0xd5, 0x46, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x92, 0x09, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x23, 0x77, 0xb1, 0xd0, 0x6c, 0x58 } ;
const unsigned char camera_para_iPhone_5_rear_1280x720_macro[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x97, 0x0a, 0xd5, 0xb4, 0x5b, 0x47, 0x0d,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x85, 0x16, 0xfa, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x96, 0xed, 0x23, 0x8d, 0x29, 0xb2, 0xa3, 0x40, 0x77, 0x18, 0x32, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbd, 0x88, 0xef, 0x00, 0x00, 0x00, 0x00,
    0xbf, 0xe0, 0x4c, 0xa5, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x72, 0x8c, 0xe8, 0x80, 0x00, 0x00, 0x00,
    0x3f, 0x85, 0xc6, 0x0a, 0x80, 0x00, 0x00, 0x00, 0x40, 0x96, 0xa2, 0x28, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x96, 0x84, 0xfd, 0x20, 0x00, 0x00, 0x00, 0x40, 0x85, 0x16, 0xfa, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x77, 0x18, 0x32, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x6e, 0xa1, 0x3d, 0x52, 0xf8, 0x5f } ;
const unsigned char camera_para_iPhone_5s_front_640x480[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x6f, 0x58, 0x09, 0x79, 0x52, 0xd8,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xec, 0xb3, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x57, 0x2b, 0x4e, 0x6c, 0x71, 0xc5, 0x40, 0x6e, 0x46, 0x0d, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x8a, 0xaf, 0x3c, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0xba, 0x7e, 0xb9, 0x80, 0x00, 0x00, 0x00, 0x3f, 0x68, 0xb5, 0x63, 0xc0, 0x00, 0x00, 0x00,
    0xbf, 0x50, 0x0f, 0xb0, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x82, 0x61, 0x27, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x49, 0x0d, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xec, 0xb3, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x6e, 0x46, 0x0d, 0x80, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xe7, 0x5f, 0x2a, 0xf7, 0x7e, 0x6c } ;
const unsigned char camera_para_iPhone_5s_rear_640x480_0_3m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x12, 0x81, 0xe4, 0x07, 0x99, 0x51,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0xa0, 0x5b, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x00, 0xb6, 0xfd, 0x70, 0xe8, 0x73, 0x40, 0x6e, 0x8e, 0x63, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb5, 0x86, 0xf0, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0xbc, 0xb0, 0xd1, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0x7d, 0x34, 0xe1, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x67, 0x1a, 0x9d, 0x60, 0x00, 0x00, 0x00, 0x40, 0x81, 0x83, 0xa5, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x81, 0x72, 0x67, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0xa0, 0x5b, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x6e, 0x8e, 0x63, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x03, 0x0a, 0x10, 0x2d, 0x00, 0xf1 } ;
const unsigned char camera_para_iPhone_5s_rear_640x480_1_0m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x81, 0xfd, 0x96, 0x28, 0x56, 0x7c, 0xeb,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x73, 0xd8, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x81, 0xea, 0xe3, 0x54, 0x66, 0xc9, 0x9f, 0x40, 0x6d, 0xf7, 0xd5, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xaf, 0x91, 0xd5, 0x40, 0x00, 0x00, 0x00,
    0x3f, 0x93, 0x0f, 0x03, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x63, 0xc6, 0xac, 0x80, 0x00, 0x00, 0x00,
    0x3f, 0x36, 0xb9, 0x86, 0x20, 0x00, 0x00, 0x00, 0x40, 0x81, 0x4c, 0x3c, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x81, 0x3a, 0x42, 0x60, 0x00, 0x00, 0x00, 0x40, 0x74, 0x73, 0xd8, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xf7, 0xd5, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xee, 0xc4, 0x8c, 0x50, 0x17, 0x05, 0x5c } ;
const unsigned char camera_para_iPhone_5s_rear_640x480_inf[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x81, 0xdc, 0xce, 0x08, 0xdc, 0x21, 0x23,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x62, 0xf3, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x81, 0xc8, 0xec, 0x19, 0xe8, 0x1f, 0x6a, 0x40, 0x6d, 0x9e, 0xf0, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb3, 0x09, 0x48, 0xc0, 0x00, 0x00, 0x00,
    0xbf, 0xb4, 0x14, 0x3d, 0x20, 0x00, 0x00, 0x00, 0x3f, 0x4d, 0xad, 0x1b, 0x80, 0x00, 0x00, 0x00,
    0xbf, 0x30, 0x67, 0xd3, 0x00, 0x00, 0x00, 0x00, 0x40, 0x81, 0x84, 0x98, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x81, 0x71, 0x19, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x62, 0xf3, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0x9e, 0xf0, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x61, 0xfa, 0x84, 0x46, 0xa2, 0x25 } ;
const unsigned char camera_para_iPhone_5s_rear_640x480_macro[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x42, 0x35, 0xaf, 0xae, 0x61, 0x7c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0xb6, 0x0f, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x2f, 0xd7, 0x7a, 0x3f, 0x14, 0xd0, 0x40, 0x6c, 0xf7, 0xb9, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc3, 0x14, 0xa6, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0xd5, 0x2e, 0xe3, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x47, 0x28, 0x81, 0x60, 0x00, 0x00, 0x00,
    0x3f, 0x72, 0x40, 0x9f, 0x20, 0x00, 0x00, 0x00, 0x40, 0x81, 0xd9, 0xa0, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x81, 0xc7, 0xab, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x74, 0xb6, 0x0f, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x6c, 0xf7, 0xb9, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x48, 0xb5, 0xa5, 0xa6, 0x05, 0xa7 } ;
const unsigned char camera_para_iPhone_5s_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0x36, 0x74, 0xa7, 0xb5, 0x03, 0x53,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x18, 0xdf, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x16, 0x6b, 0x67, 0x4d, 0xf0, 0x38, 0x40, 0x76, 0xc9, 0xfb, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x74, 0xad, 0x0a, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0x81, 0x6b, 0xb9, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0x6b, 0x6c, 0x58, 0xe0, 0x00, 0x00, 0x00,
    0x3f, 0x41, 0x5c, 0x13, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x91, 0x18, 0xc5, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x90, 0xf8, 0xf3, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x18, 0xdf, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0xc9, 0xfb, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xc8, 0xcf, 0x8d, 0x9f, 0xb9, 0xec } ;
const unsigned char camera_para_iPhone_5s_rear_1280x720_0_3m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0xd2, 0x58, 0xd1, 0xc4, 0x2e, 0xd6,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x4a, 0x41, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0xbe, 0x61, 0xfa, 0xdc, 0xc6, 0xbb, 0x40, 0x75, 0xc1, 0x92, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb5, 0xe4, 0xca, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0xc0, 0xfa, 0x33, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x52, 0xa9, 0xea, 0x00, 0x00, 0x00, 0x00,
    0xbf, 0x59, 0xa3, 0xc0, 0x80, 0x00, 0x00, 0x00, 0x40, 0x91, 0x87, 0xd7, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x74, 0x33, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x4a, 0x41, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x75, 0xc1, 0x92, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x7a, 0x37, 0xad, 0x81, 0xf0, 0x9c } ;
const unsigned char camera_para_iPhone_5s_rear_1280x720_1_0m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0xcd, 0x74, 0xad, 0xd8, 0x27, 0x2c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0xaf, 0xce, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0xbd, 0x58, 0xfa, 0xbf, 0x9b, 0xae, 0x40, 0x76, 0x28, 0xa5, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb4, 0x70, 0x0c, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0xb1, 0xf6, 0x7c, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0x59, 0x73, 0x53, 0x40, 0x00, 0x00, 0x00,
    0x3f, 0x62, 0x2b, 0x48, 0x60, 0x00, 0x00, 0x00, 0x40, 0x91, 0x5a, 0x05, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x4a, 0x51, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x84, 0xaf, 0xce, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x28, 0xa5, 0x80, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x30, 0x81, 0x07, 0xc6, 0xac, 0xfa } ;
const unsigned char camera_para_iPhone_5s_rear_1280x720_inf[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0xb1, 0x31, 0xc5, 0x5a, 0x84, 0x2c,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0xb0, 0x8e, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0xa1, 0x84, 0x1a, 0xde, 0x16, 0x72, 0x40, 0x76, 0x9d, 0x6e, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbb, 0x73, 0x3f, 0xc0, 0x00, 0x00, 0x00,
    0xbf, 0xcd, 0x8d, 0x3a, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0x75, 0xb3, 0x52, 0xa0, 0x00, 0x00, 0x00,
    0x3f, 0x70, 0x1c, 0x41, 0x00, 0x00, 0x00, 0x00, 0x40, 0x91, 0x57, 0x4b, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x47, 0xed, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x84, 0xb0, 0x8e, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x9d, 0x6e, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x5d, 0x66, 0x4e, 0x6c, 0xe1, 0x27 } ;
const unsigned char camera_para_iPhone_5s_rear_1280x720_macro[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0xb8, 0xdc, 0x51, 0x5a, 0x80, 0x9e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x86, 0x11, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0xa6, 0xfb, 0x4d, 0xe8, 0xcf, 0x6e, 0x40, 0x75, 0xd8, 0x1f, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x9b, 0xf3, 0x65, 0x60, 0x00, 0x00, 0x00,
    0x3f, 0xbc, 0x95, 0xa8, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x41, 0x5b, 0x97, 0xa0, 0x00, 0x00, 0x00,
    0xbf, 0x4c, 0x2c, 0x90, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x92, 0x2e, 0xc0, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x1d, 0x63, 0x80, 0x00, 0x00, 0x00, 0x40, 0x84, 0x86, 0x11, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x75, 0xd8, 0x1f, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x13, 0xf1, 0xbc, 0x42, 0x24, 0x76 } ;
const unsigned char camera_para_iPad_mini_3_front_640x480[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x3b, 0xd1, 0xc6, 0xca, 0x09, 0x82,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xfa, 0xfa, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x26, 0x51, 0xeb, 0xdc, 0x48, 0xc6, 0x40, 0x6d, 0x0f, 0x92, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xa9, 0x1e, 0x51, 0xa0, 0x00, 0x00, 0x00,
    0xbf, 0xb7, 0xa5, 0x30, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x3c, 0x15, 0x8e, 0xe0, 0x00, 0x00, 0x00,
    0x3f, 0x57, 0xdb, 0x9d, 0x60, 0x00, 0x00, 0x00, 0x40, 0x82, 0x13, 0x20, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x81, 0xfd, 0xd0, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xfa, 0xfa, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0x0f, 0x92, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xb8, 0x95, 0xf3, 0x5f, 0x24, 0xa7
};
const unsigned char camera_para_iPad_mini_3_rear_640x480_0_3m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0xbc, 0x2e, 0xd7, 0x12, 0xc5, 0x27,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x32, 0x1b, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0xa5, 0x5e, 0xd9, 0xbb, 0xc1, 0xfc, 0x40, 0x6e, 0x52, 0x58, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc4, 0xb8, 0x4e, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0xd8, 0x56, 0x75, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x6c, 0x71, 0x5e, 0xa0, 0x00, 0x00, 0x00,
    0x3f, 0x51, 0x92, 0xe8, 0x80, 0x00, 0x00, 0x00, 0x40, 0x82, 0x5d, 0x07, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x46, 0xaa, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x74, 0x32, 0x1b, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x6e, 0x52, 0x58, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x5d, 0x78, 0xc9, 0x42, 0xc2, 0x04
};
const unsigned char camera_para_iPad_mini_3_rear_640x480_1_0m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x88, 0x9d, 0xd3, 0xec, 0x76, 0xe0,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x69, 0x46, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x6f, 0x7d, 0x02, 0xc0, 0x6a, 0x1a, 0x40, 0x6e, 0x19, 0x37, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc5, 0x90, 0xd4, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0xd7, 0xef, 0xa5, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x56, 0x50, 0xb8, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0x6f, 0xdd, 0x59, 0x40, 0x00, 0x00, 0x00, 0x40, 0x82, 0x19, 0x31, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x00, 0xa8, 0x20, 0x00, 0x00, 0x00, 0x40, 0x74, 0x69, 0x46, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x6e, 0x19, 0x37, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x3f, 0x9e, 0xdf, 0x79, 0x84, 0x0e
};
const unsigned char camera_para_iPad_mini_3_rear_640x480_inf[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x9e, 0x17, 0xc8, 0xb9, 0x81, 0x19,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x38, 0x11, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x85, 0x4d, 0xc7, 0xfa, 0x1c, 0x00, 0x40, 0x6e, 0x11, 0xfb, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc5, 0x16, 0xd2, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0xd7, 0x5d, 0x94, 0x40, 0x00, 0x00, 0x00, 0x3f, 0x58, 0xea, 0x3b, 0x40, 0x00, 0x00, 0x00,
    0x3f, 0x4f, 0xa2, 0xa7, 0x60, 0x00, 0x00, 0x00, 0x40, 0x82, 0x45, 0x2f, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x2c, 0xdc, 0x20, 0x00, 0x00, 0x00, 0x40, 0x74, 0x38, 0x11, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x6e, 0x11, 0xfb, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x67, 0x2f, 0xdd, 0x5f, 0x4e, 0x18
};
const unsigned char camera_para_iPad_mini_3_rear_640x480_macro[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x32, 0x92, 0xfd, 0x21, 0xb6, 0x1b,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x2a, 0xa1, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x83, 0x18, 0x8b, 0xf6, 0x92, 0x98, 0x47, 0x40, 0x6d, 0xf8, 0x1f, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc4, 0x9d, 0xdf, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0xdd, 0xc6, 0x4f, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0x58, 0xd8, 0x40, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0x19, 0x93, 0x9d, 0x00, 0x00, 0x00, 0x00, 0x40, 0x82, 0xe7, 0x3a, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0xcd, 0x99, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x74, 0x2a, 0xa1, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xf8, 0x1f, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x82, 0x68, 0xa2, 0x23, 0x6b, 0x87
};
const unsigned char camera_para_iPad_mini_3_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0x04, 0xbd, 0x00, 0x4a, 0x10, 0x93,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0xe2, 0xfc, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x90, 0xd7, 0xc4, 0x5d, 0xc7, 0x81, 0xd9, 0x40, 0x76, 0x1a, 0x16, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xa0, 0x77, 0x90, 0x00, 0x00, 0x00, 0x00,
    0xbf, 0xa7, 0x93, 0xa5, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x67, 0x5c, 0x92, 0xa0, 0x00, 0x00, 0x00,
    0x3f, 0x45, 0x77, 0x3c, 0x20, 0x00, 0x00, 0x00, 0x40, 0x90, 0xd2, 0xbc, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x90, 0xa6, 0x47, 0x80, 0x00, 0x00, 0x00, 0x40, 0x83, 0xe2, 0xfc, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x1a, 0x16, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xa1, 0xfa, 0x34, 0x40, 0xe9, 0xfe
};
const unsigned char camera_para_iPad_mini_3_rear_1280x720_0_3m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x93, 0x2d, 0xba, 0x1c, 0xaa, 0x50, 0x1e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0xd1, 0xc7, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x93, 0x0d, 0xec, 0x9f, 0xaa, 0xa0, 0x68, 0x40, 0x77, 0x1c, 0xfc, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc1, 0xb0, 0xaa, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0xca, 0x03, 0xf2, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x77, 0xa8, 0x3e, 0x20, 0x00, 0x00, 0x00,
    0x3f, 0x82, 0x84, 0xad, 0x60, 0x00, 0x00, 0x00, 0x40, 0x92, 0x65, 0x5e, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x46, 0xdd, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x84, 0xd1, 0xc7, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x77, 0x1c, 0xfc, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xee, 0xb1, 0xb3, 0x4f, 0xef, 0xf9, 0x77
};
const unsigned char camera_para_iPad_mini_3_rear_1280x720_1_0m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0xe6, 0x07, 0xb6, 0x17, 0x5c, 0x10,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x7f, 0xc9, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0xd0, 0xdd, 0xca, 0x40, 0x0f, 0x2d, 0x40, 0x76, 0xf6, 0xf9, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbf, 0x18, 0x43, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0xc3, 0xb7, 0x1c, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x70, 0x8f, 0xf6, 0x20, 0x00, 0x00, 0x00,
    0x3f, 0x72, 0x79, 0xe0, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x92, 0x3f, 0xc9, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x2b, 0x59, 0x40, 0x00, 0x00, 0x00, 0x40, 0x84, 0x7f, 0xc9, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0xf6, 0xf9, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xee, 0xe6, 0x81, 0x69, 0xec, 0x1e, 0x6b
};
const unsigned char camera_para_iPad_mini_3_rear_1280x720_inf[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0xd0, 0x74, 0xa5, 0x2b, 0x64, 0xb1,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x84, 0x32, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0xb9, 0x61, 0x38, 0x8a, 0x6a, 0x7f, 0x40, 0x76, 0x66, 0x73, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0, 0xe3, 0x19, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0xcb, 0x37, 0xa8, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x4a, 0xd3, 0x93, 0xa0, 0x00, 0x00, 0x00,
    0x3f, 0x6e, 0x83, 0x8c, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x92, 0x52, 0x58, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x3b, 0xdf, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x84, 0x32, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x66, 0x73, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x29, 0x82, 0x2f, 0x18, 0x51, 0xf7
};
const unsigned char camera_para_iPad_mini_3_rear_1280x720_macro[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x93, 0x21, 0x4b, 0xd8, 0x9c, 0xd6, 0x3e,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0xcf, 0x55, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x93, 0x08, 0xe0, 0xed, 0xd7, 0x7b, 0x88, 0x40, 0x75, 0x82, 0x22, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xd1, 0xe7, 0x7e, 0xa0, 0x00, 0x00, 0x00,
    0xbf, 0xe9, 0x76, 0xda, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x6e, 0x04, 0x5a, 0xa0, 0x00, 0x00, 0x00,
    0x3f, 0x76, 0x83, 0xd3, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x92, 0x9a, 0x9b, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x82, 0xdc, 0x80, 0x00, 0x00, 0x00, 0x40, 0x84, 0xcf, 0x55, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x75, 0x82, 0x22, 0x80, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x1e, 0xb2, 0xaa, 0x5a, 0xad, 0xda
};

const unsigned char camera_para_iPhone_6_Plus_rear_1280x720_0_3m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0x1c, 0x41, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0x96, 0x64, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x00, 0x74, 0x80, 0x00, 0x00, 0x00, 0x40, 0x75, 0x60, 0x7a, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb6, 0x55, 0x03, 0x00, 0x00, 0x00, 0x00,
    0xbf, 0x7f, 0xe1, 0xba, 0x40, 0x00, 0x00, 0x00, 0xbf, 0x74, 0x9d, 0x7b, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0x6e, 0xef, 0x66, 0x60, 0x00, 0x00, 0x00, 0x40, 0x91, 0x51, 0x1d, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x36, 0x88, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x83, 0x96, 0x64, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x75, 0x60, 0x7a, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xee, 0x99, 0x10, 0xa0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_rear_1280x720_1_0m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0xc4, 0xb1, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x1c, 0xe2, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0xa4, 0xdc, 0x60, 0x00, 0x00, 0x00, 0x40, 0x76, 0x1a, 0xac, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb7, 0x41, 0x8e, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0x9f, 0x60, 0x92, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x10, 0x2d, 0x9c, 0x20, 0x00, 0x00, 0x00,
    0x3f, 0x53, 0x09, 0xd7, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x91, 0x2b, 0x6f, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x0c, 0xad, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x1c, 0xe2, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x1a, 0xac, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xee, 0xeb, 0xfe, 0xa0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_rear_1280x720_inf[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0x5c, 0x0f, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x80, 0xd0, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x36, 0xa6, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x75, 0xe0, 0xeb, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xbf, 0x53, 0xc2, 0x22, 0x60, 0x00, 0x00, 0x00,
    0x3f, 0xd8, 0x06, 0xaa, 0x20, 0x00, 0x00, 0x00, 0xbf, 0x71, 0x0c, 0xf4, 0xe0, 0x00, 0x00, 0x00,
    0x3f, 0x7a, 0x53, 0x51, 0x60, 0x00, 0x00, 0x00, 0x40, 0x91, 0x38, 0x9d, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x15, 0x86, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x80, 0xd0, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x75, 0xe0, 0xeb, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xee, 0x04, 0x06, 0x00, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_rear_1280x720_macro[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0x41, 0xc4, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x47, 0xdf, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x37, 0x5b, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x77, 0x10, 0xbe, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xca, 0xb1, 0xb6, 0x00, 0x00, 0x00, 0x00,
    0xbf, 0xe2, 0xf8, 0x53, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0x59, 0xf7, 0x8c, 0x20, 0x00, 0x00, 0x00,
    0x3f, 0x5c, 0x86, 0xf7, 0x40, 0x00, 0x00, 0x00, 0x40, 0x90, 0xf5, 0xac, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x90, 0xeb, 0x71, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x47, 0xdf, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x77, 0x10, 0xbe, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x72, 0xe4, 0xa0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_rear_640x480_0_3m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x81, 0x77, 0x98, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xf6, 0x13, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x81, 0x61, 0x11, 0x40, 0x00, 0x00, 0x00, 0x40, 0x6d, 0xcb, 0x7c, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb7, 0x57, 0x4a, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0xc1, 0x02, 0x4c, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x54, 0x7f, 0x3e, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0x56, 0x25, 0xb6, 0x80, 0x00, 0x00, 0x00, 0x40, 0x81, 0x28, 0xcb, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x81, 0x12, 0xa9, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xf6, 0x13, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xcb, 0x7c, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x6f, 0xa2, 0xe0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_rear_640x480_1_0m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x81, 0x72, 0xff, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xed, 0xd0, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x81, 0x5f, 0x72, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x6d, 0x83, 0x16, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbd, 0x71, 0xef, 0xc0, 0x00, 0x00, 0x00,
    0xbf, 0xc2, 0x2e, 0x94, 0x60, 0x00, 0x00, 0x00, 0xbf, 0x71, 0xd7, 0x13, 0x60, 0x00, 0x00, 0x00,
    0x3f, 0x38, 0x2c, 0x8d, 0x20, 0x00, 0x00, 0x00, 0x40, 0x80, 0xec, 0xc2, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x80, 0xd9, 0xcb, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xed, 0xd0, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0x83, 0x16, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x09, 0xd1, 0xa0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_rear_640x480_inf[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x81, 0xb3, 0x53, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x49, 0x11, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x81, 0xa4, 0xa5, 0x80, 0x00, 0x00, 0x00, 0x40, 0x6e, 0x04, 0x29, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb5, 0xf2, 0xa7, 0x80, 0x00, 0x00, 0x00,
    0xbf, 0xb3, 0x7f, 0x11, 0xc0, 0x00, 0x00, 0x00, 0xbf, 0x64, 0x07, 0x5b, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x61, 0xef, 0x4b, 0x80, 0x00, 0x00, 0x00, 0x40, 0x81, 0x2a, 0xb4, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x81, 0x1c, 0x78, 0x20, 0x00, 0x00, 0x00, 0x40, 0x74, 0x49, 0x11, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x6e, 0x04, 0x29, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x09, 0x02, 0xa0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_rear_640x480_macro[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x05, 0xcf, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xc0, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x81, 0xef, 0x7e, 0x00, 0x00, 0x00, 0x00, 0x40, 0x6e, 0x3e, 0xee, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc5, 0x35, 0x81, 0x80, 0x00, 0x00, 0x00,
    0xbf, 0xd9, 0x36, 0xed, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x4b, 0x4d, 0x6d, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0x60, 0xc4, 0x43, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x81, 0xb3, 0xfa, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x81, 0x9e, 0x0e, 0x40, 0x00, 0x00, 0x00, 0x40, 0x73, 0xc0, 0x02, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x6e, 0x3e, 0xee, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x6e, 0xb4, 0x20, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0xa0, 0x3f, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0xad, 0xc2, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x8f, 0x64, 0x80, 0x00, 0x00, 0x00, 0x40, 0x76, 0x97, 0xfa, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbe, 0x1c, 0x01, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0xd5, 0x4b, 0xa6, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x5e, 0x89, 0x3f, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0x7b, 0xb3, 0x9c, 0x60, 0x00, 0x00, 0x00, 0x40, 0x91, 0x5a, 0xa9, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x4a, 0x10, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x83, 0xad, 0xc2, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x97, 0xfa, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x81, 0xaa, 0x40, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_Plus_front_640x480[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0xf6, 0x18, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0x87, 0xe1, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0xdc, 0x47, 0x60, 0x00, 0x00, 0x00, 0x40, 0x6d, 0x83, 0xe8, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb5, 0x0d, 0x1c, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0xc7, 0x8c, 0xbd, 0x20, 0x00, 0x00, 0x00, 0xbf, 0x48, 0xd5, 0x04, 0xc0, 0x00, 0x00, 0x00,
    0xbf, 0x79, 0xdb, 0xe5, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x82, 0x9d, 0x5b, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x84, 0x03, 0x60, 0x00, 0x00, 0x00, 0x40, 0x73, 0x87, 0xe1, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0x83, 0xe8, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x6a, 0x3e, 0x20, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_rear_1280x720_0_3m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0x68, 0x91, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x1b, 0x64, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x50, 0xa2, 0x60, 0x00, 0x00, 0x00, 0x40, 0x76, 0x0b, 0x2d, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc5, 0xed, 0xe9, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0xe0, 0x70, 0x1f, 0x20, 0x00, 0x00, 0x00, 0xbf, 0x69, 0x37, 0xf7, 0xe0, 0x00, 0x00, 0x00,
    0x3f, 0x64, 0x54, 0x66, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x92, 0x27, 0x25, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x0f, 0x8a, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x1b, 0x64, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x0b, 0x2d, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x8e, 0x45, 0x60, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_rear_1280x720_1_0m[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0xde, 0x55, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x7a, 0x84, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0xc8, 0x5f, 0x00, 0x00, 0x00, 0x00, 0x40, 0x76, 0x32, 0x4d, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbe, 0x6e, 0x45, 0xa0, 0x00, 0x00, 0x00,
    0xbf, 0xae, 0x0c, 0x36, 0x80, 0x00, 0x00, 0x00, 0xbf, 0x71, 0xab, 0xb7, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x75, 0xc6, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x92, 0x00, 0xa0, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x91, 0xeb, 0xac, 0x40, 0x00, 0x00, 0x00, 0x40, 0x84, 0x7a, 0x84, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x32, 0x4d, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xee, 0x87, 0xff, 0x60, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_rear_1280x720_inf[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0x95, 0x12, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x2f, 0x64, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x83, 0x10, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x76, 0x74, 0x8e, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc1, 0x94, 0x2a, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0xd3, 0x9d, 0x39, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x46, 0x83, 0x3d, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0x70, 0x1b, 0x71, 0x00, 0x00, 0x00, 0x00, 0x40, 0x92, 0x35, 0x37, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x23, 0x93, 0x20, 0x00, 0x00, 0x00, 0x40, 0x84, 0x2f, 0x64, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x74, 0x8e, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x5a, 0xef, 0x40, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_rear_1280x720_macro[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x93, 0x38, 0xd2, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0xe6, 0x2a, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x93, 0x15, 0xb3, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x75, 0x0d, 0x73, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc8, 0xda, 0x04, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0xe6, 0x36, 0xa7, 0x40, 0x00, 0x00, 0x00, 0xbf, 0x73, 0xdc, 0xea, 0x60, 0x00, 0x00, 0x00,
    0x3f, 0x69, 0x35, 0x49, 0x20, 0x00, 0x00, 0x00, 0x40, 0x92, 0xf1, 0x3d, 0x60, 0x00, 0x00, 0x00,
    0x40, 0x92, 0xce, 0xa1, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x83, 0xe6, 0x2a, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x75, 0x0d, 0x73, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x88, 0xd5, 0x80, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_rear_640x480_0_3m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x88, 0xca, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x04, 0x4c, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x70, 0xc2, 0x00, 0x00, 0x00, 0x00, 0x40, 0x6d, 0xbb, 0xc0, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc4, 0x1d, 0x66, 0x80, 0x00, 0x00, 0x00,
    0xbf, 0xd8, 0x27, 0xb7, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0x46, 0x2c, 0xdc, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x62, 0xc5, 0x50, 0x00, 0x00, 0x00, 0x00, 0x40, 0x82, 0x37, 0x31, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x1f, 0x92, 0x40, 0x00, 0x00, 0x00, 0x40, 0x74, 0x04, 0x4c, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xbb, 0xc0, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x73, 0x1d, 0xc0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_rear_640x480_1_0m[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x75, 0xbf, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xf9, 0x6a, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x5e, 0x0c, 0x20, 0x00, 0x00, 0x00, 0x40, 0x6d, 0xc2, 0x65, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc3, 0x47, 0x78, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0xd4, 0x1d, 0xbd, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x39, 0x23, 0xb1, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x64, 0x6c, 0x7c, 0x40, 0x00, 0x00, 0x00, 0x40, 0x82, 0x13, 0xce, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x81, 0xfc, 0x99, 0x20, 0x00, 0x00, 0x00, 0x40, 0x73, 0xf9, 0x6a, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xc2, 0x65, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x56, 0x38, 0xc0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_rear_640x480_inf[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x82, 0x9b, 0xe2, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x0e, 0xc5, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x81, 0x6e, 0x80, 0x00, 0x00, 0x00, 0x40, 0x6d, 0xb9, 0x3a, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc3, 0x33, 0x33, 0x40, 0x00, 0x00, 0x00,
    0xbf, 0xd5, 0xb5, 0xb4, 0x80, 0x00, 0x00, 0x00, 0xbf, 0x35, 0xf2, 0x77, 0x00, 0x00, 0x00, 0x00,
    0x3f, 0x6a, 0xe6, 0xb1, 0x60, 0x00, 0x00, 0x00, 0x40, 0x82, 0x3c, 0xb8, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x22, 0xcc, 0x60, 0x00, 0x00, 0x00, 0x40, 0x74, 0x0e, 0xc5, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xb9, 0x3a, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x5c, 0x5c, 0x00, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_rear_640x480_macro[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x3a, 0x63, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x73, 0xcb, 0xfa, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x83, 0x20, 0xf9, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x6d, 0xa9, 0x7c, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc3, 0xe7, 0xe3, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0xdb, 0x16, 0x3e, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x24, 0xd3, 0xab, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0x1b, 0x24, 0xaf, 0x00, 0x00, 0x00, 0x00, 0x40, 0x82, 0xf6, 0x70, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0xdd, 0x60, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x73, 0xcb, 0xfa, 0x80, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0xa9, 0x7c, 0x20, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x8e, 0xeb, 0x00, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0x94, 0xbe, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x14, 0x0b, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x72, 0xbb, 0x20, 0x00, 0x00, 0x00, 0x40, 0x75, 0xd3, 0x84, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xcc, 0x9b, 0x85, 0xa0, 0x00, 0x00, 0x00,
    0xbf, 0xe9, 0xa4, 0x33, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x4b, 0xc3, 0xb0, 0xe0, 0x00, 0x00, 0x00,
    0x3f, 0x62, 0xb8, 0x36, 0x40, 0x00, 0x00, 0x00, 0x40, 0x91, 0x4e, 0xfc, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x2d, 0x7f, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x14, 0x0b, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x75, 0xd3, 0x84, 0x40, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x81, 0x07, 0x40, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_Air_2_front_640x480[cparam_size] = {
    0x00, 0x00, 0x02, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x40, 0x83, 0x07, 0x34, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x74, 0x68, 0x32, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x82, 0xea, 0x1e, 0x60, 0x00, 0x00, 0x00, 0x40, 0x6d, 0x45, 0x15, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc8, 0xc2, 0xd1, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0xe1, 0xbe, 0x85, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0x36, 0x4c, 0xa8, 0x20, 0x00, 0x00, 0x00,
    0x3f, 0x79, 0x25, 0x94, 0x80, 0x00, 0x00, 0x00, 0x40, 0x82, 0x9f, 0x48, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x82, 0x82, 0xd1, 0x60, 0x00, 0x00, 0x00, 0x40, 0x74, 0x68, 0x32, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x6d, 0x45, 0x15, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x51, 0x3b, 0xe0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6s_Plus_rear_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0x24, 0x19, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0xea, 0x10, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x29, 0x2c, 0x40, 0x00, 0x00, 0x00, 0x40, 0x76, 0x7b, 0x14, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xbd, 0x75, 0x31, 0xc0, 0x00, 0x00, 0x00,
    0xbf, 0xcf, 0xdc, 0x6d, 0x60, 0x00, 0x00, 0x00, 0x3f, 0x54, 0xa0, 0x07, 0xa0, 0x00, 0x00, 0x00,
    0x3f, 0x6d, 0x1f, 0x97, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x90, 0xdd, 0x39, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x90, 0xe2, 0x37, 0x40, 0x00, 0x00, 0x00, 0x40, 0x83, 0xea, 0x10, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x7b, 0x14, 0x80, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x7b, 0xaf, 0x80, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6s_Plus_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0x74, 0x97, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x3f, 0x46, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x6d, 0x4f, 0x00, 0x00, 0x00, 0x00, 0x40, 0x76, 0x50, 0x31, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb7, 0x2c, 0x0e, 0xe0, 0x00, 0x00, 0x00,
    0xbf, 0xd7, 0xd2, 0x37, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x5e, 0x59, 0x46, 0x40, 0x00, 0x00, 0x00,
    0x3f, 0x78, 0xe4, 0xd5, 0x40, 0x00, 0x00, 0x00, 0x40, 0x91, 0x54, 0x98, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x4d, 0x5c, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x3f, 0x46, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x50, 0x31, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0xc5, 0x57, 0x00, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6s_rear_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0x73, 0x51, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x43, 0xba, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x76, 0x51, 0x00, 0x00, 0x00, 0x00, 0x40, 0x76, 0xc3, 0x18, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc0, 0xd1, 0x5d, 0x20, 0x00, 0x00, 0x00,
    0xbf, 0xda, 0x74, 0x91, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x77, 0x6e, 0xfa, 0x60, 0x00, 0x00, 0x00,
    0x3f, 0x77, 0x84, 0x9e, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x91, 0x33, 0x57, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x36, 0x4c, 0x80, 0x00, 0x00, 0x00, 0x40, 0x84, 0x43, 0xba, 0xa0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0xc3, 0x18, 0x80, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x8a, 0xaf, 0xa0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6s_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0x7d, 0xff, 0x80, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x3c, 0x21, 0x20, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x76, 0x68, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x76, 0x3b, 0x59, 0x60, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x45, 0x48, 0xbc, 0x40, 0x00, 0x00, 0x00,
    0x3f, 0xd4, 0xaf, 0xb0, 0xa0, 0x00, 0x00, 0x00, 0xbf, 0x6a, 0xc2, 0x8e, 0x40, 0x00, 0x00, 0x00,
    0x3f, 0x77, 0x09, 0x74, 0x80, 0x00, 0x00, 0x00, 0x40, 0x91, 0x7a, 0x32, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x73, 0x06, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x3c, 0x21, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x3b, 0x59, 0x60, 0x00, 0x00, 0x00, 0x3f, 0xee, 0x3e, 0x6d, 0x80, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_rear_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0x9c, 0xef, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x83, 0x77, 0x4f, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x8d, 0x50, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x77, 0x21, 0x21, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xb2, 0x28, 0x4f, 0xe0, 0x00, 0x00, 0x00,
    0x3f, 0xca, 0xe1, 0xc9, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0x74, 0x8a, 0x64, 0xc0, 0x00, 0x00, 0x00,
    0xbf, 0x96, 0x95, 0x7d, 0x00, 0x00, 0x00, 0x00, 0x40, 0x91, 0x01, 0xbd, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x90, 0xf3, 0x78, 0x20, 0x00, 0x00, 0x00, 0x40, 0x83, 0x77, 0x4f, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x77, 0x21, 0x21, 0xa0, 0x00, 0x00, 0x00, 0x3f, 0xed, 0x3d, 0x10, 0x40, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPhone_6_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x92, 0x5b, 0xd0, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x85, 0x36, 0xef, 0x40, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x4c, 0x2f, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x76, 0x6c, 0x5c, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xd0, 0xed, 0x8e, 0x60, 0x00, 0x00, 0x00,
    0xbf, 0xe5, 0x9d, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x5a, 0xd2, 0x50, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0x94, 0x73, 0xdf, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x91, 0x6c, 0xb3, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x5d, 0xdd, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x85, 0x36, 0xef, 0x40, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x6c, 0x5c, 0xc0, 0x00, 0x00, 0x00, 0x3f, 0xee, 0x5f, 0x35, 0xe0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_mini_4_rear_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x94, 0xa4, 0x93, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0xa6, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x94, 0xa9, 0xf0, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x75, 0xe7, 0x1d, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xa7, 0xb0, 0x82, 0xe0, 0x00, 0x00, 0x00,
    0x3f, 0xec, 0x34, 0xd9, 0xe0, 0x00, 0x00, 0x00, 0xbf, 0x82, 0xa3, 0x88, 0x20, 0x00, 0x00, 0x00,
    0x3f, 0x85, 0x73, 0xcd, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x92, 0x80, 0x81, 0x20, 0x00, 0x00, 0x00,
    0x40, 0x92, 0x85, 0x4f, 0xe0, 0x00, 0x00, 0x00, 0x40, 0x84, 0xa6, 0xa6, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x75, 0xe7, 0x1d, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xec, 0xae, 0x64, 0xe0, 0x00, 0x00, 0x00
};

const unsigned char camera_para_iPad_mini_4_front_1280x720[cparam_size] = {
    0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x02, 0xd0, 0x40, 0x91, 0xc4, 0x4c, 0xa0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x84, 0x9d, 0x40, 0xc0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x40, 0x91, 0xbc, 0x2c, 0x20, 0x00, 0x00, 0x00, 0x40, 0x76, 0x0c, 0x04, 0xe0, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xc9, 0xb2, 0x88, 0x80, 0x00, 0x00, 0x00,
    0xbf, 0xe2, 0xd5, 0x78, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0x40, 0xed, 0x2a, 0xc0, 0x00, 0x00, 0x00,
    0x3f, 0x88, 0xa6, 0x0e, 0xa0, 0x00, 0x00, 0x00, 0x40, 0x91, 0x4b, 0x5f, 0xe0, 0x00, 0x00, 0x00,
    0x40, 0x91, 0x43, 0x76, 0xc0, 0x00, 0x00, 0x00, 0x40, 0x84, 0x9d, 0x40, 0xc0, 0x00, 0x00, 0x00,
    0x40, 0x76, 0x0c, 0x04, 0xe0, 0x00, 0x00, 0x00, 0x3f, 0xef, 0x26, 0x33, 0x80, 0x00, 0x00, 0x00
};

#endif // TARGET_OS_IOS

