# 🧐 What's inside?

## 1️⃣ Boilerplate code

This repository contains boilerplate code for everyone who wants to create a multi-page website powered by all the modern tools such as:

* [React](https://reactjs.org) - a JavaScript library for building user interfaces
* [Redux](https://redux.js.org) - a predictable state container for JavaScript apps
* [React Router](https://reacttraining.com/react-router) - a collection of navigational components
* [**Loco-JS-Model**](https://github.com/locoframework/loco-js-model) - a missing model layer for JavaScript. Give it a try - it's a neat solution for handling RESTful resources
* [Babel](https://babeljs.io) - a JavaScript compiler
* [Webpack](https://webpack.js.org) with plugins - a module bundler
* [Tailwind CSS](https://tailwindcss.com) - a utility-first CSS framework packed with classes
* [Jest](https://facebook.github.io/jest) - delightful JavaScript testing framework
* [TestCafe](https://testcafe.io) - end-to-end testing, simplified
* Linters + [Prettier](https://prettier.io)

For a complete list of dependencies see [package.json](https://github.com/artofcodelabs/front-end-boilerplate/blob/master/package.json)

👍 It may be a good choice for everyone who thinks that [Create React App](https://github.com/facebook/create-react-app) is too complicated and looking for a more straightforward, preconfigured solution to experiment with all the mentioned above tools.

## 2️⃣ Example app

This repository also contains an exemplary app showcasing how to use all the libraries and correctly structure your code.

# 🎮 Usage

Delete the example app to have a fresh start:

```bash
npm run clear
```

Start developing your own website:

```bash
npm run start
```

Run tests:

```bash
npm run test
```

Cut a production build:

```bash
npm run build
```

# 📜 License

[MIT License](https://opensource.org/licenses/MIT)

# 👨‍🏭 Author

Zbigniew Humeniuk from [Art of Code](http://artofcode.co)