/*
 * Decompiled with CFR 0.152.
 */
package org.flexunit.ant.tasks.configuration;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.FileSet;
import org.flexunit.ant.LoggingUtil;
import org.flexunit.ant.tasks.configuration.CompilationConfiguration;
import org.flexunit.ant.tasks.configuration.TestRunConfiguration;
import org.flexunit.ant.tasks.types.LoadConfig;

public class TaskConfiguration {
    private final String DEFAULT_WORKING_PATH = ".";
    private final String DEFAULT_REPORT_PATH = ".";
    private final List<String> VALID_PLAYERS = Arrays.asList("flash", "air");
    private String player = "flash";
    private File reportDir = null;
    private File workingDir = null;
    private boolean verbose = false;
    private File flexHome = null;
    private Project project;
    private CompilationConfiguration compilationConfiguration;
    private TestRunConfiguration testRunConfiguration;

    public TaskConfiguration(Project project) {
        this.project = project;
        this.compilationConfiguration = new CompilationConfiguration();
        this.testRunConfiguration = new TestRunConfiguration();
        if (project.getProperty("FLEX_HOME") != null) {
            this.flexHome = new File(project.getProperty("FLEX_HOME"));
        }
    }

    public CompilationConfiguration getCompilationConfiguration() {
        return this.compilationConfiguration;
    }

    public TestRunConfiguration getTestRunConfiguration() {
        return this.testRunConfiguration;
    }

    public void setCommand(String string) {
        this.testRunConfiguration.setCommand(this.project.resolveFile(string));
    }

    public void setDisplay(int n) {
        this.testRunConfiguration.setDisplay(n);
    }

    public void setFailOnTestFailure(boolean bl) {
        this.testRunConfiguration.setFailOnTestFailure(bl);
    }

    public void setFailureProperty(String string) {
        this.testRunConfiguration.setFailureProperty(string);
    }

    public void addSource(FileSet fileSet) {
        fileSet.setProject(this.project);
        this.compilationConfiguration.addSource(fileSet);
    }

    public void addTestSource(FileSet fileSet) {
        fileSet.setProject(this.project);
        this.compilationConfiguration.addTestSource(fileSet);
    }

    public void addLibrary(FileSet fileSet) {
        fileSet.setProject(this.project);
        this.compilationConfiguration.addLibrary(fileSet);
    }

    public void setHeadless(boolean bl) {
        this.testRunConfiguration.setHeadless(bl);
    }

    public void setLocalTrusted(boolean bl) {
        this.testRunConfiguration.setLocalTrusted(bl);
    }

    public void setPlayer(String string) {
        this.player = string;
    }

    public void setPort(int n) {
        this.testRunConfiguration.setPort(n);
    }

    public void setReportDir(String string) {
        this.reportDir = this.project.resolveFile(string);
    }

    public void setServerBufferSize(int n) {
        this.testRunConfiguration.setServerBufferSize(n);
    }

    public void setSocketTimeout(int n) {
        this.testRunConfiguration.setSocketTimeout(n);
    }

    public void setSwf(String string) {
        this.testRunConfiguration.setSwf(this.project.resolveFile(string));
    }

    public void setSwf(File file) {
        this.testRunConfiguration.setSwf(file);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
        LoggingUtil.VERBOSE = bl;
    }

    public void setWorkingDir(String string) {
        this.workingDir = this.project.resolveFile(string);
    }

    public boolean shouldCompile() {
        File file = this.testRunConfiguration.getSwf();
        boolean bl = !this.compilationConfiguration.getTestSources().provided();
        return !bl && (file == null || !file.exists());
    }

    public void verify() throws BuildException {
        this.validateSharedProperties();
        if (this.shouldCompile()) {
            this.compilationConfiguration.validate();
        }
        this.testRunConfiguration.validate();
        this.propagateSharedConfiguration();
    }

    protected void validateSharedProperties() throws BuildException {
        boolean bl;
        LoggingUtil.log("Validating task attributes ...");
        if (!this.VALID_PLAYERS.contains(this.player)) {
            throw new BuildException("The provided 'player' property value [" + this.player + "] must be either of the following values: " + this.VALID_PLAYERS.toString() + ".");
        }
        File file = this.testRunConfiguration.getSwf();
        boolean bl2 = bl = !this.compilationConfiguration.getTestSources().provided();
        if ((file == null || !file.exists()) && bl) {
            throw new BuildException("The provided 'swf' property value [" + (file == null ? "" : file.getPath()) + "] could not be found.");
        }
        if (file != null && !bl) {
            throw new BuildException("Please specify the 'swf' property or use the 'testSource' element(s), but not both.");
        }
        if (!(this.flexHome != null && this.flexHome.exists() || !new String("air").equals(this.testRunConfiguration.getPlayer()) && !this.shouldCompile())) {
            throw new BuildException("Please specify, or verify the location for, the FLEX_HOME property.  It is required when testing with 'air' as the player or when using the 'testSource' element.  It should point to the installation directory for a Flex SDK.");
        }
    }

    protected void propagateSharedConfiguration() {
        LoggingUtil.log("Generating default values ...");
        this.compilationConfiguration.setPlayer(this.player);
        this.testRunConfiguration.setPlayer(this.player);
        this.compilationConfiguration.setFlexHome(this.flexHome);
        this.testRunConfiguration.setFlexHome(this.flexHome);
        if (this.workingDir == null || !this.workingDir.exists()) {
            this.workingDir = this.project.resolveFile(".");
            LoggingUtil.log("Using default working dir [" + this.workingDir.getAbsolutePath() + "]");
        }
        this.workingDir.mkdirs();
        this.compilationConfiguration.setWorkingDir(this.workingDir);
        if (this.reportDir == null || !this.reportDir.exists()) {
            this.reportDir = this.project.resolveFile(".");
            LoggingUtil.log("Using default reporting dir [" + this.reportDir.getAbsolutePath() + "]");
        }
        this.reportDir.mkdir();
        this.testRunConfiguration.setReportDir(this.reportDir);
    }

    public void setDebug(boolean bl) {
        this.compilationConfiguration.setDebug(bl);
    }

    public void setLoadConfig(LoadConfig loadConfig) {
        this.compilationConfiguration.setLoadConfig(loadConfig);
    }
}

