/*
 Copyright (c) 2023 artegoser (Artemy Egorov)

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

const Ajv = require("ajv");
const ajv = new Ajv();
const note_schema = {
  type: "object",
  properties: {
    name: { type: "string", maxLength: 64 },
    text: { type: "string", maxLength: 5000 },
  },
  required: ["name", "text"],
  additionalProperties: false,
};

module.exports = (data) => {
  return ajv.validate(note_schema, data);
};
