"""
	Update feature code for static build
"""

import sys
from fontParts.world import *

fontPath = sys.argv[1]

font = OpenFont(fontPath, showInterface=False)


if "sparse" not in fontPath:
    print()
    print(font.info.familyName, font.info.styleName)
    print("feature code was:")
    print(font.features.text)
    
    font.features.text = """\
languagesystem DFLT dflt;
languagesystem latn dflt;

include(../features/features/common.fea);
include(../features/features/frac.fea);
include(../features/features/numr_dnom_supr_infr.fea);

feature calt {
    @randomCycle1 = [Udieresis      eight.dnom      one.dnom      s      Idieresis      M      heartwhite      lessequal      S      nine      B      perthousand      odieresis      ncaron      Obreve      gnrl:hyphen      section      ae      Ucaron      T      Ugrave      Eacute      x      heartblack      zero.numr      obreve      Iogonek      c      emdash      ydieresis      tildecomb      Ccaron      ampersand      Oslash      Aacute      fiveeighths      Igrave      radical      emacron      ugrave      V      t      imacron      three.numr      greaterequal      sacute      endash      acutecomb      logicalnot      nine.superior      iogonek      Odieresis      dieresis      product      X      AE      Edieresis      iacute      equal      increment      threeeighths      trademark      Q      Umacron      quotedblright      y      Oacute      Ecaron      Atilde      threesuperior      four      summation      tcaron      Tcaron      one.inferior      Iacute      Ncaron      abreve      sterling      P      periodcentered      nine.inferior      U      n      integral      period      space      three      oslashacute      Lslash      arrowNW      space.frac      Omacron      uhungarumlaut      ogonekcomb      ohungarumlaut      ccedilla      eacute      Ccedilla      grave      four.numr      copyright      Ydieresis      tilde      H      dcaron      pi      quotedbl      seveneighths      plusminus      Aring      Agrave      Ecircumflex      one.numr      z      omacron      second      zero.dnom      lslash      braceright      u      adieresis      six.superior      Z      o      five      cent      Zdotaccent      macron      degree      four.dnom      bar      arrowSW      Amacron      question      acaron      nbspace      quoteleft      Cacute      IJ      exclam      scaron      circumflexcomb      arrowSE      Ebreve      W      litre      fraction      asterisk      macroncomb      cedilla      g      zdotaccent      twothirds      Racute      e      oneeighth      dotaccent      ogonekcmb      Imacron      percent      R      i      aacute      greater      partialdiff      aogonek      Scaron      E      quotedblleft      guilsinglright      zcaron      Emacron      agrave      two.numr      Nacute      Ocircumflex      a      two.dnom      asciitilde      dollar.tabl      braceleft      Omega      Yacute      five.dnom      seven.numr      Ntilde      Egrave      nine.numr      K      atilde      Zacute      caroncomb      scedilla      Adieresis      Icircumflex      D      five.inferior      oacute      fhook      eight.superior      Uacute      Acircumflex      acute      exclamdown      approxequal      amacron      ucaron      cacute      uacute      l      cedillacomb      Acaron      onethird      slash      F      daggerdbl      d      notequal      v      uring      f      questiondown      eight.numr      Ubreve      eight.inferior      two.inferior      guillemetleft      igrave      Rcaron      C      three.inferior      Uhungarumlaut      idieresis      circumflex      egrave      dotaccentcmb      parenleft      six      J      underscore      G      ordmasculine      Ibreve      arrowleft      N      lozenge      ocircumflex      six.dnom      plus      bullet      paragraph      ograve      five.numr      Uring      at      germandbls      ecircumflex      semicolon      Ograve      eight      oslash      h      Abreve      ubreve      zero      arrowright      at.case      seven.inferior      asciicircum      r      aring      breve      zero.superior      onehalf      threequarters      jdotless      five.superior      six.numr      rcaron      L      minute      comma      numbersign      w      arrowdown      ibreve      gravecomb      seven.dnom      ccaron      Idotaccent      umacron      bracketleft      guilsinglleft      OE      edieresis      ellipsis      mu.math      eogonek      nine.dnom      j      ringcomb      registered      three.dnom      Ohungarumlaut      uogonek      divide      ordfeminine      Scedilla      seven.superior      Sacute      twosuperior      udieresis      b      bracketright      four.inferior      Gbreve      guillemetright      dollar      two      dieresiscomb      one      Ucircumflex      zero.inferior      yacute      racute      dagger      infinity      uni2010      arrowup      O      ecaron      Eogonek      onesuperior      six.inferior      Y      yen      less      Dcaron      arrowNE      icircumflex      ebreve      q      backslash      k      quoteright      Zcaron      ntilde      otilde      Uogonek      m      nacute      Euro      four.superior      quotesinglbase      onequarter      I      ucircumflex      A      ring      quotesingle      Aogonek      hyphen      hungarumlautcmb      Oslashacute      quotedblbase      brevecomb      parenright      dotbelowcmb      acircumflex      seven      gbreve      colon      oe      ogonek      caron      zacute      p      Otilde      ];
    @randomCycle2 = [Udieresis.alt1 eight.dnom.alt1 one.dnom.alt1 s.alt1 Idieresis.alt1 M.alt1 heartwhite.alt1 lessequal.alt1 S.alt1 nine.alt1 B.alt1 perthousand.alt1 odieresis.alt1 ncaron.alt1 Obreve.alt1 gnrl:hyphen.alt1 section.alt1 ae.alt1 Ucaron.alt1 T.alt1 Ugrave.alt1 Eacute.alt1 x.alt1 heartblack.alt1 zero.numr.alt1 obreve.alt1 Iogonek.alt1 c.alt1 emdash.alt1 ydieresis.alt1 tildecomb.alt1 Ccaron.alt1 ampersand.alt1 Oslash.alt1 Aacute.alt1 fiveeighths.alt1 Igrave.alt1 radical.alt1 emacron.alt1 ugrave.alt1 V.alt1 t.alt1 imacron.alt1 three.numr.alt1 greaterequal.alt1 sacute.alt1 endash.alt1 acutecomb.alt1 logicalnot.alt1 nine.superior.alt1 iogonek.alt1 Odieresis.alt1 dieresis.alt1 product.alt1 X.alt1 AE.alt1 Edieresis.alt1 iacute.alt1 equal.alt1 increment.alt1 threeeighths.alt1 trademark.alt1 Q.alt1 Umacron.alt1 quotedblright.alt1 y.alt1 Oacute.alt1 Ecaron.alt1 Atilde.alt1 threesuperior.alt1 four.alt1 summation.alt1 tcaron.alt1 Tcaron.alt1 one.inferior.alt1 Iacute.alt1 Ncaron.alt1 abreve.alt1 sterling.alt1 P.alt1 periodcentered.alt1 nine.inferior.alt1 U.alt1 n.alt1 integral.alt1 period.alt1 space.alt1 three.alt1 oslashacute.alt1 Lslash.alt1 arrowNW.alt1 space.frac.alt1 Omacron.alt1 uhungarumlaut.alt1 ogonekcomb.alt1 ohungarumlaut.alt1 ccedilla.alt1 eacute.alt1 Ccedilla.alt1 grave.alt1 four.numr.alt1 copyright.alt1 Ydieresis.alt1 tilde.alt1 H.alt1 dcaron.alt1 pi.alt1 quotedbl.alt1 seveneighths.alt1 plusminus.alt1 Aring.alt1 Agrave.alt1 Ecircumflex.alt1 one.numr.alt1 z.alt1 omacron.alt1 second.alt1 zero.dnom.alt1 lslash.alt1 braceright.alt1 u.alt1 adieresis.alt1 six.superior.alt1 Z.alt1 o.alt1 five.alt1 cent.alt1 Zdotaccent.alt1 macron.alt1 degree.alt1 four.dnom.alt1 bar.alt1 arrowSW.alt1 Amacron.alt1 question.alt1 acaron.alt1 nbspace.alt1 quoteleft.alt1 Cacute.alt1 IJ.alt1 exclam.alt1 scaron.alt1 circumflexcomb.alt1 arrowSE.alt1 Ebreve.alt1 W.alt1 litre.alt1 fraction.alt1 asterisk.alt1 macroncomb.alt1 cedilla.alt1 g.alt1 zdotaccent.alt1 twothirds.alt1 Racute.alt1 e.alt1 oneeighth.alt1 dotaccent.alt1 ogonekcmb.alt1 Imacron.alt1 percent.alt1 R.alt1 i.alt1 aacute.alt1 greater.alt1 partialdiff.alt1 aogonek.alt1 Scaron.alt1 E.alt1 quotedblleft.alt1 guilsinglright.alt1 zcaron.alt1 Emacron.alt1 agrave.alt1 two.numr.alt1 Nacute.alt1 Ocircumflex.alt1 a.alt1 two.dnom.alt1 asciitilde.alt1 dollar.tabl.alt1 braceleft.alt1 Omega.alt1 Yacute.alt1 five.dnom.alt1 seven.numr.alt1 Ntilde.alt1 Egrave.alt1 nine.numr.alt1 K.alt1 atilde.alt1 Zacute.alt1 caroncomb.alt1 scedilla.alt1 Adieresis.alt1 Icircumflex.alt1 D.alt1 five.inferior.alt1 oacute.alt1 fhook.alt1 eight.superior.alt1 Uacute.alt1 Acircumflex.alt1 acute.alt1 exclamdown.alt1 approxequal.alt1 amacron.alt1 ucaron.alt1 cacute.alt1 uacute.alt1 l.alt1 cedillacomb.alt1 Acaron.alt1 onethird.alt1 slash.alt1 F.alt1 daggerdbl.alt1 d.alt1 notequal.alt1 v.alt1 uring.alt1 f.alt1 questiondown.alt1 eight.numr.alt1 Ubreve.alt1 eight.inferior.alt1 two.inferior.alt1 guillemetleft.alt1 igrave.alt1 Rcaron.alt1 C.alt1 three.inferior.alt1 Uhungarumlaut.alt1 idieresis.alt1 circumflex.alt1 egrave.alt1 dotaccentcmb.alt1 parenleft.alt1 six.alt1 J.alt1 underscore.alt1 G.alt1 ordmasculine.alt1 Ibreve.alt1 arrowleft.alt1 N.alt1 lozenge.alt1 ocircumflex.alt1 six.dnom.alt1 plus.alt1 bullet.alt1 paragraph.alt1 ograve.alt1 five.numr.alt1 Uring.alt1 at.alt1 germandbls.alt1 ecircumflex.alt1 semicolon.alt1 Ograve.alt1 eight.alt1 oslash.alt1 h.alt1 Abreve.alt1 ubreve.alt1 zero.alt1 arrowright.alt1 at.case.alt1 seven.inferior.alt1 asciicircum.alt1 r.alt1 aring.alt1 breve.alt1 zero.superior.alt1 onehalf.alt1 threequarters.alt1 jdotless.alt1 five.superior.alt1 six.numr.alt1 rcaron.alt1 L.alt1 minute.alt1 comma.alt1 numbersign.alt1 w.alt1 arrowdown.alt1 ibreve.alt1 gravecomb.alt1 seven.dnom.alt1 ccaron.alt1 Idotaccent.alt1 umacron.alt1 bracketleft.alt1 guilsinglleft.alt1 OE.alt1 edieresis.alt1 ellipsis.alt1 mu.math.alt1 eogonek.alt1 nine.dnom.alt1 j.alt1 ringcomb.alt1 registered.alt1 three.dnom.alt1 Ohungarumlaut.alt1 uogonek.alt1 divide.alt1 ordfeminine.alt1 Scedilla.alt1 seven.superior.alt1 Sacute.alt1 twosuperior.alt1 udieresis.alt1 b.alt1 bracketright.alt1 four.inferior.alt1 Gbreve.alt1 guillemetright.alt1 dollar.alt1 two.alt1 dieresiscomb.alt1 one.alt1 Ucircumflex.alt1 zero.inferior.alt1 yacute.alt1 racute.alt1 dagger.alt1 infinity.alt1 uni2010.alt1 arrowup.alt1 O.alt1 ecaron.alt1 Eogonek.alt1 onesuperior.alt1 six.inferior.alt1 Y.alt1 yen.alt1 less.alt1 Dcaron.alt1 arrowNE.alt1 icircumflex.alt1 ebreve.alt1 q.alt1 backslash.alt1 k.alt1 quoteright.alt1 Zcaron.alt1 ntilde.alt1 otilde.alt1 Uogonek.alt1 m.alt1 nacute.alt1 Euro.alt1 four.superior.alt1 quotesinglbase.alt1 onequarter.alt1 I.alt1 ucircumflex.alt1 A.alt1 ring.alt1 quotesingle.alt1 Aogonek.alt1 hyphen.alt1 hungarumlautcmb.alt1 Oslashacute.alt1 quotedblbase.alt1 brevecomb.alt1 parenright.alt1 dotbelowcmb.alt1 acircumflex.alt1 seven.alt1 gbreve.alt1 colon.alt1 oe.alt1 ogonek.alt1 caron.alt1 zacute.alt1 p.alt1 Otilde.alt1 ];
    @randomCycle3 = [Udieresis.alt2 eight.dnom.alt2 one.dnom.alt2 s.alt2 Idieresis.alt2 M.alt2 heartwhite.alt2 lessequal.alt2 S.alt2 nine.alt2 B.alt2 perthousand.alt2 odieresis.alt2 ncaron.alt2 Obreve.alt2 gnrl:hyphen.alt2 section.alt2 ae.alt2 Ucaron.alt2 T.alt2 Ugrave.alt2 Eacute.alt2 x.alt2 heartblack.alt2 zero.numr.alt2 obreve.alt2 Iogonek.alt2 c.alt2 emdash.alt2 ydieresis.alt2 tildecomb.alt2 Ccaron.alt2 ampersand.alt2 Oslash.alt2 Aacute.alt2 fiveeighths.alt2 Igrave.alt2 radical.alt2 emacron.alt2 ugrave.alt2 V.alt2 t.alt2 imacron.alt2 three.numr.alt2 greaterequal.alt2 sacute.alt2 endash.alt2 acutecomb.alt2 logicalnot.alt2 nine.superior.alt2 iogonek.alt2 Odieresis.alt2 dieresis.alt2 product.alt2 X.alt2 AE.alt2 Edieresis.alt2 iacute.alt2 equal.alt2 increment.alt2 threeeighths.alt2 trademark.alt2 Q.alt2 Umacron.alt2 quotedblright.alt2 y.alt2 Oacute.alt2 Ecaron.alt2 Atilde.alt2 threesuperior.alt2 four.alt2 summation.alt2 tcaron.alt2 Tcaron.alt2 one.inferior.alt2 Iacute.alt2 Ncaron.alt2 abreve.alt2 sterling.alt2 P.alt2 periodcentered.alt2 nine.inferior.alt2 U.alt2 n.alt2 integral.alt2 period.alt2 space.alt2 three.alt2 oslashacute.alt2 Lslash.alt2 arrowNW.alt2 space.frac.alt2 Omacron.alt2 uhungarumlaut.alt2 ogonekcomb.alt2 ohungarumlaut.alt2 ccedilla.alt2 eacute.alt2 Ccedilla.alt2 grave.alt2 four.numr.alt2 copyright.alt2 Ydieresis.alt2 tilde.alt2 H.alt2 dcaron.alt2 pi.alt2 quotedbl.alt2 seveneighths.alt2 plusminus.alt2 Aring.alt2 Agrave.alt2 Ecircumflex.alt2 one.numr.alt2 z.alt2 omacron.alt2 second.alt2 zero.dnom.alt2 lslash.alt2 braceright.alt2 u.alt2 adieresis.alt2 six.superior.alt2 Z.alt2 o.alt2 five.alt2 cent.alt2 Zdotaccent.alt2 macron.alt2 degree.alt2 four.dnom.alt2 bar.alt2 arrowSW.alt2 Amacron.alt2 question.alt2 acaron.alt2 nbspace.alt2 quoteleft.alt2 Cacute.alt2 IJ.alt2 exclam.alt2 scaron.alt2 circumflexcomb.alt2 arrowSE.alt2 Ebreve.alt2 W.alt2 litre.alt2 fraction.alt2 asterisk.alt2 macroncomb.alt2 cedilla.alt2 g.alt2 zdotaccent.alt2 twothirds.alt2 Racute.alt2 e.alt2 oneeighth.alt2 dotaccent.alt2 ogonekcmb.alt2 Imacron.alt2 percent.alt2 R.alt2 i.alt2 aacute.alt2 greater.alt2 partialdiff.alt2 aogonek.alt2 Scaron.alt2 E.alt2 quotedblleft.alt2 guilsinglright.alt2 zcaron.alt2 Emacron.alt2 agrave.alt2 two.numr.alt2 Nacute.alt2 Ocircumflex.alt2 a.alt2 two.dnom.alt2 asciitilde.alt2 dollar.tabl.alt2 braceleft.alt2 Omega.alt2 Yacute.alt2 five.dnom.alt2 seven.numr.alt2 Ntilde.alt2 Egrave.alt2 nine.numr.alt2 K.alt2 atilde.alt2 Zacute.alt2 caroncomb.alt2 scedilla.alt2 Adieresis.alt2 Icircumflex.alt2 D.alt2 five.inferior.alt2 oacute.alt2 fhook.alt2 eight.superior.alt2 Uacute.alt2 Acircumflex.alt2 acute.alt2 exclamdown.alt2 approxequal.alt2 amacron.alt2 ucaron.alt2 cacute.alt2 uacute.alt2 l.alt2 cedillacomb.alt2 Acaron.alt2 onethird.alt2 slash.alt2 F.alt2 daggerdbl.alt2 d.alt2 notequal.alt2 v.alt2 uring.alt2 f.alt2 questiondown.alt2 eight.numr.alt2 Ubreve.alt2 eight.inferior.alt2 two.inferior.alt2 guillemetleft.alt2 igrave.alt2 Rcaron.alt2 C.alt2 three.inferior.alt2 Uhungarumlaut.alt2 idieresis.alt2 circumflex.alt2 egrave.alt2 dotaccentcmb.alt2 parenleft.alt2 six.alt2 J.alt2 underscore.alt2 G.alt2 ordmasculine.alt2 Ibreve.alt2 arrowleft.alt2 N.alt2 lozenge.alt2 ocircumflex.alt2 six.dnom.alt2 plus.alt2 bullet.alt2 paragraph.alt2 ograve.alt2 five.numr.alt2 Uring.alt2 at.alt2 germandbls.alt2 ecircumflex.alt2 semicolon.alt2 Ograve.alt2 eight.alt2 oslash.alt2 h.alt2 Abreve.alt2 ubreve.alt2 zero.alt2 arrowright.alt2 at.case.alt2 seven.inferior.alt2 asciicircum.alt2 r.alt2 aring.alt2 breve.alt2 zero.superior.alt2 onehalf.alt2 threequarters.alt2 jdotless.alt2 five.superior.alt2 six.numr.alt2 rcaron.alt2 L.alt2 minute.alt2 comma.alt2 numbersign.alt2 w.alt2 arrowdown.alt2 ibreve.alt2 gravecomb.alt2 seven.dnom.alt2 ccaron.alt2 Idotaccent.alt2 umacron.alt2 bracketleft.alt2 guilsinglleft.alt2 OE.alt2 edieresis.alt2 ellipsis.alt2 mu.math.alt2 eogonek.alt2 nine.dnom.alt2 j.alt2 ringcomb.alt2 registered.alt2 three.dnom.alt2 Ohungarumlaut.alt2 uogonek.alt2 divide.alt2 ordfeminine.alt2 Scedilla.alt2 seven.superior.alt2 Sacute.alt2 twosuperior.alt2 udieresis.alt2 b.alt2 bracketright.alt2 four.inferior.alt2 Gbreve.alt2 guillemetright.alt2 dollar.alt2 two.alt2 dieresiscomb.alt2 one.alt2 Ucircumflex.alt2 zero.inferior.alt2 yacute.alt2 racute.alt2 dagger.alt2 infinity.alt2 uni2010.alt2 arrowup.alt2 O.alt2 ecaron.alt2 Eogonek.alt2 onesuperior.alt2 six.inferior.alt2 Y.alt2 yen.alt2 less.alt2 Dcaron.alt2 arrowNE.alt2 icircumflex.alt2 ebreve.alt2 q.alt2 backslash.alt2 k.alt2 quoteright.alt2 Zcaron.alt2 ntilde.alt2 otilde.alt2 Uogonek.alt2 m.alt2 nacute.alt2 Euro.alt2 four.superior.alt2 quotesinglbase.alt2 onequarter.alt2 I.alt2 ucircumflex.alt2 A.alt2 ring.alt2 quotesingle.alt2 Aogonek.alt2 hyphen.alt2 hungarumlautcmb.alt2 Oslashacute.alt2 quotedblbase.alt2 brevecomb.alt2 parenright.alt2 dotbelowcmb.alt2 acircumflex.alt2 seven.alt2 gbreve.alt2 colon.alt2 oe.alt2 ogonek.alt2 caron.alt2 zacute.alt2 p.alt2 Otilde.alt2 ];

    sub @randomCycle1 @randomCycle1' by @randomCycle2;
    sub @randomCycle2 @randomCycle1' by @randomCycle3;
} calt;

    """
    
    print("feature code is now:")
    print(font.features.text)
    print()


font.save()
font.close()
