# Contributing to the Shantell Sans Project

## Types of contributions

### Issues

If you find something that’s not working as you expect, please file an [Issue](https://github.com/arrowtype/shantell-sans/issues).

### Documentation improvements

If you find a typo or something that seems out of date in the Readme, etc, please feel free to file a [Pull Request](https://github.com/arrowtype/shantell-sans/pulls) with your suggested change(s).

### Type design fixes/changes

Some open-source projects might function well with direct contributions from many participants, but type design tends to benefit from a central, strong creative & technical direction. There are probably exceptions to this, but Shantell Sans – as a commissioned, custom font – is not one of them.

That said, type design contributions are very highly valued here, but they require good communication (before & during work) to go well.

Have an idea for something that you think would be worth changing in the design? Cool! You have two good options:

1. File an issue to point out the design problem. Include a description your idea for an improvement, if you have one. @ArrowType will try to comment on the issue fairly promptly, and the proposed solution can be discussed before a course of action is decided.
2. Alternatively, this project is [OFL-licensed](OFL.txt), so you are welcome to fork the repo and make whatever changes you like, so long as you keep the same license and respect its provisions. In this scenario, please be sure to change the font family name to avoid user confusion.

## Contribution requirements

Things that will make contributions work well:

1. Post an Issue first to discuss the contribution, if it is a suggested change to the font or script sources themselves. Depending on the contribution, it may or may not make sense to do here (versus e.g. in a forked project).
2. Work in a [feature branch of a fork](https://guides.github.com/introduction/flow/) named for the feature/fixes you are working on, e.g. `add-localization`. When you feel this is ready to merge into the main project, make a Pull Request to request a review.
