Contributions to ORSSerialPort are most welcome!

There are a few guidelines to follow to make it easier to integrate your contributions.

## ORSSerialPort Is Simple ##

The goal of ORSSerialPort is to make serial port programming in a Cocoa app
much easier than it otherwise would be. It should be simple enough for complete
beginners to get up and running quickly without a lot of overhead or required
knowledge. As such, the public API must be kept as simple as possible without
sacrificing usability.

Contributions which enhance ORSSerialPort or fix bugs are very much appreciated.
However, please note that I can't promise that all contributions will be accepted.
Many suggestions will be rejected to preserve simplicity. For this reason, it's a good
idea to discuss major changes beforehand.

## Use Github Issues and Pull Requests

If you're capable of implementing the feature or bug fix yourself, please open a pull request
rather than opening an issue.

If you're not able to make the change yourself, please open an issue after checking
to be sure there's not already an existing open issue.

Contributions must be submitted using Github. Contributions sent as code dumps via email
are difficult to merge in, don't promote discussion and iteration, and don't leave a 
good "paper trail" explaining the change. If you're new to contributing via GitHub, feel free to [email me](mailto:andrew@openreelsoftware.com) and I'll be happy to help you get started.

## Code style

ORSSerialPort doesn't currently have a style guide document, but its style should be easy to infer by reading the existing code.
If you’re interested in contributing code, please try to match this style closely.

**Thanks!**  
Andrew Madsen