const { series, parallel, watch } = require('gulp');
const bs = require('browser-sync');

const config = require('./config');

const clean = require('./tasks/clean');
const sprite = require('./tasks/sprite');
const scss = require('./tasks/scss');
const html = require('./tasks/html');
const images = require('./tasks/images');
const assets = require('./tasks/assets');
const report = require('./tasks/report');
const webpack = require('./tasks/webpack');
const browserSync = require('./tasks/browserSync');

const tasks = [scss, html, images, assets];

function setBuild(cb) {
  global.env = 'build';
  cb();
}

function setProd(cb) {
  global.env = 'prod';
  cb();
}

function setWatch(cb) {
  global.env = 'watch';
  cb();
}

function reload(cb) {
  bs.reload();
  cb();
}

function watchFiles(cb) {
  watch(config.sprite.src, series(sprite, reload));
  watch(config.scss.src, scss);
  watch(config.images.src, series(images, reload));
  watch(config.html.src, series(html, reload));
  watch(config.html.data, series(html, reload));
  cb();
}

const _default = series(clean, setBuild, sprite, parallel(...tasks, webpack));
const _prod = series(
  clean,
  setProd,
  sprite,
  parallel(...tasks, webpack),
  report
);
const _watch = series(
  clean,
  setWatch,
  sprite,
  parallel(...tasks),
  watchFiles,
  browserSync
);

module.exports = {
  default: _default,
  production: _prod,
  watch: _watch,
};
