<div align="center">

<img src="https://glottologist.js.org/img/Logo.svg" width="300">

# Glottologist
A JavaScript language translation framework.
<br>

[![GitHub release](https://img.shields.io/github/release/arguiot/Glottologist.svg)](https://github.com/arguiot/Glottologist/releases)
[![Build Status](https://travis-ci.org/arguiot/Glottologist.svg?branch=master)](https://travis-ci.org/arguiot/Glottologist)
[![Github All Releases](https://img.shields.io/github/downloads/arguiot/Glottologist/total.svg)](https://github.com/arguiot/Glottologist/)
[![npm](https://img.shields.io/npm/dt/glottologist.svg)](https://www.npmjs.com/package/glottologist)
[![License](https://img.shields.io/github/license/arguiot/Glottologist.svg)](LICENSE)
</div>

## Install


- Browsers:

```html
<script src="https://unpkg.com/glottologist"></script>
<script>
  const glot = new Glottologist();

  /* Your code */

</script>
```
- NodeJS:

```bash
npm i glottologist --save
```
```js
const glot = require("glottologist");
```

## The full docs can be found [here](https://github.com/arguiot/Glottologist/wiki)

## Support
Glottologist is a project that required a lot of work and effort. You can show your appreciation by leaving a ⭐️. But you can also contribute in a 'financial' way by giving some XMRs (if you have no idea of what this is, look for Monero on Google) at this address:
```bash
49qzWTyu4awZFpnVRUZHCQE8xz1bcoRkCQh1nrRsTHg3if6osQqVXRoFAyGYvhDR4pZ4w8WTKQDykYy5Z2Sj6i9TAj2fiBr
```

## Contributing

Please read [CONTRIBUTING.md](./CONTRIBUTING.md) for details on our code of conduct, and the process for submitting pull requests to us.

#### Made something using the Glottologist?

Add the built with Glottologist badge to your `README.md`

[![Built with Glottologist](https://img.shields.io/badge/Built%20with-Glottologist-blue.svg)](https://img.shields.io/badge/Built%20with-Glottologist-blue.svg)


Feel free to send me an email at [arguiot@gmail.com](mailto:arguiot@gmail.com), and I might add your site to an examples section I'm currently working on.

## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/arguiot/Glottologist/tags).

## Authors

- **Arthur Guiot** - *Initial work* - [@arguiot](https://github.com/arguiot)

Also look at the list of [contributors](https://github.com/arguiot/Glottologist/contributors) who participated in this project. If you don't code but you have great ideas, don't hesitate to write your idea in the issue part. If your idea is accepted, I will add you to this list 😊.

## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details

Copyright &copy; 2017 Arthur Guiot All Rights Reserved.
