<h1 align="center">DisplayJS</h1>
<p align="center">
  <img src="https://rawgit.com/arguiot/DisplayJS/master/docs/img/logo.svg" width="256">
<br/>
A simple framework for building ambitious UI, without thinking about how everything will be displayed.
<br/>
By the way, you can ⭐️ the project to support it 😊
</p>

<div align="center">

[![GitHub release](https://img.shields.io/github/release/arguiot/DisplayJS.svg)](https://github.com/arguiot/DisplayJS/releases)
[![Build Status](https://travis-ci.org/arguiot/DisplayJS.svg?branch=master)](https://travis-ci.org/arguiot/DisplayJS)
[![Github All Releases](https://img.shields.io/github/downloads/arguiot/DisplayJS/total.svg)](https://github.com/arguiot/DisplayJS/)
[![npm](https://img.shields.io/npm/dt/display.js.svg)](https://www.npmjs.com/package/display.js)
[![License](https://img.shields.io/github/license/arguiot/DisplayJS.svg)](LICENSE)
</div>

## Browser support
The browser support table is not 100% accurate. The ⛔ means that I didn't test DisplayJS for that browser.

| <img src="https://github.com/alrra/browser-logos/blob/master/src/chrome/chrome_128x128.png?raw=true" width="48px" height="48px" alt="Chrome logo"> | <img src="https://github.com/alrra/browser-logos/blob/master/src/firefox/firefox_128x128.png?raw=true" width="48px" height="48px" alt="Firefox logo"> | <img src="https://github.com/alrra/browser-logos/blob/master/src//archive/internet-explorer_9-11/internet-explorer_9-11_128x128.png?raw=true" width="48px" height="48px" alt="IE logo"> | <img src="https://github.com/alrra/browser-logos/blob/master/src/opera/opera_128x128.png?raw=true" width="48px" height="48px" alt="Opera logo"> | <img src="https://github.com/alrra/browser-logos/blob/master/src/safari/safari_128x128.png?raw=true" width="48px" height="48px" alt="Safari logo"> | <img src="https://github.com/alrra/browser-logos/blob/master/src/archive/android/android_128x128.png?raw=true" width="48px" height="48px" alt="Android Browser Logo" >
|:---:|:---:|:---:|:---:|:---:|:---:|
| 52+ ✅ | 52+ ✅ | 10+⛔ | 40+ ✅ | 9+ ✅ | 5.2+ ⛔
## Getting Started

To use display.js, you'll need to download display.js and add it in your js folder. Or, you can add these line of code in the head or in the body of your page:
```html
// Add DisplayJS
<script src="https://unpkg.com/display.js"></script>
```
or you can install DisplayJS using [npm](https://npmjs.com/package/display.js)
```bash
$ npm install display.js
```

## Initialize DisplayJS

```javascript
// Create a var for Display.JS. You don't have to add the $ var, you can change the name.
var $ = new DisplayJS (window);
```

## The full docs can be found [here](https://github.com/arguiot/DisplayJS/wiki)

## Support
DisplayJS is a project that required a lot of work and effort. You can show your appreciation by leaving a ⭐️. But you can also contribute in a 'financial' way by giving to my [Patreon](https://www.patreon.com/bePatron?u=10987869)
## Contributing

Please read [CONTRIBUTING.md](./CONTRIBUTING.md) for details on our code of conduct, and the process for submitting pull requests to us.

#### Made a website using the DisplayJS?

Add the built with DisplayJS badge to your `README.md`

[![Built with DisplayJS](https://img.shields.io/badge/Built%20with-DisplayJS-blue.svg)](https://img.shields.io/badge/Built%20with-DisplayJS-blue.svg)


Feel free to send me an email at [arguiot@gmail.com](mailto:arguiot@gmail.com), and I might add your site to an examples section I'm currently working on.

## Examples of projects using DisplayJS
- [EyeJS](https://eye.js.org)
- [Glottologist](https://glottologist.js.org)
- ~~[CrypTools Org](https://cryptools.github.io)~~ <!-- Cryptools deosn't use display.js anymore -->
## Versioning

We use [SemVer](http://semver.org/) for versioning. For the versions available, see the [tags on this repository](https://github.com/arguiot/DisplayJS/tags).

## Authors

- **Arthur Guiot** - *Initial work* - [@arguiot](https://github.com/arguiot)
- **Nikhil Bhaskar** - *Added aliases for the `$.var()` function* - [@Nikhil22](https://github.com/Nikhil22)
- **devrafalko** - *Helped a lot for the `$.math()` function* - [@devrafalko](https://github.com/devrafalko)
- **Irving Ventura** - *Fixed a merge issue* - [@irvingv8](https://github.com/irvingv8)
- **Vladimir B.** - *Fixed the global export warning* - [@ange007](https://github.com/ange007)
- **ChenSheng** - *Fixed `$.s()` function* - [@Cslove](https://github.com/Cslove)

See also the list of [contributors](https://github.com/arguiot/DisplayJS/contributors) who participated in this project. If you don't code but you have great ideas, don't hesitate to write your idea in the issue part. If your idea is accepted, I will add you to this list 😊.
<dl>
  <dt>Thank You</dt>
  <dd>for support</dd>


## License

This project is licensed under the MIT License - see the [LICENSE](LICENSE) file for details.

Copyright &copy; 2017 Arthur Guiot All Rights Reserved.
