import { LanguageSupport } from './language';

export const localeMap = {
    DevelopmentGuide: {
        [LanguageSupport.CH]: '开发指南',
        [LanguageSupport.EN]: 'Development Guide',
    },
    QuickStart: {
        [LanguageSupport.CH]: '快速开始',
        [LanguageSupport.EN]: 'Quick Start',
    },
    Components: {
        [LanguageSupport.CH]: '组件',
        [LanguageSupport.EN]: 'Components',
    },
    CompositeComp: {
        [LanguageSupport.CH]: '复合组件',
        [LanguageSupport.EN]: 'Composite Components',
    },
    Changelog: {
        [LanguageSupport.CH]: '更新日志',
        [LanguageSupport.EN]: 'Changelog',
    },
    Home: {
        [LanguageSupport.CH]: '首页',
        [LanguageSupport.EN]: 'Home',
    },
    Resource: {
        [LanguageSupport.CH]: '工具函数',
        [LanguageSupport.EN]: 'Tools',
    },
    DevelopmentResource: {
        [LanguageSupport.CH]: '开发资源',
        [LanguageSupport.EN]: 'Development Resource',
    },
    SwitchToDarkMode: {
        [LanguageSupport.CH]: '切换至暗黑模式',
        [LanguageSupport.EN]: 'Switch to dark mode',
    },
    SwitchToLightMode: {
        [LanguageSupport.CH]: '切换至亮色模式',
        [LanguageSupport.EN]: 'Switch to light mode',
    },
    Copy: {
        [LanguageSupport.CH]: '复制',
        [LanguageSupport.EN]: 'Copy',
    },
    CopySuccess: {
        [LanguageSupport.CH]: '复制成功',
        [LanguageSupport.EN]: 'Copy successfully',
    },
    Expand: {
        [LanguageSupport.CH]: '展开',
        [LanguageSupport.EN]: 'Expand',
    },
    Collapse: {
        [LanguageSupport.CH]: '收起',
        [LanguageSupport.EN]: 'Collapse',
    },
    Others: {
        [LanguageSupport.CH]: '其他',
        [LanguageSupport.EN]: 'Others',
    },
    GeneralHooks: {
        [LanguageSupport.CH]: '公共Hooks',
        [LanguageSupport.EN]: 'General Hooks',
    },
    Icon: {
        [LanguageSupport.CH]: '图标',
        [LanguageSupport.EN]: 'Icon',
    },
    DesignResource: {
        [LanguageSupport.CH]: '设计资源',
        [LanguageSupport.EN]: 'Design Resources',
    },
    DesignResourceDesc: {
        [LanguageSupport.CH]: '即刻开启你的体验旅程',
        [LanguageSupport.EN]: 'Start your experience journey now',
    },
    DesignResourceFigmaTitle: {
        [LanguageSupport.CH]: '获取 Figma 文件',
        [LanguageSupport.EN]: 'Get the Figma file',
    },
    DesignResourceFigmaDesc1: {
        [LanguageSupport.CH]: '跳转至Figma网页版本，可直接进行编辑。',
        [LanguageSupport.EN]: 'Jump to the Figma web version for direct editing.',
    },
    QRCodeTip: {
        [LanguageSupport.CH]: '扫描二维码查看演示效果',
        [LanguageSupport.EN]: 'Scan the QR code to view the demo',
    },
    SearchTip: {
        [LanguageSupport.CH]: '在 Arco Design 中搜索...',
        [LanguageSupport.EN]: 'Searching in Arco Design...',
    },
    SearchResultTip: {
        [LanguageSupport.CH]: (num: number) => `搜索到 ${num} 个结果`,
        [LanguageSupport.EN]: (num: number) => `About ${num} results found`,
    },
    Loading: {
        [LanguageSupport.CH]: '加载中...',
        [LanguageSupport.EN]: 'Loading...',
    },
    SearchNoResultTip: {
        [LanguageSupport.CH]: (value: string) => `没有 “${value}” 的搜索结果`,
        [LanguageSupport.EN]: (value: string) => `No results for '${value}'`,
    },
    ComponentType: {
        [LanguageSupport.CH]: '组件',
        [LanguageSupport.EN]: 'Component',
    },
    HomeBannerSlogan: {
        [LanguageSupport.CH]: '让移动应用获得开箱即用的设计解决方案',
        [LanguageSupport.EN]: 'Out-of-the-box design solutions for mobile apps',
    },
    HomeStartButton: {
        [LanguageSupport.CH]: '开始使用',
        [LanguageSupport.EN]: 'Get Started',
    },
    HomeQRButton: {
        [LanguageSupport.CH]: '扫码展示',
        [LanguageSupport.EN]: 'Scan QR Code',
    },
    HomeQRButtonMobile: {
        [LanguageSupport.CH]: '查看组件',
        [LanguageSupport.EN]: 'Components',
    },
    HomeDomStation: {
        [LanguageSupport.CH]: '文档站',
        [LanguageSupport.EN]: 'Doc Station',
    },
    HomeBusinessTitle: {
        [LanguageSupport.CH]: '谁在使用',
        [LanguageSupport.EN]: 'Who are Users',
    },
    HomeBusinessSubTitle: {
        [LanguageSupport.CH]: '多场景的接入案例',
        [LanguageSupport.EN]: 'Multi-scenario Access Case',
    },
    HomeBusinessBarTitle: {
        [LanguageSupport.CH]: '来自众多优秀产品的信任',
        [LanguageSupport.EN]: 'Trust from excellent products',
    },
    HomeComponentTitle: {
        [LanguageSupport.CH]: '丰富的组件类型',
        [LanguageSupport.EN]: 'Rich Components',
    },
    HomeComponentSubTitle: {
        [LanguageSupport.CH]: '帮助创造优秀的产品设计',
        [LanguageSupport.EN]: 'Help to create great product designs',
    },
    HomeComponentTip1: {
        [LanguageSupport.CH]: 'arco移动端提供50+基础模块组件，覆盖各类场景。',
        [LanguageSupport.EN]:
            'Arco mobile provides 50+ basic components, covering various scenarios.',
    },
    HomeComponentTip2: {
        [LanguageSupport.CH]: '借助arco丰富的组件可以更好的搭建应用，提高效率，',
        [LanguageSupport.EN]: `With the help of arco's rich components, you can better build applications and improve efficiency,`,
    },
    HomeComponentTip3: {
        [LanguageSupport.CH]: '在整个产品生产过程中创造更具凝聚力的可扩展体验。',
        [LanguageSupport.EN]: `and create a more cohesive and scalable experience throughout the product production process.`,
    },
    HomeQRCodePopover1: {
        [LanguageSupport.CH]: '请扫描二维码',
        [LanguageSupport.EN]: 'Scan the QR code to',
    },
    HomeQRCodePopover2: {
        [LanguageSupport.CH]: '体验移动端效果',
        [LanguageSupport.EN]: 'experience on mobile',
    },
    HomeFooterEcosystem: {
        [LanguageSupport.CH]: '生态系统',
        [LanguageSupport.EN]: 'Ecosystem',
    },
    HomeFooterResource: {
        [LanguageSupport.CH]: '资源',
        [LanguageSupport.EN]: 'Resource',
    },
    HomeFooterFeedback: {
        [LanguageSupport.CH]: '反馈',
        [LanguageSupport.EN]: 'Feedback',
    },
    HomeFooterFigma: {
        [LanguageSupport.CH]: '组件库 Figma 资源',
        [LanguageSupport.EN]: 'Figma Of Component',
    },
    DesignLabDesignSystemLab: {
        [LanguageSupport.CH]: 'DesignLab 设计系统配置平台',
        [LanguageSupport.EN]: 'DesignLab Design System Lab',
    },
    ArcoMaterialComponentMarket: {
        [LanguageSupport.CH]: 'ArcoMaterial 物料平台',
        [LanguageSupport.EN]: 'ArcoMaterial Component Market',
    },
    ArcoProBestPractices: {
        [LanguageSupport.CH]: 'ArcoPro 中后台最佳实践',
        [LanguageSupport.EN]: 'ArcoPro Best Practices',
    },
    ProductDescription: {
        [LanguageSupport.CH]: '产品介绍',
        [LanguageSupport.EN]: 'Product Description',
    },
    ProductLineAccess: {
        [LanguageSupport.CH]: '产品线接入',
        [LanguageSupport.EN]: 'Product Line Access',
    },
    FeedbackTips: {
        [LanguageSupport.CH]: '期待收到你的反馈，交流让 Arco 更好。',
        [LanguageSupport.EN]:
            'Looking forward to receiving your feedback and communication to make Arco better.',
    },
    DesignPrinciples: {
        [LanguageSupport.CH]: '设计原则',
        [LanguageSupport.EN]: 'Design Principles',
    },
    DesignPrinciplesDesc: {
        [LanguageSupport.CH]: '建立务实而浪漫的工作方式',
        [LanguageSupport.EN]: 'Establish a pragmatic and romantic way of working',
    },
    DesignPrinciplesPart1Title: {
        [LanguageSupport.CH]: '跨端兼容',
        [LanguageSupport.EN]: 'Cross-end Compatible',
    },
    DesignPrinciplesPart1SubTitle: {
        [LanguageSupport.CH]: '提供兼容多宿主的解决方案，多端组件 UI 一键适配。',
        [LanguageSupport.EN]:
            'Provide a multi-terminal compatible solution, and the multi-terminal component UI is adapted with one click.',
    },
    DesignPrinciplesPart2Title: {
        [LanguageSupport.CH]: '功能全面',
        [LanguageSupport.EN]: 'Full-featured',
    },
    DesignPrinciplesPart2SubTitle: {
        [LanguageSupport.CH]: '几十种企业级常用 UI 组件，深入业务场景的每个细节。',
        [LanguageSupport.EN]:
            'Dozens of enterprise-level common UI components, go deep into every detail of business scenarios.',
    },
    DesignPrinciplesPart3Title: {
        [LanguageSupport.CH]: '快速生产',
        [LanguageSupport.EN]: 'Fast Production',
    },
    DesignPrinciplesPart3SubTitle: {
        [LanguageSupport.CH]: '标准的业务组件库及配套文档站。',
        [LanguageSupport.EN]:
            'Standard business component library and supporting documentation station.',
    },
    DesignPrinciplesPart4Title: {
        [LanguageSupport.CH]: '灵活易用',
        [LanguageSupport.EN]: 'Flexible & Easy-to-use',
    },
    DesignPrinciplesPart4SubTitle: {
        [LanguageSupport.CH]: '提供强大功能及灵活配置，极力寻找易用与可定制的平衡。',
        [LanguageSupport.EN]:
            'Offers powerful features and flexible configuration, striving to find a balance between ease of use and customizability.',
    },
};
