
# Contributing

Thank you for taking your time to contribute and make this project better! Here are some guidelines to help you get started. Please make sure to take a moment and read through them before submitting your contributions.

## Code of Conduct

This project is governed by the [Contributor Covenant Code of Conduct](./CODE_OF_CONDUCT.md). By participating, you are expected to adhere to it.

## Open Development

All work happens directly on GitHub. Both core team members and external contributors send pull requests which go through the same review process.

## Semantic Versioning

This project follows semantic versioning. We release patch versions for bug fixes or other changes that do not change the behavior of the API, minor versions for new features that are backward-compatible, and major versions for any breaking changes.

Every significant change is documented in the changelog file.

## Reporting Issues

We use [Github issues](https://github.com/arco-design/arco-design-mobile/issues) for bug reports and feature requests. Before reporting an issue, please make sure you have searched for similar [issues](https://github.com/arco-design/arco-design-mobile/issues) as they may have been already answered or being fixed. A new issue should be submitted via [issue helper](https://arco.design/issue-helper?repo=arco-design-mobile). For bug reporting, please include the minimum code that can be used to reproduce the problem. For feature request, please specify what changes you want and what behavior you expect.

## Sending a pull request

1. Fork [the repository](https://github.com/arco-design/arco-design-mobile) and create your branch from `main`. Please submit your changes to the `main` branch.
2. Run `npm install` in the repository root.
3. Run `npm start` to start and preview mobile site and `npm run start:pc` to start and preview pc site.
4. Make changes to the codebase. Please add tests if applicable.
5. Make sure the test suite passes with `npm run test`.
6. Commit your changes, adhering to the [Commit Guidelines](#commit-guidelines)
7. Open a new pull request, [referencing corresponding issues](https://docs.github.com/en/issues/tracking-your-work-with-issues/linking-a-pull-request-to-an-issue#linking-a-pull-request-to-an-issue-using-a-keyword) if available.

### Commonly used npm scripts

```bash
# start and preview mobile site locally
$ npm start

# start and preview pc site locally
$ npm run start:pc

# create a build of the components
$ npm run build

# run the complete test suite
$ npm run test

# add a new component
$ npm run add -- new-comp
```

## Commit Guidelines

Commit messages are required to follow the [conventional-changelog standard](https://www.conventionalcommits.org/en/v1.0.0/):

```bash
<type>[optional scope]: <description>

[optional body]

[optional footer(s)]
```

### Commit types

The following is a list of commit types:

- feat: A new feature or functionality
- fix: A bug fix
- docs: Documentation only changes
- style: Code formatting or component style changes
- refactor: Code changes that neither fixes a bug nor adds a feature.
- perf: Improve performance.
- test: Add missing or correct existing tests.
- chore: Other commits that don’t modify src or test files.

## Project Structure

### Component directory

> packages/arcodesign/components/{componentName}

```
├── README.md (Note: Don't edit this file, it's generated by script)
├── README.en-US.md (Note: Don't edit this file, it's generated by script)
├── __ast__
│   ├── index.ast.json（Ast structure of component attribute description）
├── __test__
│   ├── __snapshots__
│   │   └── index.test.js.snap （Snapshot）
│   └── index.spec.js （Unit test）
├── demo （Demos for each component）
│   ├── style（Style for component demo）
│   ├── basic.md
│   └── advanced.md
├── index.tsx（Component export）
└── style
    └── index.less（Component style）
    └── index.ts (Component style entry)
```

### Changelog

Changelogs in `CHANGELOG.md` are generated automatically by script on release. Please don't edit the files manually.

## License

By contributing your code to the repository, you agree to license your contribution under the [MIT license](./LICENSE).
