import { LucideProps, Moon, SunMedium, type LucideIcon } from "lucide-react";

export type Icon = LucideIcon;

export const Icons = {
  sun: SunMedium,
  moon: Moon,
  logo: (props: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 128 128" {...props}>
      <path
        fillRule="evenodd"
        clipRule="evenodd"
        fill="currentColor"
        d="M6.49017 63.3113C4.26219 63.5402 2.08772 63.7636 0 64C2.08772 64.2364 4.26219 64.4598 6.49016 64.6887C22.5501 66.3385 41.3902 68.2739 50.5581 77.4419C59.7252 86.6089 61.6606 105.446 63.3106 121.505C63.5397 123.735 63.7633 125.911 64 128C64.2367 125.911 64.4603 123.735 64.6894 121.505C66.3394 105.446 68.2748 86.6089 77.4419 77.4419C86.6098 68.2739 105.45 66.3385 121.51 64.6887C123.738 64.4598 125.912 64.2364 128 64C125.912 63.7636 123.738 63.5402 121.51 63.3113C105.45 61.6615 86.6098 59.7261 77.4419 50.5581C68.2748 41.3911 66.3394 22.5543 64.6894 6.49512C64.4603 4.26543 64.2367 2.08929 64 0C63.7633 2.08928 63.5397 4.26542 63.3106 6.4951C61.6606 22.5543 59.7252 41.3911 50.5581 50.5581C41.3902 59.7261 22.5501 61.6615 6.49017 63.3113Z"
      />
    </svg>
  ),
};